/*
 * Decompiled with CFR 0.152.
 */
package map;

import bwapi.Game;
import bwapi.Position;
import bwapi.TilePosition;
import bwem.BWEM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import map.TilePositionValidator;

public class PathFinding {
    private BWEM bwem;
    private Game game;
    private TilePositionValidator tilePositionValidator;

    public PathFinding(BWEM bwem, Game game) {
        this.bwem = bwem;
        this.game = game;
        this.tilePositionValidator = new TilePositionValidator(game);
    }

    public List<Position> findPath(Position start, Position goal) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(Node::getF));
        HashMap<Position, Node> allNodes = new HashMap<Position, Node>();
        Node startNode = new Node(start, null, 0.0, this.heuristic(start, goal));
        openSet.add(startNode);
        allNodes.put(start, startNode);
        while (!openSet.isEmpty()) {
            Node current = openSet.poll();
            if (current.getPosition().equals(goal)) {
                return this.reconstructPath(current);
            }
            for (Position neighbor : this.getNeighbors(current.getPosition())) {
                Node neighborNode;
                double tentativeG = current.getG() + (double)current.getPosition().getApproxDistance(neighbor);
                if (!(tentativeG < (neighborNode = allNodes.getOrDefault(neighbor, new Node(neighbor))).getG())) continue;
                neighborNode.setCameFrom(current);
                neighborNode.setG(tentativeG);
                neighborNode.setF(tentativeG + this.heuristic(neighbor, goal));
                if (!openSet.contains(neighborNode)) {
                    openSet.add(neighborNode);
                }
                allNodes.put(neighbor, neighborNode);
            }
        }
        return Collections.emptyList();
    }

    private List<Position> reconstructPath(Node node) {
        ArrayList<Position> path = new ArrayList<Position>();
        while (node != null) {
            path.add(node.getPosition());
            node = node.getCameFrom();
        }
        Collections.reverse(path);
        return path;
    }

    private double heuristic(Position a, Position b) {
        return a.getApproxDistance(b);
    }

    private List<Position> getNeighbors(Position position) {
        ArrayList<Position> neighbors = new ArrayList<Position>();
        TilePosition tilePosition = position.toTilePosition();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                TilePosition neighborTile;
                if (dx == 0 && dy == 0 || !this.tilePositionValidator.isValid(neighborTile = new TilePosition(tilePosition.getX() + dx, tilePosition.getY() + dy)) || !this.bwem.getMap().getTile(neighborTile).isWalkable()) continue;
                neighbors.add(neighborTile.toPosition());
            }
        }
        return neighbors;
    }

    public Position findNearestWalkable(Position position) {
        TilePosition centerTile = position.toTilePosition();
        if (this.tilePositionValidator.isWalkable(centerTile)) {
            return centerTile.toPosition();
        }
        for (int radius = 1; radius <= 10; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    TilePosition checkTile;
                    if (Math.abs(dx) != radius && Math.abs(dy) != radius || !this.tilePositionValidator.isValid(checkTile = new TilePosition(centerTile.getX() + dx, centerTile.getY() + dy)) || !this.tilePositionValidator.isWalkable(checkTile)) continue;
                    return checkTile.toPosition();
                }
            }
        }
        return null;
    }

    public TilePositionValidator getTilePositionValidator() {
        return this.tilePositionValidator;
    }

    private static class Node {
        private Position position;
        private Node cameFrom;
        private double g;
        private double f;

        public Node(Position position) {
            this.position = position;
            this.g = Double.POSITIVE_INFINITY;
            this.f = Double.POSITIVE_INFINITY;
        }

        public Node(Position position, Node cameFrom, double g, double f) {
            this.position = position;
            this.cameFrom = cameFrom;
            this.g = g;
            this.f = f;
        }

        public Position getPosition() {
            return this.position;
        }

        public Node getCameFrom() {
            return this.cameFrom;
        }

        public void setCameFrom(Node cameFrom) {
            this.cameFrom = cameFrom;
        }

        public double getG() {
            return this.g;
        }

        public void setG(double g) {
            this.g = g;
        }

        public double getF() {
            return this.f;
        }

        public void setF(double f) {
            this.f = f;
        }
    }
}

