/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups.units;

import bwapi.Game;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.WeaponType;
import bwem.Base;
import bwem.ChokePoint;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;
import util.Time;

public class Vulture
extends CombatUnits {
    private EnemyInformation enemyInformation;
    private BaseInfo baseInfo;
    private List<Position> minePositions = new ArrayList<Position>();
    private Position currentMinePos = null;
    private int mineCount = 3;
    private int pulseCheck = 0;
    private int mineTimer = 0;
    private boolean layingMines = false;
    private boolean recentlyMined = false;
    private boolean lobotomyOverride = false;
    private final int FULL_MINE_CYCLE = new Time(0, 30).getFrames();
    private final int ALLOWED_MINE_CYCLE = new Time(0, 10).getFrames();
    private int mineCycle;

    public Vulture(Game game, EnemyInformation enemyInformation, Unit unit) {
        super(game, unit);
        this.enemyInformation = enemyInformation;
        this.baseInfo = enemyInformation.getBaseInfo();
        this.unitStatus = UnitStatus.ATTACK;
        this.mineCycle = game.getFrameCount();
        this.calculateMinePositions();
    }

    @Override
    public void rally() {
        if (this.rallyPoint == null) {
            return;
        }
        this.unit.move(this.rallyPoint.toPosition());
        this.setUnitStatus(UnitStatus.ATTACK);
    }

    @Override
    public void attack() {
        if (this.enemyUnit == null) {
            return;
        }
        if (this.mineCount > this.unit.getSpiderMineCount()) {
            this.mineCount = this.unit.getSpiderMineCount();
            this.recentlyMined = true;
            this.layingMines = false;
        }
        if (this.pulseCheck > 64) {
            this.pulseCheck = 0;
            this.layingMines = false;
        }
        if (this.layingMines) {
            if (this.unit.isStuck()) {
                this.layingMines = false;
                this.recentlyMined = true;
                this.pulseCheck = 0;
                return;
            }
            this.pulseCheck += 8;
            return;
        }
        if (this.isOutRanged() && !this.hasTankSupport && !this.lobotomyOverride) {
            this.unitStatus = UnitStatus.RETREAT;
            return;
        }
        if (this.enemyInformation.outRangingUnitNearby(this.enemyUnit, this.unit.getType(), this.unit.getType().groundWeapon().maxRange() - 32) && !this.hasTankSupport && !this.lobotomyOverride) {
            this.unitStatus = UnitStatus.RETREAT;
            return;
        }
        this.attackMove();
        if (!this.game.self().hasResearched(TechType.Spider_Mines) || this.unit.getSpiderMineCount() == 0) {
            return;
        }
        this.layMinesOnEnemy();
        if (this.allowMineLaying()) {
            this.layMinesAtChokepoints();
        }
    }

    @Override
    public void retreat() {
        if (this.enemyUnit == null || this.rallyPoint == null) {
            return;
        }
        if (this.unit.getDistance(this.rallyPoint.toPosition()) < 100) {
            this.setUnitStatus(UnitStatus.DEFEND);
        }
        if (!this.inRangeOfThreat && this.isOutRanged()) {
            this.unit.move(this.rallyPoint.toPosition());
        }
        if (this.inBase && this.isOutRanged()) {
            this.setUnitStatus(UnitStatus.DEFEND);
        }
        if (this.enemyInformation.outRangingUnitNearby(this.enemyUnit, this.unit.getType(), this.unit.getType().groundWeapon().maxRange() - 32) && !this.hasTankSupport) {
            this.unit.move(this.rallyPoint.toPosition());
        }
        if (!(this.inRangeOfThreat || this.isOutRanged() && !this.hasTankSupport)) {
            this.setUnitStatus(UnitStatus.ATTACK);
        }
    }

    @Override
    public void defend() {
        if (this.rallyPoint == null) {
            return;
        }
        if (this.enemyUnit == null) {
            this.setUnitStatus(UnitStatus.ATTACK);
            return;
        }
        if (this.isOutRanged() && this.inBase) {
            this.attackMove();
            if (this.hasTankSupport) {
                this.setUnitStatus(UnitStatus.ATTACK);
            }
            return;
        }
        if (!this.enemyInBase && this.inBase) {
            this.setUnitStatus(UnitStatus.ATTACK);
            return;
        }
        if (!this.isOutRanged()) {
            this.setUnitStatus(UnitStatus.ATTACK);
            return;
        }
        this.attackMove();
    }

    private Position kiteTo(int distance) {
        Position enemyPos = this.enemyUnit.getEnemyPosition();
        Position unitPos = this.unit.getPosition();
        int dx = unitPos.getX() - enemyPos.getX();
        int dy = unitPos.getY() - enemyPos.getY();
        double moveX = (double)unitPos.getX() + (double)(dx * distance) / Math.max(1.0, unitPos.getDistance(enemyPos));
        double moveY = (double)unitPos.getY() + (double)(dy * distance) / Math.max(1.0, unitPos.getDistance(enemyPos));
        moveX = Math.min(Math.max(moveX, 0.0), (double)(this.game.mapWidth() * 32));
        moveY = Math.min(Math.max(moveY, 0.0), (double)(this.game.mapHeight() * 32));
        return new Position((int)moveX, (int)moveY);
    }

    private boolean minimnumThreshold(double threshold) {
        double halfRange = (double)this.weaponRange() * threshold;
        Position enemyPosition = this.enemyUnit.getEnemyPosition();
        Position unitPosition = this.unit.getPosition();
        double distanceToEnemy = unitPosition.getDistance(enemyPosition);
        return distanceToEnemy < halfRange;
    }

    private void attackMove() {
        if (this.minimnumThreshold(1.05)) {
            this.unit.patrol(this.kiteTo(this.weaponRange()));
        } else if (this.minimnumThreshold(0.5)) {
            this.unit.move(this.kiteTo(this.weaponRange()));
        } else {
            this.unit.move(this.enemyUnit.getEnemyPosition());
        }
    }

    private int weaponRange() {
        WeaponType weaponType = this.unit.getType().groundWeapon();
        return weaponType.maxRange();
    }

    private void calculateMinePositions() {
        if (this.enemyInformation.getStartingEnemyBase() == null) {
            return;
        }
        if (this.enemyInformation.getStartingEnemyBase().getEnemyPosition() == null) {
            return;
        }
        ChokePoint mainChoke = this.baseInfo.getMainChoke();
        ChokePoint naturalChoke = this.baseInfo.getNaturalChoke();
        if (mainChoke == null || naturalChoke == null) {
            return;
        }
        for (Base base : this.baseInfo.getAllBasePaths().getPathLists().keySet()) {
            if (!this.enemyInformation.getStartingEnemyBase().getEnemyPosition().equals(base.getCenter())) continue;
            List<Position> allPositions = this.baseInfo.getAllBasePaths().getPathLists().get(base);
            for (Position position : allPositions) {
                boolean nearNaturalChoke;
                boolean nearMainChoke = position.getDistance(mainChoke.getCenter().toPosition()) < 175.0;
                boolean bl = nearNaturalChoke = position.getDistance(naturalChoke.getCenter().toPosition()) < 175.0;
                if (nearMainChoke || nearNaturalChoke) continue;
                this.minePositions.add(position);
            }
        }
    }

    private boolean isOutRanged() {
        if (this.enemyUnit != null) {
            if (this.enemyUnit.getEnemyType().isBuilding()) {
                return false;
            }
            if (this.enemyUnit.getEnemyType().groundWeapon().maxRange() + 32 >= this.weaponRange()) {
                return true;
            }
        }
        return false;
    }

    private void layMinesAtChokepoints() {
        if (this.minePositions.isEmpty()) {
            this.calculateMinePositions();
            return;
        }
        for (Position pos : this.minePositions) {
            if (this.unit.getDistance(pos) >= 250) continue;
            for (int validMinePositionAttempt = 0; validMinePositionAttempt < 10; ++validMinePositionAttempt) {
                Random random = new Random();
                int randX = pos.getX() - 200 + random.nextInt(400);
                int randY = pos.getY() - 200 + random.nextInt(400);
                Position testPos = new Position(randX, randY);
                if (this.baseInfo.getPathFinding().getTilePositionValidator().isWalkable(testPos.toTilePosition())) {
                    this.currentMinePos = testPos;
                    break;
                }
                ++validMinePositionAttempt;
            }
            if (this.currentMinePos == null) continue;
            this.unit.useTech(TechType.Spider_Mines, this.currentMinePos);
            this.layingMines = true;
            this.currentMinePos = null;
        }
    }

    private void layMinesOnEnemy() {
        if (this.enemyUnit.getEnemyType().isBuilding()) {
            return;
        }
        if (this.mineTimer >= 192) {
            this.mineTimer = 0;
            this.recentlyMined = false;
        }
        if (this.recentlyMined) {
            this.mineTimer += 8;
            return;
        }
        if (this.unit.getDistance(this.enemyUnit.getEnemyPosition()) < 200) {
            if (this.enemyUnit.getEnemyType().groundWeapon().maxRange() <= 64) {
                Position minePos = this.kiteTo(64);
                this.unit.move(minePos);
                this.unit.useTech(TechType.Spider_Mines, minePos);
                this.layingMines = true;
            } else {
                this.unit.useTech(TechType.Spider_Mines, this.unit.getPosition());
                this.layingMines = true;
            }
        }
    }

    private boolean allowMineLaying() {
        int idOffset;
        if (this.recentlyMined) {
            return false;
        }
        int currentFrame = this.game.getFrameCount();
        return (currentFrame - this.mineCycle + (idOffset = (10 + this.unit.getID() % 21) * 24)) % this.FULL_MINE_CYCLE < this.ALLOWED_MINE_CYCLE;
    }

    public boolean isLobotomyOverride() {
        return this.lobotomyOverride;
    }

    public void setLobotomyOverride(boolean lobotomyOverride) {
        this.lobotomyOverride = lobotomyOverride;
    }
}

