/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups;

import bwapi.Game;
import bwapi.Position;
import bwapi.Unit;
import information.enemy.EnemyUnits;
import macro.unitgroups.WorkerStatus;

public class Workers {
    private Game game;
    private Unit unit;
    private Unit repairTarget;
    private WorkerStatus workerStatus;
    private int buildFrameCount;
    private int attackClock;
    private int idleClock = 0;
    private int lastFrameChecked = 0;
    private int unitID;
    private Integer distanceToBuildTarget = null;
    private EnemyUnits enemyUnit;
    private boolean preemptiveRepair = false;
    private boolean assignedToBase = false;
    private Position buildingPosition;

    public Workers(Game game, Unit unit, WorkerStatus workerStatus) {
        this.game = game;
        this.unit = unit;
        this.workerStatus = workerStatus;
        this.unitID = unit.getID();
        this.buildFrameCount = 0;
        this.attackClock = 0;
    }

    public void selfDefense() {
        if (this.enemyUnit == null) {
            return;
        }
        if (!this.unit.isAttackFrame()) {
            this.attackClock = 0;
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
    }

    public void repair(Unit target) {
        if (target != null && target.getHitPoints() < target.getType().maxHitPoints() && !this.unit.isRepairing()) {
            this.unit.repair(target);
            return;
        }
        if (target != null && this.preemptiveRepair && target.getHitPoints() == target.getType().maxHitPoints()) {
            this.unit.move(target.getPosition());
            return;
        }
        if (target == null || target.getHitPoints() >= target.getType().maxHitPoints() && !this.preemptiveRepair) {
            this.workerStatus = WorkerStatus.IDLE;
            this.repairTarget = null;
        }
    }

    public void pulseCheck() {
        if (this.buildingPosition == null) {
            return;
        }
        if (!this.unit.isMoving()) {
            ++this.idleClock;
        }
        if (this.idleClock > 48) {
            this.unit.move(this.buildingPosition);
            this.idleClock = 0;
        }
    }

    public void stuckCheck() {
        ++this.lastFrameChecked;
        if (this.lastFrameChecked < 240) {
            return;
        }
        if (this.distanceToBuildTarget == null || this.buildingPosition == null) {
            return;
        }
        int currentDistance = this.unit.getDistance(this.buildingPosition);
        if (Math.abs(this.distanceToBuildTarget - currentDistance) < 32 && this.distanceToBuildTarget > 96) {
            this.setWorkerStatus(WorkerStatus.STUCK);
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public WorkerStatus getWorkerStatus() {
        return this.workerStatus;
    }

    public void setWorkerStatus(WorkerStatus workerStatus) {
        this.workerStatus = workerStatus;
    }

    public int getBuildFrameCount() {
        return this.buildFrameCount;
    }

    public void setBuildFrameCount(int buildFrameCount) {
        this.buildFrameCount = buildFrameCount;
    }

    public int getAttackClock() {
        return this.attackClock;
    }

    public void setAttackClock(int attackClock) {
        this.attackClock = attackClock;
    }

    public EnemyUnits getEnemyUnit() {
        return this.enemyUnit;
    }

    public void setEnemyUnit(EnemyUnits enemyUnit) {
        this.enemyUnit = enemyUnit;
    }

    public Unit getRepairTarget() {
        return this.repairTarget;
    }

    public void setRepairTarget(Unit repairTarget) {
        this.repairTarget = repairTarget;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public void setUnitID(int unitID) {
        this.unitID = unitID;
    }

    public int getIdleClock() {
        return this.idleClock;
    }

    public void setIdleClock(int idleClock) {
        this.idleClock = idleClock;
    }

    public boolean isPreemptiveRepair() {
        return this.preemptiveRepair;
    }

    public void setPreemptiveRepair(boolean preemptiveRepair) {
        this.preemptiveRepair = preemptiveRepair;
    }

    public boolean isAssignedToBase() {
        return this.assignedToBase;
    }

    public void setAssignedToBase(boolean assignedToBase) {
        this.assignedToBase = assignedToBase;
    }

    public Position getBuildingPosition() {
        return this.buildingPosition;
    }

    public void setBuildingPosition(Position buildingPosition) {
        this.buildingPosition = buildingPosition;
    }

    public int getDistanceToBuildTarget() {
        return this.distanceToBuildTarget;
    }

    public void setDistanceToBuildTarget(int distanceToBuildTarget) {
        this.distanceToBuildTarget = distanceToBuildTarget;
    }

    public int getLastFrameChecked() {
        return this.lastFrameChecked;
    }

    public void setLastFrameChecked(int lastFrameChecked) {
        this.lastFrameChecked = lastFrameChecked;
    }
}

