/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups;

import bwapi.Game;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import information.enemy.EnemyUnits;
import java.util.HashSet;
import macro.unitgroups.UnitStatus;

public class CombatUnits {
    protected Game game;
    protected Unit unit;
    protected UnitType unitType;
    protected UnitStatus unitStatus;
    protected CombatUnits friendlyUnit;
    protected EnemyUnits enemyUnit;
    protected EnemyUnits closestEnemyBuilding;
    protected TilePosition rallyPoint;
    protected HashSet<UnitType> priorityTargets = new HashSet();
    protected int unitID;
    protected int resetClock = 0;
    protected int targetRange = 200;
    protected boolean inBunker;
    protected boolean enemyInBase = false;
    protected boolean inRangeOfThreat = false;
    protected boolean naturalRallySet = false;
    protected boolean hasTankSupport = false;
    protected boolean priorityTargetExists = false;
    protected boolean inBase = true;

    public CombatUnits(Game game, Unit unit) {
        this.game = game;
        this.unit = unit;
        this.unitType = unit.getType();
        this.unitID = unit.getID();
        this.rallyPoint = null;
        this.unitStatus = UnitStatus.RALLY;
        this.inBunker = false;
    }

    public CombatUnits(Unit unit, UnitStatus unitStatus) {
        this.unit = unit;
        this.unitType = unit.getType();
        this.unitID = unit.getID();
        this.rallyPoint = null;
        this.unitStatus = unitStatus;
        this.inBunker = false;
    }

    public CombatUnits(Game game, Unit unit, UnitStatus unitStatus) {
        this.game = game;
        this.unit = unit;
        this.unitType = unit.getType();
        this.unitID = unit.getID();
        this.rallyPoint = null;
        this.unitStatus = unitStatus;
        this.inBunker = false;
    }

    public void attack() {
        if (this.enemyUnit == null) {
            return;
        }
        if (!this.unit.isStimmed() && this.unit.isAttacking()) {
            this.unit.useTech(TechType.Stim_Packs);
        }
        if (!this.unit.isStartingAttack() && this.unit.getGroundWeaponCooldown() == 0 && !this.unit.isAttackFrame()) {
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
    }

    public void rally() {
        if (this.rallyPoint == null) {
            return;
        }
        if (this.enemyUnit != null) {
            this.setUnitStatus(UnitStatus.DEFEND);
        }
        this.unit.attack(this.rallyPoint.toPosition());
    }

    public void defend() {
        if (this.enemyUnit == null) {
            this.setUnitStatus(UnitStatus.RALLY);
            return;
        }
        if (!this.unit.isStimmed() && this.unit.isAttacking()) {
            this.unit.useTech(TechType.Stim_Packs);
        }
        if (!this.unit.isStartingAttack() && this.unit.getGroundWeaponCooldown() == 0 && !this.unit.isAttackFrame()) {
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
    }

    public void retreat() {
        if (this.enemyUnit == null) {
            return;
        }
        if (!this.inRangeOfThreat) {
            this.setUnitStatus(UnitStatus.ATTACK);
        }
    }

    public void hunting() {
    }

    public void onFrame() {
    }

    public int getResetClock() {
        return this.resetClock;
    }

    public void setResetClock(int resetClock) {
        this.resetClock = resetClock;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public UnitStatus getUnitStatus() {
        return this.unitStatus;
    }

    public void setUnitStatus(UnitStatus unitStatus) {
        this.unitStatus = unitStatus;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public void setUnitType(UnitType unitType) {
        this.unitType = unitType;
    }

    public void setEnemyUnit(EnemyUnits enemyUnit) {
        this.enemyUnit = enemyUnit;
    }

    public EnemyUnits getEnemyUnit() {
        return this.enemyUnit;
    }

    public TilePosition getRallyPoint() {
        return this.rallyPoint;
    }

    public void setRallyPoint(TilePosition rallyPoint) {
        this.rallyPoint = rallyPoint;
    }

    public boolean isInBunker() {
        return this.inBunker;
    }

    public void setInBunker(boolean inBunker) {
        this.inBunker = inBunker;
    }

    public CombatUnits getFriendlyUnit() {
        return this.friendlyUnit;
    }

    public void setFriendlyUnit(CombatUnits friendlyUnit) {
        this.friendlyUnit = friendlyUnit;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public void setTargetRange(int targetRange) {
        this.targetRange = targetRange;
    }

    public boolean isEnemyInBase() {
        return this.enemyInBase;
    }

    public void setEnemyInBase(boolean enemyInBase) {
        this.enemyInBase = enemyInBase;
    }

    public boolean isInRangeOfThreat() {
        return this.inRangeOfThreat;
    }

    public void setInRangeOfThreat(boolean inRangeOfThreat) {
        this.inRangeOfThreat = inRangeOfThreat;
    }

    public boolean isNaturalRallySet() {
        return this.naturalRallySet;
    }

    public void setNaturalRallySet(boolean naturalRallySet) {
        this.naturalRallySet = naturalRallySet;
    }

    public boolean hasTankSupport() {
        return this.hasTankSupport;
    }

    public void setHasTankSupport(boolean hasTankSupport) {
        this.hasTankSupport = hasTankSupport;
    }

    public HashSet<UnitType> getPriorityTargets() {
        return this.priorityTargets;
    }

    public boolean isPriorityTargetExists() {
        return this.priorityTargetExists;
    }

    public void setPriorityTargetExists(boolean priorityTargetExists) {
        this.priorityTargetExists = priorityTargetExists;
    }

    public boolean isInBase() {
        return this.inBase;
    }

    public void setInBase(boolean inBase) {
        this.inBase = inBase;
    }
}

