/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Position;
import bwapi.UnitType;
import information.enemy.EnemyUnits;
import java.util.HashSet;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.units.SiegeTank;

public class ClosestUnit {
    public static void findClosestUnit(CombatUnits combatUnit, HashSet<EnemyUnits> enemyUnits, int range) {
        if (combatUnit.getUnitType() == UnitType.Terran_Medic) {
            return;
        }
        EnemyUnits closestEnemy = ClosestUnit.findClosestEnemyUnit(combatUnit, enemyUnits, range);
        if (closestEnemy == null) {
            combatUnit.setEnemyUnit(null);
            return;
        }
        combatUnit.setEnemyUnit(closestEnemy);
    }

    public static void findClosestFriendlyUnit(CombatUnits combatUnit, HashSet<CombatUnits> friendlyUnits, UnitType unitType) {
        CombatUnits closestUnit = null;
        int closestDistance = combatUnit.getTargetRange();
        if (combatUnit.getFriendlyUnit() != null && combatUnit.getFriendlyUnit().getUnit().exists()) {
            return;
        }
        for (CombatUnits friendlyUnit : friendlyUnits) {
            int distance;
            if (friendlyUnit.getUnitID() == combatUnit.getUnitID() || friendlyUnit.getUnitType() != unitType && !(friendlyUnit instanceof SiegeTank) || friendlyUnit.getUnitType() == UnitType.Terran_Medic || friendlyUnit.isInBunker()) continue;
            if (combatUnit.getUnitType() == UnitType.Terran_Medic) {
                boolean alreadyAssigned = false;
                for (CombatUnits assignedUnit : friendlyUnits) {
                    if (assignedUnit.getUnitType() != UnitType.Terran_Medic || assignedUnit.getUnitID() == combatUnit.getUnitID() || assignedUnit.getFriendlyUnit() == null || assignedUnit.getFriendlyUnit().getUnit().getID() != friendlyUnit.getUnitID()) continue;
                    alreadyAssigned = true;
                    break;
                }
                if (alreadyAssigned) continue;
            }
            if (friendlyUnit.getUnitType().isMechanical() && !unitType.isMechanical() || (distance = combatUnit.getUnit().getDistance(friendlyUnit.getUnit())) >= closestDistance) continue;
            closestUnit = friendlyUnit;
            closestDistance = distance;
        }
        if (closestUnit != null) {
            combatUnit.setFriendlyUnit(closestUnit);
        } else {
            combatUnit.setFriendlyUnit(null);
        }
    }

    public static void priorityTargets(CombatUnits combatUnit, HashSet<UnitType> priorityUnit, HashSet<EnemyUnits> enemyUnits, int range) {
        HashSet<EnemyUnits> priorityEnemies = new HashSet<EnemyUnits>();
        for (EnemyUnits enemyUnit : enemyUnits) {
            if (!priorityUnit.contains((Object)enemyUnit.getEnemyType())) continue;
            priorityEnemies.add(enemyUnit);
            combatUnit.setPriorityTargetExists(true);
        }
        EnemyUnits closestEnemy = ClosestUnit.findClosestEnemyUnit(combatUnit, priorityEnemies, range);
        if (closestEnemy == null) {
            combatUnit.setPriorityTargetExists(false);
            closestEnemy = ClosestUnit.findClosestEnemyUnit(combatUnit, enemyUnits, range);
        }
        combatUnit.setEnemyUnit(closestEnemy);
    }

    private static EnemyUnits findClosestEnemyUnit(CombatUnits combatUnit, HashSet<EnemyUnits> enemyUnits, int range) {
        int closestDistance = range;
        EnemyUnits closestEnemy = null;
        for (EnemyUnits enemyUnit : enemyUnits) {
            int distance;
            Position enemyPosition = enemyUnit.getEnemyPosition();
            Position unitPosition = combatUnit.getUnit().getPosition();
            if (combatUnit.getUnit().getDistance(enemyPosition) < 250 && !enemyUnit.getEnemyUnit().exists()) {
                enemyUnit.setEnemyPosition(null);
                continue;
            }
            if (!combatUnit.getUnit().hasPath(enemyPosition) || !combatUnit.getUnit().getType().airWeapon().targetsAir() && enemyUnit.getEnemyUnit().getType().isFlyer() || enemyUnit.getEnemyUnit().isCloaked() || enemyUnit.getEnemyUnit().isBurrowed() || enemyUnit.getEnemyUnit().isMorphing() || enemyUnit.getEnemyUnit().getType() == UnitType.Zerg_Overlord || enemyUnit.getEnemyUnit().getType() == UnitType.Protoss_Observer || enemyPosition == null || (distance = unitPosition.getApproxDistance(enemyPosition)) >= closestDistance) continue;
            closestDistance = distance;
            closestEnemy = enemyUnit;
        }
        return closestEnemy;
    }
}

