/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Color;
import bwapi.Force;
import bwapi.Game;
import bwapi.PlayerSelf;
import bwapi.PlayerType;
import bwapi.Race;
import bwapi.TechType;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WeaponType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Player
implements Comparable<Player> {
    private final ClientData.PlayerData playerData;
    private final Game game;
    private final int id;
    private final String name;
    private final PlayerType playerType;
    private final TilePosition startLocation;
    private PlayerSelf self = null;

    PlayerSelf self() {
        if (this.self == null) {
            this.self = new PlayerSelf();
        }
        return this.self;
    }

    Player(ClientData.PlayerData playerData, int id, Game game) {
        this.playerData = playerData;
        this.game = game;
        this.id = id;
        this.name = playerData.getName();
        this.playerType = PlayerType.idToEnum[playerData.getType()];
        this.startLocation = new TilePosition(playerData.getStartLocationX(), playerData.getStartLocationY());
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Unit> getUnits() {
        return this.game.getAllUnits().stream().filter(u -> this.equals(u.getPlayer())).collect(Collectors.toList());
    }

    public Race getRace() {
        return Race.idToEnum[this.playerData.getRace()];
    }

    public PlayerType getType() {
        return this.playerType;
    }

    public Force getForce() {
        return this.game.getForce(this.playerData.getForce());
    }

    public boolean isAlly(Player player) {
        if (player == null || this.isNeutral() || player.isNeutral() || this.isObserver() || player.isObserver()) {
            return false;
        }
        return this.playerData.isAlly(player.getID());
    }

    public boolean isEnemy(Player player) {
        if (player == null || this.isNeutral() || player.isNeutral() || this.isObserver() || player.isObserver()) {
            return false;
        }
        return !this.playerData.isAlly(player.getID());
    }

    public boolean isNeutral() {
        return this.equals(this.game.neutral());
    }

    public TilePosition getStartLocation() {
        return this.startLocation;
    }

    public boolean isVictorious() {
        return this.playerData.isVictorious();
    }

    public boolean isDefeated() {
        return this.playerData.isDefeated();
    }

    public boolean leftGame() {
        return this.playerData.getLeftGame();
    }

    public int minerals() {
        int minerals = this.playerData.getMinerals();
        if (this.game.isLatComEnabled() && this.self().minerals.valid(this.game.getFrameCount())) {
            return minerals + (Integer)this.self().minerals.get();
        }
        return minerals;
    }

    public int gas() {
        int gas = this.playerData.getGas();
        if (this.game.isLatComEnabled() && this.self().gas.valid(this.game.getFrameCount())) {
            return gas + (Integer)this.self().gas.get();
        }
        return gas;
    }

    public int gatheredMinerals() {
        return this.playerData.getGatheredMinerals();
    }

    public int gatheredGas() {
        return this.playerData.getGatheredGas();
    }

    public int repairedMinerals() {
        return this.playerData.getRepairedMinerals();
    }

    public int repairedGas() {
        return this.playerData.getRepairedGas();
    }

    public int refundedMinerals() {
        return this.playerData.getRefundedMinerals();
    }

    public int refundedGas() {
        return this.playerData.getRefundedGas();
    }

    public int spentMinerals() {
        return this.gatheredMinerals() + this.refundedMinerals() - this.minerals() - this.repairedMinerals();
    }

    public int spentGas() {
        return this.gatheredGas() + this.refundedGas() - this.gas() - this.repairedGas();
    }

    public int supplyTotal() {
        return this.supplyTotal(this.getRace());
    }

    public int supplyTotal(Race race) {
        return this.playerData.getSupplyTotal(race.id);
    }

    public int supplyUsed() {
        return this.supplyUsed(this.getRace());
    }

    public int supplyUsed(Race race) {
        int supplyUsed = this.playerData.getSupplyUsed(race.id);
        if (this.game.isLatComEnabled() && this.self().supplyUsed[race.id].valid(this.game.getFrameCount())) {
            return supplyUsed + (Integer)this.self().supplyUsed[race.id].get();
        }
        return supplyUsed;
    }

    public int allUnitCount() {
        return this.allUnitCount(UnitType.AllUnits);
    }

    public int allUnitCount(UnitType unit) {
        return this.playerData.getAllUnitCount(unit.id);
    }

    public int visibleUnitCount() {
        return this.visibleUnitCount(UnitType.AllUnits);
    }

    public int visibleUnitCount(UnitType unit) {
        return this.playerData.getVisibleUnitCount(unit.id);
    }

    public int completedUnitCount() {
        return this.completedUnitCount(UnitType.AllUnits);
    }

    public int completedUnitCount(UnitType unit) {
        return this.playerData.getCompletedUnitCount(unit.id);
    }

    public int incompleteUnitCount() {
        return this.allUnitCount() - this.completedUnitCount();
    }

    public int incompleteUnitCount(UnitType unit) {
        return this.allUnitCount(unit) - this.completedUnitCount(unit);
    }

    public int deadUnitCount() {
        return this.deadUnitCount(UnitType.AllUnits);
    }

    public int deadUnitCount(UnitType unit) {
        return this.playerData.getDeadUnitCount(unit.id);
    }

    public int killedUnitCount() {
        return this.killedUnitCount(UnitType.AllUnits);
    }

    public int killedUnitCount(UnitType unit) {
        return this.playerData.getKilledUnitCount(unit.id);
    }

    public int getUpgradeLevel(UpgradeType upgrade) {
        return this.playerData.getUpgradeLevel(upgrade.id);
    }

    public boolean hasResearched(TechType tech) {
        return this.playerData.getHasResearched(tech.id);
    }

    public boolean isResearching(TechType tech) {
        if (this.game.isLatComEnabled() && this.self().isResearching[tech.id].valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isResearching[tech.id].get();
        }
        return this.playerData.isResearching(tech.id);
    }

    public boolean isUpgrading(UpgradeType upgrade) {
        if (this.game.isLatComEnabled() && this.self().isUpgrading[upgrade.id].valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isUpgrading[upgrade.id].get();
        }
        return this.playerData.isUpgrading(upgrade.id);
    }

    public Color getColor() {
        return new Color(this.playerData.getColor());
    }

    public Text getTextColor() {
        switch (this.playerData.getColor()) {
            case 111: {
                return Text.BrightRed;
            }
            case 165: {
                return Text.Blue;
            }
            case 159: {
                return Text.Teal;
            }
            case 164: {
                return Text.Purple;
            }
            case 156: {
                return Text.Orange;
            }
            case 19: {
                return Text.Brown;
            }
            case 84: {
                return Text.PlayerWhite;
            }
            case 135: {
                return Text.PlayerYellow;
            }
            case 185: {
                return Text.DarkGreen;
            }
            case 136: {
                return Text.LightYellow;
            }
            case 134: {
                return Text.Tan;
            }
            case 51: {
                return Text.GreyBlue;
            }
        }
        return Text.Default;
    }

    public int maxEnergy(UnitType unit) {
        int energy = unit.maxEnergy();
        if (unit == UnitType.Protoss_Arbiter && this.getUpgradeLevel(UpgradeType.Khaydarin_Core) > 0 || unit == UnitType.Protoss_Corsair && this.getUpgradeLevel(UpgradeType.Argus_Jewel) > 0 || unit == UnitType.Protoss_Dark_Archon && this.getUpgradeLevel(UpgradeType.Argus_Talisman) > 0 || unit == UnitType.Protoss_High_Templar && this.getUpgradeLevel(UpgradeType.Khaydarin_Amulet) > 0 || unit == UnitType.Terran_Ghost && this.getUpgradeLevel(UpgradeType.Moebius_Reactor) > 0 || unit == UnitType.Terran_Battlecruiser && this.getUpgradeLevel(UpgradeType.Colossus_Reactor) > 0 || unit == UnitType.Terran_Science_Vessel && this.getUpgradeLevel(UpgradeType.Titan_Reactor) > 0 || unit == UnitType.Terran_Wraith && this.getUpgradeLevel(UpgradeType.Apollo_Reactor) > 0 || unit == UnitType.Terran_Medic && this.getUpgradeLevel(UpgradeType.Caduceus_Reactor) > 0 || unit == UnitType.Zerg_Defiler && this.getUpgradeLevel(UpgradeType.Metasynaptic_Node) > 0 || unit == UnitType.Zerg_Queen && this.getUpgradeLevel(UpgradeType.Gamete_Meiosis) > 0) {
            energy += 50;
        }
        return energy;
    }

    public double topSpeed(UnitType unit) {
        double speed = unit.topSpeed();
        if (unit == UnitType.Terran_Vulture && this.getUpgradeLevel(UpgradeType.Ion_Thrusters) > 0 || unit == UnitType.Zerg_Overlord && this.getUpgradeLevel(UpgradeType.Pneumatized_Carapace) > 0 || unit == UnitType.Zerg_Zergling && this.getUpgradeLevel(UpgradeType.Metabolic_Boost) > 0 || unit == UnitType.Zerg_Hydralisk && this.getUpgradeLevel(UpgradeType.Muscular_Augments) > 0 || unit == UnitType.Protoss_Zealot && this.getUpgradeLevel(UpgradeType.Leg_Enhancements) > 0 || unit == UnitType.Protoss_Shuttle && this.getUpgradeLevel(UpgradeType.Gravitic_Drive) > 0 || unit == UnitType.Protoss_Observer && this.getUpgradeLevel(UpgradeType.Gravitic_Boosters) > 0 || unit == UnitType.Protoss_Scout && this.getUpgradeLevel(UpgradeType.Gravitic_Thrusters) > 0 || unit == UnitType.Zerg_Ultralisk && this.getUpgradeLevel(UpgradeType.Anabolic_Synthesis) > 0) {
            speed = unit == UnitType.Protoss_Scout ? (speed += 1.66796875) : (speed *= 1.5);
            if (speed < 3.33203125) {
                speed = 3.33203125;
            }
        }
        return speed;
    }

    public int weaponMaxRange(WeaponType weapon) {
        int range = weapon.maxRange();
        if (weapon == WeaponType.Gauss_Rifle && this.getUpgradeLevel(UpgradeType.U_238_Shells) > 0 || weapon == WeaponType.Needle_Spines && this.getUpgradeLevel(UpgradeType.Grooved_Spines) > 0) {
            range += 32;
        } else if (weapon == WeaponType.Phase_Disruptor && this.getUpgradeLevel(UpgradeType.Singularity_Charge) > 0) {
            range += 64;
        } else if (weapon == WeaponType.Hellfire_Missile_Pack && this.getUpgradeLevel(UpgradeType.Charon_Boosters) > 0) {
            range += 96;
        }
        return range;
    }

    public int sightRange(UnitType unit) {
        int range = unit.sightRange();
        if (unit == UnitType.Terran_Ghost && this.getUpgradeLevel(UpgradeType.Ocular_Implants) > 0 || unit == UnitType.Zerg_Overlord && this.getUpgradeLevel(UpgradeType.Antennae) > 0 || unit == UnitType.Protoss_Observer && this.getUpgradeLevel(UpgradeType.Sensor_Array) > 0 || unit == UnitType.Protoss_Scout && this.getUpgradeLevel(UpgradeType.Apial_Sensors) > 0) {
            range = 352;
        }
        return range;
    }

    public int weaponDamageCooldown(UnitType unit) {
        int cooldown = unit.groundWeapon().damageCooldown();
        if (unit == UnitType.Zerg_Zergling && this.getUpgradeLevel(UpgradeType.Adrenal_Glands) > 0) {
            cooldown /= 2;
            cooldown = Math.min(Math.max(cooldown, 5), 250);
        }
        return cooldown;
    }

    public int armor(UnitType unit) {
        int armor = unit.armor();
        armor += this.getUpgradeLevel(unit.armorUpgrade());
        if (unit == UnitType.Zerg_Ultralisk && this.getUpgradeLevel(UpgradeType.Chitinous_Plating) > 0 || unit == UnitType.Hero_Torrasque) {
            armor += 2;
        }
        return armor;
    }

    public int damage(WeaponType wpn) {
        int dmg = wpn.damageAmount();
        dmg += this.getUpgradeLevel(wpn.upgradeType()) * wpn.damageBonus();
        return dmg *= wpn.damageFactor();
    }

    public int getUnitScore() {
        return this.playerData.getTotalUnitScore();
    }

    public int getKillScore() {
        return this.playerData.getTotalKillScore();
    }

    public int getBuildingScore() {
        return this.playerData.getTotalBuildingScore();
    }

    public int getRazingScore() {
        return this.playerData.getTotalRazingScore();
    }

    public int getCustomScore() {
        return this.playerData.getCustomScore();
    }

    public boolean isObserver() {
        return !this.playerData.isParticipating();
    }

    public int getMaxUpgradeLevel(UpgradeType upgrade) {
        return this.playerData.getMaxUpgradeLevel(upgrade.id);
    }

    public boolean isResearchAvailable(TechType tech) {
        return this.playerData.isResearchAvailable(tech.id);
    }

    public boolean isUnitAvailable(UnitType unit) {
        return this.playerData.isUnitAvailable(unit.id);
    }

    public boolean hasUnitTypeRequirement(UnitType unit) {
        return this.hasUnitTypeRequirement(unit, 1);
    }

    public boolean hasUnitTypeRequirement(UnitType unit, int amount) {
        if (unit == UnitType.None) {
            return true;
        }
        switch (unit) {
            case Zerg_Hatchery: {
                return this.completedUnitCount(UnitType.Zerg_Hatchery) + this.allUnitCount(UnitType.Zerg_Lair) + this.allUnitCount(UnitType.Zerg_Hive) >= amount;
            }
            case Zerg_Lair: {
                return this.completedUnitCount(UnitType.Zerg_Lair) + this.allUnitCount(UnitType.Zerg_Hive) >= amount;
            }
            case Zerg_Spire: {
                return this.completedUnitCount(UnitType.Zerg_Spire) + this.allUnitCount(UnitType.Zerg_Greater_Spire) >= amount;
            }
        }
        return this.completedUnitCount(unit) >= amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return this.id == player.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Player other) {
        return this.id - other.id;
    }
}

