/*
 * Decompiled with CFR 0.152.
 */
import bwapi.BWClient;
import bwapi.DefaultBWListener;
import bwapi.Game;
import bwapi.Player;
import bwapi.Text;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import debug.Painters;
import information.BaseInfo;
import information.Scouting;
import information.enemy.EnemyInformation;
import macro.ProductionManager;
import macro.ResourceManager;
import macro.UnitManager;

public class Bot
extends DefaultBWListener {
    private BWClient bwClient;
    private Game game;
    private BWEM bwem;
    private Player player;
    private BaseInfo baseInfo;
    private EnemyInformation enemyInformation;
    private ResourceManager resourceManager;
    private ProductionManager productionManager;
    private UnitManager unitManager;
    private Scouting scouting;
    private Painters painters;

    @Override
    public void onStart() {
        this.game = this.bwClient.getGame();
        this.player = this.game.self();
        this.bwem = new BWEM(this.game);
        this.bwem.initialize();
        this.baseInfo = new BaseInfo(this.bwem, this.game);
        this.enemyInformation = new EnemyInformation(this.baseInfo, this.game);
        this.resourceManager = new ResourceManager(this.baseInfo, this.player, this.game, this.enemyInformation);
        this.productionManager = new ProductionManager(this.game, this.player, this.resourceManager, this.baseInfo, this.bwem, this.enemyInformation);
        this.scouting = new Scouting(this.bwem, this.game, this.player, this.resourceManager, this.baseInfo, this.enemyInformation);
        this.unitManager = new UnitManager(this.enemyInformation, this.baseInfo, this.game, this.scouting);
        this.painters = new Painters(this.game, this.bwem, this.resourceManager);
    }

    @Override
    public void onFrame() {
        this.game.drawTextScreen(5, 15, "Frame: " + this.game.getFrameCount(), new Text[0]);
        this.enemyInformation.onFrame();
        this.resourceManager.onFrame();
        this.productionManager.onFrame();
        this.unitManager.onFrame();
        this.scouting.onFrame();
        this.painters.onFrame();
        this.baseInfo.onFrame();
    }

    @Override
    public void onUnitCreate(Unit unit) {
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        this.baseInfo.onUnitCreate(unit);
        this.productionManager.onUnitCreate(unit);
    }

    @Override
    public void onUnitComplete(Unit unit) {
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        if (unit.getType() == UnitType.Terran_Command_Center) {
            this.baseInfo.onUnitComplete(unit);
        }
        this.productionManager.onUnitComplete(unit);
        this.resourceManager.onUnitComplete(unit);
        if (unit.getType() != UnitType.Terran_SCV && !unit.getType().isBuilding()) {
            this.unitManager.onUnitComplete(unit);
        } else if (unit.getType() == UnitType.Terran_Bunker || unit.getType() == UnitType.Terran_Comsat_Station) {
            this.unitManager.onUnitComplete(unit);
        }
    }

    @Override
    public void onUnitDestroy(Unit unit) {
        this.resourceManager.onUnitDestroy(unit);
        this.enemyInformation.onUnitDestroy(unit);
        if (unit.getPlayer() == this.game.self()) {
            if (unit.getType() != UnitType.Terran_SCV) {
                this.unitManager.onUnitDestroy(unit);
            }
            this.productionManager.onUnitDestroy(unit);
        }
        if (unit.getType() == UnitType.Terran_Command_Center) {
            this.baseInfo.onUnitDestroy(unit);
        }
        this.scouting.onEnemyDestroy(unit);
    }

    @Override
    public void onUnitDiscover(Unit unit) {
        if (unit.getPlayer() == this.game.self() || unit.getPlayer() == this.game.neutral()) {
            return;
        }
        this.enemyInformation.onUnitDiscover(unit);
    }

    @Override
    public void onUnitShow(Unit unit) {
        this.enemyInformation.onUnitShow(unit);
    }

    @Override
    public void onUnitMorph(Unit unit) {
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        this.productionManager.onUnitMorph(unit);
    }

    @Override
    public void onUnitRenegade(Unit unit) {
        this.enemyInformation.onUnitRenegade(unit);
    }

    public static void main(String[] args) {
        Bot bot = new Bot();
        bot.bwClient = new BWClient(bot);
        bot.bwClient.startGame();
    }
}

