#include "stdafx.h"
#include "CppUnitTest.h"
#include "specializations.h"
#include <BWAPI.h>
#include "unitTypeHelpers.h"
#include "helpers.h"

using namespace Microsoft::VisualStudio::CppUnitTestFramework;

namespace BWAPILIBTest
{
  TEST_CLASS(UnitTypesTest)
  {
  public:
    TEST_METHOD(UnitTypeTerran_Marine)
    {
      auto t = BWAPI::UnitTypes::Terran_Marine;
      Assert_enum(Terran_Marine);

      Assert_getName(Terran_Marine);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Barracks, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Barracks, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Stim_Packs }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::U_238_Shells, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(360);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(100);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(9);
      Assert_dimensionRight(8);
      Assert_dimensionDown(10);
      Assert_width(17);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(20);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(Gauss_Rifle);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Gauss_Rifle);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Ghost)
    {
      auto t = BWAPI::UnitTypes::Terran_Ghost;
      Assert_enum(Terran_Ghost);

      Assert_getName(Terran_Ghost);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Barracks, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Barracks, 1 }, { BWAPI::UnitTypes::Terran_Academy, 1 }, { BWAPI::UnitTypes::Terran_Covert_Ops, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Lockdown, BWAPI::TechTypes::Personnel_Cloaking, BWAPI::TechTypes::Nuclear_Strike }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons, BWAPI::UpgradeTypes::Ocular_Implants, BWAPI::UpgradeTypes::Moebius_Reactor }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(45);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(0);
      Assert_mineralPrice(25);
      Assert_gasPrice(75);
      Assert_buildTime(750);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(175);
      Assert_destroyScore(350);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(C_10_Canister_Rifle);
      Assert_maxGroundHits(1);
      Assert_airWeapon(C_10_Canister_Rifle);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Vulture)
    {
      auto t = BWAPI::UnitTypes::Terran_Vulture;
      Assert_enum(Terran_Vulture);

      Assert_getName(Terran_Vulture);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Factory, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Factory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Spider_Mines }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Ion_Thrusters, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(80);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(75);
      Assert_gasPrice(0);
      Assert_buildTime(450);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(150);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Fragmentation_Grenade);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(6.40000);
      Assert_acceleration(100);
      Assert_haltDistance(14569);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Goliath)
    {
      auto t = BWAPI::UnitTypes::Terran_Goliath;
      Assert_enum(Terran_Goliath);

      Assert_getName(Terran_Goliath);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Factory, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Factory, 1 }, { BWAPI::UnitTypes::Terran_Armory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons, BWAPI::UpgradeTypes::Charon_Boosters }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(125);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(400);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(256);
      Assert_groundWeapon(Twin_Autocannons);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Hellfire_Missile_Pack);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.57000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(17);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Siege_Tank_Tank_Mode)
    {
      auto t = BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode;
      Assert_enum(Terran_Siege_Tank_Tank_Mode);

      Assert_getName(Terran_Siege_Tank_Tank_Mode);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Factory, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Factory, 1 }, { BWAPI::UnitTypes::Terran_Machine_Shop, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Tank_Siege_Mode }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(150);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(350);
      Assert_destroyScore(700);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(Arclite_Cannon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(13);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_SCV)
    {
      auto t = BWAPI::UnitTypes::Terran_SCV;
      Assert_enum(Terran_SCV);

      Assert_getName(Terran_SCV);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Command_Center, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Command_Center, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(100);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(11);
      Assert_dimensionRight(11);
      Assert_dimensionDown(11);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(23);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(32);
      Assert_sightRange(224);
      Assert_groundWeapon(Fusion_Cutter);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(67);
      Assert_haltDistance(12227);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(true);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Academy, BWAPI::UnitTypes::Terran_Armory, BWAPI::UnitTypes::Terran_Barracks, BWAPI::UnitTypes::Terran_Bunker, BWAPI::UnitTypes::Terran_Engineering_Bay, BWAPI::UnitTypes::Terran_Command_Center, BWAPI::UnitTypes::Terran_Factory, BWAPI::UnitTypes::Terran_Missile_Turret, BWAPI::UnitTypes::Terran_Refinery, BWAPI::UnitTypes::Terran_Science_Facility, BWAPI::UnitTypes::Terran_Starport, BWAPI::UnitTypes::Terran_Supply_Depot }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Wraith)
    {
      auto t = BWAPI::UnitTypes::Terran_Wraith;
      Assert_enum(Terran_Wraith);

      Assert_getName(Terran_Wraith);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Cloaking_Field);
      AssertSetEquals({ BWAPI::TechTypes::Cloaking_Field }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons, BWAPI::UpgradeTypes::Apollo_Reactor }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(120);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(0);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(900);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(800);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(19);
      Assert_dimensionUp(15);
      Assert_dimensionRight(18);
      Assert_dimensionDown(14);
      Assert_width(38);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(30);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(Burst_Lasers);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Gemini_Missiles);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Science_Vessel)
    {
      auto t = BWAPI::UnitTypes::Terran_Science_Vessel;
      Assert_enum(Terran_Science_Vessel);

      Assert_getName(Terran_Science_Vessel);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 }, { BWAPI::UnitTypes::Terran_Control_Tower, 1 }, { BWAPI::UnitTypes::Terran_Science_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::EMP_Shockwave, BWAPI::TechTypes::Defensive_Matrix, BWAPI::TechTypes::Irradiate }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Titan_Reactor }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(225);
      Assert_buildTime(1200);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(625);
      Assert_destroyScore(1250);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(33);
      Assert_dimensionRight(32);
      Assert_dimensionDown(16);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(50);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.00000);
      Assert_acceleration(50);
      Assert_haltDistance(5120);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Gui_Montag)
    {
      auto t = BWAPI::UnitTypes::Hero_Gui_Montag;
      Assert_enum(Hero_Gui_Montag);

      Assert_getName(Hero_Gui_Montag);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Stim_Packs }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(160);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(100);
      Assert_gasPrice(50);
      Assert_buildTime(720);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(7);
      Assert_dimensionRight(11);
      Assert_dimensionDown(14);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Flame_Thrower_Gui_Montag);
      Assert_maxGroundHits(3);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Dropship)
    {
      auto t = BWAPI::UnitTypes::Terran_Dropship;
      Assert_enum(Terran_Dropship);

      Assert_getName(Terran_Dropship);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 }, { BWAPI::UnitTypes::Terran_Control_Tower, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(150);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(8);
      Assert_buildScore(300);
      Assert_destroyScore(600);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(16);
      Assert_dimensionRight(24);
      Assert_dimensionDown(20);
      Assert_width(49);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(37);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.47000);
      Assert_acceleration(17);
      Assert_haltDistance(37756);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Battlecruiser)
    {
      auto t = BWAPI::UnitTypes::Terran_Battlecruiser;
      Assert_enum(Terran_Battlecruiser);

      Assert_getName(Terran_Battlecruiser);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 }, { BWAPI::UnitTypes::Terran_Control_Tower, 1 }, { BWAPI::UnitTypes::Terran_Physics_Lab, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Yamato_Gun }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons, BWAPI::UpgradeTypes::Colossus_Reactor }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(500);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(3);
      Assert_mineralPrice(400);
      Assert_gasPrice(300);
      Assert_buildTime(2000);
      Assert_supplyRequired(12);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(1200);
      Assert_destroyScore(2400);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(29);
      Assert_dimensionRight(37);
      Assert_dimensionDown(29);
      Assert_width(75);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(59);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(ATS_Laser_Battery);
      Assert_maxGroundHits(1);
      Assert_airWeapon(ATA_Laser_Battery);
      Assert_maxAirHits(1);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Vulture_Spider_Mine)
    {
      auto t = BWAPI::UnitTypes::Terran_Vulture_Spider_Mine;
      Assert_enum(Terran_Vulture_Spider_Mine);

      Assert_getName(Terran_Vulture_Spider_Mine);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(20);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(25);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(7);
      Assert_dimensionRight(7);
      Assert_dimensionDown(7);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(15);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(96);
      Assert_groundWeapon(Spider_Mines);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(16.0000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(127);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Nuclear_Missile)
    {
      auto t = BWAPI::UnitTypes::Terran_Nuclear_Missile;
      Assert_enum(Terran_Nuclear_Missile);

      Assert_getName(Terran_Nuclear_Missile);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Nuclear_Silo, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Nuclear_Silo, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(200);
      Assert_gasPrice(200);
      Assert_buildTime(1500);
      Assert_supplyRequired(16);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(800);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(14);
      Assert_dimensionRight(7);
      Assert_dimensionDown(14);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(29);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(96);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(33.3300);
      Assert_acceleration(33);
      Assert_haltDistance(1103213);
      Assert_turnRadius(127);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Civilian)
    {
      auto t = BWAPI::UnitTypes::Terran_Civilian;
      Assert_enum(Terran_Civilian);

      Assert_getName(Terran_Civilian);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(9);
      Assert_dimensionRight(8);
      Assert_dimensionDown(10);
      Assert_width(17);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(20);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Sarah_Kerrigan)
    {
      auto t = BWAPI::UnitTypes::Hero_Sarah_Kerrigan;
      Assert_enum(Hero_Sarah_Kerrigan);

      Assert_getName(Hero_Sarah_Kerrigan);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Lockdown, BWAPI::TechTypes::Personnel_Cloaking }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(50);
      Assert_gasPrice(150);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(700);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(C_10_Canister_Rifle_Sarah_Kerrigan);
      Assert_maxGroundHits(1);
      Assert_airWeapon(C_10_Canister_Rifle_Sarah_Kerrigan);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Alan_Schezar)
    {
      auto t = BWAPI::UnitTypes::Hero_Alan_Schezar;
      Assert_enum(Hero_Alan_Schezar);

      Assert_getName(Hero_Alan_Schezar);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(200);
      Assert_gasPrice(100);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(800);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(256);
      Assert_groundWeapon(Twin_Autocannons_Alan_Schezar);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Hellfire_Missile_Pack_Alan_Schezar);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.57000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(17);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Jim_Raynor_Vulture)
    {
      auto t = BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture;
      Assert_enum(Hero_Jim_Raynor_Vulture);

      Assert_getName(Hero_Jim_Raynor_Vulture);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Spider_Mines }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(300);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Fragmentation_Grenade_Jim_Raynor);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(6.40000);
      Assert_acceleration(100);
      Assert_haltDistance(14569);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Jim_Raynor_Marine)
    {
      auto t = BWAPI::UnitTypes::Hero_Jim_Raynor_Marine;
      Assert_enum(Hero_Jim_Raynor_Marine);

      Assert_getName(Hero_Jim_Raynor_Marine);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Stim_Packs }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(200);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(9);
      Assert_dimensionRight(8);
      Assert_dimensionDown(10);
      Assert_width(17);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(20);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(Gauss_Rifle_Jim_Raynor);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Gauss_Rifle_Jim_Raynor);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Tom_Kazansky)
    {
      auto t = BWAPI::UnitTypes::Hero_Tom_Kazansky;
      Assert_enum(Hero_Tom_Kazansky);

      Assert_getName(Hero_Tom_Kazansky);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Cloaking_Field);
      AssertSetEquals({ BWAPI::TechTypes::Cloaking_Field }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(500);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(400);
      Assert_gasPrice(200);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1600);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(19);
      Assert_dimensionUp(15);
      Assert_dimensionRight(18);
      Assert_dimensionDown(14);
      Assert_width(38);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(30);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(Burst_Lasers_Tom_Kazansky);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Gemini_Missiles_Tom_Kazansky);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Magellan)
    {
      auto t = BWAPI::UnitTypes::Hero_Magellan;
      Assert_enum(Hero_Magellan);

      Assert_getName(Hero_Magellan);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::EMP_Shockwave, BWAPI::TechTypes::Defensive_Matrix, BWAPI::TechTypes::Irradiate }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(50);
      Assert_gasPrice(600);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2500);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(33);
      Assert_dimensionRight(32);
      Assert_dimensionDown(16);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(50);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.00000);
      Assert_acceleration(50);
      Assert_haltDistance(5120);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Edmund_Duke_Tank_Mode)
    {
      auto t = BWAPI::UnitTypes::Hero_Edmund_Duke_Tank_Mode;
      Assert_enum(Hero_Edmund_Duke_Tank_Mode);

      Assert_getName(Hero_Edmund_Duke_Tank_Mode);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Tank_Siege_Mode }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(300);
      Assert_gasPrice(200);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1400);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(Arclite_Cannon_Edmund_Duke);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(13);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Edmund_Duke_Siege_Mode)
    {
      auto t = BWAPI::UnitTypes::Hero_Edmund_Duke_Siege_Mode;
      Assert_enum(Hero_Edmund_Duke_Siege_Mode);

      Assert_getName(Hero_Edmund_Duke_Siege_Mode);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Tank_Siege_Mode }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(300);
      Assert_gasPrice(200);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1400);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(Arclite_Shock_Cannon_Edmund_Duke);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Arcturus_Mengsk)
    {
      auto t = BWAPI::UnitTypes::Hero_Arcturus_Mengsk;
      Assert_enum(Hero_Arcturus_Mengsk);

      Assert_getName(Hero_Arcturus_Mengsk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(1000);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(800);
      Assert_gasPrice(600);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(29);
      Assert_dimensionRight(37);
      Assert_dimensionDown(29);
      Assert_width(75);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(59);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(ATS_Laser_Battery_Hero);
      Assert_maxGroundHits(1);
      Assert_airWeapon(ATA_Laser_Battery_Hero);
      Assert_maxAirHits(1);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Hyperion)
    {
      auto t = BWAPI::UnitTypes::Hero_Hyperion;
      Assert_enum(Hero_Hyperion);

      Assert_getName(Hero_Hyperion);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Yamato_Gun }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(800);
      Assert_gasPrice(600);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(29);
      Assert_dimensionRight(37);
      Assert_dimensionDown(29);
      Assert_width(75);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(59);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(ATS_Laser_Battery_Hyperion);
      Assert_maxGroundHits(1);
      Assert_airWeapon(ATA_Laser_Battery_Hyperion);
      Assert_maxAirHits(1);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Norad_II)
    {
      auto t = BWAPI::UnitTypes::Hero_Norad_II;
      Assert_enum(Hero_Norad_II);

      Assert_getName(Hero_Norad_II);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Yamato_Gun }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(700);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(800);
      Assert_gasPrice(600);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(29);
      Assert_dimensionRight(37);
      Assert_dimensionDown(29);
      Assert_width(75);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(59);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(ATS_Laser_Battery_Hero);
      Assert_maxGroundHits(1);
      Assert_airWeapon(ATA_Laser_Battery_Hero);
      Assert_maxAirHits(1);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Siege_Tank_Siege_Mode)
    {
      auto t = BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode;
      Assert_enum(Terran_Siege_Tank_Siege_Mode);

      Assert_getName(Terran_Siege_Tank_Siege_Mode);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Factory, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Factory, 1 }, { BWAPI::UnitTypes::Terran_Machine_Shop, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Tank_Siege_Mode }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Vehicle_Plating);
      Assert_maxHitPoints(150);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(700);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(Arclite_Shock_Cannon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Firebat)
    {
      auto t = BWAPI::UnitTypes::Terran_Firebat;
      Assert_enum(Terran_Firebat);

      Assert_getName(Terran_Firebat);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Barracks, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Barracks, 1 }, { BWAPI::UnitTypes::Terran_Academy, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Stim_Packs }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(25);
      Assert_buildTime(360);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(200);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(7);
      Assert_dimensionRight(11);
      Assert_dimensionDown(14);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Flame_Thrower);
      Assert_maxGroundHits(3);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpell_Scanner_Sweep)
    {
      auto t = BWAPI::UnitTypes::Spell_Scanner_Sweep;
      Assert_enum(Spell_Scanner_Sweep);

      Assert_getName(Spell_Scanner_Sweep);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(0);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(13);
      Assert_dimensionUp(13);
      Assert_dimensionRight(13);
      Assert_dimensionDown(17);
      Assert_width(27);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(31);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(true);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Medic)
    {
      auto t = BWAPI::UnitTypes::Terran_Medic;
      Assert_enum(Terran_Medic);

      Assert_getName(Terran_Medic);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Barracks, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Barracks, 1 }, { BWAPI::UnitTypes::Terran_Academy, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Restoration, BWAPI::TechTypes::Optical_Flare, BWAPI::TechTypes::Healing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Caduceus_Reactor }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(25);
      Assert_buildTime(450);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(125);
      Assert_destroyScore(250);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(9);
      Assert_dimensionRight(8);
      Assert_dimensionDown(10);
      Assert_width(17);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(20);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(288);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Larva)
    {
      auto t = BWAPI::UnitTypes::Zerg_Larva;
      Assert_enum(Zerg_Larva);

      Assert_getName(Zerg_Larva);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Hatchery, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Hatchery, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(25);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(10);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(8);
      Assert_dimensionRight(7);
      Assert_dimensionDown(7);
      Assert_width(16);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(16);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(128);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Hydralisk, BWAPI::UnitTypes::Zerg_Defiler, BWAPI::UnitTypes::Zerg_Drone, BWAPI::UnitTypes::Zerg_Mutalisk, BWAPI::UnitTypes::Zerg_Overlord, BWAPI::UnitTypes::Zerg_Zergling, BWAPI::UnitTypes::Zerg_Queen, BWAPI::UnitTypes::Zerg_Ultralisk, BWAPI::UnitTypes::Zerg_Scourge }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Egg)
    {
      auto t = BWAPI::UnitTypes::Zerg_Egg;
      Assert_enum(Zerg_Egg);

      Assert_getName(Zerg_Egg);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(10);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(25);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(128);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Zergling)
    {
      auto t = BWAPI::UnitTypes::Zerg_Zergling;
      Assert_enum(Zerg_Zergling);

      Assert_getName(Zerg_Zergling);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Spawning_Pool, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Metabolic_Boost, BWAPI::UpgradeTypes::Zerg_Melee_Attacks, BWAPI::UpgradeTypes::Adrenal_Glands }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(35);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(420);
      Assert_supplyRequired(1);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(25);
      Assert_destroyScore(50);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(4);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(16);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(16);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(Claws);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.49000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(true);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Hydralisk)
    {
      auto t = BWAPI::UnitTypes::Zerg_Hydralisk;
      Assert_enum(Zerg_Hydralisk);

      Assert_getName(Zerg_Hydralisk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Hydralisk_Den, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Missile_Attacks, BWAPI::UpgradeTypes::Muscular_Augments, BWAPI::UpgradeTypes::Grooved_Spines }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(80);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(75);
      Assert_gasPrice(25);
      Assert_buildTime(420);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(125);
      Assert_destroyScore(350);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(10);
      Assert_dimensionUp(10);
      Assert_dimensionRight(10);
      Assert_dimensionDown(12);
      Assert_width(21);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(23);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(192);
      Assert_groundWeapon(Needle_Spines);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Needle_Spines);
      Assert_maxAirHits(1);
      Assert_topSpeed(3.66000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Lurker }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Ultralisk)
    {
      auto t = BWAPI::UnitTypes::Zerg_Ultralisk;
      Assert_enum(Zerg_Ultralisk);

      Assert_getName(Zerg_Ultralisk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Ultralisk_Cavern, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Melee_Attacks, BWAPI::UpgradeTypes::Chitinous_Plating, BWAPI::UpgradeTypes::Anabolic_Synthesis }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(200);
      Assert_buildTime(900);
      Assert_supplyRequired(8);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(650);
      Assert_destroyScore(1300);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(19);
      Assert_dimensionUp(16);
      Assert_dimensionRight(18);
      Assert_dimensionDown(15);
      Assert_width(38);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Kaiser_Blades);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.12000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Broodling)
    {
      auto t = BWAPI::UnitTypes::Zerg_Broodling;
      Assert_enum(Zerg_Broodling);

      Assert_getName(Zerg_Broodling);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Melee_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(30);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(25);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(9);
      Assert_dimensionUp(9);
      Assert_dimensionRight(9);
      Assert_dimensionDown(9);
      Assert_width(19);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(19);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(Toxic_Spores);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(6.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Drone)
    {
      auto t = BWAPI::UnitTypes::Zerg_Drone;
      Assert_enum(Zerg_Drone);

      Assert_getName(Zerg_Drone);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(40);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(100);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(11);
      Assert_dimensionRight(11);
      Assert_dimensionDown(11);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(23);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(Spines);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(67);
      Assert_haltDistance(12227);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(true);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Hydralisk_Den, BWAPI::UnitTypes::Zerg_Creep_Colony, BWAPI::UnitTypes::Zerg_Defiler_Mound, BWAPI::UnitTypes::Zerg_Hatchery, BWAPI::UnitTypes::Zerg_Evolution_Chamber, BWAPI::UnitTypes::Zerg_Extractor, BWAPI::UnitTypes::Zerg_Spawning_Pool, BWAPI::UnitTypes::Zerg_Nydus_Canal, BWAPI::UnitTypes::Zerg_Queens_Nest, BWAPI::UnitTypes::Zerg_Spire, BWAPI::UnitTypes::Zerg_Ultralisk_Cavern }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Overlord)
    {
      auto t = BWAPI::UnitTypes::Zerg_Overlord;
      Assert_enum(Zerg_Overlord);

      Assert_getName(Zerg_Overlord);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Ventral_Sacs, BWAPI::UpgradeTypes::Antennae, BWAPI::UpgradeTypes::Pneumatized_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(16);
      Assert_spaceRequired(255);
      Assert_spaceProvided(8);
      Assert_buildScore(100);
      Assert_destroyScore(200);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(25);
      Assert_dimensionUp(25);
      Assert_dimensionRight(24);
      Assert_dimensionDown(24);
      Assert_width(50);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(50);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.830000);
      Assert_acceleration(27);
      Assert_haltDistance(840);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Mutalisk)
    {
      auto t = BWAPI::UnitTypes::Zerg_Mutalisk;
      Assert_enum(Zerg_Mutalisk);

      Assert_getName(Zerg_Mutalisk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Zerg_Flyer_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(120);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(300);
      Assert_destroyScore(600);
      Assert_size(Small);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Glave_Wurm);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Glave_Wurm);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Guardian, BWAPI::UnitTypes::Zerg_Devourer }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Guardian)
    {
      auto t = BWAPI::UnitTypes::Zerg_Guardian;
      Assert_enum(Zerg_Guardian);

      Assert_getName(Zerg_Guardian);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Mutalisk, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Mutalisk, 1 }, { BWAPI::UnitTypes::Zerg_Greater_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Zerg_Flyer_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(150);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(50);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(550);
      Assert_destroyScore(1100);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(Acid_Spore);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Queen)
    {
      auto t = BWAPI::UnitTypes::Zerg_Queen;
      Assert_enum(Zerg_Queen);

      Assert_getName(Zerg_Queen);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Queens_Nest, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Infestation, BWAPI::TechTypes::Spawn_Broodlings, BWAPI::TechTypes::Ensnare, BWAPI::TechTypes::Parasite }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Gamete_Meiosis }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(120);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(800);
      Assert_size(Medium);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(23);
      Assert_dimensionDown(23);
      Assert_width(48);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(48);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Defiler)
    {
      auto t = BWAPI::UnitTypes::Zerg_Defiler;
      Assert_enum(Zerg_Defiler);

      Assert_getName(Zerg_Defiler);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Defiler_Mound, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing, BWAPI::TechTypes::Dark_Swarm, BWAPI::TechTypes::Plague, BWAPI::TechTypes::Consume }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Metasynaptic_Node }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(80);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(150);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(225);
      Assert_destroyScore(450);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(13);
      Assert_dimensionUp(12);
      Assert_dimensionRight(13);
      Assert_dimensionDown(12);
      Assert_width(27);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(25);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Scourge)
    {
      auto t = BWAPI::UnitTypes::Zerg_Scourge;
      Assert_enum(Zerg_Scourge);

      Assert_getName(Zerg_Scourge);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Larva, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Larva, 1 }, { BWAPI::UnitTypes::Zerg_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(25);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(25);
      Assert_gasPrice(75);
      Assert_buildTime(450);
      Assert_supplyRequired(1);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(200);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(12);
      Assert_dimensionRight(11);
      Assert_dimensionDown(11);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(24);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Suicide_Scourge);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(107);
      Assert_haltDistance(13616);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(true);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Torrasque)
    {
      auto t = BWAPI::UnitTypes::Hero_Torrasque;
      Assert_enum(Hero_Torrasque);

      Assert_getName(Hero_Torrasque);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Melee_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(4);
      Assert_mineralPrice(400);
      Assert_gasPrice(400);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2600);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(19);
      Assert_dimensionUp(16);
      Assert_dimensionRight(18);
      Assert_dimensionDown(15);
      Assert_width(38);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Kaiser_Blades_Torrasque);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.12000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Matriarch)
    {
      auto t = BWAPI::UnitTypes::Hero_Matriarch;
      Assert_enum(Hero_Matriarch);

      Assert_getName(Hero_Matriarch);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Infestation, BWAPI::TechTypes::Spawn_Broodlings, BWAPI::TechTypes::Ensnare, BWAPI::TechTypes::Parasite }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(200);
      Assert_gasPrice(300);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1600);
      Assert_size(Medium);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(23);
      Assert_dimensionDown(23);
      Assert_width(48);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(48);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Infested_Terran)
    {
      auto t = BWAPI::UnitTypes::Zerg_Infested_Terran;
      Assert_enum(Zerg_Infested_Terran);

      Assert_getName(Zerg_Infested_Terran);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Infested_Command_Center, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Infested_Command_Center, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(9);
      Assert_dimensionRight(8);
      Assert_dimensionDown(10);
      Assert_width(17);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(20);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(Suicide_Infested_Terran);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.82000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Infested_Kerrigan)
    {
      auto t = BWAPI::UnitTypes::Hero_Infested_Kerrigan;
      Assert_enum(Hero_Infested_Kerrigan);

      Assert_getName(Hero_Infested_Kerrigan);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Personnel_Cloaking, BWAPI::TechTypes::Ensnare, BWAPI::TechTypes::Psionic_Storm, BWAPI::TechTypes::Consume }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Melee_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(2);
      Assert_mineralPrice(200);
      Assert_gasPrice(300);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4000);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(288);
      Assert_groundWeapon(Claws_Infested_Kerrigan);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Unclean_One)
    {
      auto t = BWAPI::UnitTypes::Hero_Unclean_One;
      Assert_enum(Hero_Unclean_One);

      Assert_getName(Hero_Unclean_One);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing, BWAPI::TechTypes::Dark_Swarm, BWAPI::TechTypes::Plague, BWAPI::TechTypes::Consume }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(50);
      Assert_gasPrice(200);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(900);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(13);
      Assert_dimensionUp(12);
      Assert_dimensionRight(13);
      Assert_dimensionDown(12);
      Assert_width(27);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(25);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Hunter_Killer)
    {
      auto t = BWAPI::UnitTypes::Hero_Hunter_Killer;
      Assert_enum(Hero_Hunter_Killer);

      Assert_getName(Hero_Hunter_Killer);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Missile_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(160);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(150);
      Assert_gasPrice(50);
      Assert_buildTime(780);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(500);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(10);
      Assert_dimensionUp(10);
      Assert_dimensionRight(10);
      Assert_dimensionDown(12);
      Assert_width(21);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(23);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Needle_Spines_Hunter_Killer);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Needle_Spines_Hunter_Killer);
      Assert_maxAirHits(1);
      Assert_topSpeed(3.66000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Devouring_One)
    {
      auto t = BWAPI::UnitTypes::Hero_Devouring_One;
      Assert_enum(Hero_Devouring_One);

      Assert_getName(Hero_Devouring_One);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Melee_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(120);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(840);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(4);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(16);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(16);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(Claws_Devouring_One);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.49000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(true);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Kukulza_Mutalisk)
    {
      auto t = BWAPI::UnitTypes::Hero_Kukulza_Mutalisk;
      Assert_enum(Hero_Kukulza_Mutalisk);

      Assert_getName(Hero_Kukulza_Mutalisk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Zerg_Flyer_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(200);
      Assert_gasPrice(200);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1200);
      Assert_size(Small);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Glave_Wurm_Kukulza);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Glave_Wurm_Kukulza);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(21745);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Kukulza_Guardian)
    {
      auto t = BWAPI::UnitTypes::Hero_Kukulza_Guardian;
      Assert_enum(Hero_Kukulza_Guardian);

      Assert_getName(Hero_Kukulza_Guardian);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Zerg_Flyer_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(4);
      Assert_mineralPrice(100);
      Assert_gasPrice(200);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2200);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(Acid_Spore_Kukulza);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Yggdrasill)
    {
      auto t = BWAPI::UnitTypes::Hero_Yggdrasill;
      Assert_enum(Hero_Yggdrasill);

      Assert_getName(Hero_Yggdrasill);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(1000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(4);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(60);
      Assert_spaceRequired(255);
      Assert_spaceProvided(8);
      Assert_buildScore(0);
      Assert_destroyScore(400);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(25);
      Assert_dimensionUp(25);
      Assert_dimensionRight(24);
      Assert_dimensionDown(24);
      Assert_width(50);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(50);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.830000);
      Assert_acceleration(27);
      Assert_haltDistance(840);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Valkyrie)
    {
      auto t = BWAPI::UnitTypes::Terran_Valkyrie;
      Assert_enum(Terran_Valkyrie);

      Assert_getName(Terran_Valkyrie);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 }, { BWAPI::UnitTypes::Terran_Control_Tower, 1 }, { BWAPI::UnitTypes::Terran_Armory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(250);
      Assert_gasPrice(125);
      Assert_buildTime(750);
      Assert_supplyRequired(6);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(16);
      Assert_dimensionRight(24);
      Assert_dimensionDown(20);
      Assert_width(49);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(37);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Halo_Rockets);
      Assert_maxAirHits(4);
      Assert_topSpeed(6.60000);
      Assert_acceleration(65);
      Assert_haltDistance(21901);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Cocoon)
    {
      auto t = BWAPI::UnitTypes::Zerg_Cocoon;
      Assert_enum(Zerg_Cocoon);

      Assert_getName(Zerg_Cocoon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Mutalisk, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Mutalisk, 1 }, { BWAPI::UnitTypes::Zerg_Greater_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1100);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(128);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Corsair)
    {
      auto t = BWAPI::UnitTypes::Protoss_Corsair;
      Assert_enum(Protoss_Corsair);

      Assert_getName(Protoss_Corsair);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Stargate, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Stargate, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Disruption_Web }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Argus_Jewel, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(80);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(350);
      Assert_destroyScore(700);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(18);
      Assert_dimensionUp(16);
      Assert_dimensionRight(17);
      Assert_dimensionDown(15);
      Assert_width(36);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(288);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Neutron_Flare);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Dark_Templar)
    {
      auto t = BWAPI::UnitTypes::Protoss_Dark_Templar;
      Assert_enum(Protoss_Dark_Templar);

      Assert_getName(Protoss_Dark_Templar);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Gateway, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Gateway, 1 }, { BWAPI::UnitTypes::Protoss_Templar_Archives, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Dark_Archon_Meld }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(80);
      Assert_maxShields(40);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(125);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(325);
      Assert_destroyScore(650);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(6);
      Assert_dimensionRight(11);
      Assert_dimensionDown(19);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(26);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Warp_Blades);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(true);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Dark_Archon }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Devourer)
    {
      auto t = BWAPI::UnitTypes::Zerg_Devourer;
      Assert_enum(Zerg_Devourer);

      Assert_getName(Zerg_Devourer);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Mutalisk, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Mutalisk, 1 }, { BWAPI::UnitTypes::Zerg_Greater_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Carapace, BWAPI::UpgradeTypes::Zerg_Flyer_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Flyer_Carapace);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(150);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(550);
      Assert_destroyScore(1100);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(224);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Corrosive_Acid);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(48);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Dark_Archon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Dark_Archon;
      Assert_enum(Protoss_Dark_Archon);

      Assert_getName(Protoss_Dark_Archon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Dark_Templar, 2);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Dark_Templar, 2 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Mind_Control, BWAPI::TechTypes::Feedback, BWAPI::TechTypes::Maelstrom }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons, BWAPI::UpgradeTypes::Argus_Talisman }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(25);
      Assert_maxShields(200);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(8);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(650);
      Assert_destroyScore(1300);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(224);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(160);
      Assert_haltDistance(5120);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Probe)
    {
      auto t = BWAPI::UnitTypes::Protoss_Probe;
      Assert_enum(Protoss_Probe);

      Assert_getName(Protoss_Probe);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Nexus, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Nexus, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(20);
      Assert_maxShields(20);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(100);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(11);
      Assert_dimensionRight(11);
      Assert_dimensionDown(11);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(23);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Particle_Beam);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(67);
      Assert_haltDistance(12227);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(true);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(true);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Nexus, BWAPI::UnitTypes::Protoss_Arbiter_Tribunal, BWAPI::UnitTypes::Protoss_Assimilator, BWAPI::UnitTypes::Protoss_Citadel_of_Adun, BWAPI::UnitTypes::Protoss_Cybernetics_Core, BWAPI::UnitTypes::Protoss_Fleet_Beacon, BWAPI::UnitTypes::Protoss_Forge, BWAPI::UnitTypes::Protoss_Gateway, BWAPI::UnitTypes::Protoss_Observatory, BWAPI::UnitTypes::Protoss_Photon_Cannon, BWAPI::UnitTypes::Protoss_Pylon, BWAPI::UnitTypes::Protoss_Robotics_Facility, BWAPI::UnitTypes::Protoss_Robotics_Support_Bay, BWAPI::UnitTypes::Protoss_Shield_Battery, BWAPI::UnitTypes::Protoss_Stargate, BWAPI::UnitTypes::Protoss_Templar_Archives }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Zealot)
    {
      auto t = BWAPI::UnitTypes::Protoss_Zealot;
      Assert_enum(Protoss_Zealot);

      Assert_getName(Protoss_Zealot);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Gateway, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Gateway, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons, BWAPI::UpgradeTypes::Leg_Enhancements }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(60);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(200);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(5);
      Assert_dimensionRight(11);
      Assert_dimensionDown(13);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(19);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Psi_Blades);
      Assert_maxGroundHits(2);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Dragoon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Dragoon;
      Assert_enum(Protoss_Dragoon);

      Assert_getName(Protoss_Dragoon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Gateway, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Gateway, 1 }, { BWAPI::UnitTypes::Protoss_Cybernetics_Core, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons, BWAPI::UpgradeTypes::Singularity_Charge }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(80);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(125);
      Assert_gasPrice(50);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(250);
      Assert_destroyScore(500);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(15);
      Assert_dimensionUp(15);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Phase_Disruptor);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Phase_Disruptor);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_High_Templar)
    {
      auto t = BWAPI::UnitTypes::Protoss_High_Templar;
      Assert_enum(Protoss_High_Templar);

      Assert_getName(Protoss_High_Templar);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Gateway, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Gateway, 1 }, { BWAPI::UnitTypes::Protoss_Templar_Archives, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Psionic_Storm, BWAPI::TechTypes::Hallucination, BWAPI::TechTypes::Archon_Warp }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Khaydarin_Amulet }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(40);
      Assert_maxEnergy(200);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(150);
      Assert_buildTime(750);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(350);
      Assert_destroyScore(700);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(10);
      Assert_dimensionRight(11);
      Assert_dimensionDown(13);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(24);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.20000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Archon }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Archon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Archon;
      Assert_enum(Protoss_Archon);

      Assert_getName(Protoss_Archon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_High_Templar, 2);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_High_Templar, 2 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(10);
      Assert_maxShields(350);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(8);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(700);
      Assert_destroyScore(1400);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(256);
      Assert_groundWeapon(Psionic_Shockwave);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Psionic_Shockwave);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.92000);
      Assert_acceleration(160);
      Assert_haltDistance(5120);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Shuttle)
    {
      auto t = BWAPI::UnitTypes::Protoss_Shuttle;
      Assert_enum(Protoss_Shuttle);

      Assert_getName(Protoss_Shuttle);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Robotics_Facility, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Robotics_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Gravitic_Drive }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(80);
      Assert_maxShields(60);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(8);
      Assert_buildScore(200);
      Assert_destroyScore(400);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(20);
      Assert_dimensionUp(16);
      Assert_dimensionRight(19);
      Assert_dimensionDown(15);
      Assert_width(40);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.43000);
      Assert_acceleration(17);
      Assert_haltDistance(37756);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(true);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Scout)
    {
      auto t = BWAPI::UnitTypes::Protoss_Scout;
      Assert_enum(Protoss_Scout);

      Assert_getName(Protoss_Scout);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Stargate, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Stargate, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons, BWAPI::UpgradeTypes::Apial_Sensors, BWAPI::UpgradeTypes::Gravitic_Thrusters }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(150);
      Assert_maxShields(100);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(275);
      Assert_gasPrice(125);
      Assert_buildTime(1200);
      Assert_supplyRequired(6);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(650);
      Assert_destroyScore(1300);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(18);
      Assert_dimensionUp(16);
      Assert_dimensionRight(17);
      Assert_dimensionDown(15);
      Assert_width(36);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Dual_Photon_Blasters);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Anti_Matter_Missiles);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(48);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Arbiter)
    {
      auto t = BWAPI::UnitTypes::Protoss_Arbiter;
      Assert_enum(Protoss_Arbiter);

      Assert_getName(Protoss_Arbiter);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Stargate, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Stargate, 1 }, { BWAPI::UnitTypes::Protoss_Arbiter_Tribunal, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Recall, BWAPI::TechTypes::Stasis_Field }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons, BWAPI::UpgradeTypes::Khaydarin_Core }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(200);
      Assert_maxShields(150);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(350);
      Assert_buildTime(2400);
      Assert_supplyRequired(8);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(1025);
      Assert_destroyScore(2050);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(Phase_Disruptor_Cannon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Phase_Disruptor_Cannon);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(33);
      Assert_haltDistance(24824);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Carrier)
    {
      auto t = BWAPI::UnitTypes::Protoss_Carrier;
      Assert_enum(Protoss_Carrier);

      Assert_getName(Protoss_Carrier);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Stargate, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Stargate, 1 }, { BWAPI::UnitTypes::Protoss_Fleet_Beacon, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons, BWAPI::UpgradeTypes::Carrier_Capacity }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(300);
      Assert_maxShields(150);
      Assert_maxEnergy(0);
      Assert_armor(4);
      Assert_mineralPrice(350);
      Assert_gasPrice(250);
      Assert_buildTime(2100);
      Assert_supplyRequired(12);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(950);
      Assert_destroyScore(1900);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(352);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.33000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(20);
      Assert_canProduce(true);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Interceptor }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Interceptor)
    {
      auto t = BWAPI::UnitTypes::Protoss_Interceptor;
      Assert_enum(Protoss_Interceptor);

      Assert_getName(Protoss_Interceptor);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Carrier, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Carrier, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(40);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(25);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(30);
      Assert_destroyScore(60);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(8);
      Assert_dimensionUp(8);
      Assert_dimensionRight(7);
      Assert_dimensionDown(7);
      Assert_width(16);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(16);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(192);
      Assert_groundWeapon(Pulse_Cannon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Pulse_Cannon);
      Assert_maxAirHits(1);
      Assert_topSpeed(13.3300);
      Assert_acceleration(427);
      Assert_haltDistance(13640);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Dark_Templar)
    {
      auto t = BWAPI::UnitTypes::Hero_Dark_Templar;
      Assert_enum(Hero_Dark_Templar);

      Assert_getName(Hero_Dark_Templar);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(80);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(150);
      Assert_gasPrice(150);
      Assert_buildTime(750);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(6);
      Assert_dimensionRight(11);
      Assert_dimensionDown(19);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(26);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Warp_Blades_Hero);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(true);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Zeratul)
    {
      auto t = BWAPI::UnitTypes::Hero_Zeratul;
      Assert_enum(Hero_Zeratul);

      Assert_getName(Hero_Zeratul);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(60);
      Assert_maxShields(400);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(300);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(800);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(6);
      Assert_dimensionRight(11);
      Assert_dimensionDown(19);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(26);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Warp_Blades_Zeratul);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.92000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(true);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Tassadar_Zeratul_Archon)
    {
      auto t = BWAPI::UnitTypes::Hero_Tassadar_Zeratul_Archon;
      Assert_enum(Hero_Tassadar_Zeratul_Archon);

      Assert_getName(Hero_Tassadar_Zeratul_Archon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(800);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2800);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(256);
      Assert_groundWeapon(Psionic_Shockwave_TZ_Archon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Psionic_Shockwave_TZ_Archon);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.92000);
      Assert_acceleration(160);
      Assert_haltDistance(5120);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Fenix_Zealot)
    {
      auto t = BWAPI::UnitTypes::Hero_Fenix_Zealot;
      Assert_enum(Hero_Fenix_Zealot);

      Assert_getName(Hero_Fenix_Zealot);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(240);
      Assert_maxShields(240);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(11);
      Assert_dimensionUp(5);
      Assert_dimensionRight(11);
      Assert_dimensionDown(13);
      Assert_width(23);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(19);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Psi_Blades_Fenix);
      Assert_maxGroundHits(2);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Fenix_Dragoon)
    {
      auto t = BWAPI::UnitTypes::Hero_Fenix_Dragoon;
      Assert_enum(Hero_Fenix_Dragoon);

      Assert_getName(Hero_Fenix_Dragoon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(240);
      Assert_maxShields(240);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(300);
      Assert_gasPrice(100);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1000);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(15);
      Assert_dimensionUp(15);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(Phase_Disruptor_Fenix);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Phase_Disruptor_Fenix);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Tassadar)
    {
      auto t = BWAPI::UnitTypes::Hero_Tassadar;
      Assert_enum(Hero_Tassadar);

      Assert_getName(Hero_Tassadar);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Psionic_Storm, BWAPI::TechTypes::Hallucination }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(80);
      Assert_maxShields(300);
      Assert_maxEnergy(250);
      Assert_armor(2);
      Assert_mineralPrice(100);
      Assert_gasPrice(300);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(10);
      Assert_dimensionRight(11);
      Assert_dimensionDown(13);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(24);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Psi_Assault);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.20000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Mojo)
    {
      auto t = BWAPI::UnitTypes::Hero_Mojo;
      Assert_enum(Hero_Mojo);

      Assert_getName(Hero_Mojo);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(400);
      Assert_maxShields(400);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(600);
      Assert_gasPrice(300);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2600);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(18);
      Assert_dimensionUp(16);
      Assert_dimensionRight(17);
      Assert_dimensionDown(15);
      Assert_width(36);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(Dual_Photon_Blasters_Mojo);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Anti_Matter_Missiles_Mojo);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(48);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Warbringer)
    {
      auto t = BWAPI::UnitTypes::Hero_Warbringer;
      Assert_enum(Hero_Warbringer);

      Assert_getName(Hero_Warbringer);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons, BWAPI::UpgradeTypes::Scarab_Damage, BWAPI::UpgradeTypes::Reaver_Capacity }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(200);
      Assert_maxShields(400);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(400);
      Assert_gasPrice(200);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1600);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.78000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(20);
      Assert_canProduce(true);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(true);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Gantrithor)
    {
      auto t = BWAPI::UnitTypes::Hero_Gantrithor;
      Assert_enum(Hero_Gantrithor);

      Assert_getName(Hero_Gantrithor);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(800);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(4);
      Assert_mineralPrice(700);
      Assert_gasPrice(600);
      Assert_buildTime(4200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(3800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.33000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(20);
      Assert_canProduce(true);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Reaver)
    {
      auto t = BWAPI::UnitTypes::Protoss_Reaver;
      Assert_enum(Protoss_Reaver);

      Assert_getName(Protoss_Reaver);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Robotics_Facility, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Robotics_Facility, 1 }, { BWAPI::UnitTypes::Protoss_Robotics_Support_Bay, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons, BWAPI::UpgradeTypes::Scarab_Damage, BWAPI::UpgradeTypes::Reaver_Capacity }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(80);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(200);
      Assert_gasPrice(100);
      Assert_buildTime(1050);
      Assert_supplyRequired(8);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(800);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.78000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(20);
      Assert_canProduce(true);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(true);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Scarab }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Observer)
    {
      auto t = BWAPI::UnitTypes::Protoss_Observer;
      Assert_enum(Protoss_Observer);

      Assert_getName(Protoss_Observer);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Robotics_Facility, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Robotics_Facility, 1 }, { BWAPI::UnitTypes::Protoss_Observatory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Gravitic_Boosters, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Sensor_Array }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(40);
      Assert_maxShields(20);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(25);
      Assert_gasPrice(75);
      Assert_buildTime(600);
      Assert_supplyRequired(2);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(225);
      Assert_destroyScore(450);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.33000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(true);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(true);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Scarab)
    {
      auto t = BWAPI::UnitTypes::Protoss_Scarab;
      Assert_enum(Protoss_Scarab);

      Assert_getName(Protoss_Scarab);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Reaver, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Reaver, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(20);
      Assert_maxShields(10);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(15);
      Assert_gasPrice(0);
      Assert_buildTime(105);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(2);
      Assert_dimensionUp(2);
      Assert_dimensionRight(2);
      Assert_dimensionDown(2);
      Assert_width(5);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(5);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(160);
      Assert_groundWeapon(Scarab);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(16.0000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Danimoth)
    {
      auto t = BWAPI::UnitTypes::Hero_Danimoth;
      Assert_enum(Hero_Danimoth);

      Assert_getName(Hero_Danimoth);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Recall, BWAPI::TechTypes::Stasis_Field }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(600);
      Assert_maxShields(500);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(50);
      Assert_gasPrice(1000);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4100);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(22);
      Assert_dimensionUp(22);
      Assert_dimensionRight(21);
      Assert_dimensionDown(21);
      Assert_width(44);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(44);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(Phase_Disruptor_Cannon_Danimoth);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Phase_Disruptor_Cannon_Danimoth);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(33);
      Assert_haltDistance(24824);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Aldaris)
    {
      auto t = BWAPI::UnitTypes::Hero_Aldaris;
      Assert_enum(Hero_Aldaris);

      Assert_getName(Hero_Aldaris);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Ground_Armor);
      Assert_maxHitPoints(80);
      Assert_maxShields(300);
      Assert_maxEnergy(250);
      Assert_armor(2);
      Assert_mineralPrice(100);
      Assert_gasPrice(300);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(2);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1400);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(12);
      Assert_dimensionUp(10);
      Assert_dimensionRight(11);
      Assert_dimensionDown(13);
      Assert_width(24);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(24);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(96);
      Assert_sightRange(224);
      Assert_groundWeapon(Psi_Assault);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(3.20000);
      Assert_acceleration(27);
      Assert_haltDistance(13474);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Artanis)
    {
      auto t = BWAPI::UnitTypes::Hero_Artanis;
      Assert_enum(Hero_Artanis);

      Assert_getName(Hero_Artanis);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(250);
      Assert_maxShields(250);
      Assert_maxEnergy(0);
      Assert_armor(3);
      Assert_mineralPrice(600);
      Assert_gasPrice(300);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2400);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(18);
      Assert_dimensionUp(16);
      Assert_dimensionRight(17);
      Assert_dimensionDown(15);
      Assert_width(36);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(Dual_Photon_Blasters_Artanis);
      Assert_maxGroundHits(1);
      Assert_airWeapon(Anti_Matter_Missiles_Artanis);
      Assert_maxAirHits(1);
      Assert_topSpeed(5.00000);
      Assert_acceleration(48);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Rhynadon)
    {
      auto t = BWAPI::UnitTypes::Critter_Rhynadon;
      Assert_enum(Critter_Rhynadon);

      Assert_getName(Critter_Rhynadon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Bengalaas)
    {
      auto t = BWAPI::UnitTypes::Critter_Bengalaas;
      Assert_enum(Critter_Bengalaas);

      Assert_getName(Critter_Bengalaas);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Cargo_Ship)
    {
      auto t = BWAPI::UnitTypes::Special_Cargo_Ship;
      Assert_enum(Special_Cargo_Ship);

      Assert_getName(Special_Cargo_Ship);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(125);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(15);
      Assert_dimensionUp(15);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(256);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Mercenary_Gunship)
    {
      auto t = BWAPI::UnitTypes::Special_Mercenary_Gunship;
      Assert_enum(Special_Mercenary_Gunship);

      Assert_getName(Special_Mercenary_Gunship);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(125);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(15);
      Assert_dimensionUp(15);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(128);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Scantid)
    {
      auto t = BWAPI::UnitTypes::Critter_Scantid;
      Assert_enum(Critter_Scantid);

      Assert_getName(Critter_Scantid);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Kakaru)
    {
      auto t = BWAPI::UnitTypes::Critter_Kakaru;
      Assert_enum(Critter_Kakaru);

      Assert_getName(Critter_Kakaru);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.00000);
      Assert_acceleration(16);
      Assert_haltDistance(51200);
      Assert_turnRadius(14);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Ragnasaur)
    {
      auto t = BWAPI::UnitTypes::Critter_Ragnasaur;
      Assert_enum(Critter_Ragnasaur);

      Assert_getName(Critter_Ragnasaur);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeCritter_Ursadon)
    {
      auto t = BWAPI::UnitTypes::Critter_Ursadon;
      Assert_enum(Critter_Ursadon);

      Assert_getName(Critter_Ursadon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(60);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(true);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Lurker_Egg)
    {
      auto t = BWAPI::UnitTypes::Zerg_Lurker_Egg;
      Assert_enum(Zerg_Lurker_Egg);

      Assert_getName(Zerg_Lurker_Egg);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Hydralisk, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Hydralisk, 1 } }, t.requiredUnits());
      Assert_requiredTech(Lurker_Aspect);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(10);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(500);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(128);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Raszagal)
    {
      auto t = BWAPI::UnitTypes::Hero_Raszagal;
      Assert_enum(Hero_Raszagal);

      Assert_getName(Hero_Raszagal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Disruption_Web }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields, BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons }, t.upgrades());
      Assert_armorUpgrade(Protoss_Air_Armor);
      Assert_maxHitPoints(100);
      Assert_maxShields(60);
      Assert_maxEnergy(250);
      Assert_armor(0);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(750);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(1300);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(18);
      Assert_dimensionUp(16);
      Assert_dimensionRight(17);
      Assert_dimensionDown(15);
      Assert_width(36);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(288);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Neutron_Flare);
      Assert_maxAirHits(1);
      Assert_topSpeed(6.67000);
      Assert_acceleration(67);
      Assert_haltDistance(17067);
      Assert_turnRadius(30);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Samir_Duran)
    {
      auto t = BWAPI::UnitTypes::Hero_Samir_Duran;
      Assert_enum(Hero_Samir_Duran);

      Assert_getName(Hero_Samir_Duran);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Lockdown, BWAPI::TechTypes::Personnel_Cloaking }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(2);
      Assert_mineralPrice(200);
      Assert_gasPrice(75);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(700);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(C_10_Canister_Rifle_Samir_Duran);
      Assert_maxGroundHits(1);
      Assert_airWeapon(C_10_Canister_Rifle_Samir_Duran);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Alexei_Stukov)
    {
      auto t = BWAPI::UnitTypes::Hero_Alexei_Stukov;
      Assert_enum(Hero_Alexei_Stukov);

      Assert_getName(Hero_Alexei_Stukov);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Lockdown, BWAPI::TechTypes::Personnel_Cloaking }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Infantry_Armor);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(200);
      Assert_gasPrice(75);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(700);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(C_10_Canister_Rifle_Alexei_Stukov);
      Assert_maxGroundHits(1);
      Assert_airWeapon(C_10_Canister_Rifle_Alexei_Stukov);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Map_Revealer)
    {
      auto t = BWAPI::UnitTypes::Special_Map_Revealer;
      Assert_enum(Special_Map_Revealer);

      Assert_getName(Special_Map_Revealer);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(13);
      Assert_dimensionUp(13);
      Assert_dimensionRight(13);
      Assert_dimensionDown(17);
      Assert_width(27);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(31);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Gerard_DuGalle)
    {
      auto t = BWAPI::UnitTypes::Hero_Gerard_DuGalle;
      Assert_enum(Hero_Gerard_DuGalle);

      Assert_getName(Hero_Gerard_DuGalle);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Yamato_Gun }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Ship_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons }, t.upgrades());
      Assert_armorUpgrade(Terran_Ship_Plating);
      Assert_maxHitPoints(700);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(4);
      Assert_mineralPrice(800);
      Assert_gasPrice(600);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4800);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(29);
      Assert_dimensionRight(37);
      Assert_dimensionDown(29);
      Assert_width(75);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(59);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(ATS_Laser_Battery_Hero);
      Assert_maxGroundHits(1);
      Assert_airWeapon(ATA_Laser_Battery_Hero);
      Assert_maxAirHits(1);
      Assert_topSpeed(2.50000);
      Assert_acceleration(27);
      Assert_haltDistance(7585);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(true);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Lurker)
    {
      auto t = BWAPI::UnitTypes::Zerg_Lurker;
      Assert_enum(Zerg_Lurker);

      Assert_getName(Zerg_Lurker);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Hydralisk, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Hydralisk, 1 } }, t.requiredUnits());
      Assert_requiredTech(Lurker_Aspect);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Zerg_Missile_Attacks }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(125);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(100);
      Assert_buildTime(600);
      Assert_supplyRequired(4);
      Assert_supplyProvided(0);
      Assert_spaceRequired(4);
      Assert_spaceProvided(0);
      Assert_buildScore(250);
      Assert_destroyScore(500);
      Assert_size(Medium);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(15);
      Assert_dimensionUp(15);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(192);
      Assert_sightRange(256);
      Assert_groundWeapon(Subterranean_Spines);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(5.82000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(true);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeHero_Infested_Duran)
    {
      auto t = BWAPI::UnitTypes::Hero_Infested_Duran;
      Assert_enum(Hero_Infested_Duran);

      Assert_getName(Hero_Infested_Duran);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(Personnel_Cloaking);
      AssertSetEquals({ BWAPI::TechTypes::Lockdown, BWAPI::TechTypes::Personnel_Cloaking, BWAPI::TechTypes::Consume }, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Carapace, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Zerg_Carapace);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(250);
      Assert_armor(3);
      Assert_mineralPrice(200);
      Assert_gasPrice(75);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(1);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(700);
      Assert_size(Small);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(7);
      Assert_dimensionUp(10);
      Assert_dimensionRight(7);
      Assert_dimensionDown(11);
      Assert_width(15);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(22);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(C_10_Canister_Rifle_Infested_Duran);
      Assert_maxGroundHits(1);
      Assert_airWeapon(C_10_Canister_Rifle_Infested_Duran);
      Assert_maxAirHits(1);
      Assert_topSpeed(4.00000);
      Assert_acceleration(1);
      Assert_haltDistance(1);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(true);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(true);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(true);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpell_Disruption_Web)
    {
      auto t = BWAPI::UnitTypes::Spell_Disruption_Web;
      Assert_enum(Spell_Disruption_Web);

      Assert_getName(Spell_Disruption_Web);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(250);
      Assert_gasPrice(250);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(60);
      Assert_dimensionUp(40);
      Assert_dimensionRight(59);
      Assert_dimensionDown(39);
      Assert_width(120);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(80);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(true);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Command_Center)
    {
      auto t = BWAPI::UnitTypes::Terran_Command_Center;
      Assert_enum(Terran_Command_Center);

      Assert_getName(Terran_Command_Center);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(400);
      Assert_gasPrice(0);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(20);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(1200);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(58);
      Assert_dimensionUp(41);
      Assert_dimensionRight(58);
      Assert_dimensionDown(41);
      Assert_width(117);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(83);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(true);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_SCV, BWAPI::UnitTypes::Terran_Comsat_Station, BWAPI::UnitTypes::Terran_Nuclear_Silo }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Comsat_Station)
    {
      auto t = BWAPI::UnitTypes::Terran_Comsat_Station;
      Assert_enum(Terran_Comsat_Station);

      Assert_getName(Terran_Comsat_Station);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Command_Center, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Command_Center, 1 }, { BWAPI::UnitTypes::Terran_Academy, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({ BWAPI::TechTypes::Scanner_Sweep }, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(0);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(16);
      Assert_dimensionRight(31);
      Assert_dimensionDown(25);
      Assert_width(69);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(42);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Nuclear_Silo)
    {
      auto t = BWAPI::UnitTypes::Terran_Nuclear_Silo;
      Assert_enum(Terran_Nuclear_Silo);

      Assert_getName(Terran_Nuclear_Silo);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Command_Center, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Command_Center, 1 }, { BWAPI::UnitTypes::Terran_Science_Facility, 1 }, { BWAPI::UnitTypes::Terran_Covert_Ops, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(37);
      Assert_dimensionUp(16);
      Assert_dimensionRight(31);
      Assert_dimensionDown(25);
      Assert_width(69);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(42);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Nuclear_Missile }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Supply_Depot)
    {
      auto t = BWAPI::UnitTypes::Terran_Supply_Depot;
      Assert_enum(Terran_Supply_Depot);

      Assert_getName(Terran_Supply_Depot);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(16);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(38);
      Assert_dimensionUp(22);
      Assert_dimensionRight(38);
      Assert_dimensionDown(26);
      Assert_width(77);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Refinery)
    {
      auto t = BWAPI::UnitTypes::Terran_Refinery;
      Assert_enum(Terran_Refinery);

      Assert_getName(Terran_Refinery);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(4, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(56);
      Assert_dimensionUp(32);
      Assert_dimensionRight(56);
      Assert_dimensionDown(31);
      Assert_width(113);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(true);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Barracks)
    {
      auto t = BWAPI::UnitTypes::Terran_Barracks;
      Assert_enum(Terran_Barracks);

      Assert_getName(Terran_Barracks);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Command_Center, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(40);
      Assert_dimensionRight(56);
      Assert_dimensionDown(32);
      Assert_width(105);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(73);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Marine, BWAPI::UnitTypes::Terran_Firebat, BWAPI::UnitTypes::Terran_Medic, BWAPI::UnitTypes::Terran_Ghost }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Academy)
    {
      auto t = BWAPI::UnitTypes::Terran_Academy;
      Assert_enum(Terran_Academy);

      Assert_getName(Terran_Academy);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Barracks, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(44);
      Assert_dimensionDown(24);
      Assert_width(85);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Stim_Packs, BWAPI::TechTypes::Restoration, BWAPI::TechTypes::Optical_Flare }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::U_238_Shells, BWAPI::UpgradeTypes::Caduceus_Reactor }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Factory)
    {
      auto t = BWAPI::UnitTypes::Terran_Factory;
      Assert_enum(Terran_Factory);

      Assert_getName(Terran_Factory);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Barracks, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1250);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(100);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(600);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(56);
      Assert_dimensionUp(40);
      Assert_dimensionRight(56);
      Assert_dimensionDown(40);
      Assert_width(113);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(81);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(true);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Vulture, BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode, BWAPI::UnitTypes::Terran_Goliath, BWAPI::UnitTypes::Terran_Machine_Shop }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Starport)
    {
      auto t = BWAPI::UnitTypes::Terran_Starport;
      Assert_enum(Terran_Starport);

      Assert_getName(Terran_Starport);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Factory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1300);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(1050);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(600);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(40);
      Assert_dimensionRight(48);
      Assert_dimensionDown(38);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(79);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(true);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Wraith, BWAPI::UnitTypes::Terran_Dropship, BWAPI::UnitTypes::Terran_Control_Tower, BWAPI::UnitTypes::Terran_Science_Vessel, BWAPI::UnitTypes::Terran_Battlecruiser, BWAPI::UnitTypes::Terran_Valkyrie }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Control_Tower)
    {
      auto t = BWAPI::UnitTypes::Terran_Control_Tower;
      Assert_enum(Terran_Control_Tower);

      Assert_getName(Terran_Control_Tower);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Starport, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Starport, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(47);
      Assert_dimensionUp(24);
      Assert_dimensionRight(28);
      Assert_dimensionDown(22);
      Assert_width(76);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(47);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Cloaking_Field }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Apollo_Reactor }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Science_Facility)
    {
      auto t = BWAPI::UnitTypes::Terran_Science_Facility;
      Assert_enum(Terran_Science_Facility);

      Assert_getName(Terran_Science_Facility);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Starport, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(150);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(275);
      Assert_destroyScore(825);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(38);
      Assert_dimensionRight(48);
      Assert_dimensionDown(38);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(77);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(true);
      AssertSetEquals({ BWAPI::UnitTypes::Terran_Covert_Ops, BWAPI::UnitTypes::Terran_Physics_Lab }, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::EMP_Shockwave, BWAPI::TechTypes::Irradiate }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Titan_Reactor }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Covert_Ops)
    {
      auto t = BWAPI::UnitTypes::Terran_Covert_Ops;
      Assert_enum(Terran_Covert_Ops);

      Assert_getName(Terran_Covert_Ops);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Science_Facility, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Science_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(47);
      Assert_dimensionUp(24);
      Assert_dimensionRight(28);
      Assert_dimensionDown(22);
      Assert_width(76);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(47);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Personnel_Cloaking, BWAPI::TechTypes::Lockdown }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Ocular_Implants, BWAPI::UpgradeTypes::Moebius_Reactor }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Physics_Lab)
    {
      auto t = BWAPI::UnitTypes::Terran_Physics_Lab;
      Assert_enum(Terran_Physics_Lab);

      Assert_getName(Terran_Physics_Lab);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Science_Facility, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Science_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(47);
      Assert_dimensionUp(24);
      Assert_dimensionRight(28);
      Assert_dimensionDown(22);
      Assert_width(76);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(47);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Yamato_Gun }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Colossus_Reactor }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Machine_Shop)
    {
      auto t = BWAPI::UnitTypes::Terran_Machine_Shop;
      Assert_enum(Terran_Machine_Shop);

      Assert_getName(Terran_Machine_Shop);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_Factory, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_Factory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(39);
      Assert_dimensionUp(24);
      Assert_dimensionRight(31);
      Assert_dimensionDown(24);
      Assert_width(71);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(true);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Tank_Siege_Mode, BWAPI::TechTypes::Spider_Mines }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Ion_Thrusters, BWAPI::UpgradeTypes::Charon_Boosters }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Engineering_Bay)
    {
      auto t = BWAPI::UnitTypes::Terran_Engineering_Bay;
      Assert_enum(Terran_Engineering_Bay);

      Assert_getName(Terran_Engineering_Bay);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Command_Center, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(125);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(65);
      Assert_destroyScore(195);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(48);
      Assert_dimensionDown(28);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(61);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Armor, BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Armory)
    {
      auto t = BWAPI::UnitTypes::Terran_Armory;
      Assert_enum(Terran_Armory);

      Assert_getName(Terran_Armory);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Factory, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(50);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(22);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(55);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Plating, BWAPI::UpgradeTypes::Terran_Ship_Weapons, BWAPI::UpgradeTypes::Terran_Vehicle_Weapons, BWAPI::UpgradeTypes::Terran_Ship_Plating }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Missile_Turret)
    {
      auto t = BWAPI::UnitTypes::Terran_Missile_Turret;
      Assert_enum(Terran_Missile_Turret);

      Assert_getName(Terran_Missile_Turret);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Engineering_Bay, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(200);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(75);
      Assert_gasPrice(0);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(32);
      Assert_dimensionRight(16);
      Assert_dimensionDown(16);
      Assert_width(33);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Longbolt_Missile);
      Assert_maxAirHits(1);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(40);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeTerran_Bunker)
    {
      auto t = BWAPI::UnitTypes::Terran_Bunker;
      Assert_enum(Terran_Bunker);

      Assert_getName(Terran_Bunker);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(Terran_SCV, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Terran_SCV, 1 }, { BWAPI::UnitTypes::Terran_Barracks, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(350);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(4);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(24);
      Assert_dimensionRight(32);
      Assert_dimensionDown(16);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(41);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Crashed_Norad_II)
    {
      auto t = BWAPI::UnitTypes::Special_Crashed_Norad_II;
      Assert_enum(Special_Crashed_Norad_II);

      Assert_getName(Special_Crashed_Norad_II);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(700);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(800);
      Assert_gasPrice(600);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Ion_Cannon)
    {
      auto t = BWAPI::UnitTypes::Special_Ion_Cannon;
      Assert_enum(Special_Ion_Cannon);

      Assert_getName(Special_Ion_Cannon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Uraj_Crystal)
    {
      auto t = BWAPI::UnitTypes::Powerup_Uraj_Crystal;
      Assert_enum(Powerup_Uraj_Crystal);

      Assert_getName(Powerup_Uraj_Crystal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(10000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Khalis_Crystal)
    {
      auto t = BWAPI::UnitTypes::Powerup_Khalis_Crystal;
      Assert_enum(Powerup_Khalis_Crystal);

      Assert_getName(Powerup_Khalis_Crystal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(10000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Infested_Command_Center)
    {
      auto t = BWAPI::UnitTypes::Zerg_Infested_Command_Center;
      Assert_enum(Zerg_Infested_Command_Center);

      Assert_getName(Zerg_Infested_Command_Center);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(300);
      Assert_destroyScore(900);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(58);
      Assert_dimensionUp(41);
      Assert_dimensionRight(58);
      Assert_dimensionDown(41);
      Assert_width(117);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(83);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(1.00000);
      Assert_acceleration(33);
      Assert_haltDistance(2763);
      Assert_turnRadius(27);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(true);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Infested_Terran }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Hatchery)
    {
      auto t = BWAPI::UnitTypes::Zerg_Hatchery;
      Assert_enum(Zerg_Hatchery);

      Assert_getName(Zerg_Hatchery);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1250);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(300);
      Assert_gasPrice(0);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(2);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(300);
      Assert_destroyScore(900);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(49);
      Assert_dimensionUp(32);
      Assert_dimensionRight(49);
      Assert_dimensionDown(32);
      Assert_width(99);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(65);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(true);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Lair }, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Lair)
    {
      auto t = BWAPI::UnitTypes::Zerg_Lair;
      Assert_enum(Zerg_Lair);

      Assert_getName(Zerg_Lair);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Hatchery, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Hatchery, 1 }, { BWAPI::UnitTypes::Zerg_Spawning_Pool, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(1500);
      Assert_supplyRequired(0);
      Assert_supplyProvided(2);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(1200);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(49);
      Assert_dimensionUp(32);
      Assert_dimensionRight(49);
      Assert_dimensionDown(32);
      Assert_width(99);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(65);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(true);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Hive }, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Ventral_Sacs, BWAPI::UpgradeTypes::Antennae, BWAPI::UpgradeTypes::Pneumatized_Carapace }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Hive)
    {
      auto t = BWAPI::UnitTypes::Zerg_Hive;
      Assert_enum(Zerg_Hive);

      Assert_getName(Zerg_Hive);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Lair, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Lair, 1 }, { BWAPI::UnitTypes::Zerg_Queens_Nest, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(150);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(2);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(1500);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(49);
      Assert_dimensionUp(32);
      Assert_dimensionRight(49);
      Assert_dimensionDown(32);
      Assert_width(99);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(65);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(true);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Burrowing }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Ventral_Sacs, BWAPI::UpgradeTypes::Antennae, BWAPI::UpgradeTypes::Pneumatized_Carapace }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Nydus_Canal)
    {
      auto t = BWAPI::UnitTypes::Zerg_Nydus_Canal;
      Assert_enum(Zerg_Nydus_Canal);

      Assert_getName(Zerg_Nydus_Canal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Hive, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Hydralisk_Den)
    {
      auto t = BWAPI::UnitTypes::Zerg_Hydralisk_Den;
      Assert_enum(Zerg_Hydralisk_Den);

      Assert_getName(Zerg_Hydralisk_Den);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Spawning_Pool, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(50);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(40);
      Assert_dimensionDown(24);
      Assert_width(81);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Lurker_Aspect }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Muscular_Augments, BWAPI::UpgradeTypes::Grooved_Spines }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Defiler_Mound)
    {
      auto t = BWAPI::UnitTypes::Zerg_Defiler_Mound;
      Assert_enum(Zerg_Defiler_Mound);

      Assert_getName(Zerg_Defiler_Mound);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Hive, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(150);
      Assert_destroyScore(450);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(4, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(48);
      Assert_dimensionDown(4);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(37);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Consume, BWAPI::TechTypes::Plague }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Metasynaptic_Node }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Greater_Spire)
    {
      auto t = BWAPI::UnitTypes::Zerg_Greater_Spire;
      Assert_enum(Zerg_Greater_Spire);

      Assert_getName(Zerg_Greater_Spire);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Spire, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Hive, 1 }, { BWAPI::UnitTypes::Zerg_Spire, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(150);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(1350);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(28);
      Assert_dimensionUp(32);
      Assert_dimensionRight(28);
      Assert_dimensionDown(24);
      Assert_width(57);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Attacks, BWAPI::UpgradeTypes::Zerg_Flyer_Carapace }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Queens_Nest)
    {
      auto t = BWAPI::UnitTypes::Zerg_Queens_Nest;
      Assert_enum(Zerg_Queens_Nest);

      Assert_getName(Zerg_Queens_Nest);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Lair, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(850);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(175);
      Assert_destroyScore(525);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(38);
      Assert_dimensionUp(28);
      Assert_dimensionRight(32);
      Assert_dimensionDown(28);
      Assert_width(71);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Ensnare, BWAPI::TechTypes::Spawn_Broodlings }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Gamete_Meiosis }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Evolution_Chamber)
    {
      auto t = BWAPI::UnitTypes::Zerg_Evolution_Chamber;
      Assert_enum(Zerg_Evolution_Chamber);

      Assert_getName(Zerg_Evolution_Chamber);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Hatchery, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(75);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(40);
      Assert_destroyScore(120);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(44);
      Assert_dimensionUp(32);
      Assert_dimensionRight(32);
      Assert_dimensionDown(20);
      Assert_width(77);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(53);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Melee_Attacks, BWAPI::UpgradeTypes::Zerg_Missile_Attacks, BWAPI::UpgradeTypes::Zerg_Carapace }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Ultralisk_Cavern)
    {
      auto t = BWAPI::UnitTypes::Zerg_Ultralisk_Cavern;
      Assert_enum(Zerg_Ultralisk_Cavern);

      Assert_getName(Zerg_Ultralisk_Cavern);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Hive, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(200);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(275);
      Assert_destroyScore(825);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(32);
      Assert_dimensionDown(31);
      Assert_width(73);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Anabolic_Synthesis, BWAPI::UpgradeTypes::Chitinous_Plating }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Spire)
    {
      auto t = BWAPI::UnitTypes::Zerg_Spire;
      Assert_enum(Zerg_Spire);

      Assert_getName(Zerg_Spire);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Lair, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(150);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(250);
      Assert_destroyScore(750);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(28);
      Assert_dimensionUp(32);
      Assert_dimensionRight(28);
      Assert_dimensionDown(24);
      Assert_width(57);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Greater_Spire }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Zerg_Flyer_Attacks, BWAPI::UpgradeTypes::Zerg_Flyer_Carapace }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Spawning_Pool)
    {
      auto t = BWAPI::UnitTypes::Zerg_Spawning_Pool;
      Assert_enum(Zerg_Spawning_Pool);

      Assert_getName(Zerg_Spawning_Pool);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 }, { BWAPI::UnitTypes::Zerg_Hatchery, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(36);
      Assert_dimensionUp(28);
      Assert_dimensionRight(40);
      Assert_dimensionDown(18);
      Assert_width(77);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(47);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Metabolic_Boost, BWAPI::UpgradeTypes::Adrenal_Glands }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Creep_Colony)
    {
      auto t = BWAPI::UnitTypes::Zerg_Creep_Colony;
      Assert_enum(Zerg_Creep_Colony);

      Assert_getName(Zerg_Creep_Colony);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(75);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(40);
      Assert_destroyScore(120);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(23);
      Assert_dimensionDown(23);
      Assert_width(48);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(48);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Zerg_Sunken_Colony, BWAPI::UnitTypes::Zerg_Spore_Colony }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Spore_Colony)
    {
      auto t = BWAPI::UnitTypes::Zerg_Spore_Colony;
      Assert_enum(Zerg_Spore_Colony);

      Assert_getName(Zerg_Spore_Colony);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Creep_Colony, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Evolution_Chamber, 1 }, { BWAPI::UnitTypes::Zerg_Creep_Colony, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(400);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(25);
      Assert_destroyScore(195);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(23);
      Assert_dimensionDown(23);
      Assert_width(48);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(48);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Seeker_Spores);
      Assert_maxAirHits(1);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Sunken_Colony)
    {
      auto t = BWAPI::UnitTypes::Zerg_Sunken_Colony;
      Assert_enum(Zerg_Sunken_Colony);

      Assert_getName(Zerg_Sunken_Colony);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Creep_Colony, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Spawning_Pool, 1 }, { BWAPI::UnitTypes::Zerg_Creep_Colony, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(300);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(2);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(300);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(40);
      Assert_destroyScore(240);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(23);
      Assert_dimensionDown(23);
      Assert_width(48);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(48);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(Subterranean_Tentacle);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(true);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Overmind_With_Shell)
    {
      auto t = BWAPI::UnitTypes::Special_Overmind_With_Shell;
      Assert_enum(Special_Overmind_With_Shell);

      Assert_getName(Special_Overmind_With_Shell);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(5000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10000);
      Assert_size(Large);
      Assert_tileWidth(5);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(5, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(80);
      Assert_dimensionUp(32);
      Assert_dimensionRight(79);
      Assert_dimensionDown(40);
      Assert_width(160);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(73);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Overmind)
    {
      auto t = BWAPI::UnitTypes::Special_Overmind;
      Assert_enum(Special_Overmind);

      Assert_getName(Special_Overmind);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10000);
      Assert_size(Large);
      Assert_tileWidth(5);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(5, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(80);
      Assert_dimensionUp(32);
      Assert_dimensionRight(79);
      Assert_dimensionDown(40);
      Assert_width(160);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(73);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeZerg_Extractor)
    {
      auto t = BWAPI::UnitTypes::Zerg_Extractor;
      Assert_enum(Zerg_Extractor);

      Assert_getName(Zerg_Extractor);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(Zerg_Drone, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Zerg_Drone, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(25);
      Assert_destroyScore(75);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(4, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(64);
      Assert_dimensionUp(32);
      Assert_dimensionRight(63);
      Assert_dimensionDown(31);
      Assert_width(128);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(true);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Mature_Chrysalis)
    {
      auto t = BWAPI::UnitTypes::Special_Mature_Chrysalis;
      Assert_enum(Special_Mature_Chrysalis);

      Assert_getName(Special_Mature_Chrysalis);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(250);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Cerebrate)
    {
      auto t = BWAPI::UnitTypes::Special_Cerebrate;
      Assert_enum(Special_Cerebrate);

      Assert_getName(Special_Cerebrate);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2500);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(32);
      Assert_dimensionDown(31);
      Assert_width(73);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Cerebrate_Daggoth)
    {
      auto t = BWAPI::UnitTypes::Special_Cerebrate_Daggoth;
      Assert_enum(Special_Cerebrate_Daggoth);

      Assert_getName(Special_Cerebrate_Daggoth);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2500);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(32);
      Assert_dimensionDown(31);
      Assert_width(73);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Nexus)
    {
      auto t = BWAPI::UnitTypes::Protoss_Nexus;
      Assert_enum(Protoss_Nexus);

      Assert_getName(Protoss_Nexus);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(750);
      Assert_maxShields(750);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(400);
      Assert_gasPrice(0);
      Assert_buildTime(1800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(18);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(400);
      Assert_destroyScore(1200);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(56);
      Assert_dimensionUp(39);
      Assert_dimensionRight(56);
      Assert_dimensionDown(39);
      Assert_width(113);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(79);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Probe }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Robotics_Facility)
    {
      auto t = BWAPI::UnitTypes::Protoss_Robotics_Facility;
      Assert_enum(Protoss_Robotics_Facility);

      Assert_getName(Protoss_Robotics_Facility);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Cybernetics_Core, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(200);
      Assert_buildTime(1200);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(300);
      Assert_destroyScore(900);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(36);
      Assert_dimensionUp(16);
      Assert_dimensionRight(40);
      Assert_dimensionDown(20);
      Assert_width(77);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(37);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Observer, BWAPI::UnitTypes::Protoss_Reaver, BWAPI::UnitTypes::Protoss_Shuttle }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Pylon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Pylon;
      Assert_enum(Protoss_Pylon);

      Assert_getName(Protoss_Pylon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(300);
      Assert_maxShields(300);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(16);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(12);
      Assert_dimensionRight(16);
      Assert_dimensionDown(20);
      Assert_width(33);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(33);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Assimilator)
    {
      auto t = BWAPI::UnitTypes::Protoss_Assimilator;
      Assert_enum(Protoss_Assimilator);

      Assert_getName(Protoss_Assimilator);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(450);
      Assert_maxShields(450);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(4, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(48);
      Assert_dimensionDown(24);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(true);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Observatory)
    {
      auto t = BWAPI::UnitTypes::Protoss_Observatory;
      Assert_enum(Protoss_Observatory);

      Assert_getName(Protoss_Observatory);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Robotics_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(250);
      Assert_maxShields(250);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(50);
      Assert_gasPrice(100);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(175);
      Assert_destroyScore(525);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(44);
      Assert_dimensionUp(16);
      Assert_dimensionRight(44);
      Assert_dimensionDown(28);
      Assert_width(89);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(45);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Sensor_Array, BWAPI::UpgradeTypes::Gravitic_Boosters }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Gateway)
    {
      auto t = BWAPI::UnitTypes::Protoss_Gateway;
      Assert_enum(Protoss_Gateway);

      Assert_getName(Protoss_Gateway);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Nexus, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(75);
      Assert_destroyScore(225);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(48);
      Assert_dimensionDown(40);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(73);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Zealot, BWAPI::UnitTypes::Protoss_Dragoon, BWAPI::UnitTypes::Protoss_High_Templar, BWAPI::UnitTypes::Protoss_Dark_Templar }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Photon_Cannon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Photon_Cannon;
      Assert_enum(Protoss_Photon_Cannon);

      Assert_getName(Protoss_Photon_Cannon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Forge, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100);
      Assert_maxShields(100);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(750);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(20);
      Assert_dimensionUp(16);
      Assert_dimensionRight(20);
      Assert_dimensionDown(16);
      Assert_width(41);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(33);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(352);
      Assert_groundWeapon(STS_Photon_Cannon);
      Assert_maxGroundHits(1);
      Assert_airWeapon(STA_Photon_Cannon);
      Assert_maxAirHits(1);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Citadel_of_Adun)
    {
      auto t = BWAPI::UnitTypes::Protoss_Citadel_of_Adun;
      Assert_enum(Protoss_Citadel_of_Adun);

      Assert_getName(Protoss_Citadel_of_Adun);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Cybernetics_Core, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(450);
      Assert_maxShields(450);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(200);
      Assert_destroyScore(600);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(24);
      Assert_dimensionUp(24);
      Assert_dimensionRight(40);
      Assert_dimensionDown(24);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Leg_Enhancements }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Cybernetics_Core)
    {
      auto t = BWAPI::UnitTypes::Protoss_Cybernetics_Core;
      Assert_enum(Protoss_Cybernetics_Core);

      Assert_getName(Protoss_Cybernetics_Core);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Gateway, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(0);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(24);
      Assert_dimensionRight(40);
      Assert_dimensionDown(24);
      Assert_width(81);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Air_Armor, BWAPI::UpgradeTypes::Protoss_Air_Weapons, BWAPI::UpgradeTypes::Singularity_Charge }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Templar_Archives)
    {
      auto t = BWAPI::UnitTypes::Protoss_Templar_Archives;
      Assert_enum(Protoss_Templar_Archives);

      Assert_getName(Protoss_Templar_Archives);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Citadel_of_Adun, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(200);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(250);
      Assert_destroyScore(750);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(24);
      Assert_dimensionRight(32);
      Assert_dimensionDown(24);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(49);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Psionic_Storm, BWAPI::TechTypes::Mind_Control, BWAPI::TechTypes::Hallucination, BWAPI::TechTypes::Maelstrom }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Khaydarin_Amulet, BWAPI::UpgradeTypes::Argus_Talisman }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Forge)
    {
      auto t = BWAPI::UnitTypes::Protoss_Forge;
      Assert_enum(Protoss_Forge);

      Assert_getName(Protoss_Forge);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Nexus, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(550);
      Assert_maxShields(550);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(600);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(100);
      Assert_destroyScore(300);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(36);
      Assert_dimensionUp(24);
      Assert_dimensionRight(36);
      Assert_dimensionDown(20);
      Assert_width(73);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(45);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Ground_Armor, BWAPI::UpgradeTypes::Protoss_Ground_Weapons, BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Stargate)
    {
      auto t = BWAPI::UnitTypes::Protoss_Stargate;
      Assert_enum(Protoss_Stargate);

      Assert_getName(Protoss_Stargate);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Cybernetics_Core, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(600);
      Assert_maxShields(600);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(150);
      Assert_buildTime(1050);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(300);
      Assert_destroyScore(900);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(40);
      Assert_dimensionRight(48);
      Assert_dimensionDown(32);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(73);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(true);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({ BWAPI::UnitTypes::Protoss_Scout, BWAPI::UnitTypes::Protoss_Carrier, BWAPI::UnitTypes::Protoss_Arbiter, BWAPI::UnitTypes::Protoss_Corsair }, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Stasis_Cell_Prison)
    {
      auto t = BWAPI::UnitTypes::Special_Stasis_Cell_Prison;
      Assert_enum(Special_Stasis_Cell_Prison);

      Assert_getName(Special_Stasis_Cell_Prison);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(64);
      Assert_dimensionUp(48);
      Assert_dimensionRight(63);
      Assert_dimensionDown(47);
      Assert_width(128);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(96);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Fleet_Beacon)
    {
      auto t = BWAPI::UnitTypes::Protoss_Fleet_Beacon;
      Assert_enum(Protoss_Fleet_Beacon);

      Assert_getName(Protoss_Fleet_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Stargate, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(300);
      Assert_gasPrice(200);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(350);
      Assert_destroyScore(1050);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(40);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(24);
      Assert_width(88);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Disruption_Web }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Carrier_Capacity, BWAPI::UpgradeTypes::Apial_Sensors, BWAPI::UpgradeTypes::Gravitic_Thrusters, BWAPI::UpgradeTypes::Argus_Jewel }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Arbiter_Tribunal)
    {
      auto t = BWAPI::UnitTypes::Protoss_Arbiter_Tribunal;
      Assert_enum(Protoss_Arbiter_Tribunal);

      Assert_getName(Protoss_Arbiter_Tribunal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Templar_Archives, 1 }, { BWAPI::UnitTypes::Protoss_Stargate, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(500);
      Assert_maxShields(500);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(150);
      Assert_buildTime(900);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(450);
      Assert_destroyScore(1350);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(44);
      Assert_dimensionUp(28);
      Assert_dimensionRight(44);
      Assert_dimensionDown(28);
      Assert_width(89);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(57);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({ BWAPI::TechTypes::Stasis_Field, BWAPI::TechTypes::Recall }, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Khaydarin_Core }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Robotics_Support_Bay)
    {
      auto t = BWAPI::UnitTypes::Protoss_Robotics_Support_Bay;
      Assert_enum(Protoss_Robotics_Support_Bay);

      Assert_getName(Protoss_Robotics_Support_Bay);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Robotics_Facility, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(450);
      Assert_maxShields(450);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(150);
      Assert_gasPrice(100);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(125);
      Assert_destroyScore(375);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(32);
      Assert_dimensionDown(20);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(53);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({ BWAPI::UpgradeTypes::Scarab_Damage, BWAPI::UpgradeTypes::Reaver_Capacity, BWAPI::UpgradeTypes::Gravitic_Drive }, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeProtoss_Shield_Battery)
    {
      auto t = BWAPI::UnitTypes::Protoss_Shield_Battery;
      Assert_enum(Protoss_Shield_Battery);

      Assert_getName(Protoss_Shield_Battery);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(Protoss_Probe, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Protoss_Probe, 1 }, { BWAPI::UnitTypes::Protoss_Gateway, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Protoss_Plasma_Shields }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(200);
      Assert_maxShields(200);
      Assert_maxEnergy(200);
      Assert_armor(1);
      Assert_mineralPrice(100);
      Assert_gasPrice(0);
      Assert_buildTime(450);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(50);
      Assert_destroyScore(150);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(16);
      Assert_dimensionRight(32);
      Assert_dimensionDown(16);
      Assert_width(65);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(33);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(true);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(true);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Khaydarin_Crystal_Form)
    {
      auto t = BWAPI::UnitTypes::Special_Khaydarin_Crystal_Form;
      Assert_enum(Special_Khaydarin_Crystal_Form);

      Assert_getName(Special_Khaydarin_Crystal_Form);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(250);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2500);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(64);
      Assert_dimensionUp(48);
      Assert_dimensionRight(63);
      Assert_dimensionDown(47);
      Assert_width(128);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(96);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Protoss_Temple)
    {
      auto t = BWAPI::UnitTypes::Special_Protoss_Temple;
      Assert_enum(Special_Protoss_Temple);

      Assert_getName(Special_Protoss_Temple);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(1500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(250);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(7);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(7, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(112);
      Assert_dimensionUp(48);
      Assert_dimensionRight(111);
      Assert_dimensionDown(47);
      Assert_width(224);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(96);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_XelNaga_Temple)
    {
      auto t = BWAPI::UnitTypes::Special_XelNaga_Temple;
      Assert_enum(Special_XelNaga_Temple);

      Assert_getName(Special_XelNaga_Temple);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(5000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1500);
      Assert_gasPrice(500);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(5000);
      Assert_size(Large);
      Assert_tileWidth(5);
      Assert_tileHeight(4);
      Assert_tileSize(BWAPI::TilePosition(5, 4));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(80);
      Assert_dimensionUp(34);
      Assert_dimensionRight(79);
      Assert_dimensionDown(63);
      Assert_width(160);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(98);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeResource_Mineral_Field)
    {
      auto t = BWAPI::UnitTypes::Resource_Mineral_Field;
      Assert_enum(Resource_Mineral_Field);

      Assert_getName(Resource_Mineral_Field);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(10);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(16);
      Assert_dimensionRight(31);
      Assert_dimensionDown(15);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(true);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeResource_Mineral_Field_Type_2)
    {
      auto t = BWAPI::UnitTypes::Resource_Mineral_Field_Type_2;
      Assert_enum(Resource_Mineral_Field_Type_2);

      Assert_getName(Resource_Mineral_Field_Type_2);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(10);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(16);
      Assert_dimensionRight(31);
      Assert_dimensionDown(15);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(true);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeResource_Mineral_Field_Type_3)
    {
      auto t = BWAPI::UnitTypes::Resource_Mineral_Field_Type_3;
      Assert_enum(Resource_Mineral_Field_Type_3);

      Assert_getName(Resource_Mineral_Field_Type_3);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(10);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(2);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(2, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(16);
      Assert_dimensionRight(31);
      Assert_dimensionDown(15);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(true);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Independant_Starport)
    {
      auto t = BWAPI::UnitTypes::Special_Independant_Starport;
      Assert_enum(Special_Independant_Starport);

      Assert_getName(Special_Independant_Starport);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(10);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(Independant_Laser_Battery);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeResource_Vespene_Geyser)
    {
      auto t = BWAPI::UnitTypes::Resource_Vespene_Geyser;
      Assert_enum(Resource_Vespene_Geyser);

      Assert_getName(Resource_Vespene_Geyser);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(10);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(4);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(4, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(64);
      Assert_dimensionUp(32);
      Assert_dimensionRight(63);
      Assert_dimensionDown(31);
      Assert_width(128);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(288);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(true);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Warp_Gate)
    {
      auto t = BWAPI::UnitTypes::Special_Warp_Gate;
      Assert_enum(Special_Warp_Gate);

      Assert_getName(Special_Warp_Gate);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(700);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(600);
      Assert_gasPrice(200);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(2000);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Psi_Disrupter)
    {
      auto t = BWAPI::UnitTypes::Special_Psi_Disrupter;
      Assert_enum(Special_Psi_Disrupter);

      Assert_getName(Special_Psi_Disrupter);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1000);
      Assert_gasPrice(400);
      Assert_buildTime(4800);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(3600);
      Assert_size(Large);
      Assert_tileWidth(5);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(5, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(80);
      Assert_dimensionUp(38);
      Assert_dimensionRight(69);
      Assert_dimensionDown(47);
      Assert_width(150);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(86);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Zerg_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Zerg_Beacon;
      Assert_enum(Special_Zerg_Beacon);

      Assert_getName(Special_Zerg_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(250);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(true);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Terran_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Terran_Beacon;
      Assert_enum(Special_Terran_Beacon);

      Assert_getName(Special_Terran_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(true);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Protoss_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Protoss_Beacon;
      Assert_enum(Special_Protoss_Beacon);

      Assert_getName(Special_Protoss_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(true);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Zerg_Flag_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Zerg_Flag_Beacon;
      Assert_enum(Special_Zerg_Flag_Beacon);

      Assert_getName(Special_Zerg_Flag_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(250);
      Assert_gasPrice(0);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(true);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Terran_Flag_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Terran_Flag_Beacon;
      Assert_enum(Special_Terran_Flag_Beacon);

      Assert_getName(Special_Terran_Flag_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(50);
      Assert_gasPrice(50);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(true);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Protoss_Flag_Beacon)
    {
      auto t = BWAPI::UnitTypes::Special_Protoss_Flag_Beacon;
      Assert_enum(Special_Protoss_Flag_Beacon);

      Assert_getName(Special_Protoss_Flag_Beacon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Protoss);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(100);
      Assert_gasPrice(100);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(true);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Power_Generator)
    {
      auto t = BWAPI::UnitTypes::Special_Power_Generator;
      Assert_enum(Special_Power_Generator);

      Assert_getName(Special_Power_Generator);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Terran);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(200);
      Assert_gasPrice(50);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(600);
      Assert_size(Large);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(56);
      Assert_dimensionUp(28);
      Assert_dimensionRight(63);
      Assert_dimensionDown(43);
      Assert_width(120);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(72);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Overmind_Cocoon)
    {
      auto t = BWAPI::UnitTypes::Special_Overmind_Cocoon;
      Assert_enum(Special_Overmind_Cocoon);

      Assert_getName(Special_Overmind_Cocoon);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Zerg);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(2500);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(1);
      Assert_mineralPrice(1000);
      Assert_gasPrice(500);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(4000);
      Assert_size(Large);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(47);
      Assert_dimensionDown(31);
      Assert_width(96);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(320);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(true);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(true);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(true);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpell_Dark_Swarm)
    {
      auto t = BWAPI::UnitTypes::Spell_Dark_Swarm;
      Assert_enum(Spell_Dark_Swarm);

      Assert_getName(Spell_Dark_Swarm);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(250);
      Assert_gasPrice(200);
      Assert_buildTime(2400);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(5);
      Assert_tileHeight(5);
      Assert_tileSize(BWAPI::TilePosition(5, 5));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(80);
      Assert_dimensionUp(80);
      Assert_dimensionRight(79);
      Assert_dimensionDown(79);
      Assert_width(160);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(160);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(256);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(true);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(true);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Floor_Missile_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Floor_Missile_Trap;
      Assert_enum(Special_Floor_Missile_Trap);

      Assert_getName(Special_Floor_Missile_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(192);
      Assert_groundWeapon(Hellfire_Missile_Pack_Floor_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(20);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Floor_Hatch)
    {
      auto t = BWAPI::UnitTypes::Special_Floor_Hatch;
      Assert_enum(Special_Floor_Hatch);

      Assert_getName(Special_Floor_Hatch);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(8);
      Assert_tileHeight(4);
      Assert_tileSize(BWAPI::TilePosition(8, 4));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(128);
      Assert_dimensionUp(64);
      Assert_dimensionRight(127);
      Assert_dimensionDown(63);
      Assert_width(256);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(128);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(224);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Upper_Level_Door)
    {
      auto t = BWAPI::UnitTypes::Special_Upper_Level_Door;
      Assert_enum(Special_Upper_Level_Door);

      Assert_getName(Special_Upper_Level_Door);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(25);
      Assert_dimensionUp(17);
      Assert_dimensionRight(44);
      Assert_dimensionDown(20);
      Assert_width(70);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(38);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(32);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Right_Upper_Level_Door)
    {
      auto t = BWAPI::UnitTypes::Special_Right_Upper_Level_Door;
      Assert_enum(Special_Right_Upper_Level_Door);

      Assert_getName(Special_Right_Upper_Level_Door);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(44);
      Assert_dimensionUp(17);
      Assert_dimensionRight(25);
      Assert_dimensionDown(20);
      Assert_width(70);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(38);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(32);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Pit_Door)
    {
      auto t = BWAPI::UnitTypes::Special_Pit_Door;
      Assert_enum(Special_Pit_Door);

      Assert_getName(Special_Pit_Door);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(41);
      Assert_dimensionUp(17);
      Assert_dimensionRight(28);
      Assert_dimensionDown(20);
      Assert_width(70);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(38);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(32);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Right_Pit_Door)
    {
      auto t = BWAPI::UnitTypes::Special_Right_Pit_Door;
      Assert_enum(Special_Right_Pit_Door);

      Assert_getName(Special_Right_Pit_Door);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(10);
      Assert_size(Independent);
      Assert_tileWidth(3);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(3, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(28);
      Assert_dimensionUp(17);
      Assert_dimensionRight(41);
      Assert_dimensionDown(20);
      Assert_width(70);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(38);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(32);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Floor_Gun_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Floor_Gun_Trap;
      Assert_enum(Special_Floor_Gun_Trap);

      Assert_getName(Special_Floor_Gun_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(2);
      Assert_tileHeight(2);
      Assert_tileSize(BWAPI::TilePosition(2, 2));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(32);
      Assert_dimensionUp(32);
      Assert_dimensionRight(31);
      Assert_dimensionDown(31);
      Assert_width(64);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(64);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(192);
      Assert_groundWeapon(Twin_Autocannons_Floor_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(127);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Wall_Missile_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Wall_Missile_Trap;
      Assert_enum(Special_Wall_Missile_Trap);

      Assert_getName(Special_Wall_Missile_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(192);
      Assert_groundWeapon(Hellfire_Missile_Pack_Wall_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Wall_Flame_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Wall_Flame_Trap;
      Assert_enum(Special_Wall_Flame_Trap);

      Assert_getName(Special_Wall_Flame_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(64);
      Assert_sightRange(96);
      Assert_groundWeapon(Flame_Thrower_Wall_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Right_Wall_Missile_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Right_Wall_Missile_Trap;
      Assert_enum(Special_Right_Wall_Missile_Trap);

      Assert_getName(Special_Right_Wall_Missile_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Vehicle_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(160);
      Assert_sightRange(192);
      Assert_groundWeapon(Hellfire_Missile_Pack_Wall_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Right_Wall_Flame_Trap)
    {
      auto t = BWAPI::UnitTypes::Special_Right_Wall_Flame_Trap;
      Assert_enum(Special_Right_Wall_Flame_Trap);

      Assert_getName(Special_Right_Wall_Flame_Trap);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({ BWAPI::UpgradeTypes::Terran_Infantry_Weapons }, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(50);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(100);
      Assert_size(Large);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(64);
      Assert_sightRange(96);
      Assert_groundWeapon(Flame_Thrower_Wall_Trap);
      Assert_maxGroundHits(1);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(true);
      Assert_isRobotic(false);
      Assert_isDetector(true);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeSpecial_Start_Location)
    {
      auto t = BWAPI::UnitTypes::Special_Start_Location;
      Assert_enum(Special_Start_Location);

      Assert_getName(Special_Start_Location);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(4);
      Assert_tileHeight(3);
      Assert_tileSize(BWAPI::TilePosition(4, 3));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(48);
      Assert_dimensionUp(32);
      Assert_dimensionRight(48);
      Assert_dimensionDown(32);
      Assert_width(97);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(65);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(32);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(true);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(true);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(true);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Flag)
    {
      auto t = BWAPI::UnitTypes::Powerup_Flag;
      Assert_enum(Powerup_Flag);

      Assert_getName(Powerup_Flag);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(100000);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Young_Chrysalis)
    {
      auto t = BWAPI::UnitTypes::Powerup_Young_Chrysalis;
      Assert_enum(Powerup_Young_Chrysalis);

      Assert_getName(Powerup_Young_Chrysalis);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Psi_Emitter)
    {
      auto t = BWAPI::UnitTypes::Powerup_Psi_Emitter;
      Assert_enum(Powerup_Psi_Emitter);

      Assert_getName(Powerup_Psi_Emitter);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Data_Disk)
    {
      auto t = BWAPI::UnitTypes::Powerup_Data_Disk;
      Assert_enum(Powerup_Data_Disk);

      Assert_getName(Powerup_Data_Disk);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Khaydarin_Crystal)
    {
      auto t = BWAPI::UnitTypes::Powerup_Khaydarin_Crystal;
      Assert_enum(Powerup_Khaydarin_Crystal);

      Assert_getName(Powerup_Khaydarin_Crystal);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(true);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Mineral_Cluster_Type_1)
    {
      auto t = BWAPI::UnitTypes::Powerup_Mineral_Cluster_Type_1;
      Assert_enum(Powerup_Mineral_Cluster_Type_1);

      Assert_getName(Powerup_Mineral_Cluster_Type_1);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Mineral_Cluster_Type_2)
    {
      auto t = BWAPI::UnitTypes::Powerup_Mineral_Cluster_Type_2;
      Assert_enum(Powerup_Mineral_Cluster_Type_2);

      Assert_getName(Powerup_Mineral_Cluster_Type_2);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Protoss_Gas_Orb_Type_1)
    {
      auto t = BWAPI::UnitTypes::Powerup_Protoss_Gas_Orb_Type_1;
      Assert_enum(Powerup_Protoss_Gas_Orb_Type_1);

      Assert_getName(Powerup_Protoss_Gas_Orb_Type_1);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Protoss_Gas_Orb_Type_2)
    {
      auto t = BWAPI::UnitTypes::Powerup_Protoss_Gas_Orb_Type_2;
      Assert_enum(Powerup_Protoss_Gas_Orb_Type_2);

      Assert_getName(Powerup_Protoss_Gas_Orb_Type_2);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Zerg_Gas_Sac_Type_1)
    {
      auto t = BWAPI::UnitTypes::Powerup_Zerg_Gas_Sac_Type_1;
      Assert_enum(Powerup_Zerg_Gas_Sac_Type_1);

      Assert_getName(Powerup_Zerg_Gas_Sac_Type_1);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Zerg_Gas_Sac_Type_2)
    {
      auto t = BWAPI::UnitTypes::Powerup_Zerg_Gas_Sac_Type_2;
      Assert_enum(Powerup_Zerg_Gas_Sac_Type_2);

      Assert_getName(Powerup_Zerg_Gas_Sac_Type_2);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Terran_Gas_Tank_Type_1)
    {
      auto t = BWAPI::UnitTypes::Powerup_Terran_Gas_Tank_Type_1;
      Assert_enum(Powerup_Terran_Gas_Tank_Type_1);

      Assert_getName(Powerup_Terran_Gas_Tank_Type_1);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypePowerup_Terran_Gas_Tank_Type_2)
    {
      auto t = BWAPI::UnitTypes::Powerup_Terran_Gas_Tank_Type_2;
      Assert_enum(Powerup_Terran_Gas_Tank_Type_2);

      Assert_getName(Powerup_Terran_Gas_Tank_Type_2);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Upgrade_60);
      Assert_maxHitPoints(800);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(1);
      Assert_gasPrice(1);
      Assert_buildTime(1);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(255);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Independent);
      Assert_tileWidth(1);
      Assert_tileHeight(1);
      Assert_tileSize(BWAPI::TilePosition(1, 1));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(16);
      Assert_dimensionUp(16);
      Assert_dimensionRight(15);
      Assert_dimensionDown(15);
      Assert_width(32);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(32);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(160);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(true);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeNone)
    {
      auto t = BWAPI::UnitTypes::None;
      Assert_enum(None);

      Assert_getName(None);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(None);
      Assert_whatBuilds(None, 0);
      AssertSetEquals({}, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(None);
      Assert_maxHitPoints(0);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(0);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(None);
      Assert_tileWidth(0);
      Assert_tileHeight(0);
      Assert_tileSize(BWAPI::TilePosition(0, 0));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(0);
      Assert_dimensionUp(0);
      Assert_dimensionRight(0);
      Assert_dimensionDown(0);
      Assert_width(1);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(1);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(0);
      Assert_groundWeapon(None);
      Assert_maxGroundHits(0);
      Assert_airWeapon(None);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(false);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }
    TEST_METHOD(UnitTypeUnknown)
    {
      auto t = BWAPI::UnitTypes::Unknown;
      Assert_enum(Unknown);

      Assert_getName(Unknown);
      Assert::AreEqual(t.c_str(), t.getName().c_str());
      Assert_getRace(Unknown);
      Assert_whatBuilds(Unknown, 1);
      AssertSetEquals({ { BWAPI::UnitTypes::Unknown, 1 } }, t.requiredUnits());
      Assert_requiredTech(None);
      Assert_cloakingTech(None);
      AssertSetEquals({}, t.abilities());
      AssertSetEquals({}, t.upgrades());
      Assert_armorUpgrade(Unknown);
      Assert_maxHitPoints(0);
      Assert_maxShields(0);
      Assert_maxEnergy(0);
      Assert_armor(0);
      Assert_mineralPrice(0);
      Assert_gasPrice(0);
      Assert_buildTime(0);
      Assert_supplyRequired(0);
      Assert_supplyProvided(0);
      Assert_spaceRequired(0);
      Assert_spaceProvided(0);
      Assert_buildScore(0);
      Assert_destroyScore(0);
      Assert_size(Unknown);
      Assert_tileWidth(0);
      Assert_tileHeight(0);
      Assert_tileSize(BWAPI::TilePosition(0, 0));
      Assert::AreEqual(BWAPI::TilePosition(t.tileWidth(), t.tileHeight()), t.tileSize());
      Assert_dimensionLeft(0);
      Assert_dimensionUp(0);
      Assert_dimensionRight(0);
      Assert_dimensionDown(0);
      Assert_width(1);
      Assert::AreEqual(t.dimensionLeft() + 1 + t.dimensionRight(), t.width());
      Assert_height(1);
      Assert::AreEqual(t.dimensionUp() + 1 + t.dimensionDown(), t.height());
      Assert_seekRange(0);
      Assert_sightRange(0);
      Assert_groundWeapon(Unknown);
      Assert_maxGroundHits(0);
      Assert_airWeapon(Unknown);
      Assert_maxAirHits(0);
      Assert_topSpeed(0.000000);
      Assert_acceleration(0);
      Assert_haltDistance(0);
      Assert_turnRadius(0);
      Assert_canProduce(false);
      Assert_canAttack(true);
      Assert_canMove(false);
      Assert_isFlyer(false);
      Assert_regeneratesHP(false);
      Assert_isSpellcaster(false);
      Assert_hasPermanentCloak(false);
      Assert_isInvincible(false);
      Assert_isOrganic(false);
      Assert_isMechanical(false);
      Assert_isRobotic(false);
      Assert_isDetector(false);
      Assert_isResourceContainer(false);
      Assert_isResourceDepot(false);
      Assert_isRefinery(false);
      Assert_isWorker(false);
      Assert_requiresPsi(false);
      Assert_requiresCreep(false);
      Assert_isTwoUnitsInOneEgg(false);
      Assert_isBurrowable(false);
      Assert_isCloakable(false);
      Assert_isBuilding(false);
      Assert_isAddon(false);
      Assert_isFlyingBuilding(false);
      Assert_isNeutral(false);
      Assert_isHero(false);
      Assert_isPowerup(false);
      Assert_isBeacon(false);
      Assert_isFlagBeacon(false);
      Assert_isSpecialBuilding(false);
      Assert_isSpell(false);
      Assert_producesCreep(false);
      Assert_producesLarva(false);
      Assert_isMineralField(false);
      Assert_isCritter(false);
      Assert_canBuildAddon(false);
      AssertSetEquals({}, t.buildsWhat());
      AssertSetEquals({}, t.researchesWhat());
      AssertSetEquals({}, t.upgradesWhat());
    }

  };
}