/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Color;
import bwapi.Position;
import bwapi.Race;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.UnitType;
import java.util.ArrayList;
import java.util.List;
import jbweb.JBWEB;
import jbweb.Piece;

public class Block {
    private int w = 0;
    private int h = 0;
    private final TilePosition tile;
    private List<TilePosition> smallTiles = new ArrayList<TilePosition>();
    private List<TilePosition> mediumTiles = new ArrayList<TilePosition>();
    private List<TilePosition> largeTiles = new ArrayList<TilePosition>();
    private final boolean proxy;
    private final boolean defensive;

    public Block() {
        this.tile = null;
        this.proxy = false;
        this.defensive = false;
    }

    public Block(TilePosition _tile, List<Piece> _pieces, boolean _proxy, boolean _defensive) {
        this.tile = _tile;
        this.proxy = _proxy;
        this.defensive = _defensive;
        int rowHeight = 0;
        int rowWidth = 0;
        TilePosition here = this.tile;
        for (Piece p : _pieces) {
            if (p == Piece.Small) {
                this.smallTiles.add(here);
                here = new TilePosition(here.x + 2, here.y);
                rowWidth += 2;
                rowHeight = Math.max(rowHeight, 2);
            }
            if (p == Piece.Medium) {
                this.mediumTiles.add(here);
                here = new TilePosition(here.x + 3, here.y);
                rowWidth += 3;
                rowHeight = Math.max(rowHeight, 2);
            }
            if (p == Piece.Large) {
                if (JBWEB.game.self().getRace() == Race.Zerg && !JBWEB.game.canBuildHere(here, UnitType.Zerg_Hatchery)) continue;
                this.largeTiles.add(here);
                here = new TilePosition(here.x + 4, here.y);
                rowWidth += 4;
                rowHeight = Math.max(rowHeight, 3);
            }
            if (p == Piece.Addon) {
                TilePosition insertTile = new TilePosition(here.x, here.y + 1);
                this.smallTiles.add(insertTile);
                here = new TilePosition(here.x + 2, here.y);
                rowWidth += 2;
                rowHeight = Math.max(rowHeight, 2);
            }
            if (p != Piece.Row) continue;
            this.w = Math.max(this.w, rowWidth);
            this.h += rowHeight;
            rowWidth = 0;
            rowHeight = 0;
            here = new TilePosition(here.x, here.y + this.h);
        }
        this.w = Math.max(this.w, rowWidth);
        this.h += rowHeight;
    }

    public TilePosition getTilePosition() {
        return this.tile;
    }

    public List<TilePosition> getSmallTiles() {
        return this.smallTiles;
    }

    public List<TilePosition> getMediumTiles() {
        return this.mediumTiles;
    }

    public List<TilePosition> getLargeTiles() {
        return this.largeTiles;
    }

    public void insertSmall(TilePosition here) {
        this.smallTiles.add(here);
    }

    public void insertMedium(TilePosition here) {
        this.mediumTiles.add(here);
    }

    public void insertLarge(TilePosition here) {
        this.largeTiles.add(here);
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isDefensive() {
        return this.defensive;
    }

    public void draw() {
        Position p2;
        Position p1;
        Color color = JBWEB.game.self().getColor();
        Text textColor = color.id == 185 ? Text.DarkGreen : JBWEB.game.self().getTextColor();
        for (TilePosition tile : this.smallTiles) {
            p1 = new Position(tile.toPosition().x + 65, tile.toPosition().y + 65);
            p2 = new Position(tile.toPosition().x + 52, tile.toPosition().y + 52);
            JBWEB.game.drawBoxMap(new Position(tile), p1, color);
            JBWEB.game.drawTextMap(p2, "%cB", textColor);
        }
        for (TilePosition tile : this.mediumTiles) {
            p1 = new Position(tile.toPosition().x + 97, tile.toPosition().y + 65);
            p2 = new Position(tile.toPosition().x + 84, tile.toPosition().y + 52);
            JBWEB.game.drawBoxMap(new Position(tile), p1, color);
            JBWEB.game.drawTextMap(p2, "%cB", textColor);
        }
        for (TilePosition tile : this.largeTiles) {
            p1 = new Position(tile.toPosition().x + 129, tile.toPosition().y + 97);
            p2 = new Position(tile.toPosition().x + 116, tile.toPosition().y + 84);
            JBWEB.game.drawBoxMap(new Position(tile), p1, color);
            JBWEB.game.drawTextMap(p2, "%cB", textColor);
        }
    }
}

