/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.CommandType;
import bwapi.CoordinateType;
import bwapi.GameDataUtils;
import bwapi.ShapeType;
import java.util.function.Consumer;

class SideEffect {
    private Consumer<ClientData.GameData> application;

    void apply(ClientData.GameData gameData) {
        this.application.accept(gameData);
    }

    private SideEffect() {
    }

    static SideEffect addUnitCommand(int type, int unit, int target, int x, int y, int extra) {
        SideEffect output = new SideEffect();
        output.application = gameData -> {
            ClientData.UnitCommand unitCommand = GameDataUtils.addUnitCommand(gameData);
            unitCommand.setTid(type);
            unitCommand.setUnitIndex(unit);
            unitCommand.setTargetIndex(target);
            unitCommand.setX(x);
            unitCommand.setY(y);
            unitCommand.setExtra(extra);
        };
        return output;
    }

    static SideEffect addCommand(CommandType type, int value1, int value2) {
        SideEffect output = new SideEffect();
        output.application = gameData -> {
            ClientData.Command command = GameDataUtils.addCommand(gameData);
            command.setType(type);
            command.setValue1(value1);
            command.setValue2(value2);
        };
        return output;
    }

    static SideEffect addCommand(CommandType type, String text, int value2) {
        SideEffect output = new SideEffect();
        output.application = gameData -> {
            ClientData.Command command = GameDataUtils.addCommand(gameData);
            command.setType(type);
            command.setValue1(GameDataUtils.addString(gameData, text));
            command.setValue2(value2);
        };
        return output;
    }

    static SideEffect addShape(ShapeType type, CoordinateType coordType, int x1, int y1, int x2, int y2, int extra1, int extra2, int color, boolean isSolid) {
        SideEffect output = new SideEffect();
        output.application = gameData -> {
            ClientData.Shape shape = GameDataUtils.addShape(gameData);
            shape.setType(type);
            shape.setCtype(coordType);
            shape.setX1(x1);
            shape.setY1(y1);
            shape.setX2(x2);
            shape.setY2(y2);
            shape.setExtra1(extra1);
            shape.setExtra2(extra2);
            shape.setColor(color);
            shape.setIsSolid(isSolid);
        };
        return output;
    }

    static SideEffect addShape(ShapeType type, CoordinateType coordType, int x1, int y1, int x2, int y2, String text, int extra2, int color, boolean isSolid) {
        SideEffect output = new SideEffect();
        output.application = gameData -> {
            ClientData.Shape shape = GameDataUtils.addShape(gameData);
            shape.setType(type);
            shape.setCtype(coordType);
            shape.setX1(x1);
            shape.setY1(y1);
            shape.setX2(x2);
            shape.setY2(y2);
            shape.setExtra1(GameDataUtils.addString(gameData, text));
            shape.setExtra2(extra2);
            shape.setColor(color);
            shape.setIsSolid(isSolid);
        };
        return output;
    }
}

