/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClientConfiguration;
import bwapi.PerformanceMetric;
import java.util.ArrayList;

public class PerformanceMetrics {
    private PerformanceMetric frameDurationReceiveToSend;
    private PerformanceMetric frameDurationReceiveToSent;
    private PerformanceMetric frameDurationReceiveToReceive;
    private PerformanceMetric copyingToBuffer;
    private PerformanceMetric intentionallyBlocking;
    private PerformanceMetric frameBufferSize;
    private PerformanceMetric framesBehind;
    private PerformanceMetric flushSideEffects;
    private PerformanceMetric botResponse;
    private PerformanceMetric communicationSendToReceive;
    private PerformanceMetric communicationSendToSent;
    private PerformanceMetric communicationListenToReceive;
    private PerformanceMetric botIdle;
    private PerformanceMetric clientIdle;
    private PerformanceMetric excessSleep;
    private PerformanceMetric numberOfEvents;
    PerformanceMetric numberOfEventsTimesDurationReceiveToSent;
    private BWClientConfiguration configuration;
    private ArrayList<PerformanceMetric> performanceMetrics = new ArrayList();

    public PerformanceMetric getFrameDurationReceiveToSend() {
        return this.frameDurationReceiveToSend;
    }

    public PerformanceMetric getFrameDurationReceiveToSent() {
        return this.frameDurationReceiveToSent;
    }

    public PerformanceMetric getFrameDurationReceiveToReceive() {
        return this.frameDurationReceiveToReceive;
    }

    public PerformanceMetric getCopyingToBuffer() {
        return this.copyingToBuffer;
    }

    public PerformanceMetric getIntentionallyBlocking() {
        return this.intentionallyBlocking;
    }

    public PerformanceMetric getFrameBufferSize() {
        return this.frameBufferSize;
    }

    public PerformanceMetric getFramesBehind() {
        return this.framesBehind;
    }

    public PerformanceMetric getFlushSideEffects() {
        return this.flushSideEffects;
    }

    public PerformanceMetric getBotResponse() {
        return this.botResponse;
    }

    public PerformanceMetric getCommunicationSendToReceive() {
        return this.communicationSendToReceive;
    }

    public PerformanceMetric getCommunicationSendToSent() {
        return this.communicationSendToSent;
    }

    public PerformanceMetric getCommunicationListenToReceive() {
        return this.communicationListenToReceive;
    }

    public PerformanceMetric getBotIdle() {
        return this.botIdle;
    }

    public PerformanceMetric getClientIdle() {
        return this.clientIdle;
    }

    public PerformanceMetric getExcessSleep() {
        return this.excessSleep;
    }

    public PerformanceMetric getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public PerformanceMetric getNumberOfEventsTimesDurationReceiveToSent() {
        return this.numberOfEventsTimesDurationReceiveToSent;
    }

    PerformanceMetrics(BWClientConfiguration configuration) {
        this.configuration = configuration;
        this.reset();
    }

    public void reset() {
        this.performanceMetrics.clear();
        this.frameDurationReceiveToSend = new PerformanceMetric(this, "Frame duration: After receiving 'frame ready' -> before sending 'frame done'", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
        this.frameDurationReceiveToSent = new PerformanceMetric(this, "Frame duration: After receiving 'frame ready' -> after sending 'frame done'", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
        this.frameDurationReceiveToReceive = new PerformanceMetric(this, "Frame duration: After receiving 'frame ready' -> receiving next 'frame ready'", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
        this.communicationSendToReceive = new PerformanceMetric(this, "BWAPI duration: Before sending 'frame done' -> After receiving 'frame ready'", 1.0, 3.0, 5.0, 10.0, 15.0, 20.0, 30.0);
        this.communicationSendToSent = new PerformanceMetric(this, "BWAPI duration: Before sending 'frame done' -> After sending 'frame done'", 1.0, 3.0, 5.0, 10.0, 15.0, 20.0, 30.0);
        this.communicationListenToReceive = new PerformanceMetric(this, "BWAPI duration: Before listening for 'frame ready' -> After receiving 'frame ready'", 1.0, 3.0, 5.0, 10.0, 15.0, 20.0, 30.0);
        this.copyingToBuffer = new PerformanceMetric(this, "Copying frame to buffer", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0);
        this.intentionallyBlocking = new PerformanceMetric(this, "Time holding frame until buffer frees capacity", 0.0);
        this.frameBufferSize = new PerformanceMetric(this, "Frames already buffered when enqueuing a new frame", 0.0, 1.0);
        this.framesBehind = new PerformanceMetric(this, "Frames behind real-time when handling events", 0.0, 1.0);
        this.flushSideEffects = new PerformanceMetric(this, "Time flushing side effects", 1.0, 3.0, 5.0);
        this.botResponse = new PerformanceMetric(this, "Duration of bot event handlers", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
        this.botIdle = new PerformanceMetric(this, "Time bot spent idle", 9.223372036854776E18);
        this.clientIdle = new PerformanceMetric(this, "Time client spent waiting for bot", this.configuration.getMaxFrameDurationMs());
        this.excessSleep = new PerformanceMetric(this, "Excess duration of client sleep", 1.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
        this.numberOfEvents = new PerformanceMetric(this, "Number of events received from BWAPI", 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 15.0, 20.0);
        this.numberOfEventsTimesDurationReceiveToSent = new PerformanceMetric(this, "Number of events received from BWAPI, multiplied by the receive-to-sent duration of that frame", 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 85.0);
    }

    void addMetric(PerformanceMetric performanceMetric) {
        this.performanceMetrics.add(performanceMetric);
    }

    public String toString() {
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("Performance metrics:");
        this.performanceMetrics.forEach(metric -> {
            outputBuilder.append("\n");
            outputBuilder.append(metric.toString());
        });
        return outputBuilder.toString();
    }
}

