/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClient;
import bwapi.ClientData;
import bwapi.GameInstance;
import bwapi.GameTable;
import bwapi.PerformanceMetrics;
import bwapi.WrappedBuffer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class Client {
    private static final int READ_WRITE = 7;
    private static final int SUPPORTED_BWAPI_VERSION = 10003;
    private ClientData clientData;
    private BWClient bwClient;
    private boolean connected = false;
    private RandomAccessFile pipeObjectHandle = null;
    private WrappedBuffer gameTableFileHandle = null;
    private WrappedBuffer mapFileHandle = null;

    Client(BWClient bwClient) {
        this.bwClient = bwClient;
    }

    Client(WrappedBuffer buffer) {
        this.clientData = new ClientData();
        this.clientData.setBuffer(buffer);
    }

    ClientData liveClientData() {
        return this.clientData;
    }

    WrappedBuffer mapFile() {
        return this.mapFileHandle;
    }

    boolean isConnected() {
        return this.connected;
    }

    void reconnect() {
        while (!this.connect()) {
            this.sleep(1000);
        }
    }

    private String getTimestampString() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")) + " (" + (System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime()) + "ms after VM start)";
    }

    private void disconnect() {
        if (this.bwClient.getConfiguration().getDebugConnection()) {
            System.err.print("Disconnect called by: ");
            System.err.println(Thread.currentThread().getStackTrace()[2]);
        }
        if (!this.connected) {
            return;
        }
        if (this.pipeObjectHandle != null) {
            try {
                this.pipeObjectHandle.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pipeObjectHandle = null;
        }
        this.gameTableFileHandle = null;
        this.mapFileHandle = null;
        this.clientData = null;
        this.connected = false;
    }

    boolean connect() {
        GameTable gameTable;
        if (this.connected) {
            System.err.println("Attempting to connect, but we are already connected.");
            return true;
        }
        System.out.println("Attempting to connect to BWAPI at " + this.getTimestampString());
        int serverProcID = -1;
        int gameTableIndex = -1;
        try {
            Pointer gameTableView = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, "Local\\bwapi_shared_memory_game_list"), 7, 0, 0, 96);
            if (gameTableView == null) {
                System.err.println("Looking for an instance of StarCraft with BWAPI.");
                return false;
            }
            this.gameTableFileHandle = new WrappedBuffer(gameTableView, 96);
        }
        catch (Exception e) {
            System.err.println("Did not find a StarCraft BWAPI game table mapping.");
            return false;
        }
        try {
            gameTable = new GameTable(this.gameTableFileHandle);
        }
        catch (Exception e) {
            System.err.println("Unable to map Game table at getTimestampString()");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            return false;
        }
        int latest = 0;
        for (int i = 0; i < 8; ++i) {
            GameInstance gameInstance = gameTable.gameInstances[i];
            System.out.println(i + " | " + gameInstance.serverProcessID + " | " + (gameInstance.isConnected ? 1 : 0) + " | " + gameInstance.lastKeepAliveTime);
            if (gameInstance.serverProcessID == 0 || gameInstance.isConnected || gameTableIndex != -1 && latest != 0 && gameInstance.lastKeepAliveTime >= latest) continue;
            latest = gameInstance.lastKeepAliveTime;
            gameTableIndex = i;
        }
        if (gameTableIndex != -1) {
            serverProcID = gameTable.gameInstances[gameTableIndex].serverProcessID;
        }
        if (serverProcID == -1) {
            System.err.println("No server proc ID");
            return false;
        }
        String sharedMemoryName = "Local\\bwapi_shared_memory_" + serverProcID;
        String communicationPipe = "\\\\.\\pipe\\bwapi_pipe_" + serverProcID;
        try {
            this.pipeObjectHandle = new RandomAccessFile(communicationPipe, "rw");
        }
        catch (Exception e) {
            System.err.println("Unable to open communications pipe: " + communicationPipe);
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.gameTableFileHandle = null;
            return false;
        }
        System.out.println("Connected to StarCraft with BWAPI at " + this.getTimestampString());
        try {
            Pointer mapFileView = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, sharedMemoryName), 7, 0, 0, 33017048);
            this.mapFileHandle = new WrappedBuffer(mapFileView, 33017048);
        }
        catch (Exception e) {
            System.err.println("Unable to open shared memory mapping at " + this.getTimestampString() + ": " + sharedMemoryName);
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.pipeObjectHandle = null;
            this.gameTableFileHandle = null;
            return false;
        }
        try {
            this.clientData = new ClientData();
            this.clientData.setBuffer(this.mapFileHandle);
        }
        catch (Exception e) {
            System.err.println("Unable to map game data at " + this.getTimestampString());
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            return false;
        }
        if (10003 != this.clientData.gameData().getClient_version()) {
            System.err.println("Error: BWAPI Client and BWAPI Server have different versions and are not compatible!");
            System.err.println("Client version: 10003");
            System.err.println("Server version: " + this.clientData.gameData().getClient_version());
            this.disconnect();
            this.sleep(2000);
            return false;
        }
        int code = 1;
        while (code != 2) {
            try {
                code = this.pipeObjectHandle.readByte();
            }
            catch (Exception e) {
                System.err.println("Unable to read pipe object at " + this.getTimestampString());
                if (this.bwClient.getConfiguration().getDebugConnection()) {
                    e.printStackTrace();
                }
                this.disconnect();
                return false;
            }
        }
        System.out.println("Connection successful");
        this.connected = true;
        return true;
    }

    void sendFrameReceiveFrame() {
        PerformanceMetrics metrics = this.bwClient.getPerformanceMetrics();
        metrics.getFrameDurationReceiveToSend().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getCommunicationSendToReceive().startTiming();
            metrics.getCommunicationSendToSent().startTiming();
        }
        try {
            this.pipeObjectHandle.writeByte(1);
        }
        catch (Exception e) {
            System.err.println("Sending 'frame done' failed. Will disconnect.");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.disconnect();
            return;
        }
        metrics.getCommunicationSendToSent().stopTiming();
        metrics.getFrameDurationReceiveToSent().stopTiming();
        if (this.bwClient.doTime()) {
            int eventCount = this.clientData.gameData().getEventCount();
            metrics.getNumberOfEvents().record(eventCount);
            metrics.getNumberOfEventsTimesDurationReceiveToSent().record((double)eventCount * metrics.getFrameDurationReceiveToSent().getRunningTotal().getLast());
        }
        if (this.bwClient.doTime()) {
            metrics.getCommunicationListenToReceive().startTiming();
        }
        boolean frameReady = false;
        while (!frameReady) {
            try {
                frameReady = this.pipeObjectHandle.readByte() == 2;
            }
            catch (Exception e) {
                System.err.println("Reading 'frame ready' failed. Will disconnect.");
                if (this.bwClient.getConfiguration().getDebugConnection()) {
                    e.printStackTrace();
                }
                this.disconnect();
                break;
            }
        }
        metrics.getCommunicationListenToReceive().stopTiming();
        metrics.getCommunicationSendToReceive().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getFrameDurationReceiveToSend().startTiming();
            metrics.getFrameDurationReceiveToSent().startTiming();
        }
        metrics.getFrameDurationReceiveToReceive().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getFrameDurationReceiveToReceive().startTiming();
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface MappingKernel
    extends Kernel32 {
        public static final MappingKernel INSTANCE = Native.load(MappingKernel.class, W32APIOptions.DEFAULT_OPTIONS);

        public WinNT.HANDLE OpenFileMapping(int var1, boolean var2, String var3);
    }
}

