/*
 * Decompiled with CFR 0.152.
 */
package Placement.Walls;

import Information.Geography.Pathfinding.PathfindProfile;
import Information.Geography.Pathfinding.PathfindProfile$;
import Information.Geography.Pathfinding.PathfindRepulsor;
import Information.Geography.Types.Base;
import Information.Geography.Types.Edge;
import Information.Geography.Types.Metro;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.AbstractPoint;
import Mathematics.Points.Direction;
import Mathematics.Points.Pixel;
import Mathematics.Points.Point;
import Mathematics.Points.Tile;
import Mathematics.Points.TileRectangle;
import Mathematics.Shapes.Pylons$;
import Mathematics.Shapes.Rectangle$;
import Mathematics.Shapes.RoundedBox$;
import Placement.Generation.TileGeneratorRectangularSweep;
import Placement.Walls.Wall;
import Placement.Walls.WallConstraint;
import Placement.Walls.WallFillers;
import Placement.Walls.WallFillers$PylonsCannons$;
import Placement.Walls.WallMetrics;
import Placement.Walls.WallProblems;
import Placement.Walls.WallProblems$FailedRecursively$;
import Placement.Walls.WallProblems$GapTooWide$;
import Placement.Walls.WallProblems$InsufficientFiller$;
import Placement.Walls.WallProblems$InsufficientlyTight$;
import Placement.Walls.WallProblems$IntersectsHall$;
import Placement.Walls.WallProblems$IntersectsMining$;
import Placement.Walls.WallProblems$IntersectsPrevious$;
import Placement.Walls.WallProblems$NoHallway$;
import Placement.Walls.WallProblems$UnbuildableGranular$;
import Placement.Walls.WallProblems$UnbuildableTerrain$;
import Placement.Walls.WallProblems$UnpoweredByFiller$;
import Placement.Walls.WallProblems$UnpoweredByWall$;
import Placement.Walls.WallSpans;
import Placement.Walls.WallSpans$TerrainGas$;
import Placement.Walls.WallSpans$TerrainHall$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.UnitClasses.UnitClass;
import ProxyBwapi.UnitClasses.UnitClassProxy;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import Utilities.$qmark$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.IndexedSeqView;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u000f\u001f\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"B0\u0001\t\u0003\u0001\u0007bB4\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0001]\"1!\u0010\u0001Q\u0001\n=Dqa\u001f\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004}\u0001\u0001\u0006Ia\u001c\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u0019y\b\u0001)A\u0005o\"I\u0011\u0011\u0001\u0001A\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0001\u0003\u001bA\u0001\"!\u0007\u0001A\u0003&\u0011Q\u0001\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\u0010\u0001\t\u0003\ti\u0002C\u0004\u0002B\u0001!\t!a\u0011\t\u0015\u0005m\u0003\u0001#b\u0001\n\u0013\ti\u0006C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAA\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t9\n\u0001C!\u00033\u0013!bV1mY\u001aKg\u000eZ3s\u0015\ty\u0002%A\u0003XC2d7OC\u0001\"\u0003%\u0001F.Y2f[\u0016tGo\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0003{_:,\u0007C\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003\u0015!\u0016\u0010]3t\u0015\t\u0001\u0014'A\u0005HK><'/\u00199is*\t!'A\u0006J]\u001a|'/\\1uS>t\u0017B\u0001\u001b.\u0005\u0011QvN\\3\u0002\t\u0015D\u0018\u000e\u001e\t\u0003Y]J!\u0001O\u0017\u0003\t\u0015#w-Z\u0001\tK:$(/\u00198dKB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0007!>Lg\u000e^:\u000b\u0003}\n1\"T1uQ\u0016l\u0017\r^5dg&\u0011\u0011\t\u0010\u0002\u0005)&dW-A\u0006d_:\u001cHO]1j]R\u001c\bc\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\n\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005-3\u0013a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tYe\u0005\u0005\u0002Q#6\ta$\u0003\u0002S=\tqq+\u00197m\u0007>t7\u000f\u001e:bS:$\u0018A\u00024jY2,'\u000f\u0005\u0002V9:\u0011aK\u0017\b\u0003/fs!A\u0012-\n\u0003\u0005J!a\b\u0011\n\u0005ms\u0012aC,bY24\u0015\u000e\u001c7feNL!!\u00180\u0003\u0015]\u000bG\u000e\u001c$jY2,'O\u0003\u0002\\=\u00051A(\u001b8jiz\"b!\u00192dI\u00164\u0007C\u0001)\u0001\u0011\u0015Qc\u00011\u0001,\u0011\u0015)d\u00011\u00017\u0011\u0015Id\u00011\u0001;\u0011\u0015\u0011e\u00011\u0001D\u0011\u0015\u0019f\u00011\u0001U\u0003\u001diW\r\u001e:jGN,\u0012!\u001b\t\u0003!*L!a\u001b\u0010\u0003\u0017]\u000bG\u000e\\'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005\tr/\u00197mgVs\u0017mY2faR\f'\r\\3\u0016\u0003=\u00042\u0001];x\u001b\u0005\t(B\u0001:t\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001e\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002wc\nY\u0011I\u001d:bs\n+hMZ3s!\t\u0001\u00060\u0003\u0002z=\t!q+\u00197m\u0003I9\u0018\r\u001c7t+:\f7mY3qi\u0006\u0014G.\u001a\u0011\u0002\u001f]\fG\u000e\\:BG\u000e,\u0007\u000f^1cY\u0016\f\u0001c^1mYN\f5mY3qi\u0006\u0014G.\u001a\u0011\u0002\u001d]\fG\u000e\\%o!J|wM]3tgV\tq/A\bxC2d\u0017J\u001c)s_\u001e\u0014Xm]:!\u0003\u00119\u0018\r\u001c7\u0016\u0005\u0005\u0015\u0001\u0003B\u0013\u0002\b]L1!!\u0003'\u0005\u0019y\u0005\u000f^5p]\u0006Aq/\u00197m?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0005U\u0001cA\u0013\u0002\u0012%\u0019\u00111\u0003\u0014\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003/\u0001\u0012\u0011!a\u0001\u0003\u000b\t1\u0001\u001f\u00132\u0003\u00159\u0018\r\u001c7!\u0003!9WM\\3sCR,GCAA\u0003\u0003\u00111\u0017-\u001b7\u0015\r\u0005\r\u0012\u0011FA\u0017!\r)\u0013QE\u0005\u0004\u0003O1#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003W\u0019\u0002\u0019A<\u0002\u0015\u0019\f\u0017\u000e\\3e/\u0006dG\u000eC\u0004\u00020M\u0001\r!!\r\u0002\u000fA\u0014xN\u00197f[B!\u00111GA\u001d\u001d\r1\u0016QG\u0005\u0004\u0003oq\u0012\u0001D,bY2\u0004&o\u001c2mK6\u001c\u0018\u0002BA\u001e\u0003{\u00111bV1mYB\u0013xN\u00197f[*\u0019\u0011q\u0007\u0010\u0002-Ad\u0017mY3SKF,\u0018N]3e\u0005VLG\u000eZ5oON\f\u0001bY1o!2\f7-\u001a\u000b\u000b\u0003G\t)%a\u0014\u0002T\u0005]\u0003bBA$+\u0001\u0007\u0011\u0011J\u0001\u0006o&$G\u000f\u001b\t\u0004K\u0005-\u0013bAA'M\t\u0019\u0011J\u001c;\t\u000f\u0005ES\u00031\u0001\u0002J\u00051\u0001.Z5hQRDa!!\u0016\u0016\u0001\u0004Q\u0014\u0001\u00042vS2$\u0017N\\4US2,\u0007bBA-+\u0001\u0007\u00111E\u0001\rG>,h\u000e^'fiJL7m]\u0001\u000ei><h\u000eS1mYRKG.Z:\u0016\u0005\u0005}\u0003#BA1\u0003ORTBAA2\u0015\r\t)g]\u0001\nS6lW\u000f^1cY\u0016LA!!\u001b\u0002d\t1a+Z2u_J\f\u0011b]2pe\u0016<\u0016\r\u001c7\u0015\t\u0005=\u0014Q\u000f\t\u0004K\u0005E\u0014bAA:M\t1Ai\\;cY\u0016Da!!\u0001\u0018\u0001\u00049\u0018aD:d_J,w+\u00197m\u0005f\f%/Z1\u0015\t\u0005=\u00141\u0010\u0005\u0007\u0003\u0003A\u0002\u0019A<\u0002\u0017Ad\u0017mY3GS2dWM\u001d\u000b\u0003\u0003\u001f\tqAZ5mYJB&'A\u0007gS2d'\u0007\u001f\u001aPM\u001a\u001cX\r\u001e\u000b\u0007\u0003\u001f\t9)!%\t\u000f\u0005%5\u00041\u0001\u0002\f\u00061qN\u001a4tKR\u00042aOAG\u0013\r\ty\t\u0010\u0002\u0006!>Lg\u000e\u001e\u0005\b\u0003'[\u0002\u0019AAK\u0003)\u0001H.Y2f[\u0016tGo\u001d\t\u0004aVT\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0005\u0003BAO\u0003KsA!a(\u0002\"B\u0011aIJ\u0005\u0004\u0003G3\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0006%&AB*ue&twMC\u0002\u0002$\u001a\u0002")
public class WallFinder {
    private Vector<Tile> townHallTiles;
    private final Zone zone;
    private final Tile entrance;
    private final Seq<WallConstraint> constraints;
    private final WallFillers.WallFiller filler;
    private final WallMetrics metrics;
    private final ArrayBuffer<Wall> wallsUnacceptable;
    private final ArrayBuffer<Wall> wallsAcceptable;
    private final Wall wallInProgress;
    private Option<Wall> wall;
    private volatile boolean bitmap$0;

    public WallMetrics metrics() {
        return this.metrics;
    }

    public ArrayBuffer<Wall> wallsUnacceptable() {
        return this.wallsUnacceptable;
    }

    public ArrayBuffer<Wall> wallsAcceptable() {
        return this.wallsAcceptable;
    }

    public Wall wallInProgress() {
        return this.wallInProgress;
    }

    public Option<Wall> wall() {
        return this.wall;
    }

    public void wall_$eq(Option<Wall> x$1) {
        this.wall = x$1;
    }

    public Option<Wall> generate() {
        this.placeRequiredBuildings();
        if (this.wall().isEmpty()) {
            return None$.MODULE$;
        }
        this.placeFiller();
        return this.wall();
    }

    public boolean fail(Wall failedWall, WallProblems.WallProblem problem) {
        if (With$.MODULE$.configuration().debugging()) {
            Wall copy = new Wall(failedWall);
            copy.problems().add(problem);
            this.wallsUnacceptable().$plus$eq((Object)copy);
            if (this.wall().contains(failedWall)) {
                failedWall.problems().add(problem);
                this.wall_$eq(None$.MODULE$);
            }
        }
        return false;
    }

    public Option<Wall> placeRequiredBuildings() {
        if (this.constraints.isEmpty()) {
            return None$.MODULE$;
        }
        if (this.zone.exitOriginal().isEmpty()) {
            return None$.MODULE$;
        }
        IntRef constraintIndex = IntRef.create(0);
        IntRef gapsLeft = IntRef.create(0);
        while (constraintIndex.elem < this.constraints.length() && this.wall().isEmpty()) {
            this.pickNextConstraint$1(constraintIndex, gapsLeft);
            Vector permutations = (Vector)this.constraint$1().buildings().permutations().toVector().distinct();
            this.metrics().permutations_$eq(this.metrics().permutations() + permutations.length());
            permutations.foreach((Function1<Seq, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(this.tryPlace$1(this.zone.wallPerimeterEntrance(), x$7, this.constraint$1().gapTiles())));
            this.wall_$eq(Maff$.MODULE$.minBy(this.wallsAcceptable(), (Function1<Wall, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble(x$8.score()), Ordering$Double$.MODULE$));
        }
        return this.wall();
    }

    public boolean canPlace(int width, int height, Tile buildingTile, boolean countMetrics) {
        IndexedSeq buildingTiles = Rectangle$.MODULE$.apply(width, height).map((Function1<Point, Tile> & Serializable & scala.Serializable)point -> buildingTile.add((Point)point), IndexedSeq$.MODULE$.canBuildFrom());
        int buildingEndX = buildingTile.x() + width;
        int buildingEndY = buildingTile.y() + height;
        Maff$.MODULE$.fromBoolean(countMetrics);
        if (!BoxesRunTime.unboxToBoolean(With$.MODULE$.grids().buildableW(width).apply(buildingTile))) {
            return this.fail(this.wallInProgress(), WallProblems$UnbuildableTerrain$.MODULE$);
        }
        if (this.wallInProgress().buildings().exists((Function1<Tuple2<Tile, UnitClass>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)existingBuilding -> BoxesRunTime.boxToBoolean(Maff$.MODULE$.rectanglesIntersect(buildingTile.x(), buildingTile.y(), buildingEndX, buildingEndY, ((AbstractPoint)existingBuilding._1()).x(), ((AbstractPoint)existingBuilding._1()).y(), ((AbstractPoint)existingBuilding._1()).x() + ((UnitClass)existingBuilding._2()).tileWidthPlusAddon(), ((AbstractPoint)existingBuilding._1()).y() + ((UnitClassProxy)existingBuilding._2()).tileHeight())))) {
            return this.fail(this.wallInProgress(), WallProblems$IntersectsPrevious$.MODULE$);
        }
        if (buildingTile.zone().bases().exists((Function1<Base, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(Maff$.MODULE$.rectanglesIntersect(buildingTile.x(), buildingTile.y(), buildingEndX, buildingEndY, b.townHallArea().startInclusive().x(), b.townHallArea().startInclusive().y(), b.townHallArea().endExclusive().x(), b.townHallArea().endExclusive().y())))) {
            return this.fail(this.wallInProgress(), WallProblems$IntersectsHall$.MODULE$);
        }
        if (buildingTiles.exists((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$canPlace$4(t)))) {
            return this.fail(this.wallInProgress(), WallProblems$IntersectsMining$.MODULE$);
        }
        if (buildingTiles.exists((Function1<Tile, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$canPlace$6(x$10)))) {
            return this.fail(this.wallInProgress(), WallProblems$UnbuildableGranular$.MODULE$);
        }
        return true;
    }

    private Vector<Tile> townHallTiles$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.townHallTiles = this.zone.bases().flatMap((Function1<Base, Seq> & Serializable & scala.Serializable)x$11 -> x$11.townHallArea().tiles(), Vector$.MODULE$.canBuildFrom());
                this.bitmap$0 = true;
            }
        }
        return this.townHallTiles;
    }

    private Vector<Tile> townHallTiles() {
        if (!this.bitmap$0) {
            return this.townHallTiles$lzycompute();
        }
        return this.townHallTiles;
    }

    public double scoreWall(Wall wall) {
        if (wall.buildings().isEmpty()) {
            return 0.0;
        }
        ArrayBuffer<?> rectangles = wall.buildings().map((Function1<Tuple2, TileRectangle> & Serializable & scala.Serializable)b -> new TileRectangle((Tile)b._1(), ((UnitClass)b._2()).tileWidthPlusAddon(), ((UnitClassProxy)b._2()).tileHeight()), ArrayBuffer$.MODULE$.canBuildFrom());
        ArrayBuffer expanded = rectangles.map((Function1<TileRectangle, TileRectangle> & Serializable & scala.Serializable)x$12 -> x$12.expand(1, 1), ArrayBuffer$.MODULE$.canBuildFrom());
        TileRectangle union = (TileRectangle)expanded.reduce((Function2<TileRectangle, TileRectangle, TileRectangle> & Serializable & scala.Serializable)(x$13, x$14) -> x$13.add((TileRectangle)x$14));
        int perimeter = union.tiles().count((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$scoreWall$4(rectangles, expanded, t)));
        int distance = union.center().walkableTile().groundTiles(this.zone.heart());
        int margin = BoxesRunTime.unboxToInt(Maff$.MODULE$.min(this.townHallTiles().flatMap((Function1<Tile, ArrayBuffer> & Serializable & scala.Serializable)hallTile -> ((TraversableLike)rectangles.flatMap((Function1<TileRectangle, Seq> & Serializable & scala.Serializable)x$17 -> x$17.tiles(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1<Tile, Object> & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger(x$18.tileDistanceChebyshev(hallTile)), ArrayBuffer$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom()), Ordering$Int$.MODULE$).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
        return 10 * perimeter - 5 * margin - 1 * distance;
    }

    public double scoreWallByArea(Wall wall) {
        if (wall.buildings().isEmpty()) {
            return 0.0;
        }
        ArrayBuffer<?> endTiles = wall.buildings().map((Function1<Tuple2, Tile> & Serializable & scala.Serializable)p -> ((Tile)p._1()).add(((UnitClass)p._2()).tileWidthPlusAddon(), ((UnitClassProxy)p._2()).tileHeight()), ArrayBuffer$.MODULE$.canBuildFrom());
        int xMin = BoxesRunTime.unboxToInt(((TraversableOnce)wall.buildings().map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$scoreWallByArea$2(x$19)), ArrayBuffer$.MODULE$.canBuildFrom())).min(Ordering$Int$.MODULE$));
        int yMin = BoxesRunTime.unboxToInt(((TraversableOnce)wall.buildings().map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$scoreWallByArea$3(x$20)), ArrayBuffer$.MODULE$.canBuildFrom())).min(Ordering$Int$.MODULE$));
        int xMax = BoxesRunTime.unboxToInt(((TraversableOnce)endTiles.map((Function1<Tile, Object> & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger(x$21.x()), ArrayBuffer$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$));
        int yMax = BoxesRunTime.unboxToInt(((TraversableOnce)endTiles.map((Function1<Tile, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger(x$22.y()), ArrayBuffer$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$));
        return Maff$.MODULE$.broodWarDistance(xMin, yMin, xMax, yMax);
    }

    public void placeFiller() {
        block9: {
            block8: {
                WallFillers$PylonsCannons$ wallFillers$PylonsCannons$;
                WallFillers.WallFiller wallFiller;
                block7: {
                    if (this.wall().get().gap().isDefined()) {
                        Tile gap = this.wall().get().gap().get();
                        Set<Tile> hallwayWalls = ((BufferLike)this.wall().get().buildings().flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)p -> ((UnitClass)p._2()).tileAreaPlusAddon().add((Tile)p._1()).tiles(), ArrayBuffer$.MODULE$.canBuildFrom())).$plus$plus(this.zone.bases().flatMap((Function1<Base, Seq> & Serializable & scala.Serializable)x$23 -> x$23.townHallArea().tiles(), Vector$.MODULE$.canBuildFrom())).toSet();
                        Some<Tile> x$2 = new Some<Tile>(this.entrance);
                        boolean x$3 = true;
                        boolean x$5 = false;
                        double x$6 = PathfindProfile$.MODULE$.$lessinit$greater$default$3();
                        Option<Object> x$7 = PathfindProfile$.MODULE$.$lessinit$greater$default$4();
                        Option<Object> x$8 = PathfindProfile$.MODULE$.$lessinit$greater$default$5();
                        Option<Object> x$9 = PathfindProfile$.MODULE$.$lessinit$greater$default$6();
                        Option<Object> x$10 = PathfindProfile$.MODULE$.$lessinit$greater$default$7();
                        Option<Object> x$11 = PathfindProfile$.MODULE$.$lessinit$greater$default$8();
                        boolean x$12 = PathfindProfile$.MODULE$.$lessinit$greater$default$10();
                        double x$13 = PathfindProfile$.MODULE$.$lessinit$greater$default$11();
                        double x$14 = PathfindProfile$.MODULE$.$lessinit$greater$default$12();
                        double x$15 = PathfindProfile$.MODULE$.$lessinit$greater$default$13();
                        double x$16 = PathfindProfile$.MODULE$.$lessinit$greater$default$14();
                        double x$17 = PathfindProfile$.MODULE$.$lessinit$greater$default$15();
                        boolean x$18 = PathfindProfile$.MODULE$.$lessinit$greater$default$16();
                        IndexedSeq<PathfindRepulsor> x$19 = PathfindProfile$.MODULE$.$lessinit$greater$default$19();
                        Option<FriendlyUnitInfo> x$20 = PathfindProfile$.MODULE$.$lessinit$greater$default$20();
                        Option<IndexedSeq<Tile>> hallwayPath = new PathfindProfile(gap, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$3, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$5, hallwayWalls, x$19, x$20).find().tiles();
                        this.wall().get().hallway_$eq((Seq)hallwayPath.getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> Nil$.MODULE$));
                        if (this.wall().get().hallway().isEmpty()) {
                            this.fail(this.wall().get(), WallProblems$NoHallway$.MODULE$);
                            return;
                        }
                    }
                    wallFiller = this.filler;
                    wallFillers$PylonsCannons$ = WallFillers$PylonsCannons$.MODULE$;
                    if (wallFiller != null) break block7;
                    if (wallFillers$PylonsCannons$ != null) {
                        return;
                    }
                    break block8;
                }
                if (!wallFiller.equals(wallFillers$PylonsCannons$)) break block9;
            }
            this.fill2X2();
            return;
        }
    }

    public void fill2X2() {
        block10: {
            ArrayBuffer tiles;
            block9: {
                WallFillers$PylonsCannons$ wallFillers$PylonsCannons$;
                WallFillers.WallFiller wallFiller;
                block8: {
                    Vector offsets = (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(1, 0), new Point(1, 1)}));
                    HashMap placements = new HashMap();
                    offsets.foreach((Function1<Point, Object> & Serializable & scala.Serializable)offset -> {
                        WallFinder.$anonfun$fill2X2$1(this, placements, offset);
                        return BoxedUnit.UNIT;
                    });
                    tiles = (ArrayBuffer)placements.values().maxBy((Function1<ArrayBuffer, Object> & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger(x$24.length()), Ordering$Int$.MODULE$);
                    wallFiller = this.filler;
                    wallFillers$PylonsCannons$ = WallFillers$PylonsCannons$.MODULE$;
                    if (wallFiller != null) break block8;
                    if (wallFillers$PylonsCannons$ != null) {
                        return;
                    }
                    break block9;
                }
                if (!wallFiller.equals(wallFillers$PylonsCannons$)) break block10;
            }
            if (tiles.length() + this.wall().get().buildings().length() < 7) {
                this.fail(this.wall().get(), WallProblems$InsufficientFiller$.MODULE$);
                return;
            }
            Pixel centroid = Maff$.MODULE$.centroid(this.wall().get().buildings().map((Function1<Tuple2, Pixel> & Serializable & scala.Serializable)b -> ((Tile)b._1()).topLeftPixel().add(((UnitClassProxy)b._2()).dimensionLeft(), ((UnitClassProxy)b._2()).dimensionUp()), ArrayBuffer$.MODULE$.canBuildFrom()));
            this.wall().get().buildings().$plus$plus$eq((TraversableOnce)tiles.map((Function1<Tile, Tuple2> & Serializable & scala.Serializable)t -> new Tuple2<Tile, UnitClass>((Tile)t, Protoss$.MODULE$.PhotonCannon()), ArrayBuffer$.MODULE$.canBuildFrom()));
            while (this.unpowered$1().nonEmpty() && this.convertable$1().nonEmpty()) {
                SeqView scores = this.convertable$1().map((Function1<Tuple2, Tuple3> & Serializable & scala.Serializable)c -> new Tuple3(c._1(), c._2(), ((TraversableOnce)this.unpowered$1().map((Function1<Tuple2, Object> & Serializable & scala.Serializable)u -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$fill2X2$10(c, u)), IndexedSeqView$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$)), IndexedSeqView$.MODULE$.canBuildFrom());
                int maxScore = BoxesRunTime.unboxToInt(((TraversableOnce)scores.map((Function1<Tuple3, Object> & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$fill2X2$15(x$25)), SeqView$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$));
                if (maxScore == 0) {
                    this.fail(this.wall().get(), WallProblems$UnpoweredByFiller$.MODULE$);
                    return;
                }
                Tuple3 best = (Tuple3)((SeqView)scores.filter((Function1<Tuple3, Object> & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2X2$16(maxScore, x$26)))).maxBy((Function1<Tuple3, Object> & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$fill2X2$17(centroid, x$27)), Ordering$Int$.MODULE$);
                this.wall().get().buildings().$minus$eq((Object)new Tuple2(best._1(), best._2()));
                this.wall().get().buildings().$plus$eq((Object)new Tuple2(best._1(), Protoss$.MODULE$.Pylon()));
                if (!this.unpowered$1().exists((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2X2$18(x$28)))) continue;
                this.fail(this.wall().get(), WallProblems$UnpoweredByFiller$.MODULE$);
                return;
            }
            return;
        }
    }

    public void fill2x2Offset(Point offset, ArrayBuffer<Tile> placements) {
        Wall w = this.wall().get();
        Pixel buildingCentroid = Maff$.MODULE$.centroid(w.buildings().map((Function1<Tuple2, Pixel> & Serializable & scala.Serializable)b -> ((Tile)b._1()).topLeftPixel().add(16 * ((UnitClass)b._2()).tileWidthPlusAddon(), 16 * ((UnitClassProxy)b._2()).tileHeight()), ArrayBuffer$.MODULE$.canBuildFrom())).walkablePixel();
        ArrayBuffer buildingTiles = w.buildings().flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)b -> ((UnitClass)b._2()).tileAreaPlusAddon().add((Tile)b._1()).expand(3, 3).tiles(), ArrayBuffer$.MODULE$.canBuildFrom());
        Tile startOrigin = (Tile)this.zone.metro().flatMap((Function1<Metro, Option> & Serializable & scala.Serializable)x$29 -> x$29.main().map((Function1<Base, Tile> & Serializable & scala.Serializable)x$30 -> x$30.heart())).getOrElse((Function0<Tile> & Serializable & scala.Serializable)() -> (Tile)With$.MODULE$.geography().startLocations().minBy((Function1<Tile, Object> & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToDouble(x$31.groundPixels(this.zone.heart())), Ordering$Double$.MODULE$));
        Tile startRemote = (Tile)With$.MODULE$.geography().startLocations().maxBy((Function1<Tile, Object> & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToDouble(x$32.groundPixels(startOrigin)), Ordering$Double$.MODULE$);
        Set tiles = (Set)this.zone.tiles().$plus$plus(buildingTiles).filter((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2x2Offset$8(startOrigin, t)));
        TileRectangle generatorBounds = new TileRectangle(tiles);
        Tile generatorStart = (Tile)tiles.minBy((Function1<Tile, Object> & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToDouble(x$33.groundPixels(startRemote)), Ordering$Double$.MODULE$);
        Tile generatorEnd = (Tile)tiles.minBy((Function1<Tile, Object> & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToDouble(x$34.groundPixels(startOrigin)), Ordering$Double$.MODULE$);
        Direction direction = generatorStart.groundDirectionTo(generatorEnd);
        TileGeneratorRectangularSweep generator = new TileGeneratorRectangularSweep(generatorStart, generatorBounds.startInclusive(), generatorBounds.endExclusive(), direction);
        while (generator.hasNext() && placements.length() < 16) {
            this.tryFill$1(generator.next(), startRemote, buildingCentroid, w, placements);
        }
        Maff$.MODULE$.sortStablyInPlaceBy(placements, Maff$.MODULE$.sortStablyInPlaceBy$default$2(), Maff$.MODULE$.sortStablyInPlaceBy$default$3(), (Function1<Tile, Object> & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToDouble(x$36.groundPixels(buildingCentroid)), Ordering$Double$.MODULE$);
    }

    public String toString() {
        String arg$macro$1 = this.zone.name();
        Tile arg$macro$2 = this.zone.heart();
        Option<Wall> arg$macro$3 = this.wall();
        return new StringOps("WallFinder %s %s %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
    }

    private final WallConstraint constraint$1() {
        return this.wallInProgress().constraint();
    }

    private final void pickNextConstraint$1(IntRef constraintIndex$1, IntRef gapsLeft$1) {
        this.wallInProgress().buildings().clear();
        this.wallInProgress().constraint_$eq((WallConstraint)this.constraints.apply(constraintIndex$1.elem));
        this.wallInProgress().gap_$eq(None$.MODULE$);
        this.wallInProgress().hallway_$eq(Nil$.MODULE$);
        ++constraintIndex$1.elem;
        gapsLeft$1.elem = this.constraint$1().gapTiles();
    }

    private final Vector boundaryEnd$1() {
        WallSpans.WallSpan wallSpan = this.constraint$1().span();
        if (WallSpans$TerrainGas$.MODULE$.equals(wallSpan)) {
            return this.zone.wallPerimeterGas();
        }
        if (WallSpans$TerrainHall$.MODULE$.equals(wallSpan)) {
            return this.zone.wallPerimeterHall();
        }
        return this.zone.wallPerimeterExit();
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$2(Tile t$1, int gapsLeft$2, Tile x$1) {
        return x$1.tileDistanceManhattan(t$1) > 1 + gapsLeft$2;
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$1(WallFinder $this, int gapsLeft$2, Tile t) {
        return $this.boundaryEnd$1().forall((Function1<Tile, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$2(t, gapsLeft$2, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$3(Tuple2 x$2) {
        return ((UnitClass)x$2._2()).powers();
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$4(ArrayBuffer pylons$1, Tuple2 b) {
        return ((UnitClassProxy)b._2()).requiresPsi() && !pylons$1.exists((Function1<Tuple2, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(Pylons$.MODULE$.powers((Tile)p._1(), (Tile)b._1(), (UnitClass)b._2())));
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$8(Tile t$2, Tuple2 b) {
        return ((UnitClass)b._2()).tileAreaPlusAddon().add((Tile)b._1()).contains(t$2);
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$7(WallFinder $this, Tile t) {
        return t.walkable() && !$this.wallInProgress().buildings().exists((Function1<Tuple2<Tile, UnitClass>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$8(t, b)));
    }

    public static final /* synthetic */ int $anonfun$placeRequiredBuildings$9(WallFinder $this, Tile t) {
        return BoxesRunTime.unboxToInt(((TraversableOnce)$this.boundaryEnd$1().map((Function1<Tile, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.tileDistanceChebyshev(t)), Vector$.MODULE$.canBuildFrom())).min(Ordering$Int$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$11(WallFinder $this, int gapsLeft$2, Tile t) {
        return BoxesRunTime.unboxToInt(((TraversableOnce)$this.boundaryEnd$1().map((Function1<Tile, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.tileDistanceChebyshev(t)), Vector$.MODULE$.canBuildFrom())).min(Ordering$Int$.MODULE$)) > gapsLeft$2;
    }

    private final /* synthetic */ Tuple4 x$6$lzycompute$1(LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        synchronized (x$6$lzy$1) {
            Tuple4<Integer, Integer, Integer, Integer> tuple4;
            if (x$6$lzy$1.initialized()) {
                tuple4 = (Tuple4<Integer, Integer, Integer, Integer>)x$6$lzy$1.value();
            } else {
                Tuple4 tuple42 = (Tuple4)this.wallInProgress().buildings().lastOption().map((Function1<Tuple2, Tuple4> & Serializable & scala.Serializable)b -> {
                    UnitClass lastBuilding = (UnitClass)b._2();
                    Tile lastTile = (Tile)b._1();
                    int tileGapLeft = buildingTile$1.x() - lastTile.x() - lastBuilding.tileWidthPlusAddon();
                    int tileGapRight = lastTile.x() - buildingTile$1.x() - width$1;
                    int tileGapUp = buildingTile$1.y() - lastTile.y() - lastBuilding.tileHeight();
                    int tileGapDown = lastTile.y() - buildingTile$1.y() - height$1;
                    int alleyLeft = tileGapLeft == 0 ? lastBuilding.marginRightInclusive() + building$1.marginLeft() : -1;
                    int alleyRight = tileGapRight == 0 ? lastBuilding.marginLeft() + building$1.marginRightInclusive() : -1;
                    int alleyUp = tileGapUp == 0 ? lastBuilding.marginDownInclusive() + building$1.marginUp() : -1;
                    int alleyDown = tileGapDown == 0 ? lastBuilding.marginUp() + building$1.marginDownInclusive() : -1;
                    return new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(alleyLeft), BoxesRunTime.boxToInteger(alleyRight), BoxesRunTime.boxToInteger(alleyUp), BoxesRunTime.boxToInteger(alleyDown));
                }).getOrElse((Function0<Tuple4> & Serializable & scala.Serializable)() -> new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1)));
                if (tuple42 == null) {
                    throw new MatchError((Object)null);
                }
                int alleyLeft = BoxesRunTime.unboxToInt(tuple42._1());
                int alleyRight = BoxesRunTime.unboxToInt(tuple42._2());
                int alleyUp = BoxesRunTime.unboxToInt(tuple42._3());
                int alleyDown = BoxesRunTime.unboxToInt(tuple42._4());
                tuple4 = x$6$lzy$1.initialize(new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(alleyLeft), BoxesRunTime.boxToInteger(alleyRight), BoxesRunTime.boxToInteger(alleyUp), BoxesRunTime.boxToInteger(alleyDown)));
            }
            Tuple4<Integer, Integer, Integer, Integer> tuple43 = tuple4;
            return tuple43;
        }
    }

    private final /* synthetic */ Tuple4 x$6$1(LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        if (x$6$lzy$1.initialized()) {
            return (Tuple4)x$6$lzy$1.value();
        }
        return this.x$6$lzycompute$1(x$6$lzy$1, buildingTile$1, width$1, height$1, building$1);
    }

    private final /* synthetic */ int alleyLeft$lzycompute$1(LazyInt alleyLeft$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        synchronized (alleyLeft$lzy$1) {
            int n = alleyLeft$lzy$1.initialized() ? alleyLeft$lzy$1.value() : alleyLeft$lzy$1.initialize(BoxesRunTime.unboxToInt(this.x$6$1(x$6$lzy$1, buildingTile$1, width$1, height$1, building$1)._1()));
            return n;
        }
    }

    private final int alleyLeft$1(LazyInt alleyLeft$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        if (alleyLeft$lzy$1.initialized()) {
            return alleyLeft$lzy$1.value();
        }
        return this.alleyLeft$lzycompute$1(alleyLeft$lzy$1, x$6$lzy$1, buildingTile$1, width$1, height$1, building$1);
    }

    private final /* synthetic */ int alleyRight$lzycompute$1(LazyInt alleyRight$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        synchronized (alleyRight$lzy$1) {
            int n = alleyRight$lzy$1.initialized() ? alleyRight$lzy$1.value() : alleyRight$lzy$1.initialize(BoxesRunTime.unboxToInt(this.x$6$1(x$6$lzy$1, buildingTile$1, width$1, height$1, building$1)._2()));
            return n;
        }
    }

    private final int alleyRight$1(LazyInt alleyRight$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        if (alleyRight$lzy$1.initialized()) {
            return alleyRight$lzy$1.value();
        }
        return this.alleyRight$lzycompute$1(alleyRight$lzy$1, x$6$lzy$1, buildingTile$1, width$1, height$1, building$1);
    }

    private final /* synthetic */ int alleyUp$lzycompute$1(LazyInt alleyUp$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        synchronized (alleyUp$lzy$1) {
            int n = alleyUp$lzy$1.initialized() ? alleyUp$lzy$1.value() : alleyUp$lzy$1.initialize(BoxesRunTime.unboxToInt(this.x$6$1(x$6$lzy$1, buildingTile$1, width$1, height$1, building$1)._3()));
            return n;
        }
    }

    private final int alleyUp$1(LazyInt alleyUp$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        if (alleyUp$lzy$1.initialized()) {
            return alleyUp$lzy$1.value();
        }
        return this.alleyUp$lzycompute$1(alleyUp$lzy$1, x$6$lzy$1, buildingTile$1, width$1, height$1, building$1);
    }

    private final /* synthetic */ int alleyDown$lzycompute$1(LazyInt alleyDown$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        synchronized (alleyDown$lzy$1) {
            int n = alleyDown$lzy$1.initialized() ? alleyDown$lzy$1.value() : alleyDown$lzy$1.initialize(BoxesRunTime.unboxToInt(this.x$6$1(x$6$lzy$1, buildingTile$1, width$1, height$1, building$1)._4()));
            return n;
        }
    }

    private final int alleyDown$1(LazyInt alleyDown$lzy$1, LazyRef x$6$lzy$1, Tile buildingTile$1, int width$1, int height$1, UnitClass building$1) {
        if (alleyDown$lzy$1.initialized()) {
            return alleyDown$lzy$1.value();
        }
        return this.alleyDown$lzycompute$1(alleyDown$lzy$1, x$6$lzy$1, buildingTile$1, width$1, height$1, building$1);
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$14(WallFinder $this, int gapsLeft$2, int width$1, Tile horizonTile$1, int height$1, UnitClass building$1, Object nonLocalReturnKey1$1, Seq buildingsLeft$1, Point relative) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), gapsLeft$2).exists((JFunction1$mcZI$sp & scala.Serializable)gapsUsed -> {
            boolean output;
            LazyRef x$6$lzy = new LazyRef();
            LazyInt alleyLeft$lzy = new LazyInt();
            LazyInt alleyRight$lzy = new LazyInt();
            LazyInt alleyUp$lzy = new LazyInt();
            LazyInt alleyDown$lzy = new LazyInt();
            Point gapOffset = relative.x() == 0 ? new Point(-gapsUsed, 0) : (relative.y() == 0 ? new Point(0, -gapsUsed) : (relative.x() == width$1 + 1 ? new Point(gapsUsed, 0) : new Point(0, gapsUsed)));
            Tile buildingTile = horizonTile$1.subtract(width$1, height$1).add(relative).add(gapOffset);
            if (!$this.canPlace(width$1, height$1, buildingTile, true)) {
                return false;
            }
            if (!(gapsUsed != 0 || $this.constraint$1().blocksUnit().width() >= 32 && $this.constraint$1().blocksUnit().height() >= 32 || $this.alleyLeft$1(alleyLeft$lzy, x$6$lzy, buildingTile, width$1, height$1, building$1) < $this.constraint$1().blocksUnit().width() && $this.alleyRight$1(alleyRight$lzy, x$6$lzy, buildingTile, width$1, height$1, building$1) < $this.constraint$1().blocksUnit().width() && $this.alleyUp$1(alleyUp$lzy, x$6$lzy, buildingTile, width$1, height$1, building$1) < $this.constraint$1().blocksUnit().height() && $this.alleyDown$1(alleyDown$lzy, x$6$lzy, buildingTile, width$1, height$1, building$1) < $this.constraint$1().blocksUnit().height())) {
                throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.fail($this.wallInProgress(), WallProblems$InsufficientlyTight$.MODULE$));
            }
            $this.wallInProgress().buildings().$plus$eq((Object)new Tuple2<Tile, UnitClass>(buildingTile, building$1));
            Option<Tile> gapBefore = $this.wallInProgress().gap();
            if (gapBefore.isEmpty() && gapsUsed > 0) {
                $this.wallInProgress().gap_$eq(new Some<Tile>(horizonTile$1.add(gapOffset.direction().x(), gapOffset.direction().y())));
            }
            if (!(output = $this.tryPlace$1(building$1.tileAreaPlusAddon().tilesAtEdge().map((Function1<Tile, Tile> & Serializable & scala.Serializable)tile -> buildingTile.add((Tile)tile), Seq$.MODULE$.canBuildFrom()), (Seq)buildingsLeft$1.drop(1), gapsLeft$2 - gapsUsed))) {
                $this.fail($this.wallInProgress(), WallProblems$FailedRecursively$.MODULE$);
            }
            $this.wallInProgress().gap_$eq(gapBefore);
            $this.wallInProgress().buildings().remove($this.wallInProgress().buildings().length() - 1);
            return output;
        });
    }

    public static final /* synthetic */ boolean $anonfun$placeRequiredBuildings$13(WallFinder $this, int width$1, int height$1, int gapsLeft$2, UnitClass building$1, Object nonLocalReturnKey1$1, Seq buildingsLeft$1, Tile horizonTile) {
        $this.metrics().tilesConsidered_$eq($this.metrics().tilesConsidered() + 1);
        return RoundedBox$.MODULE$.apply(width$1 + 2, height$1 + 2).exists((Function1<Point, Object> & Serializable & scala.Serializable)relative -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$14($this, gapsLeft$2, width$1, horizonTile, height$1, building$1, nonLocalReturnKey1$1, buildingsLeft$1, relative)));
    }

    private final boolean tryPlace$1(Seq horizon, Seq buildingsLeft, int gapsLeft) {
        Object object = new Object();
        try {
            if (buildingsLeft.isEmpty()) {
                if (horizon.forall((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$1(this, gapsLeft, t)))) {
                    return this.fail(this.wallInProgress(), WallProblems$GapTooWide$.MODULE$);
                }
                ArrayBuffer pylons = (ArrayBuffer)this.wallInProgress().buildings().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$3(x$2)));
                if (pylons.nonEmpty() && this.wallInProgress().buildings().find((Function1<Tuple2<Tile, UnitClass>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$4(pylons, b))).isDefined()) {
                    return this.fail(this.wallInProgress(), WallProblems$UnpoweredByWall$.MODULE$);
                }
                if (this.wallInProgress().gap().isEmpty() && gapsLeft > 0) {
                    Set gapCandidates = (Set)((TraversableOnce)horizon.flatMap((Function1<Tile, Object> & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$3.adjacent4())), Seq$.MODULE$.canBuildFrom())).toSet().filter((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$7(this, t)));
                    this.wallInProgress().gap_$eq(Maff$.MODULE$.minBy(gapCandidates, (Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger(WallFinder.$anonfun$placeRequiredBuildings$9(this, t)), Ordering$Int$.MODULE$));
                    if (this.wallInProgress().gap().forall((Function1<Tile, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$11(this, gapsLeft, t)))) {
                        return this.fail(this.wallInProgress(), WallProblems$GapTooWide$.MODULE$);
                    }
                }
                this.wallsAcceptable().$plus$eq((Object)new Wall(this.wallInProgress()));
                this.wallInProgress().score_$eq(this.scoreWall(this.wallInProgress()));
                return true;
            }
            UnitClass building = (UnitClass)buildingsLeft.head();
            int width = building.tileWidthPlusAddon();
            int height = building.tileHeight();
            return horizon.exists((Function1<Tile, Object> & Serializable & scala.Serializable)horizonTile -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$placeRequiredBuildings$13(this, width, height, gapsLeft, building, object, buildingsLeft, horizonTile)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$canPlace$5(Tile t$5, Base x$9) {
        return x$9.resourcePathTiles().contains(t$5);
    }

    public static final /* synthetic */ boolean $anonfun$canPlace$4(Tile t) {
        return t.base().exists((Function1<Base, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$canPlace$5(t, x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$canPlace$6(Tile x$10) {
        return !x$10.buildable();
    }

    public static final /* synthetic */ boolean $anonfun$scoreWall$4(ArrayBuffer rectangles$1, ArrayBuffer expanded$1, Tile t) {
        return !rectangles$1.exists((Function1<TileRectangle, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean(x$15.contains(t))) && expanded$1.exists((Function1<TileRectangle, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.contains(t)));
    }

    public static final /* synthetic */ int $anonfun$scoreWallByArea$2(Tuple2 x$19) {
        return ((AbstractPoint)x$19._1()).x();
    }

    public static final /* synthetic */ int $anonfun$scoreWallByArea$3(Tuple2 x$20) {
        return ((AbstractPoint)x$20._1()).y();
    }

    public static final /* synthetic */ void $anonfun$fill2X2$1(WallFinder $this, HashMap placements$1, Point offset) {
        placements$1.update(offset, new ArrayBuffer());
        $this.fill2x2Offset(offset, (ArrayBuffer)placements$1.apply(offset));
    }

    public static final /* synthetic */ boolean $anonfun$fill2X2$5(Tuple2 b) {
        return ((UnitClass)b._2()).powers();
    }

    private final IndexedSeqView pylons$2() {
        return this.wall().get().buildings().view().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2X2$5(b)));
    }

    public static final /* synthetic */ boolean $anonfun$fill2X2$6(Tuple2 b) {
        Object T2 = b._2();
        UnitClass unitClass = Protoss$.MODULE$.PhotonCannon();
        return !(T2 != null ? !T2.equals(unitClass) : unitClass != null);
    }

    private final IndexedSeqView convertable$1() {
        return this.wall().get().buildings().view().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2X2$6(b)));
    }

    public static final /* synthetic */ boolean $anonfun$fill2X2$7(WallFinder $this, Tuple2 b) {
        return ((UnitClassProxy)b._2()).requiresPsi() && !$this.pylons$2().exists((Function1<Tuple2, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(Pylons$.MODULE$.powers((Tile)p._1(), (Tile)b._1(), (UnitClass)b._2())));
    }

    private final IndexedSeqView unpowered$1() {
        return this.wall().get().buildings().view().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2X2$7(this, b)));
    }

    public static final /* synthetic */ int $anonfun$fill2X2$10(Tuple2 c$1, Tuple2 u) {
        return BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(Pylons$.MODULE$.powers((Tile)c$1._1(), (Tile)u._1(), (UnitClass)u._2()), (JFunction0$mcI$sp & scala.Serializable)() -> {
            Object T2 = u._2();
            UnitClass unitClass = Protoss$.MODULE$.PhotonCannon();
            return BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(!(T2 != null ? !T2.equals(unitClass) : unitClass != null), (JFunction0$mcI$sp & scala.Serializable)() -> 1, (JFunction0$mcI$sp & scala.Serializable)() -> 100));
        }, (JFunction0$mcI$sp & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$fill2X2$15(Tuple3 x$25) {
        return BoxesRunTime.unboxToInt(x$25._3());
    }

    public static final /* synthetic */ boolean $anonfun$fill2X2$16(int maxScore$1, Tuple3 x$26) {
        return BoxesRunTime.unboxToInt(x$26._3()) == maxScore$1;
    }

    public static final /* synthetic */ int $anonfun$fill2X2$17(Pixel centroid$1, Tuple3 x$27) {
        return ((Tile)x$27._1()).topLeftPixel().add(32, 32).pixelDistanceSquared(centroid$1);
    }

    public static final /* synthetic */ boolean $anonfun$fill2X2$18(Tuple2 x$28) {
        return ((UnitClassProxy)x$28._2()).tileWidth() > 2;
    }

    public static final /* synthetic */ boolean $anonfun$fill2x2Offset$8(Tile startOrigin$1, Tile t) {
        return t.buildable() && t.groundTiles(startOrigin$1) < 256;
    }

    private static final /* synthetic */ TileRectangle rectangle$lzycompute$1(LazyRef rectangle$lzy$1, Tile tile$1) {
        synchronized (rectangle$lzy$1) {
            TileRectangle tileRectangle = rectangle$lzy$1.initialized() ? (TileRectangle)rectangle$lzy$1.value() : rectangle$lzy$1.initialize(new TileRectangle(tile$1, 2, 2));
            return tileRectangle;
        }
    }

    private static final TileRectangle rectangle$1(LazyRef rectangle$lzy$1, Tile tile$1) {
        if (rectangle$lzy$1.initialized()) {
            return (TileRectangle)rectangle$lzy$1.value();
        }
        return WallFinder.rectangle$lzycompute$1(rectangle$lzy$1, tile$1);
    }

    private static final /* synthetic */ Pixel fillerCenter$lzycompute$1(LazyRef fillerCenter$lzy$1, Tile tile$1) {
        synchronized (fillerCenter$lzy$1) {
            Pixel pixel = fillerCenter$lzy$1.initialized() ? (Pixel)fillerCenter$lzy$1.value() : fillerCenter$lzy$1.initialize(tile$1.topLeftPixel().add(32, 32));
            return pixel;
        }
    }

    private static final Pixel fillerCenter$1(LazyRef fillerCenter$lzy$1, Tile tile$1) {
        if (fillerCenter$lzy$1.initialized()) {
            return (Pixel)fillerCenter$lzy$1.value();
        }
        return WallFinder.fillerCenter$lzycompute$1(fillerCenter$lzy$1, tile$1);
    }

    public static final /* synthetic */ boolean $anonfun$fill2x2Offset$12(Tile tile$1, Tile x$35) {
        return x$35.tileDistanceChebyshev(tile$1) < 2;
    }

    private final void tryFill$1(Tile tile, Tile startRemote$1, Pixel buildingCentroid$1, Wall w$1, ArrayBuffer placements$2) {
        block8: {
            LazyRef fillerCenter$lzy;
            LazyRef rectangle$lzy;
            block7: {
                Zone zone;
                Zone zone2;
                block6: {
                    rectangle$lzy = new LazyRef();
                    fillerCenter$lzy = new LazyRef();
                    zone2 = tile.zone();
                    zone = this.zone;
                    if (zone2 != null) break block6;
                    if (zone != null) {
                        return;
                    }
                    break block7;
                }
                if (!zone2.equals(zone)) break block8;
            }
            if (WallFinder.fillerCenter$1(fillerCenter$lzy, tile).groundPixels(startRemote$1) >= buildingCentroid$1.groundPixels(startRemote$1) && this.canPlace(2, 2, tile, false) && !WallFinder.rectangle$1(rectangle$lzy, tile).tiles().exists(arg_0 -> WallFinder.$anonfun$fill2x2Offset$11$adapted(w$1.hallway(), arg_0)) && !placements$2.exists((Function1<Tile, Object> & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean(WallFinder.$anonfun$fill2x2Offset$12(tile, x$35))) && !w$1.buildings().exists((Function1<Tuple2<Tile, UnitClass>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(Maff$.MODULE$.rectanglesIntersect(((AbstractPoint)b._1()).x(), ((AbstractPoint)b._1()).y(), ((AbstractPoint)b._1()).x() + ((UnitClass)b._2()).tileWidthPlusAddon(), ((AbstractPoint)b._1()).y() + ((UnitClassProxy)b._2()).tileHeight(), tile.x(), tile.y(), tile.x() + 2, tile.y() + 2)))) {
                placements$2.$plus$eq(tile);
                return;
            }
        }
    }

    public WallFinder(Zone zone, Edge exit, Tile entrance, Seq<WallConstraint> constraints, WallFillers.WallFiller filler) {
        this.zone = zone;
        this.entrance = entrance;
        this.constraints = constraints;
        this.filler = filler;
        this.metrics = new WallMetrics();
        this.wallsUnacceptable = new ArrayBuffer();
        this.wallsAcceptable = new ArrayBuffer();
        this.wallInProgress = new Wall();
        this.wall = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$fill2x2Offset$11$adapted(Seq eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.contains(elem));
    }
}

