/*
 * Decompiled with CFR 0.152.
 */
package Lifecycle.Configure;

import Lifecycle.Configure.Configuration;
import Lifecycle.Configure.FileFlag;
import Lifecycle.With$;
import Strategery.HumanPlaybook$;
import Strategery.Playbook;
import Strategery.PretrainingPlaybook$;
import Strategery.TournamentPlaybook$;
import java.io.File;
import java.io.Serializable;
import mjson.Json;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$Long$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ConfigurationLoader$ {
    public static ConfigurationLoader$ MODULE$;

    static {
        new ConfigurationLoader$();
    }

    public <T> T getOrDefault(Json json, String property, T t) {
        Object attemptedOutput;
        Json value = json.at(property);
        if (value == null) {
            return t;
        }
        Object object = t instanceof Boolean ? (Serializable)(value.isBoolean() ? BoxesRunTime.boxToBoolean(value.asBoolean()) : t) : (Serializable)(t instanceof Integer ? (Number)(value.isNumber() ? BoxesRunTime.boxToInteger(value.asInteger()) : t) : (Number)(t instanceof Double ? (value.isNumber() ? BoxesRunTime.boxToDouble(value.asDouble()) : t) : (attemptedOutput = value.isString() ? value.asString() : t)));
        if (attemptedOutput == null) {
            return t;
        }
        return attemptedOutput;
    }

    public void load() {
        File[] configFiles = (File[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new File(With$.MODULE$.bwapiData().ai()).listFiles())).filter((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(ConfigurationLoader$.$anonfun$load$1(f)));
        File[] configFilesMatching = (File[])new $colon$colon<Nothing$>((Nothing$)((File[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])configFiles)).filter((Function1<File, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ConfigurationLoader$.$anonfun$load$3(x$1)))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)configFiles, Nil$.MODULE$)).find((Function1<File[], Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(ConfigurationLoader$.$anonfun$load$4(x$2))).getOrElse((Function0<File[]> & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])configFilesMatching)).isEmpty()) {
            With$.MODULE$.logger().warn("Didn't find any matching configurations");
            return;
        }
        if (configFilesMatching.length > 1) {
            With$.MODULE$.logger().warn(new StringBuilder(54).append("Found multiple matching configurations; using newest: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])configFilesMatching)).map((Function1<File, String> & Serializable & scala.Serializable)f -> {
                Long arg$macro$1 = BoxesRunTime.boxToLong(f.lastModified());
                return new StringOps("{f.getName} (%s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1}));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
        }
        File configFile = (File)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])configFilesMatching)).maxBy((Function1<File, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(x$3.lastModified()), Ordering$Long$.MODULE$);
        String arg$macro$2 = configFile.getName();
        With$.MODULE$.logger().debug(new StringOps("Using configuration file %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$2})));
        try {
            BufferedSource configSource = Source$.MODULE$.fromFile(configFile, Codec$.MODULE$.fallbackSystemCodec());
            String configText = configSource.mkString();
            configSource.close();
            Json config = Json.read(configText);
            boolean human = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "human", BoxesRunTime.boxToBoolean(false)));
            boolean ladder = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "ladder", BoxesRunTime.boxToBoolean(false)));
            boolean livestream = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "livestream", BoxesRunTime.boxToBoolean(false)));
            boolean tournament = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "tournament", BoxesRunTime.boxToBoolean(false)));
            boolean roundrobin = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "roundrobin", BoxesRunTime.boxToBoolean(false)));
            boolean elimination = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "elimination", BoxesRunTime.boxToBoolean(false)));
            boolean pretraining = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "pretraining", BoxesRunTime.boxToBoolean(false)));
            boolean debugging = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "debugging", BoxesRunTime.boxToBoolean(false)));
            boolean debugginglive = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "debugginglive", BoxesRunTime.boxToBoolean(false)));
            boolean logstd = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "logstd", BoxesRunTime.boxToBoolean(false)));
            boolean multiCPU = BoxesRunTime.unboxToBoolean(this.getOrDefault(config, "multiCPU", BoxesRunTime.boxToBoolean(true)));
            int frameMsTarget = BoxesRunTime.unboxToInt(this.getOrDefault(config, "framemstarget", BoxesRunTime.boxToInteger(With$.MODULE$.configuration().frameTargetMs())));
            int frameMsLimit = BoxesRunTime.unboxToInt(this.getOrDefault(config, "framemslimit", BoxesRunTime.boxToInteger(With$.MODULE$.configuration().frameLimitMs())));
            With$.MODULE$.configuration().fixedBuilds_$eq(new FileFlag("fixedbuilds.txt").contents());
            With$.MODULE$.configuration().frameTargetMs_$eq(frameMsTarget);
            With$.MODULE$.configuration().frameLimitMs_$eq(frameMsLimit);
            if (tournament && ladder) {
                With$.MODULE$.logger().warn("Both tournament and ladder modes are enabled");
            }
            if (tournament && livestream) {
                With$.MODULE$.logger().warn("Both tournament and livestream modes are enabled");
            }
            if (tournament && pretraining) {
                With$.MODULE$.logger().warn("Both tournament and pretraining modes are enabled");
            }
            if (pretraining && ladder) {
                With$.MODULE$.logger().warn("Both pretraining and laddermodes are enabled");
            }
            if (pretraining && livestream) {
                With$.MODULE$.logger().warn("Both pretraining and livestream modes are enabled");
            }
            if (roundrobin && elimination) {
                With$.MODULE$.logger().warn("Both round robin and elimination modes are enabled");
            }
            if (debugginglive && !debugging) {
                With$.MODULE$.logger().warn("debugginglive enabled without debugging enabled");
            }
            if (livestream) {
                this.setLivestreamMode();
            }
            if (human) {
                this.setHumanMode();
            }
            if (ladder) {
                this.setLadderMode();
            }
            if (tournament) {
                this.setTournamentMode();
            }
            if (roundrobin) {
                this.setRoundRobinMode();
            }
            if (elimination) {
                this.setEliminationMode();
            }
            if (pretraining) {
                this.setPretraining();
            }
            if (debugging) {
                this.setDebugMode();
            }
            if (debugginglive) {
                this.setDebugLiveMode();
            }
            if (logstd) {
                With$.MODULE$.configuration().logstd_$eq(true);
            }
            With$.MODULE$.configuration().simulationAsynchronous_$eq(multiCPU);
            ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>("Human", Boolean.toString(human)), new Tuple2<String, String>("Ladder", Boolean.toString(ladder)), new Tuple2<String, Boolean>("Livestream", BoxesRunTime.boxToBoolean(livestream)), new Tuple2<String, String>("Tournament", Boolean.toString(tournament)), new Tuple2<String, String>("Round-robin", Boolean.toString(roundrobin)), new Tuple2<String, String>("Elimination", Boolean.toString(elimination)), new Tuple2<String, String>("Pretraining", Boolean.toString(pretraining)), new Tuple2<String, String>("Debugging", Boolean.toString(debugging)), new Tuple2<String, String>("DebuggingLive", Boolean.toString(debugginglive)), new Tuple2<String, String>("Log stdout", Boolean.toString(logstd)), new Tuple2<String, Integer>("Frame MS target", BoxesRunTime.boxToInteger(frameMsTarget)), new Tuple2<String, Integer>("Frame MS limit", BoxesRunTime.boxToInteger(frameMsLimit)), new Tuple2<String, String>("Fixed build", With$.MODULE$.configuration().fixedBuilds())}))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)pair -> {
                ConfigurationLoader$.$anonfun$load$8(pair);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Exception exception) {
            With$.MODULE$.logger().onException(exception);
            return;
        }
    }

    private void setTournamentMode() {
        this.config().forcedPlaybook_$eq(new Some<Playbook>(TournamentPlaybook$.MODULE$));
    }

    private void setLadderMode() {
        this.config().historyHalfLife_$eq(40.0);
        this.config().recentFingerprints_$eq(4);
    }

    private void setEliminationMode() {
        this.config().recentFingerprints_$eq(2);
    }

    private void setRoundRobinMode() {
        this.config().historyHalfLife_$eq(30.0);
        this.config().recentFingerprints_$eq(3);
    }

    private void setLivestreamMode() {
        this.config().visualizeFun_$eq(true);
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
    }

    private void setHumanMode() {
        this.config().humanMode_$eq(true);
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
        this.config().forcedPlaybook_$eq(new Some<Playbook>(HumanPlaybook$.MODULE$));
    }

    private void setPretraining() {
        this.config().forcedPlaybook_$eq(new Some<Playbook>(PretrainingPlaybook$.MODULE$));
    }

    private void setDebugMode() {
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
        this.config().debugging_$eq(true);
    }

    private void setDebugLiveMode() {
        this.setDebugMode();
        this.config().camera_$eq(true);
        this.config().visualizeDebug_$eq(true);
        this.config().detectBreakpoints_$eq(true);
        this.config().simulationRecordingPeriod_$eq(72);
    }

    private Configuration config() {
        return With$.MODULE$.configuration();
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        return new $colon$colon<Nothing$>((Nothing$)((Object)"Purple"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)".config"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)".json"), Nil$.MODULE$))).forall(arg_0 -> ConfigurationLoader$.$anonfun$load$2$adapted(f.getName(), arg_0));
    }

    public static final /* synthetic */ boolean $anonfun$load$3(File x$1) {
        return x$1.getName().contains(With$.MODULE$.self().name());
    }

    public static final /* synthetic */ boolean $anonfun$load$4(File[] x$2) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$load$8(Tuple2 pair) {
        With$.MODULE$.logger().debug(new StringBuilder(2).append((String)pair._1()).append(": ").append(pair._2()).toString());
    }

    private ConfigurationLoader$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$load$2$adapted(String eta$0$1$1, CharSequence x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.contains(x$1));
    }
}

