/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Economy;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawScreen$;
import Debugging.Visualizations.Views.DebugView;
import Lifecycle.With$;
import Macro.Scheduling.MacroState;
import Macro.Scheduling.MacroStep;
import Utilities.Time.Seconds;
import bwapi.Color;
import scala.collection.mutable.ArrayBuffer;

public final class ShowMacroSim$
extends DebugView {
    public static ShowMacroSim$ MODULE$;
    private final int y0;
    private final double pixelsPerFrame;
    private final double pixelsPerResource;
    private final double pixelsPerSupply;
    private final Color colorMinerals;
    private final Color colorGas;
    private final Color colorSupplyUsed;
    private final Color colorSupplyAvailable;

    static {
        new ShowMacroSim$();
    }

    public int y0() {
        return this.y0;
    }

    public double pixelsPerFrame() {
        return this.pixelsPerFrame;
    }

    public double pixelsPerResource() {
        return this.pixelsPerResource;
    }

    public double pixelsPerSupply() {
        return this.pixelsPerSupply;
    }

    public Color colorMinerals() {
        return this.colorMinerals;
    }

    public Color colorGas() {
        return this.colorGas;
    }

    public Color colorSupplyUsed() {
        return this.colorSupplyUsed;
    }

    public Color colorSupplyAvailable() {
        return this.colorSupplyAvailable;
    }

    private int x0i(int i) {
        return 1 + (int)((double)With$.MODULE$.macroSim().steps().apply(i).event().dFrames() * this.pixelsPerFrame());
    }

    @Override
    public void renderScreen() {
        ArrayBuffer<MacroStep> steps = With$.MODULE$.macroSim().steps();
        if (steps.isEmpty()) {
            return;
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i = 0; i < steps.size(); ++i) {
                int x0 = this.x0i(i);
                int x1 = i == steps.size() - 1 ? 639 : 1 + (int)Math.ceil((double)steps.apply(i + 1).event().dFrames() * this.pixelsPerFrame());
                MacroState state = steps.apply(i).state();
                if (pass == 0) {
                    double ySupplyAvailable = this.pixelsPerSupply() * (double)state.supplyAvailable();
                    double ySupplyUsed = this.pixelsPerSupply() * (double)state.supplyUsed();
                    this.box$1(this.colorSupplyAvailable(), ySupplyAvailable, true, x0, x1);
                    this.box$1(this.colorSupplyUsed(), ySupplyUsed, true, x0, x1);
                    this.box$1(this.colorSupplyAvailable(), ySupplyAvailable, false, x0, x1);
                    continue;
                }
                if (pass != 1 || i >= steps.size() - 1) continue;
                int y0Minerals = (int)((double)this.y0() - this.pixelsPerResource() * (double)steps.apply(i).state().minerals());
                int y1Minerals = (int)((double)this.y0() - this.pixelsPerResource() * (double)steps.apply(i + 1).state().minerals());
                int y0Gas = (int)((double)this.y0() - this.pixelsPerResource() * (double)steps.apply(i).state().gas());
                int y1Gas = (int)((double)this.y0() - this.pixelsPerResource() * (double)steps.apply(i + 1).state().gas());
                With$.MODULE$.game().drawLineScreen(x0, y0Minerals, x1, y1Minerals, this.colorMinerals());
                With$.MODULE$.game().drawLineScreen(x0, y0Gas, x1, y1Gas, this.colorGas());
            }
        }
        for (int j = 1; j < steps.size(); ++j) {
            int x0 = this.x0i(j);
            DrawScreen$.MODULE$.text(x0, this.y0() - With$.MODULE$.visualization().lineHeightSmall() * j - 2, steps.apply(j).toString());
        }
    }

    private final void box$1(Color color, double y, boolean isSolid, int x0$1, int x1$1) {
        With$.MODULE$.game().drawBoxScreen(x0$1, (int)((double)this.y0() - y), x1$1, this.y0(), color, isSolid);
    }

    private ShowMacroSim$() {
        MODULE$ = this;
        this.y0 = 300;
        this.pixelsPerFrame = 638.0 / (double)new Seconds(90).apply();
        this.pixelsPerResource = (double)this.y0() / 1000.0;
        this.pixelsPerSupply = (double)this.y0() / 400.0;
        this.colorMinerals = Colors$.MODULE$.NeonTeal();
        this.colorGas = Colors$.MODULE$.BrightGreen();
        this.colorSupplyUsed = Colors$.MODULE$.BrightRed();
        this.colorSupplyAvailable = Colors$.MODULE$.MidnightRed();
    }
}

