/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class WrappedBuffer {
    private final ByteBuffer buffer;
    private final long address;
    private final Unsafe unsafe = WrappedBuffer.getTheUnsafe();

    WrappedBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.address = ((DirectBuffer)((Object)this.buffer)).address();
    }

    private static Unsafe getTheUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    byte getByte(int offset) {
        return this.unsafe.getByte(this.address + (long)offset);
    }

    void putByte(int offset, byte value) {
        this.unsafe.putByte(this.address + (long)offset, value);
    }

    short getShort(int offset) {
        return this.unsafe.getShort(this.address + (long)offset);
    }

    void putShort(int offset, short value) {
        this.unsafe.putShort(this.address + (long)offset, value);
    }

    int getInt(int offset) {
        return this.unsafe.getInt(this.address + (long)offset);
    }

    void putInt(int offset, int value) {
        this.unsafe.putInt(this.address + (long)offset, value);
    }

    double getDouble(int offset) {
        return this.unsafe.getDouble(this.address + (long)offset);
    }

    void putDouble(int offset, double value) {
        this.unsafe.putDouble(this.address + (long)offset, value);
    }

    String getString(int offset, int maxLen) {
        byte b;
        char[] buf = new char[maxLen];
        long pos = (long)offset + this.address;
        for (int i = 0; i < maxLen && (b = this.unsafe.getByte(pos)) != 0; ++i) {
            buf[i] = (char)(b & 0xFF);
            ++pos;
        }
        return new String(buf, 0, (int)(pos - (long)offset - this.address));
    }

    void putString(int offset, int maxLen, String string) {
        if (string.length() >= maxLen) {
            throw new StringIndexOutOfBoundsException();
        }
        long pos = (long)offset + this.address;
        for (int i = 0; i < string.length(); ++i) {
            this.unsafe.putByte(pos, (byte)string.charAt(i));
            ++pos;
        }
        this.unsafe.putByte(pos, (byte)0);
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }
}

