/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Point;
import bwapi.Position;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitCommandType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import java.util.Objects;

public class UnitCommand {
    Unit unit;
    UnitCommandType type;
    Unit target = null;
    int x;
    int y;
    int extra;

    private UnitCommand(Unit unit, UnitCommandType type) {
        this.x = Position.None.x;
        this.y = Position.None.y;
        this.extra = 0;
        this.unit = unit;
        this.type = type;
    }

    private <T extends Point<T>> void assignTarget(Point<T> target) {
        this.x = target.x;
        this.y = target.y;
    }

    public static UnitCommand attack(Unit unit, Position target) {
        return UnitCommand.attack(unit, target, false);
    }

    public static UnitCommand attack(Unit unit, Unit target) {
        return UnitCommand.attack(unit, target, false);
    }

    public static UnitCommand attack(Unit unit, Position target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Attack_Move);
        c.assignTarget(target);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand attack(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Attack_Unit);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand build(Unit unit, TilePosition target, UnitType type) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Build);
        c.assignTarget(target);
        c.extra = type.id;
        return c;
    }

    public static UnitCommand buildAddon(Unit unit, UnitType type) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Build_Addon);
        c.extra = type.id;
        return c;
    }

    public static UnitCommand train(Unit unit, UnitType type) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Train);
        c.extra = type.id;
        return c;
    }

    public static UnitCommand morph(Unit unit, UnitType type) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Morph);
        c.extra = type.id;
        return c;
    }

    public static UnitCommand research(Unit unit, TechType tech) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Research);
        c.extra = tech.id;
        return c;
    }

    public static UnitCommand upgrade(Unit unit, UpgradeType upgrade) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Upgrade);
        c.extra = upgrade.id;
        return c;
    }

    public static UnitCommand setRallyPoint(Unit unit, Position target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Set_Rally_Position);
        c.assignTarget(target);
        return c;
    }

    public static UnitCommand setRallyPoint(Unit unit, Unit target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Set_Rally_Unit);
        c.target = target;
        return c;
    }

    public static UnitCommand move(Unit unit, Position target) {
        return UnitCommand.move(unit, target, false);
    }

    public static UnitCommand move(Unit unit, Position target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Move);
        c.assignTarget(target);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand patrol(Unit unit, Position target) {
        return UnitCommand.patrol(unit, target, false);
    }

    public static UnitCommand patrol(Unit unit, Position target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Patrol);
        c.assignTarget(target);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand holdPosition(Unit unit) {
        return UnitCommand.holdPosition(unit, false);
    }

    public static UnitCommand holdPosition(Unit unit, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Hold_Position);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand stop(Unit unit) {
        return UnitCommand.stop(unit, false);
    }

    public static UnitCommand stop(Unit unit, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Stop);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand follow(Unit unit, Unit target) {
        return UnitCommand.follow(unit, target, false);
    }

    public static UnitCommand follow(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Follow);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand gather(Unit unit, Unit target) {
        return UnitCommand.gather(unit, target, false);
    }

    public static UnitCommand gather(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Gather);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand returnCargo(Unit unit) {
        return UnitCommand.returnCargo(unit, false);
    }

    public static UnitCommand returnCargo(Unit unit, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Return_Cargo);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand repair(Unit unit, Unit target) {
        return UnitCommand.repair(unit, target, false);
    }

    public static UnitCommand repair(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Repair);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand burrow(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Burrow);
    }

    public static UnitCommand unburrow(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Unburrow);
    }

    public static UnitCommand cloak(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cloak);
    }

    public static UnitCommand decloak(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Decloak);
    }

    public static UnitCommand siege(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Siege);
    }

    public static UnitCommand unsiege(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Unsiege);
    }

    public static UnitCommand lift(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Lift);
    }

    public static UnitCommand land(Unit unit, TilePosition target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Land);
        c.assignTarget(target);
        return c;
    }

    public static UnitCommand load(Unit unit, Unit target) {
        return UnitCommand.load(unit, target, false);
    }

    public static UnitCommand load(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Load);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand unload(Unit unit, Unit target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Unload);
        c.target = target;
        return c;
    }

    public static UnitCommand unloadAll(Unit unit) {
        return UnitCommand.unloadAll(unit, false);
    }

    public static UnitCommand unloadAll(Unit unit, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Unload_All);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand unloadAll(Unit unit, Position target) {
        return UnitCommand.unloadAll(unit, target, false);
    }

    public static UnitCommand unloadAll(Unit unit, Position target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Unload_All_Position);
        c.assignTarget(target);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand rightClick(Unit unit, Position target) {
        return UnitCommand.rightClick(unit, target, false);
    }

    public static UnitCommand rightClick(Unit unit, Unit target) {
        return UnitCommand.rightClick(unit, target, false);
    }

    public static UnitCommand rightClick(Unit unit, Position target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Right_Click_Position);
        c.assignTarget(target);
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand rightClick(Unit unit, Unit target, boolean shiftQueueCommand) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Right_Click_Unit);
        c.target = target;
        c.extra = shiftQueueCommand ? 1 : 0;
        return c;
    }

    public static UnitCommand haltConstruction(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Halt_Construction);
    }

    public static UnitCommand cancelConstruction(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cancel_Construction);
    }

    public static UnitCommand cancelAddon(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cancel_Addon);
    }

    public static UnitCommand cancelTrain(Unit unit) {
        return UnitCommand.cancelTrain(unit, -2);
    }

    public static UnitCommand cancelTrain(Unit unit, int slot) {
        UnitCommand c = new UnitCommand(unit, slot >= 0 ? UnitCommandType.Cancel_Train_Slot : UnitCommandType.Cancel_Train);
        c.extra = slot;
        return c;
    }

    public static UnitCommand cancelMorph(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cancel_Morph);
    }

    public static UnitCommand cancelResearch(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cancel_Research);
    }

    public static UnitCommand cancelUpgrade(Unit unit) {
        return new UnitCommand(unit, UnitCommandType.Cancel_Upgrade);
    }

    public static UnitCommand useTech(Unit unit, TechType tech) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Use_Tech);
        c.extra = tech.id;
        if (tech == TechType.Burrowing) {
            c.type = unit.isBurrowed() ? UnitCommandType.Unburrow : UnitCommandType.Burrow;
        } else if (tech == TechType.Cloaking_Field || tech == TechType.Personnel_Cloaking) {
            c.type = unit.isCloaked() ? UnitCommandType.Decloak : UnitCommandType.Cloak;
        } else if (tech == TechType.Tank_Siege_Mode) {
            c.type = unit.isSieged() ? UnitCommandType.Unsiege : UnitCommandType.Siege;
        }
        return c;
    }

    public static UnitCommand useTech(Unit unit, TechType tech, Position target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Use_Tech_Position);
        c.assignTarget(target);
        c.extra = tech.id;
        return c;
    }

    public static UnitCommand useTech(Unit unit, TechType tech, Unit target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Use_Tech_Unit);
        c.target = target;
        c.extra = tech.id;
        return c;
    }

    public static UnitCommand placeCOP(Unit unit, TilePosition target) {
        UnitCommand c = new UnitCommand(unit, UnitCommandType.Place_COP);
        c.assignTarget(target);
        return c;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public UnitCommandType getType() {
        return this.type;
    }

    public Unit getTarget() {
        return this.target;
    }

    public int getSlot() {
        return this.type == UnitCommandType.Cancel_Train_Slot ? this.extra : -1;
    }

    public Position getTargetPosition() {
        if (this.type == UnitCommandType.Build || this.type == UnitCommandType.Land || this.type == UnitCommandType.Place_COP) {
            return new TilePosition(this.x, this.y).toPosition();
        }
        return new Position(this.x, this.y);
    }

    public TilePosition getTargetTilePosition() {
        if (this.type == UnitCommandType.Build || this.type == UnitCommandType.Land || this.type == UnitCommandType.Place_COP) {
            return new TilePosition(this.x, this.y);
        }
        return new Position(this.x, this.y).toTilePosition();
    }

    public UnitType getUnitType() {
        if (this.type == UnitCommandType.Build || this.type == UnitCommandType.Build_Addon || this.type == UnitCommandType.Train || this.type == UnitCommandType.Morph) {
            return UnitType.idToEnum[this.extra];
        }
        return UnitType.None;
    }

    public TechType getTechType() {
        if (this.type == UnitCommandType.Research || this.type == UnitCommandType.Use_Tech || this.type == UnitCommandType.Use_Tech_Position || this.type == UnitCommandType.Use_Tech_Unit) {
            return TechType.idToEnum[this.extra];
        }
        return TechType.None;
    }

    public UpgradeType getUpgradeType() {
        return this.type == UnitCommandType.Upgrade ? UpgradeType.idToEnum[this.extra] : UpgradeType.None;
    }

    public boolean isQueued() {
        return (this.type == UnitCommandType.Attack_Move || this.type == UnitCommandType.Attack_Unit || this.type == UnitCommandType.Move || this.type == UnitCommandType.Patrol || this.type == UnitCommandType.Hold_Position || this.type == UnitCommandType.Stop || this.type == UnitCommandType.Follow || this.type == UnitCommandType.Gather || this.type == UnitCommandType.Return_Cargo || this.type == UnitCommandType.Load || this.type == UnitCommandType.Unload_All || this.type == UnitCommandType.Unload_All_Position || this.type == UnitCommandType.Right_Click_Position || this.type == UnitCommandType.Right_Click_Unit) && this.extra != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitCommand that = (UnitCommand)o;
        return this.x == that.x && this.y == that.y && this.extra == that.extra && this.type == that.type && Objects.equals(this.target, that.target) && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.target, this.x, this.y, this.extra, this.unit});
    }
}

