/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Order;
import bwapi.Race;
import bwapi.UnitType;
import bwapi.WeaponType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TechType {
    Stim_Packs(0),
    Lockdown(1),
    EMP_Shockwave(2),
    Spider_Mines(3),
    Scanner_Sweep(4),
    Tank_Siege_Mode(5),
    Defensive_Matrix(6),
    Irradiate(7),
    Yamato_Gun(8),
    Cloaking_Field(9),
    Personnel_Cloaking(10),
    Burrowing(11),
    Infestation(12),
    Spawn_Broodlings(13),
    Dark_Swarm(14),
    Plague(15),
    Consume(16),
    Ensnare(17),
    Parasite(18),
    Psionic_Storm(19),
    Hallucination(20),
    Recall(21),
    Stasis_Field(22),
    Archon_Warp(23),
    Restoration(24),
    Disruption_Web(25),
    Unused_26(26),
    Mind_Control(27),
    Dark_Archon_Meld(28),
    Feedback(29),
    Optical_Flare(30),
    Maelstrom(31),
    Lurker_Aspect(32),
    Unused_33(33),
    Healing(34),
    None(44),
    Nuclear_Strike(45),
    Unknown(46);

    private static final int[] defaultOreCost;
    private static final int[] defaultTimeCost;
    private static final int[] defaultEnergyCost;
    private static final UnitType[] whatResearches;
    private static final Race[] techRaces;
    private static final WeaponType[] techWeapons;
    private static final int TARG_UNIT = 1;
    private static final int TARG_POS = 2;
    private static final int TARG_BOTH = 3;
    private static final int[] techTypeFlags;
    private static final Order[] techOrders;
    private static final UnitType[][] techWhatUses;
    static final TechType[] idToEnum;
    final int id;

    private TechType(int id) {
        this.id = id;
    }

    public Race getRace() {
        return techRaces[this.id];
    }

    public int mineralPrice() {
        return defaultOreCost[this.id];
    }

    public int gasPrice() {
        return this.mineralPrice();
    }

    public int researchTime() {
        return defaultTimeCost[this.id];
    }

    public int energyCost() {
        return defaultEnergyCost[this.id];
    }

    public UnitType whatResearches() {
        return whatResearches[this.id];
    }

    public WeaponType getWeapon() {
        return techWeapons[this.id];
    }

    public boolean targetsUnit() {
        return (techTypeFlags[this.id] & 1) != 0;
    }

    public boolean targetsPosition() {
        return (techTypeFlags[this.id] & 2) != 0;
    }

    public List<UnitType> whatUses() {
        return Collections.unmodifiableList(Arrays.asList(techWhatUses[this.id]));
    }

    public Order getOrder() {
        return techOrders[this.id];
    }

    public UnitType requiredUnit() {
        return this == Lurker_Aspect ? UnitType.Zerg_Lair : UnitType.None;
    }

    static {
        defaultOreCost = new int[]{100, 200, 200, 100, 0, 150, 0, 200, 100, 150, 100, 100, 0, 100, 0, 200, 100, 100, 0, 200, 150, 150, 150, 0, 100, 200, 0, 200, 0, 100, 100, 100, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        defaultTimeCost = new int[]{1200, 1500, 1800, 1200, 0, 1200, 0, 1200, 1800, 1500, 1200, 1200, 0, 1200, 0, 1500, 1500, 1200, 0, 1800, 1200, 1800, 1500, 0, 1200, 1200, 0, 1800, 0, 1800, 1800, 1500, 1800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        defaultEnergyCost = new int[]{0, 100, 100, 0, 50, 0, 100, 75, 150, 25, 25, 0, 0, 150, 100, 150, 0, 75, 75, 75, 100, 150, 100, 0, 50, 125, 0, 150, 0, 50, 75, 100, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        whatResearches = new UnitType[]{UnitType.Terran_Academy, UnitType.Terran_Covert_Ops, UnitType.Terran_Science_Facility, UnitType.Terran_Machine_Shop, UnitType.None, UnitType.Terran_Machine_Shop, UnitType.None, UnitType.Terran_Science_Facility, UnitType.Terran_Physics_Lab, UnitType.Terran_Control_Tower, UnitType.Terran_Covert_Ops, UnitType.Zerg_Hatchery, UnitType.None, UnitType.Zerg_Queens_Nest, UnitType.None, UnitType.Zerg_Defiler_Mound, UnitType.Zerg_Defiler_Mound, UnitType.Zerg_Queens_Nest, UnitType.None, UnitType.Protoss_Templar_Archives, UnitType.Protoss_Templar_Archives, UnitType.Protoss_Arbiter_Tribunal, UnitType.Protoss_Arbiter_Tribunal, UnitType.None, UnitType.Terran_Academy, UnitType.Protoss_Fleet_Beacon, UnitType.None, UnitType.Protoss_Templar_Archives, UnitType.None, UnitType.None, UnitType.Terran_Academy, UnitType.Protoss_Templar_Archives, UnitType.Zerg_Hydralisk_Den, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.None, UnitType.Unknown};
        techRaces = new Race[]{Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Terran, Race.Zerg, Race.Zerg, Race.Zerg, Race.Zerg, Race.Zerg, Race.Zerg, Race.Zerg, Race.Zerg, Race.Protoss, Race.Protoss, Race.Protoss, Race.Protoss, Race.Protoss, Race.Terran, Race.Protoss, Race.None, Race.Protoss, Race.Protoss, Race.Protoss, Race.Terran, Race.Protoss, Race.Zerg, Race.None, Race.Terran, Race.None, Race.None, Race.None, Race.None, Race.None, Race.None, Race.None, Race.None, Race.None, Race.None, Race.Terran, Race.Unknown};
        techWeapons = new WeaponType[]{WeaponType.None, WeaponType.Lockdown, WeaponType.EMP_Shockwave, WeaponType.Spider_Mines, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.Irradiate, WeaponType.Yamato_Gun, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.Spawn_Broodlings, WeaponType.Dark_Swarm, WeaponType.Plague, WeaponType.Consume, WeaponType.Ensnare, WeaponType.Parasite, WeaponType.Psionic_Storm, WeaponType.None, WeaponType.None, WeaponType.Stasis_Field, WeaponType.None, WeaponType.Restoration, WeaponType.Disruption_Web, WeaponType.None, WeaponType.Mind_Control, WeaponType.None, WeaponType.Feedback, WeaponType.Optical_Flare, WeaponType.Maelstrom, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.None, WeaponType.Nuclear_Strike, WeaponType.Unknown};
        techTypeFlags = new int[]{0, 1, 3, 2, 3, 0, 1, 1, 1, 0, 0, 0, 1, 1, 3, 3, 1, 3, 1, 3, 1, 3, 3, 1, 1, 3, 0, 1, 1, 1, 1, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0};
        techOrders = new Order[]{Order.None, Order.CastLockdown, Order.CastEMPShockwave, Order.PlaceMine, Order.CastScannerSweep, Order.None, Order.CastDefensiveMatrix, Order.CastIrradiate, Order.FireYamatoGun, Order.None, Order.None, Order.None, Order.CastInfestation, Order.CastSpawnBroodlings, Order.CastDarkSwarm, Order.CastPlague, Order.CastConsume, Order.CastEnsnare, Order.CastParasite, Order.CastPsionicStorm, Order.CastHallucination, Order.CastRecall, Order.CastStasisField, Order.None, Order.CastRestoration, Order.CastDisruptionWeb, Order.None, Order.CastMindControl, Order.None, Order.CastFeedback, Order.CastOpticalFlare, Order.CastMaelstrom, Order.None, Order.None, Order.MedicHeal, Order.None, Order.None, Order.None, Order.None, Order.None, Order.None, Order.None, Order.None, Order.None, Order.None, Order.NukePaint, Order.Unknown};
        techWhatUses = new UnitType[][]{{UnitType.Terran_Marine, UnitType.Terran_Firebat, UnitType.Hero_Jim_Raynor_Marine, UnitType.Hero_Gui_Montag}, {UnitType.Terran_Ghost, UnitType.Hero_Alexei_Stukov, UnitType.Hero_Infested_Duran, UnitType.Hero_Samir_Duran, UnitType.Hero_Sarah_Kerrigan}, {UnitType.Terran_Science_Vessel, UnitType.Hero_Magellan}, {UnitType.Terran_Vulture, UnitType.Hero_Jim_Raynor_Vulture}, {UnitType.Terran_Comsat_Station}, {UnitType.Terran_Siege_Tank_Tank_Mode, UnitType.Terran_Siege_Tank_Siege_Mode, UnitType.Hero_Edmund_Duke_Tank_Mode, UnitType.Hero_Edmund_Duke_Siege_Mode}, {UnitType.Terran_Science_Vessel, UnitType.Hero_Magellan}, {UnitType.Terran_Science_Vessel, UnitType.Hero_Magellan}, {UnitType.Terran_Battlecruiser, UnitType.Hero_Gerard_DuGalle, UnitType.Hero_Hyperion, UnitType.Hero_Norad_II}, {UnitType.Terran_Wraith, UnitType.Hero_Tom_Kazansky}, {UnitType.Terran_Ghost, UnitType.Hero_Alexei_Stukov, UnitType.Hero_Infested_Duran, UnitType.Hero_Samir_Duran, UnitType.Hero_Sarah_Kerrigan, UnitType.Hero_Infested_Kerrigan}, {UnitType.Zerg_Zergling, UnitType.Zerg_Hydralisk, UnitType.Zerg_Drone, UnitType.Zerg_Defiler, UnitType.Zerg_Infested_Terran, UnitType.Hero_Unclean_One, UnitType.Hero_Hunter_Killer, UnitType.Hero_Devouring_One, UnitType.Zerg_Lurker}, {UnitType.Zerg_Queen, UnitType.Hero_Matriarch}, {UnitType.Zerg_Queen, UnitType.Hero_Matriarch}, {UnitType.Zerg_Defiler, UnitType.Hero_Unclean_One}, {UnitType.Zerg_Defiler, UnitType.Hero_Unclean_One}, {UnitType.Zerg_Defiler, UnitType.Hero_Unclean_One, UnitType.Hero_Infested_Kerrigan, UnitType.Hero_Infested_Duran}, {UnitType.Zerg_Queen, UnitType.Hero_Matriarch, UnitType.Hero_Infested_Kerrigan}, {UnitType.Zerg_Queen, UnitType.Hero_Matriarch}, {UnitType.Protoss_High_Templar, UnitType.Hero_Tassadar, UnitType.Hero_Infested_Kerrigan}, {UnitType.Protoss_High_Templar, UnitType.Hero_Tassadar}, {UnitType.Protoss_Arbiter, UnitType.Hero_Danimoth}, {UnitType.Protoss_Arbiter, UnitType.Hero_Danimoth}, {UnitType.Protoss_High_Templar}, {UnitType.Terran_Medic}, {UnitType.Protoss_Corsair, UnitType.Hero_Raszagal}, new UnitType[0], {UnitType.Protoss_Dark_Archon}, {UnitType.Protoss_Dark_Templar}, {UnitType.Protoss_Dark_Archon}, {UnitType.Terran_Medic}, {UnitType.Protoss_Dark_Archon}, {UnitType.Zerg_Hydralisk}, new UnitType[0], {UnitType.Terran_Medic}, new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], new UnitType[0], {UnitType.Terran_Ghost}, new UnitType[0]};
        idToEnum = new TechType[47];
        Arrays.stream(TechType.values()).forEach(v -> {
            TechType.idToEnum[v.id] = v;
        });
    }
}

