/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Point;
import bwapi.TilePosition;
import bwapi.WalkPosition;

public class Position
extends Point<Position> {
    public static final int SIZE_IN_PIXELS = 1;
    public static final Position Invalid = new Position(32000, 32000);
    public static final Position None = new Position(32000, 32032);
    public static final Position Unknown = new Position(32000, 32064);
    public static final Position Origin = new Position(0, 0);

    public Position(int x, int y) {
        super(x, y, 1);
    }

    Position(ClientData.Position position) {
        this(position.getX(), position.getY());
    }

    public TilePosition toTilePosition() {
        return new TilePosition(this.x / 32, this.y / 32);
    }

    public WalkPosition toWalkPosition() {
        return new WalkPosition(this.x / 8, this.y / 8);
    }

    @Override
    public Position subtract(Position other) {
        return new Position(this.x - other.x, this.y - other.y);
    }

    @Override
    public Position add(Position other) {
        return new Position(this.x + other.x, this.y + other.y);
    }

    @Override
    public Position divide(int divisor) {
        return new Position(this.x / divisor, this.y / divisor);
    }

    @Override
    public Position multiply(int multiplier) {
        return new Position(this.x * multiplier, this.y * multiplier);
    }
}

