/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Game;

public abstract class Point<T extends Point<T>>
implements Comparable<Point<T>> {
    static final int TILE_WALK_FACTOR = 4;
    public final int x;
    public final int y;
    private final int scalar;

    protected Point(int x, int y, int type) {
        this.x = x;
        this.y = y;
        this.scalar = type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public double getDistance(T point) {
        int dx = ((Point)point).x - this.x;
        int dy = ((Point)point).y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static int getApproxDistance(int x1, int y1, int x2, int y2) {
        int min;
        int max = Math.abs(x1 - x2);
        if (max < (min = Math.abs(y1 - y2))) {
            int temp = min;
            min = max;
            max = temp;
        }
        if (min <= max >> 2) {
            return max;
        }
        int minCalc = 3 * min >> 3;
        return (minCalc >> 5) + minCalc + max - (max >> 4) - (max >> 6);
    }

    public int getApproxDistance(T point) {
        return Point.getApproxDistance(this.x, this.y, ((Point)point).x, ((Point)point).y);
    }

    public abstract T subtract(T var1);

    public abstract T add(T var1);

    public abstract T divide(int var1);

    public abstract T multiply(int var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return this.x == point.x && this.y == point.y;
    }

    public boolean isValid(Game game) {
        return this.x >= 0 && this.y >= 0 && this.scalar * this.x < game.mapPixelWidth() && this.scalar * this.y < game.mapPixelHeight();
    }

    public int hashCode() {
        return this.x << 16 ^ this.y;
    }

    @Override
    public int compareTo(Point o) {
        if (this.scalar == o.scalar) {
            return this.hashCode() - o.hashCode();
        }
        return this.scalar - o.scalar;
    }
}

