/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWEventListener;
import bwapi.Client;
import bwapi.ClientData;
import bwapi.Game;
import bwapi.Position;
import bwapi.Unit;

class EventHandler
implements Client.EventHandler {
    private final BWEventListener eventListener;
    private final Game game;
    private final Client client;

    EventHandler(BWEventListener eventListener, Client client) {
        this.eventListener = eventListener;
        this.game = new Game(client);
        this.client = client;
    }

    @Override
    public void operation(ClientData.Event event) {
        int frames = this.game.getFrameCount();
        switch (event.getType()) {
            case MatchStart: {
                this.game.init();
                this.game.setLatCom(false);
                this.eventListener.onStart();
                break;
            }
            case MatchEnd: {
                this.eventListener.onEnd(event.getV1() != 0);
                break;
            }
            case MatchFrame: {
                this.game.onFrame(frames);
                this.eventListener.onFrame();
                break;
            }
            case SendText: {
                this.eventListener.onSendText(this.client.eventString(event.getV1()));
                break;
            }
            case ReceiveText: {
                this.eventListener.onReceiveText(this.game.getPlayer(event.getV1()), this.client.eventString(event.getV2()));
                break;
            }
            case PlayerLeft: {
                this.eventListener.onPlayerLeft(this.game.getPlayer(event.getV1()));
                break;
            }
            case NukeDetect: {
                this.eventListener.onNukeDetect(new Position(event.getV1(), event.getV2()));
                break;
            }
            case SaveGame: {
                this.eventListener.onSaveGame(this.client.eventString(event.getV1()));
                break;
            }
            case UnitDiscover: {
                this.game.unitCreate(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                u.updatePosition(frames);
                this.eventListener.onUnitDiscover(u);
                break;
            }
            case UnitEvade: {
                Unit u = this.game.getUnit(event.getV1());
                u.updatePosition(frames);
                this.eventListener.onUnitEvade(u);
                break;
            }
            case UnitShow: {
                this.game.unitShow(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                u.updatePosition(frames);
                this.eventListener.onUnitShow(u);
                break;
            }
            case UnitHide: {
                this.game.unitHide(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                this.eventListener.onUnitHide(u);
                break;
            }
            case UnitCreate: {
                this.game.unitCreate(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                u.updatePosition(frames);
                this.eventListener.onUnitCreate(u);
                break;
            }
            case UnitDestroy: {
                this.game.unitHide(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                this.eventListener.onUnitDestroy(u);
                break;
            }
            case UnitMorph: {
                Unit u = this.game.getUnit(event.getV1());
                u.updatePosition(frames);
                this.eventListener.onUnitMorph(u);
                break;
            }
            case UnitRenegade: {
                Unit u = this.game.getUnit(event.getV1());
                this.eventListener.onUnitRenegade(u);
                break;
            }
            case UnitComplete: {
                this.game.unitCreate(event.getV1());
                Unit u = this.game.getUnit(event.getV1());
                this.eventListener.onUnitComplete(u);
            }
        }
    }

    public Game getGame() {
        return this.game;
    }
}

