/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWEventListener;
import bwapi.Client;
import bwapi.EventHandler;
import bwapi.Game;
import java.util.Objects;

public class BWClient {
    private final BWEventListener eventListener;
    private final boolean debugConnection;
    private EventHandler handler;

    public BWClient(BWEventListener eventListener) {
        this(eventListener, false);
    }

    public BWClient(BWEventListener eventListener, boolean debugConnection) {
        Objects.requireNonNull(eventListener);
        this.debugConnection = debugConnection;
        this.eventListener = eventListener;
    }

    public Game getGame() {
        return this.handler == null ? null : this.handler.getGame();
    }

    public void startGame() {
        this.startGame(false);
    }

    public void startGame(boolean autoContinue) {
        Client client = new Client(this.debugConnection);
        client.reconnect();
        this.handler = new EventHandler(this.eventListener, client);
        while (true) {
            if (!this.getGame().isInGame()) {
                if (!client.isConnected()) {
                    return;
                }
                client.update(this.handler);
                continue;
            }
            while (this.getGame().isInGame()) {
                client.update(this.handler);
                if (client.isConnected()) continue;
                System.out.println("Reconnecting...");
                client.reconnect();
            }
            if (!autoContinue) break;
        }
    }
}

