/*
 * Decompiled with CFR 0.152.
 */
package jps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import jps.Node;

public class Graph<T extends Node> {
    private List<T> nodes;
    private int width;
    private BiFunction<Node, Node, Double> distance = euclidean;
    private BiFunction<Node, Node, Double> heuristic = euclidean;
    private static BiFunction<Node, Node, Double> manhattan = (a, b) -> (double)Math.abs(a.x - b.x) + (double)Math.abs(a.y - b.y);
    private static BiFunction<Node, Node, Double> euclidean = (a, b) -> Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
    private static BiFunction<Node, Node, Double> octile = (a, b) -> {
        double dy;
        double F = Math.sqrt(2.0) - 1.0;
        double dx = Math.abs(a.x - b.x);
        return dx < (dy = (double)Math.abs(a.y - b.y)) ? F * dx + dy : F * dy + dx;
    };
    private static BiFunction<Node, Node, Double> chebyshev = (a, b) -> Math.max(Math.abs(a.x - b.x), Math.abs(a.y - b.y));

    public Graph(List<List<T>> map, DistanceAlgo distance, DistanceAlgo heuristic) {
        this.width = map.get(0).size();
        this.nodes = new ArrayList<T>(map.size() * map.get(0).size());
        map.forEach(this.nodes::addAll);
        this.distance = distance.algo;
        this.heuristic = heuristic.algo;
    }

    public Graph(T[][] map, DistanceAlgo distance, DistanceAlgo heuristic) {
        this.width = map[0].length;
        this.nodes = new ArrayList<T>(map.length * map[0].length);
        for (T[] row : map) {
            Collections.addAll(this.nodes, row);
        }
        this.distance = distance.algo;
        this.heuristic = heuristic.algo;
    }

    public Graph(List<List<T>> map) {
        this.width = map.get(0).size();
        this.nodes = new ArrayList<T>(map.size() * map.get(0).size());
        map.forEach(this.nodes::addAll);
    }

    public Graph(T[][] map) {
        this.width = map[0].length;
        this.nodes = new ArrayList<T>(map.length * map[0].length);
        for (T[] row : map) {
            Collections.addAll(this.nodes, row);
        }
    }

    public Collection<T> getNodes() {
        return this.nodes;
    }

    public T getNode(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.nodes.size() / this.width) {
            return null;
        }
        return (T)((Node)this.nodes.get(x + y * this.width));
    }

    public double getDistance(Node a, Node b) {
        return this.distance.apply(a, b);
    }

    public double getHeuristicDistance(Node a, Node b) {
        return this.heuristic.apply(a, b);
    }

    public Collection<T> getNeighborsOf(T node) {
        return this.getNeighborsOf(node, Diagonal.NO_OBSTACLES);
    }

    public Set<T> getNeighborsOf(T node, Diagonal diagonal) {
        int x = ((Node)node).x;
        int y = ((Node)node).y;
        HashSet<T> neighbors = new HashSet<T>();
        boolean n = false;
        boolean s = false;
        boolean e = false;
        boolean w = false;
        boolean ne = false;
        boolean nw = false;
        boolean se = false;
        boolean sw = false;
        if (this.isWalkable(x, y - 1)) {
            neighbors.add(this.getNode(x, y - 1));
            n = true;
        }
        if (this.isWalkable(x + 1, y)) {
            neighbors.add(this.getNode(x + 1, y));
            e = true;
        }
        if (this.isWalkable(x, y + 1)) {
            neighbors.add(this.getNode(x, y + 1));
            s = true;
        }
        if (this.isWalkable(x - 1, y)) {
            neighbors.add(this.getNode(x - 1, y));
            w = true;
        }
        switch (diagonal) {
            case NEVER: {
                return neighbors;
            }
            case NO_OBSTACLES: {
                ne = n && e;
                nw = n && w;
                se = s && e;
                sw = s && w;
                break;
            }
            case ONE_OBSTACLE: {
                ne = n || e;
                nw = n || w;
                se = s || e;
                sw = s || w;
                break;
            }
            case ALWAYS: {
                sw = true;
                se = true;
                nw = true;
                ne = true;
            }
        }
        if (nw && this.isWalkable(x - 1, y - 1)) {
            neighbors.add(this.getNode(x - 1, y - 1));
        }
        if (ne && this.isWalkable(x + 1, y - 1)) {
            neighbors.add(this.getNode(x + 1, y - 1));
        }
        if (se && this.isWalkable(x + 1, y + 1)) {
            neighbors.add(this.getNode(x + 1, y + 1));
        }
        if (sw && this.isWalkable(x - 1, y + 1)) {
            neighbors.add(this.getNode(x - 1, y + 1));
        }
        return neighbors;
    }

    public boolean isWalkable(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.nodes.size() / this.width && ((Node)this.getNode((int)x, (int)y)).walkable;
    }

    public void setDistanceAlgo(BiFunction<Node, Node, Double> distance) {
        this.distance = distance;
    }

    public void setHeuristicAlgo(BiFunction<Node, Node, Double> heuristic) {
        this.heuristic = heuristic;
    }

    static /* synthetic */ BiFunction access$000() {
        return manhattan;
    }

    static /* synthetic */ BiFunction access$100() {
        return euclidean;
    }

    static /* synthetic */ BiFunction access$200() {
        return octile;
    }

    static /* synthetic */ BiFunction access$300() {
        return chebyshev;
    }

    public static enum DistanceAlgo {
        MANHATTAN(Graph.access$000()),
        EUCLIDEAN(Graph.access$100()),
        OCTILE(Graph.access$200()),
        CHEBYSHEV(Graph.access$300());

        BiFunction<Node, Node, Double> algo;

        private DistanceAlgo(BiFunction<Node, Node, Double> algo) {
            this.algo = algo;
        }
    }

    public static enum Diagonal {
        ALWAYS,
        NO_OBSTACLES,
        ONE_OBSTACLE,
        NEVER;

    }
}

