/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Pair;
import bwapi.Position;
import bwapi.TilePosition;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jbweb.AStar;
import jbweb.JBWEB;
import jbweb.Pathfinding;
import jbweb.Wall;

public class Path {
    private List<TilePosition> tiles = new ArrayList<TilePosition>();
    private double dist = 0.0;
    private boolean reachable = false;
    private TilePosition source = TilePosition.Invalid;
    private TilePosition target = TilePosition.Invalid;

    public List<TilePosition> getTiles() {
        return this.tiles;
    }

    public TilePosition getSource() {
        return this.source;
    }

    public TilePosition getTarget() {
        return this.target;
    }

    public double getDistance() {
        return this.dist;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public void createUnitPath(Position s, Position t, Wall wall) {
        Integer checkReachable;
        this.target = new TilePosition(t);
        this.source = new TilePosition(s);
        Pair<TilePosition, TilePosition> pathPoints = new Pair<TilePosition, TilePosition>(this.source, this.target);
        if (Pathfinding.unitPathCache.indexList.get(pathPoints) == null) {
            if (Pathfinding.unitPathCache.pathCache.size() == Pathfinding.maxCacheSize) {
                Path last = Pathfinding.unitPathCache.pathCache.get(Pathfinding.unitPathCache.pathCache.size() - 1);
                Pathfinding.unitPathCache.pathCache.remove(last);
                Pathfinding.unitPathCache.indexList.remove(new Pair<TilePosition, TilePosition>(last.getSource(), last.getTarget()));
            }
        } else {
            Path oldPath = Pathfinding.unitPathCache.indexList.get(pathPoints).get(Pathfinding.unitPathCache.pathCacheIndex);
            this.dist = oldPath.getDistance();
            this.tiles = oldPath.getTiles();
            this.reachable = oldPath.isReachable();
            Pathfinding.unitPathCache.pathCache.remove(Pathfinding.unitPathCache.indexList.get(pathPoints).get(Pathfinding.unitPathCache.pathCacheIndex));
            ArrayList<Path> tmpCache = new ArrayList<Path>();
            tmpCache.add(this);
            tmpCache.addAll(Pathfinding.unitPathCache.pathCache);
            Pathfinding.unitPathCache.pathCache = tmpCache;
            Pathfinding.unitPathCache.pathCacheIndex = 0;
            return;
        }
        if (this.target.isValid(JBWEB.game) && JBWEB.mapBWEM.getMap().getArea(this.target) != null && wall.wallWalkable(new TilePosition(this.source.x, this.source.y)) && (checkReachable = Pathfinding.unitPathCache.notReachableThisFrame.get(JBWEB.mapBWEM.getMap().getArea(this.target))) != null && checkReachable >= JBWEB.game.getFrameCount() && JBWEB.game.getFrameCount() > 0) {
            this.reachable = false;
            this.dist = Double.MAX_VALUE;
            return;
        }
        List<TilePosition> path = AStar.find(this.source, this.target, JBWEB.walkGrid);
        if (path != null) {
            Position current = s;
            for (TilePosition tile : path) {
                this.dist += new Position(tile).getDistance(current);
                current = new Position(tile);
                this.tiles.add(tile);
            }
            this.reachable = true;
            ArrayList<Path> tmpCache = new ArrayList<Path>();
            tmpCache.add(this);
            tmpCache.addAll(Pathfinding.unitPathCache.pathCache);
            Pathfinding.unitPathCache.pathCache = tmpCache;
            Pathfinding.unitPathCache.pathCacheIndex = 0;
        } else if (this.target.isValid(JBWEB.game) && JBWEB.mapBWEM.getMap().getArea(this.target) != null) {
            this.dist = Double.MAX_VALUE;
            Pathfinding.unitPathCache.notReachableThisFrame.put(JBWEB.mapBWEM.getMap().getArea(this.target), JBWEB.game.getFrameCount());
            this.reachable = false;
        }
    }

    public void bfsPath(Position bfsSourceP, Position bfsTargetP, Wall wall) {
        TilePosition bfsSource = new TilePosition(bfsSourceP);
        TilePosition bfsTarget = new TilePosition(bfsTargetP);
        ArrayList<TilePosition> direction = new ArrayList<TilePosition>();
        direction.add(new TilePosition(0, 1));
        direction.add(new TilePosition(1, 0));
        direction.add(new TilePosition(-1, 0));
        direction.add(new TilePosition(0, -1));
        if (bfsSource.equals(bfsTarget) || bfsSource.equals(new TilePosition(0, 0)) || bfsTarget.equals(new TilePosition(0, 0))) {
            return;
        }
        TilePosition[][] parentGrid = new TilePosition[256][256];
        LinkedList<TilePosition> nodeQueue = new LinkedList<TilePosition>();
        nodeQueue.add(bfsSource);
        parentGrid[bfsSource.x][bfsSource.y] = bfsSource;
        while (!nodeQueue.isEmpty()) {
            TilePosition tile = (TilePosition)nodeQueue.peek();
            nodeQueue.remove();
            for (TilePosition d : direction) {
                TilePosition existingParent;
                TilePosition next = new TilePosition(tile.x + d.x, tile.y + d.y);
                if (!(next.isValid(JBWEB.game) && (existingParent = parentGrid[next.x][next.y]) == null && wall.wallWalkable(next) && (d.x != 1 && d.x != -1 || d.y != 1 && d.y != -1 || wall.wallWalkable(new TilePosition(tile.x + d.x, tile.y)) && wall.wallWalkable(new TilePosition(tile.x, tile.y + d.y))))) continue;
                parentGrid[next.x][next.y] = tile;
                if (next.equals(bfsTarget)) {
                    this.bfsPath_createPath(bfsSource, bfsTarget, parentGrid);
                    return;
                }
                nodeQueue.add(next);
            }
        }
        this.reachable = false;
        this.dist = Double.MAX_VALUE;
    }

    private void bfsPath_createPath(TilePosition bfsSource, TilePosition bfsTarget, TilePosition[][] parentGrid) {
        this.tiles.add(bfsTarget);
        this.reachable = true;
        TilePosition check = parentGrid[bfsTarget.x][bfsTarget.y];
        this.dist += new Position(bfsTarget).getDistance(new Position(check));
        do {
            this.tiles.add(check);
            TilePosition prev = check;
            check = parentGrid[check.x][check.y];
            this.dist += new Position(prev).getDistance(new Position(check));
        } while (!check.equals(bfsSource));
        Position correctionSource = new Position(this.tiles.get(this.tiles.size() - 2));
        Position correctionTarget = new Position(this.tiles.get(1));
        this.dist += bfsSource.getDistance(correctionSource.toTilePosition());
        this.dist += bfsTarget.getDistance(correctionTarget.toTilePosition());
        this.dist -= 64.0;
    }
}

