/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.TilePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Stream;
import jbweb.JBWEB;

public class AStar {
    public static List<TilePosition> find(TilePosition from, TilePosition to, boolean[][] walkableXY) {
        HashSet explored = new HashSet();
        PriorityQueue<Node> horizon = new PriorityQueue<Node>(Comparator.comparingInt(a -> a.heuristic));
        class Node {
            int cost;
            int heuristic;
            TilePosition tile;
            Node from;

            Node() {
            }
        }
        Node fromNode = new Node();
        fromNode.cost = 0;
        fromNode.tile = from;
        fromNode.from = null;
        horizon.add(fromNode);
        while (!horizon.isEmpty()) {
            Node here = (Node)horizon.poll();
            if (here.tile.equals(to)) {
                ArrayList<TilePosition> output = new ArrayList<TilePosition>();
                Node step = here;
                do {
                    output.add(step.tile);
                } while ((step = step.from) != null);
                Collections.reverse(output);
                return output;
            }
            Stream.of(new TilePosition(here.tile.x - 1, here.tile.y), new TilePosition(here.tile.x + 1, here.tile.y), new TilePosition(here.tile.x, here.tile.y - 1), new TilePosition(here.tile.x, here.tile.y + 1)).filter(tile -> tile.isValid(JBWEB.game) && walkableXY[tile.x][tile.y] && !explored.contains(tile)).forEach(tile -> {
                Node neighbor = new Node();
                neighbor.tile = tile;
                neighbor.from = here;
                neighbor.cost = here.cost + 1;
                neighbor.heuristic = neighbor.cost + tile.getApproxDistance(to);
                horizon.add(neighbor);
                explored.add(tile);
            });
        }
        return null;
    }
}

