/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Position;
import bwapi.TilePosition;
import bwapi.WalkPosition;
import java.util.ArrayList;
import java.util.List;

public final class MapData {
    private final TilePosition tileSize;
    private final WalkPosition walkSize;
    private final Position pixelSize;
    private final Position center;
    private final List<TilePosition> startingLocations;

    MapData(int tileWidth, int tileHeight, List<TilePosition> startingLocations) {
        this.tileSize = new TilePosition(tileWidth, tileHeight);
        this.walkSize = this.tileSize.toWalkPosition();
        this.pixelSize = this.tileSize.toPosition();
        this.center = new Position(this.pixelSize.getX() / 2, this.pixelSize.getY() / 2);
        this.startingLocations = new ArrayList<TilePosition>(startingLocations);
    }

    public TilePosition getTileSize() {
        return this.tileSize;
    }

    public WalkPosition getWalkSize() {
        return this.walkSize;
    }

    public Position getPixelSize() {
        return this.pixelSize;
    }

    public Position getCenter() {
        return this.center;
    }

    public List<TilePosition> getStartingLocations() {
        return this.startingLocations;
    }

    public boolean isValid(TilePosition tilePosition) {
        return this.isValid(tilePosition.getX(), tilePosition.getY(), this.getTileSize().getX(), this.getTileSize().getY());
    }

    public boolean isValid(WalkPosition walkPosition) {
        return this.isValid(walkPosition.getX(), walkPosition.getY(), this.getWalkSize().getX(), this.getWalkSize().getY());
    }

    public boolean isValid(Position position) {
        return this.isValid(position.getX(), position.getY(), this.getPixelSize().getX(), this.getPixelSize().getY());
    }

    private boolean isValid(int x, int y, int maxX, int maxY) {
        return x >= 0 && x < maxX && y >= 0 && y < maxY;
    }
}

