/*
 * Decompiled with CFR 0.152.
 */
package Micro.Coordination.Pathing;

import Debugging.Visualizations.Forces$;
import Information.Geography.Pathfinding.PathfindProfile;
import Information.Geography.Pathfinding.PathfindProfile$;
import Information.Geography.Pathfinding.PathfindRepulsor;
import Information.Geography.Pathfinding.Types.TilePath;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Physics.Force;
import Mathematics.Points.Pixel;
import Mathematics.Points.Points$;
import Mathematics.Points.Tile;
import Mathematics.Shapes.Circle$;
import Mathematics.Shapes.Ray$;
import Micro.Actions.Combat.Maneuvering.DownhillPathfinder$;
import Micro.Agency.Commander$;
import Micro.Coordination.Pushing.Push;
import Micro.Heuristics.Potential$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.$qmark$;
import Utilities.SomeIf$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MicroPathing$ {
    public static MicroPathing$ MODULE$;
    private final int waypointDistanceTiles;
    private final int waypointDistancePixels;
    private final int ringDistance;
    private final Vector<Object> rayRadians32;
    private final Vector<Object> rayRadians16;
    private final Vector<Object> rayRadians12;

    static {
        new MicroPathing$();
    }

    public TilePath getSimplePath(FriendlyUnitInfo unit, Option<Tile> to) {
        PathfindProfile pathfindProfile = new PathfindProfile(unit.tile(), PathfindProfile$.MODULE$.$lessinit$greater$default$2(), PathfindProfile$.MODULE$.$lessinit$greater$default$3(), PathfindProfile$.MODULE$.$lessinit$greater$default$4(), PathfindProfile$.MODULE$.$lessinit$greater$default$5(), PathfindProfile$.MODULE$.$lessinit$greater$default$6(), PathfindProfile$.MODULE$.$lessinit$greater$default$7(), PathfindProfile$.MODULE$.$lessinit$greater$default$8(), PathfindProfile$.MODULE$.$lessinit$greater$default$9(), PathfindProfile$.MODULE$.$lessinit$greater$default$10(), PathfindProfile$.MODULE$.$lessinit$greater$default$11(), PathfindProfile$.MODULE$.$lessinit$greater$default$12(), PathfindProfile$.MODULE$.$lessinit$greater$default$13(), PathfindProfile$.MODULE$.$lessinit$greater$default$14(), PathfindProfile$.MODULE$.$lessinit$greater$default$15(), PathfindProfile$.MODULE$.$lessinit$greater$default$16(), PathfindProfile$.MODULE$.$lessinit$greater$default$17(), PathfindProfile$.MODULE$.$lessinit$greater$default$18(), PathfindProfile$.MODULE$.$lessinit$greater$default$19());
        pathfindProfile.end_$eq((Option<Tile>)to.orElse((Function0 & Serializable & scala.Serializable)() -> unit.agent().destinationNext().pixel().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tile())));
        pathfindProfile.employGroundDist_$eq(!unit.flying());
        pathfindProfile.unit_$eq((Option<FriendlyUnitInfo>)new Some((Object)unit));
        return pathfindProfile.find();
    }

    public Option<Tile> getSimplePath$default$2() {
        return None$.MODULE$;
    }

    public TilePath getSneakyPath(FriendlyUnitInfo unit, Option<Tile> to) {
        PathfindProfile pathfindProfile = new PathfindProfile(unit.tile(), PathfindProfile$.MODULE$.$lessinit$greater$default$2(), PathfindProfile$.MODULE$.$lessinit$greater$default$3(), PathfindProfile$.MODULE$.$lessinit$greater$default$4(), PathfindProfile$.MODULE$.$lessinit$greater$default$5(), PathfindProfile$.MODULE$.$lessinit$greater$default$6(), PathfindProfile$.MODULE$.$lessinit$greater$default$7(), PathfindProfile$.MODULE$.$lessinit$greater$default$8(), PathfindProfile$.MODULE$.$lessinit$greater$default$9(), PathfindProfile$.MODULE$.$lessinit$greater$default$10(), PathfindProfile$.MODULE$.$lessinit$greater$default$11(), PathfindProfile$.MODULE$.$lessinit$greater$default$12(), PathfindProfile$.MODULE$.$lessinit$greater$default$13(), PathfindProfile$.MODULE$.$lessinit$greater$default$14(), PathfindProfile$.MODULE$.$lessinit$greater$default$15(), PathfindProfile$.MODULE$.$lessinit$greater$default$16(), PathfindProfile$.MODULE$.$lessinit$greater$default$17(), PathfindProfile$.MODULE$.$lessinit$greater$default$18(), PathfindProfile$.MODULE$.$lessinit$greater$default$19());
        pathfindProfile.end_$eq((Option<Tile>)to.orElse((Function0 & Serializable & scala.Serializable)() -> unit.agent().destinationNext().pixel().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.tile())));
        pathfindProfile.employGroundDist_$eq(!unit.flying());
        pathfindProfile.unit_$eq((Option<FriendlyUnitInfo>)new Some((Object)unit));
        pathfindProfile.costEnemyVision_$eq(5.0);
        pathfindProfile.costThreat_$eq(25.0);
        pathfindProfile.lengthMaximum_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)48.0)));
        return pathfindProfile.find();
    }

    public Option<Tile> getSneakyPath$default$2() {
        return None$.MODULE$;
    }

    public TilePath getThreatAwarePath(FriendlyUnitInfo unit, boolean preferHome) {
        int pathLengthMinimum = 7;
        PathfindProfile pathfindProfile = new PathfindProfile(unit.tile(), PathfindProfile$.MODULE$.$lessinit$greater$default$2(), PathfindProfile$.MODULE$.$lessinit$greater$default$3(), PathfindProfile$.MODULE$.$lessinit$greater$default$4(), PathfindProfile$.MODULE$.$lessinit$greater$default$5(), PathfindProfile$.MODULE$.$lessinit$greater$default$6(), PathfindProfile$.MODULE$.$lessinit$greater$default$7(), PathfindProfile$.MODULE$.$lessinit$greater$default$8(), PathfindProfile$.MODULE$.$lessinit$greater$default$9(), PathfindProfile$.MODULE$.$lessinit$greater$default$10(), PathfindProfile$.MODULE$.$lessinit$greater$default$11(), PathfindProfile$.MODULE$.$lessinit$greater$default$12(), PathfindProfile$.MODULE$.$lessinit$greater$default$13(), PathfindProfile$.MODULE$.$lessinit$greater$default$14(), PathfindProfile$.MODULE$.$lessinit$greater$default$15(), PathfindProfile$.MODULE$.$lessinit$greater$default$16(), PathfindProfile$.MODULE$.$lessinit$greater$default$17(), PathfindProfile$.MODULE$.$lessinit$greater$default$18(), PathfindProfile$.MODULE$.$lessinit$greater$default$19());
        pathfindProfile.end_$eq(SomeIf$.MODULE$.apply(preferHome, (Function0 & Serializable & scala.Serializable)() -> unit.agent().safety().tile()));
        pathfindProfile.lengthMinimum_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)pathLengthMinimum)));
        pathfindProfile.lengthMaximum_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)Maff$.MODULE$.clamp((int)(unit.matchups().pixelsEntangled() + unit.effectiveRangePixels()) / 32, pathLengthMinimum, 15))));
        pathfindProfile.threatMaximum_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        pathfindProfile.employGroundDist_$eq(true);
        pathfindProfile.costOccupancy_$eq(BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(unit.flying(), (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 3.0)));
        pathfindProfile.costRepulsion_$eq(3.0);
        pathfindProfile.costThreat_$eq(6.0);
        pathfindProfile.repulsors_$eq(this.getPathfindingRepulsors(unit, this.getPathfindingRepulsors$default$2()));
        pathfindProfile.unit_$eq((Option<FriendlyUnitInfo>)new Some((Object)unit));
        return pathfindProfile.find();
    }

    public boolean getThreatAwarePath$default$2() {
        return true;
    }

    public int waypointDistanceTiles() {
        return this.waypointDistanceTiles;
    }

    public int waypointDistancePixels() {
        return this.waypointDistancePixels;
    }

    private int ringDistance() {
        return this.ringDistance;
    }

    public SeqView<Pixel, Seq<?>> getCircleTowards(Pixel from, Pixel to) {
        return (SeqView)((TraversableViewLike)Circle$.MODULE$.apply(5).view().map((Function1 & Serializable & scala.Serializable)p -> from.add(p.x() * 32, p.y() * 32), SeqView$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.valid()));
    }

    public Pixel getWaypointToPixel(UnitInfo unit, Pixel goal) {
        return (Pixel)$qmark$.MODULE$.apply(unit.flying(), (Function0 & Serializable & scala.Serializable)() -> goal, (Function0 & Serializable & scala.Serializable)() -> MODULE$.getGroundWaypointToPixel(unit.pixel(), goal));
    }

    public Pixel getGroundWaypointToPixel(Pixel from, Pixel rawGoal) {
        LazyRef hillPath$lzy = new LazyRef();
        LazyRef hillWaypoint$lzy = new LazyRef();
        if (from.pixelDistance(rawGoal) < (double)32) {
            return rawGoal;
        }
        Pixel goal = rawGoal.walkablePixel();
        return (Pixel)SomeIf$.MODULE$.apply(Ray$.MODULE$.apply(from, goal).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.walkable())), (Function0 & Serializable & scala.Serializable)() -> from.project(goal, Math.min(from.pixelDistance(goal), (double)MODULE$.waypointDistancePixels()))).orElse((Function0 & Serializable & scala.Serializable)() -> MicroPathing$.hillWaypoint$1(hillWaypoint$lzy, from, hillPath$lzy, goal)).getOrElse((Function0 & Serializable & scala.Serializable)() -> goal);
    }

    public Option<Pixel> getWaypointAlongTilePath(FriendlyUnitInfo unit, TilePath path) {
        return SomeIf$.MODULE$.apply(path.pathExists(), (Function0 & Serializable & scala.Serializable)() -> {
            int currentIndex = BoxesRunTime.unboxToInt((Object)((SeqLike)path.tiles().get()).indices().minBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> ((Tile)((SeqLike)path.tiles().get()).apply(i)).center().pixelDistanceSquared(unit.pixel()), (Ordering)Ordering.Int$.MODULE$));
            return ((Tile)((TraversableLike)((IterableLike)path.tiles().get()).take(currentIndex + MODULE$.waypointDistanceTiles())).last()).center();
        });
    }

    public void moveForcefully(FriendlyUnitInfo unit) {
        this.setWaypointForcefully(unit);
        Commander$.MODULE$.move(unit);
    }

    public boolean setWaypointForcefully(FriendlyUnitInfo unit) {
        return unit.agent().forced().setAsWaypoint((Option<Pixel>)this.getPushRadians(unit).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> MicroPathing$.MODULE$.getWaypointInDirection(unit, BoxesRunTime.unboxToDouble((Object)x$5), MicroPathing$.MODULE$.getWaypointInDirection$default$3(), MicroPathing$.MODULE$.getWaypointInDirection$default$4()))).isDefined();
    }

    private Vector<Object> rayRadiansN(int rays) {
        return (Vector)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rays).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$6 -> (double)(x$6 * 2) * Math.PI / (double)rays - Math.PI, IndexedSeq$.MODULE$.canBuildFrom())).toVector().sortBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> Math.abs(x$1), (Ordering)Ordering.Double$.MODULE$);
    }

    private Vector<Object> rayRadians32() {
        return this.rayRadians32;
    }

    private Vector<Object> rayRadians16() {
        return this.rayRadians16;
    }

    private Vector<Object> rayRadians12() {
        return this.rayRadians12;
    }

    public Option<Pixel> getWaypointInDirection(FriendlyUnitInfo unit, double radians, Option<Pixel> mustApproach, boolean requireSafety) {
        Vector<Object> vector;
        LazyRef unacceptableDistance$lzy = new LazyRef();
        if (mustApproach.exists((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)MicroPathing$.$anonfun$getWaypointInDirection$2(unit, requireSafety, a)))) {
            return mustApproach;
        }
        double waypointDistance = Math.max((double)this.waypointDistancePixels(), requireSafety ? (double)64 + unit.matchups().pixelsEntangled() : 0.0);
        switch (With$.MODULE$.reaction().sluggishness()) {
            case 0: {
                vector = this.rayRadians32();
                break;
            }
            case 1: {
                vector = this.rayRadians32();
                break;
            }
            case 2: {
                vector = this.rayRadians16();
                break;
            }
            default: {
                vector = this.rayRadians12();
            }
        }
        return ((IterableLike)vector.view().map((Function1 & Serializable & scala.Serializable)r -> MicroPathing$.MODULE$.castRay(unit.pixel(), waypointDistance, radians + BoxesRunTime.unboxToDouble((Object)r), unit.flying()), SeqView$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MicroPathing$.$anonfun$getWaypointInDirection$4(unit, mustApproach, unacceptableDistance$lzy, requireSafety, p)));
    }

    public Option<Pixel> getWaypointInDirection$default$3() {
        return None$.MODULE$;
    }

    public boolean getWaypointInDirection$default$4() {
        return false;
    }

    public void tryMovingAlongTilePath(FriendlyUnitInfo unit, TilePath path) {
        this.getWaypointAlongTilePath(unit, path).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.add(unit.pixel().offsetFromTileCenter())).foreach((Function1 & Serializable & scala.Serializable)waypoint -> {
            MicroPathing$.$anonfun$tryMovingAlongTilePath$2(unit, waypoint);
            return BoxedUnit.UNIT;
        });
    }

    public IndexedSeq<PathfindRepulsor> getPathfindingRepulsors(FriendlyUnitInfo unit, int maxThreats) {
        return ((TraversableOnce)Maff$.MODULE$.takeN(maxThreats, (Iterable)unit.matchups().threats().view().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.likelyStillThere())), package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)unit.pixelsOfEntanglement(t)), (Ordering)Ordering.Double$.MODULE$)).map((Function1 & Serializable & scala.Serializable)threat -> new PathfindRepulsor(threat.pixel(), threat.dpfOnNextHitAgainst(unit), (double)64 + threat.pixelRangeAgainst(unit)), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    public int getPathfindingRepulsors$default$2() {
        return 10;
    }

    public void setDefaultForces(FriendlyUnitInfo unit, boolean goalSafety, boolean goalOrigin) {
        unit.agent().forces().update(Forces$.MODULE$.sneaking(), Potential$.MODULE$.avoidDetection(unit));
        unit.agent().forces().update(Forces$.MODULE$.travel(), Potential$.MODULE$.towards(unit, unit.agent().safety()).$times(Maff$.MODULE$.toInt(goalOrigin)));
        unit.agent().forces().update(Forces$.MODULE$.threat(), Potential$.MODULE$.hardAvoidThreatRange(unit, Potential$.MODULE$.hardAvoidThreatRange$default$2()).$times(Maff$.MODULE$.toInt(goalSafety)));
        if (unit.agent().forces().allZero()) {
            unit.agent().forces().update(Forces$.MODULE$.travel(), Potential$.MODULE$.towards(unit, unit.agent().destinationNext().apply()));
        }
        unit.agent().forces().update(Forces$.MODULE$.spacing(), Potential$.MODULE$.preferSpacing(unit));
        unit.agent().forces().update(Forces$.MODULE$.pushing(), Potential$.MODULE$.followPushes(unit));
    }

    public Seq<Tuple2<Push, Force>> getPushForces(FriendlyUnitInfo unit) {
        return (Seq)((TraversableLike)((TraversableLike)With$.MODULE$.coordinator().pushes().get(unit).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p, p.force(unit)), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MicroPathing$.$anonfun$getPushForces$2(x$10)))).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p._1(), ((Option)p._2()).get()), Seq$.MODULE$.canBuildFrom());
    }

    public Option<Object> getPushRadians(Seq<Tuple2<Push, Force>> pushForces) {
        Option highestPriority = Maff$.MODULE$.max((TraversableOnce)pushForces.view().map((Function1 & Serializable & scala.Serializable)x$12 -> ((Push)x$12._1()).priority(), SeqView$.MODULE$.canBuildFrom()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        return ((TraversableOnce)((TraversableLike)pushForces.filter((Function1 & Serializable & scala.Serializable)pushForce -> BoxesRunTime.boxToBoolean((boolean)highestPriority.contains((Object)((Push)pushForce._1()).priority())))).map((Function1 & Serializable & scala.Serializable)x$13 -> (Force)x$13._2(), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$14, x$15) -> x$14.$plus((Force)x$15)).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16.radians()));
    }

    public Option<Object> getPushRadians(FriendlyUnitInfo unit) {
        return this.getPushRadians(this.getPushForces(unit));
    }

    public Pixel castRay(Pixel from, double lengthPixels, double radians, boolean flying) {
        ObjectRef output = ObjectRef.create((Object)from);
        BooleanRef proceed = BooleanRef.create((boolean)true);
        Ray$.MODULE$.apply(from, lengthPixels, radians).foreach((Function1 & Serializable & scala.Serializable)pixel -> {
            MicroPathing$.$anonfun$castRay$1(proceed, flying, output, pixel);
            return BoxedUnit.UNIT;
        });
        return (Pixel)output.elem;
    }

    public Pixel pullTowards(double leash, Seq<Pixel> towards) {
        DoubleRef distanceLeft = DoubleRef.create((double)leash);
        ObjectRef output = ObjectRef.create((Object)((Pixel)towards.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Points$.MODULE$.middle())));
        ((IterableLike)towards.drop(1)).foreach((Function1 & Serializable & scala.Serializable)to -> {
            MicroPathing$.$anonfun$pullTowards$2(distanceLeft, output, to);
            return BoxedUnit.UNIT;
        });
        return (Pixel)output.elem;
    }

    private static final /* synthetic */ Option hillPath$lzycompute$1(LazyRef hillPath$lzy$1, Pixel from$2, Pixel goal$2) {
        synchronized (hillPath$lzy$1) {
            Option option = hillPath$lzy$1.initialized() ? (Option)hillPath$lzy$1.value() : (Option)hillPath$lzy$1.initialize(DownhillPathfinder$.MODULE$.decend(from$2.tile(), goal$2.tile()));
            return option;
        }
    }

    private static final Option hillPath$1(LazyRef hillPath$lzy$1, Pixel from$2, Pixel goal$2) {
        if (hillPath$lzy$1.initialized()) {
            return (Option)hillPath$lzy$1.value();
        }
        return MicroPathing$.hillPath$lzycompute$1(hillPath$lzy$1, from$2, goal$2);
    }

    private static final /* synthetic */ Option hillWaypoint$lzycompute$1(LazyRef hillWaypoint$lzy$1, Pixel from$2, LazyRef hillPath$lzy$1, Pixel goal$2) {
        synchronized (hillWaypoint$lzy$1) {
            Option option = hillWaypoint$lzy$1.initialized() ? (Option)hillWaypoint$lzy$1.value() : (Option)hillWaypoint$lzy$1.initialize((Object)MicroPathing$.hillPath$1(hillPath$lzy$1, from$2, goal$2).map((Function1 & Serializable & scala.Serializable)path -> ((Tile)path.last()).center().add(from$2.offsetFromTileCenter())));
            return option;
        }
    }

    private static final Option hillWaypoint$1(LazyRef hillWaypoint$lzy$1, Pixel from$2, LazyRef hillPath$lzy$1, Pixel goal$2) {
        if (hillWaypoint$lzy$1.initialized()) {
            return (Option)hillWaypoint$lzy$1.value();
        }
        return MicroPathing$.hillWaypoint$lzycompute$1(hillWaypoint$lzy$1, from$2, hillPath$lzy$1, goal$2);
    }

    private static final /* synthetic */ Option unacceptableDistance$lzycompute$1(LazyRef unacceptableDistance$lzy$1, Option mustApproach$1, FriendlyUnitInfo unit$7) {
        synchronized (unacceptableDistance$lzy$1) {
            Option option = unacceptableDistance$lzy$1.initialized() ? (Option)unacceptableDistance$lzy$1.value() : (Option)unacceptableDistance$lzy$1.initialize((Object)mustApproach$1.map((Function1 & Serializable & scala.Serializable)to -> BoxesRunTime.boxToDouble((double)unit$7.pixelDistanceTravelling(to))));
            return option;
        }
    }

    private static final Option unacceptableDistance$1(LazyRef unacceptableDistance$lzy$1, Option mustApproach$1, FriendlyUnitInfo unit$7) {
        if (unacceptableDistance$lzy$1.initialized()) {
            return (Option)unacceptableDistance$lzy$1.value();
        }
        return MicroPathing$.unacceptableDistance$lzycompute$1(unacceptableDistance$lzy$1, mustApproach$1, unit$7);
    }

    private static final boolean acceptableForSafety$1(Pixel pixel, boolean requireSafety$1, FriendlyUnitInfo unit$7) {
        return !requireSafety$1 || pixel.tile().enemyRangeAgainst(unit$7) < Math.max(1, unit$7.tile().enemyRangeAgainst(unit$7));
    }

    public static final /* synthetic */ boolean $anonfun$getWaypointInDirection$2(FriendlyUnitInfo unit$7, boolean requireSafety$1, Pixel a) {
        return unit$7.pixelDistanceCenter(a) < (double)MODULE$.waypointDistancePixels() && MicroPathing$.acceptableForSafety$1(a, requireSafety$1, unit$7);
    }

    public static final /* synthetic */ boolean $anonfun$getWaypointInDirection$4(FriendlyUnitInfo unit$7, Option mustApproach$1, LazyRef unacceptableDistance$lzy$1, boolean requireSafety$1, Pixel p) {
        Pixel clamped = p.clamp(unit$7.unitClass().dimensionMax() / 2);
        return unit$7.pixelDistanceCenter(clamped) >= (double)80 && MicroPathing$.unacceptableDistance$1(unacceptableDistance$lzy$1, mustApproach$1, unit$7).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$7 -> x$7 > clamped.travelPixelsFor((Pixel)mustApproach$1.get(), (UnitInfo)unit$7)) && MicroPathing$.acceptableForSafety$1(unit$7.pixel().project(clamped, 80.0), requireSafety$1, unit$7);
    }

    public static final /* synthetic */ void $anonfun$tryMovingAlongTilePath$2(FriendlyUnitInfo unit$8, Pixel waypoint) {
        unit$8.agent().decision().set(waypoint);
        Commander$.MODULE$.move(unit$8);
    }

    public static final /* synthetic */ boolean $anonfun$getPushForces$3(Force x$11) {
        return x$11.lengthSquared() > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$getPushForces$2(Tuple2 x$10) {
        return ((Option)x$10._2()).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MicroPathing$.$anonfun$getPushForces$3(x$11)));
    }

    public static final /* synthetic */ void $anonfun$castRay$1(BooleanRef proceed$1, boolean flying$1, ObjectRef output$1, Pixel pixel) {
        proceed$1.elem = proceed$1.elem && pixel.valid();
        boolean bl = proceed$1.elem = proceed$1.elem && (flying$1 || pixel.walkableUnchecked());
        if (proceed$1.elem) {
            output$1.elem = pixel;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$pullTowards$2(DoubleRef distanceLeft$1, ObjectRef output$2, Pixel to) {
        if (distanceLeft$1.elem > 0.0) {
            double distanceTo = Math.min(distanceLeft$1.elem, ((Pixel)output$2.elem).pixelDistance(to));
            output$2.elem = ((Pixel)output$2.elem).project(to, distanceTo);
            distanceLeft$1.elem -= distanceTo;
            return;
        }
    }

    private MicroPathing$() {
        MODULE$ = this;
        this.waypointDistanceTiles = 4;
        this.waypointDistancePixels = 32 * this.waypointDistanceTiles();
        this.ringDistance = this.waypointDistanceTiles() * this.waypointDistanceTiles() * 32 * 32;
        this.rayRadians32 = this.rayRadiansN(32);
        this.rayRadians16 = this.rayRadiansN(16);
        this.rayRadians12 = this.rayRadiansN(12);
    }
}

