/*
 * Decompiled with CFR 0.152.
 */
package Information.Geography.Calculations;

import Debugging.Logger;
import Lifecycle.With$;
import Mathematics.Cluster$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Point;
import Mathematics.Points.Tile;
import Mathematics.Points.TileRectangle;
import Mathematics.Shapes.Circle$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.UnitInfo.ForeignUnitInfo;
import Strategery.Hunters$;
import bwapi.TilePosition;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FindBases$ {
    public static FindBases$ MODULE$;
    private final double baseRadiusPixels;
    private final double baseMergingRadiusPixels;

    static {
        new FindBases$();
    }

    public double baseRadiusPixels() {
        return this.baseRadiusPixels;
    }

    public double baseMergingRadiusPixels() {
        return this.baseMergingRadiusPixels;
    }

    public Iterable<Tile> apply() {
        Tile[] startTiles = (Tile[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(With$.MODULE$.game().getStartLocations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> new Tile((TilePosition)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tile.class));
        Pixel[] startPixels = (Pixel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])startTiles)).map((Function1 & Serializable & scala.Serializable)x$2 -> Protoss$.MODULE$.Nexus().tileArea().add((Tile)x$2).center(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Pixel.class)));
        Iterable expoResources = (Iterable)((Iterable)((Iterable)With$.MODULE$.units().neutral().filter((Function1 & Serializable & scala.Serializable)unit -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$apply$3(unit)))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isBlocker()))).filterNot((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$apply$5(startPixels, r)));
        Iterable<Iterable<ForeignUnitInfo>> clusters = this.clusterResourcePatches((Iterable<ForeignUnitInfo>)expoResources);
        Set<Tile> exclusions = this.measureExclusions((Iterable<ForeignUnitInfo>)expoResources);
        Iterable expansions = (Iterable)clusters.flatMap((Function1 & Serializable & scala.Serializable)cluster -> Option$.MODULE$.option2Iterable(MODULE$.bestTownHallTile((Iterable<ForeignUnitInfo>)cluster, exclusions)), Iterable$.MODULE$.canBuildFrom());
        Iterable<Tile> output = this.mergeBases((Iterable<Tile>)((Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])startTiles)).$plus$plus((GenTraversableOnce)expansions, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        if (output.size() <= With$.MODULE$.geography().startLocations().size()) {
            With$.MODULE$.logger().warn(new StringBuilder(25).append("Only found ").append(output.size()).append(" bases (frame").append(With$.MODULE$.frame()).append(")").toString());
            With$.MODULE$.logger().warn(new StringBuilder(24).append("Total minerals visible: ").append(With$.MODULE$.units().neutral().count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$apply$8(x$5)))).toString());
            With$.MODULE$.logger().warn(new StringBuilder(19).append("Total gas visible: ").append(With$.MODULE$.units().neutral().count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$apply$9(x$6)))).toString());
            With$.MODULE$.logger().warn(new StringBuilder(21).append("Enemy units visible: ").append(With$.MODULE$.units().enemy().size()).toString());
            With$.MODULE$.logger().warn("Neutral units visible: ");
            ((IterableLike)With$.MODULE$.units().neutral().view().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), IterableView$.MODULE$.canBuildFrom())).foreach(arg_0 -> FindBases$.$anonfun$apply$11$adapted(With$.MODULE$.logger(), arg_0));
            With$.MODULE$.logger().warn(new StringBuilder(20).append("Static units known: ").append(With$.MODULE$.game().getStaticNeutralUnits().size()).toString());
        }
        return output;
    }

    private Iterable<Iterable<ForeignUnitInfo>> clusterResourcePatches(Iterable<ForeignUnitInfo> resources) {
        boolean shouldLimitRegion = !Hunters$.MODULE$.apply();
        return Cluster$.MODULE$.apply(resources, this.baseRadiusPixels(), shouldLimitRegion, (Function1 & Serializable & scala.Serializable)x$8 -> x$8.pixel()).values();
    }

    private Set<Tile> measureExclusions(Iterable<ForeignUnitInfo> expansionResources) {
        return ((TraversableOnce)expansionResources.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.tileArea().expand(3, 3).tiles(), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Option<Tile> bestTownHallTile(Iterable<ForeignUnitInfo> resources, Set<Tile> exclusions) {
        Tile centroid = Maff$.MODULE$.centroid((TraversableOnce<Pixel>)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.pixel(), Iterable$.MODULE$.canBuildFrom()))).tile();
        int altitude = With$.MODULE$.game().getGroundHeight(centroid.bwapi());
        int searchRadius = 10;
        Seq candidates = (Seq)((TraversableLike)Circle$.MODULE$.apply(searchRadius).map((Function1 & Serializable & scala.Serializable)point -> centroid.add((Point)point), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FindBases$.MODULE$.isLegalTownHallTile(x$11, (Set<Tile>)exclusions, altitude)));
        if (candidates.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(candidates.minBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)FindBases$.MODULE$.cost(x$12, (Iterable<ForeignUnitInfo>)resources)), (Ordering)Ordering.Double$.MODULE$));
    }

    private double cost(Tile tile, Iterable<ForeignUnitInfo> resources) {
        Pixel[] corners = Protoss$.MODULE$.Nexus().tileArea().add(tile).cornerPixels();
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corners)).map((Function1 & Serializable & scala.Serializable)corner -> BoxesRunTime.boxToDouble((double)FindBases$.$anonfun$cost$1(resources, corner)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).min((Ordering)Ordering.Double$.MODULE$));
    }

    private boolean isLegalTownHallTile(Tile candidate, Set<Tile> exclusions, int altitude) {
        if (!candidate.valid()) {
            return false;
        }
        return Protoss$.MODULE$.Nexus().tileArea().add(candidate).tiles().forall((Function1 & Serializable & scala.Serializable)tile -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$isLegalTownHallTile$1(exclusions, altitude, tile)));
    }

    private Iterable<Tile> mergeBases(Iterable<Tile> bases) {
        Iterable baseAreas = (Iterable)bases.map((Function1 & Serializable & scala.Serializable)Tile2 -> Protoss$.MODULE$.Nexus().tileArea().add((Tile)Tile2), Iterable$.MODULE$.canBuildFrom());
        HashSet basesLeft = (HashSet)new HashSet().$plus$plus((GenTraversableOnce)baseAreas);
        ArrayBuffer output = new ArrayBuffer();
        baseAreas.foreach((Function1 & Serializable & scala.Serializable)base -> {
            if (basesLeft.contains(base)) {
                basesLeft.remove(base);
                output.$plus$eq((Object)base.startInclusive());
                HashSet conflicts = (HashSet)basesLeft.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$mergeBases$3(base, x$13)));
                return basesLeft.$minus$minus$eq((TraversableOnce)conflicts);
            }
            return BoxedUnit.UNIT;
        });
        return output;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(ForeignUnitInfo unit) {
        return unit.unitClass().isGas() || unit.unitClass().isMinerals();
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(ForeignUnitInfo r$1, Pixel x$4) {
        return x$4.pixelDistance(r$1.pixel()) <= MODULE$.baseRadiusPixels();
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Pixel[] startPixels$1, ForeignUnitInfo r) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])startPixels$1)).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FindBases$.$anonfun$apply$6(r, x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$8(ForeignUnitInfo x$5) {
        return x$5.unitClass().isMinerals();
    }

    public static final /* synthetic */ boolean $anonfun$apply$9(ForeignUnitInfo x$6) {
        return x$6.unitClass().isGas();
    }

    public static final /* synthetic */ double $anonfun$cost$2(Pixel corner$1, ForeignUnitInfo resource) {
        return (double)(2 * resource.gasLeft() + resource.mineralsLeft()) * resource.pixelDistanceSquared(corner$1);
    }

    public static final /* synthetic */ double $anonfun$cost$1(Iterable resources$2, Pixel corner) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)resources$2.map((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToDouble((double)FindBases$.$anonfun$cost$2(corner, resource)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$isLegalTownHallTile$1(Set exclusions$3, int altitude$2, Tile tile) {
        return !exclusions$3.contains((Object)tile) && With$.MODULE$.game().isBuildable(tile.bwapi()) && With$.MODULE$.game().getGroundHeight(tile.bwapi()) == altitude$2;
    }

    public static final /* synthetic */ boolean $anonfun$mergeBases$3(TileRectangle base$1, TileRectangle x$13) {
        return x$13.center().pixelDistance(base$1.center()) < MODULE$.baseMergingRadiusPixels();
    }

    private FindBases$() {
        MODULE$ = this;
        this.baseRadiusPixels = 480.0;
        this.baseMergingRadiusPixels = 384.0;
    }

    public static final /* synthetic */ Object $anonfun$apply$11$adapted(Logger eta$0$1$1, String message) {
        eta$0$1$1.warn(message);
        return BoxedUnit.UNIT;
    }
}

