/*
 * Decompiled with CFR 0.152.
 */
package Information.Battles.Types;

import Debugging.Visualizations.Colors$;
import Information.Battles.Types.Battle;
import Information.Battles.Types.JudgmentModifier;
import Information.Battles.Types.JudgmentModifier$;
import Information.Geography.Types.Base;
import Information.Geography.Types.Edge;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import Micro.Actions.Basic.Gather$;
import ProxyBwapi.Players.PlayerInfo;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.$qmark$;
import Utilities.SomeIf$;
import Utilities.Time.Minutes;
import Utilities.UnitFilters.IsSpeedling$;
import Utilities.UnitFilters.IsTank$;
import Utilities.UnitFilters.IsWorker$;
import Utilities.UnitFilters.UnitFilter;
import bwapi.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyDouble;
import scala.runtime.java8.JFunction0;

public final class JudgmentModifiers$ {
    public static JudgmentModifiers$ MODULE$;

    static {
        new JudgmentModifiers$();
    }

    public Seq<JudgmentModifier> apply(Battle battle) {
        ArrayBuffer output = new ArrayBuffer();
        JudgmentModifiers$.add$1("Proximity", Colors$.MODULE$.NeonRed(), this.proximity(battle), output);
        JudgmentModifiers$.add$1("Gatherers", Colors$.MODULE$.MediumBlue(), this.gatherers(battle), output);
        JudgmentModifiers$.add$1("HiddenTanks", Colors$.MODULE$.MediumIndigo(), this.hiddenTanks(battle), output);
        JudgmentModifiers$.add$1("Hysteresis", Colors$.MODULE$.MediumViolet(), this.hysteresis(battle), output);
        JudgmentModifiers$.add$1("Choke", Colors$.MODULE$.MediumOrange(), this.choke(battle), output);
        JudgmentModifiers$.add$1("TankLock", Colors$.MODULE$.MediumRed(), this.tankLock(battle), output);
        JudgmentModifiers$.add$1("Caught", Colors$.MODULE$.BrightGreen(), this.caught(battle), output);
        return output;
    }

    public Option<JudgmentModifier> proximity(Battle battleLocal) {
        double enemyRange = battleLocal.enemy().meanAttackerRange();
        double deltaMin = -0.4 * Maff$.MODULE$.clamp((double)With$.MODULE$.frame() / (double)new Minutes(10).apply(), 0.5, 1.0);
        double deltaMax = 0.05;
        double proximityMult = With$.MODULE$.scouting().proximity(battleLocal.enemy().centroidGround()) * (double)2 - 1.0;
        double rangeMult = Maff$.MODULE$.clamp(enemyRange / 192.0, 0.0, 2.0);
        double targetDeltaRaw = -0.3 * proximityMult * rangeMult;
        double targetDelta = Maff$.MODULE$.clamp(targetDeltaRaw, deltaMin, deltaMax);
        String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
        double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
        return new Some((Object)new JudgmentModifier(x$2, x$3, x$4, targetDelta));
    }

    public Option<JudgmentModifier> gatherers(Battle battleLocal) {
        int workersImperiled = battleLocal.us().units().count((Function1 & Serializable & scala.Serializable)ally -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$gatherers$1(ally)));
        int workersTotal = With$.MODULE$.units().countOurs((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsWorker$.MODULE$}));
        double workersRatio = Maff$.MODULE$.nanToZero((double)workersImperiled / (double)workersTotal);
        return SomeIf$.MODULE$.apply(workersRatio > 0.0, (Function0 & Serializable & scala.Serializable)() -> {
            double x$1 = -workersRatio / 2.0;
            String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
            Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
            double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
            return new JudgmentModifier(x$2, x$3, x$4, x$1);
        });
    }

    public Option<JudgmentModifier> hiddenTanks(Battle battleLocal) {
        if (With$.MODULE$.enemies().forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$hiddenTanks$1(e)))) {
            return None$.MODULE$;
        }
        int tanks = battleLocal.enemy().units().count((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$hiddenTanks$2(u)));
        if (tanks == 0) {
            return None$.MODULE$;
        }
        double valueUs = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JudgmentModifiers$.ourCombatUnits$1(battleLocal).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.subjectiveValue()), SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double valueUsGround = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JudgmentModifiers$.ourCombatUnits$1(battleLocal).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.flying())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7.subjectiveValue()), SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double enemyBonus = Math.min(Maff$.MODULE$.nanToZero(valueUsGround / valueUs) * (double)tanks * 0.1, 0.4);
        return SomeIf$.MODULE$.apply(enemyBonus > 0.0, (Function0 & Serializable & scala.Serializable)() -> {
            double x$1 = 1.0 - enemyBonus;
            String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
            Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
            double x$4 = JudgmentModifier$.MODULE$.apply$default$4();
            return new JudgmentModifier(x$2, x$3, x$1, x$4);
        });
    }

    private double commitmentFloor(double value) {
        if (value > 0.0) {
            return Math.max(0.25, value);
        }
        return value;
    }

    public Option<JudgmentModifier> hysteresis(Battle battleLocal) {
        LazyDouble enemyAttackers$lzy = new LazyDouble();
        LazyDouble hesitanceVisibility$lzy = new LazyDouble();
        LazyDouble hesitanceTanks$lzy = new LazyDouble();
        double commitmentRaw = Maff$.MODULE$.mean((TraversableOnce<Object>)((TraversableOnce)battleLocal.us().attackers().map((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToDouble((double)Maff$.MODULE$.clamp(JudgmentModifiers$.MODULE$.commitmentFloor(((double)8 + u.matchups().pixelsEntangled()) / 96.0), 0.0, 1.0)), Seq$.MODULE$.canBuildFrom())));
        double commitment = this.commitmentFloor(commitmentRaw);
        double x$1 = BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(commitment > 0.0, (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> -commitment * 0.2, (JFunction0.mcD.sp & Serializable & scala.Serializable)() -> JudgmentModifiers$.hesitanceVisibility$1(hesitanceVisibility$lzy, battleLocal, enemyAttackers$lzy) + JudgmentModifiers$.hesitanceTanks$1(hesitanceTanks$lzy, battleLocal, enemyAttackers$lzy)));
        String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
        double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
        return new Some((Object)new JudgmentModifier(x$2, x$3, x$4, x$1));
    }

    public Option<JudgmentModifier> choke(Battle battleLocal) {
        Pixel pUs = battleLocal.us().attackCentroidGround();
        Pixel pFoe = battleLocal.enemy().vanguardGround().apply();
        Option<Edge> edge = battleLocal.choke();
        if (edge.isEmpty()) {
            return None$.MODULE$;
        }
        if (pFoe.zone().bases().exists(arg_0 -> JudgmentModifiers$.$anonfun$choke$1$adapted(With$.MODULE$.geography().ourBasesAndSettlements(), arg_0))) {
            return None$.MODULE$;
        }
        if (pFoe.pixelDistance(((Edge)edge.get()).pixelCenter()) + ((Edge)edge.get()).radiusPixels() < battleLocal.us().maxRangeGround()) {
            return None$.MODULE$;
        }
        double badness = ((Edge)edge.get()).badness(battleLocal.us(), pUs.zone());
        if (badness <= 1.0) {
            return None$.MODULE$;
        }
        double speedMod = battleLocal.us().combatGroundFraction() * Maff$.MODULE$.nanToOne(1.0 / badness);
        double deltaMod = battleLocal.us().combatGroundFraction() * Maff$.MODULE$.clamp((badness - 1.0) * 0.0175, 0.0, 0.3);
        String x$3 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$4 = JudgmentModifier$.MODULE$.apply$default$2();
        return new Some((Object)new JudgmentModifier(x$3, x$4, speedMod, deltaMod));
    }

    public Option<JudgmentModifier> tankLock(Battle battleLocal) {
        double tankInRangeScore;
        if (!With$.MODULE$.enemies().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isTerran()))) {
            return None$.MODULE$;
        }
        if (!battleLocal.enemy().units().exists((Function1)Terran$.MODULE$.SiegeTankSieged())) {
            return None$.MODULE$;
        }
        int attackers = battleLocal.us().attackers().size();
        int inTankRange = battleLocal.us().attackers().count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$tankLock$2(x$10)));
        int tankInRange = battleLocal.us().attackers().count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$tankLock$3(x$11)));
        double inRankRangeScore = 0.3333333333333333 * (double)inTankRange / (double)Math.max(1, attackers);
        double score = 0.5 * (inRankRangeScore + (tankInRangeScore = 0.6666666666666666 * (double)tankInRange / (double)Math.max(1, attackers)));
        return (Option)$qmark$.MODULE$.apply(score <= 0.0, (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
            Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
            double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
            return new Some((Object)new JudgmentModifier(x$2, x$3, x$4, score));
        });
    }

    public Option<JudgmentModifier> caught(Battle battleLocal) {
        int allies;
        int caught;
        int enemies;
        int catchers = battleLocal.enemy().units().count((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)u.isAny((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsSpeedling$.MODULE$, Terran$.MODULE$.Vulture()}))));
        double score = Maff$.MODULE$.nanToZero((double)catchers / (double)(enemies = battleLocal.enemy().units().length()) * (double)(caught = battleLocal.us().units().count((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$caught$2(u)))) / (double)(allies = battleLocal.us().units().length()));
        return (Option)$qmark$.MODULE$.apply(score <= 0.0, (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> {
            double x$1 = -score;
            String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
            Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
            double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
            return new Some((Object)new JudgmentModifier(x$2, x$3, x$4, x$1));
        });
    }

    private static final void add$1(String name, Color color, Option modifier, ArrayBuffer output$1) {
        modifier.foreach((Function1 & Serializable & scala.Serializable)m -> {
            m.name_$eq(name);
            m.color_$eq(color);
            return output$1.$plus$eq(m);
        });
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$4(Base x$2) {
        return x$2.owner().isUs();
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$5(UnitInfo g$1, UnitInfo ally$1, UnitInfo t) {
        return t.pixelDistanceEdge(g$1) - t.pixelRangeAgainst(ally$1) <= (double)Gather$.MODULE$.defenseRadiusPixels();
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$3(UnitInfo ally$1, UnitInfo g) {
        return g.base().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$gatherers$4(x$2))) && g.pixelDistanceEdge(ally$1) <= (double)Gather$.MODULE$.defenseRadiusPixels() && ally$1.matchups().threats().exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$gatherers$5(g, ally$1, t)));
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$2(UnitInfo ally$1, FriendlyUnitInfo x$1) {
        return x$1.agent().toGather().exists((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$gatherers$3(ally$1, g)));
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$1(UnitInfo ally) {
        return ally.unitClass().isWorker() && ally.visibleToOpponents() && ally.friendly().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$gatherers$2(ally, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$1(PlayerInfo e) {
        return !e.isTerran() || !e.hasTech(Terran$.MODULE$.SiegeMode());
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$3(Base x$3) {
        return x$3.owner().isEnemy();
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$2(UnitInfo u) {
        return IsTank$.MODULE$.apply(u) && u.base().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$hiddenTanks$3(x$3))) && !u.visible();
    }

    private static final SeqView ourCombatUnits$1(Battle battleLocal$1) {
        return (SeqView)battleLocal$1.us().units().view().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.canAttack()));
    }

    private static final /* synthetic */ double enemyAttackers$lzycompute$1(LazyDouble enemyAttackers$lzy$1, Battle battleLocal$2) {
        synchronized (enemyAttackers$lzy$1) {
            double d = enemyAttackers$lzy$1.initialized() ? enemyAttackers$lzy$1.value() : enemyAttackers$lzy$1.initialize((double)battleLocal$2.enemy().attackers().size());
            return d;
        }
    }

    private static final double enemyAttackers$1(LazyDouble enemyAttackers$lzy$1, Battle battleLocal$2) {
        if (enemyAttackers$lzy$1.initialized()) {
            return enemyAttackers$lzy$1.value();
        }
        return JudgmentModifiers$.enemyAttackers$lzycompute$1(enemyAttackers$lzy$1, battleLocal$2);
    }

    public static final /* synthetic */ boolean $anonfun$hysteresis$2(UnitInfo x$8) {
        return !x$8.visible();
    }

    private static final /* synthetic */ double hesitanceVisibility$lzycompute$1(LazyDouble hesitanceVisibility$lzy$1, Battle battleLocal$2, LazyDouble enemyAttackers$lzy$1) {
        synchronized (hesitanceVisibility$lzy$1) {
            double d = hesitanceVisibility$lzy$1.initialized() ? hesitanceVisibility$lzy$1.value() : hesitanceVisibility$lzy$1.initialize(0.08 / Math.max(1.0, JudgmentModifiers$.enemyAttackers$1(enemyAttackers$lzy$1, battleLocal$2)) * (double)battleLocal$2.enemy().attackers().count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$hysteresis$2(x$8))));
            return d;
        }
    }

    private static final double hesitanceVisibility$1(LazyDouble hesitanceVisibility$lzy$1, Battle battleLocal$2, LazyDouble enemyAttackers$lzy$1) {
        if (hesitanceVisibility$lzy$1.initialized()) {
            return hesitanceVisibility$lzy$1.value();
        }
        return JudgmentModifiers$.hesitanceVisibility$lzycompute$1(hesitanceVisibility$lzy$1, battleLocal$2, enemyAttackers$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$hysteresis$3(UnitInfo t) {
        return Terran$.MODULE$.SiegeTankSieged().apply(t) || Terran$.MODULE$.SiegeTankUnsieged().apply(t) && With$.MODULE$.framesSince(t.lastSeen()) > 24;
    }

    private static final /* synthetic */ double hesitanceTanks$lzycompute$1(LazyDouble hesitanceTanks$lzy$1, Battle battleLocal$2, LazyDouble enemyAttackers$lzy$1) {
        synchronized (hesitanceTanks$lzy$1) {
            double d = hesitanceTanks$lzy$1.initialized() ? hesitanceTanks$lzy$1.value() : hesitanceTanks$lzy$1.initialize(0.12 / Math.max(1.0, JudgmentModifiers$.enemyAttackers$1(enemyAttackers$lzy$1, battleLocal$2)) * (double)battleLocal$2.enemy().attackers().count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$hysteresis$3(t))));
            return d;
        }
    }

    private static final double hesitanceTanks$1(LazyDouble hesitanceTanks$lzy$1, Battle battleLocal$2, LazyDouble enemyAttackers$lzy$1) {
        if (hesitanceTanks$lzy$1.initialized()) {
            return hesitanceTanks$lzy$1.value();
        }
        return JudgmentModifiers$.hesitanceTanks$lzycompute$1(hesitanceTanks$lzy$1, battleLocal$2, enemyAttackers$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$tankLock$2(UnitInfo x$10) {
        return x$10.matchups().inTankRange();
    }

    public static final /* synthetic */ boolean $anonfun$tankLock$3(UnitInfo x$11) {
        return x$11.matchups().targetsInRange().exists((Function1)Terran$.MODULE$.SiegeTankSieged());
    }

    public static final /* synthetic */ boolean $anonfun$caught$3(UnitInfo u$1, UnitInfo t) {
        return t.isAny((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsSpeedling$.MODULE$, Terran$.MODULE$.Vulture()})) && t.inRangeToAttack(u$1) && t.topSpeed() > u$1.topSpeed();
    }

    public static final /* synthetic */ boolean $anonfun$caught$2(UnitInfo u) {
        return u.matchups().threatDeepest().exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)JudgmentModifiers$.$anonfun$caught$3(u, t)));
    }

    private JudgmentModifiers$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$choke$1$adapted(Vector eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(elem));
    }
}

