/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Micro;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Viewport;
import Debugging.Visualizations.Views.DebugView;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ShowHealthAndCooldown$
extends DebugView {
    public static ShowHealthAndCooldown$ MODULE$;

    static {
        new ShowHealthAndCooldown$();
    }

    @Override
    public void renderMap() {
        With$.MODULE$.units().all().foreach((Function1 & java.io.Serializable & Serializable)unit -> {
            ShowHealthAndCooldown$.MODULE$.renderUnit(unit);
            return BoxedUnit.UNIT;
        });
    }

    public void renderUnit(UnitInfo unit) {
        int x$2;
        Pixel x$1;
        Viewport qual$1 = With$.MODULE$.viewport();
        if (!qual$1.contains(x$1 = unit.pixel(), x$2 = qual$1.contains$default$2())) {
            return;
        }
        if (!unit.visible()) {
            return;
        }
        if (unit.invincible()) {
            return;
        }
        if (unit.unitClass().maxTotalHealth() == 0) {
            return;
        }
        int width = Maff$.MODULE$.clamp(unit.unitClass().width(), 18, 48);
        int marginTopHp = 3;
        int denominator = unit.unitClass().maxTotalHealth() + width * 250 * Maff$.MODULE$.fromBoolean(unit.matrixPoints() > 0);
        int widthHpMax = width * unit.unitClass().maxHitPoints() / denominator;
        int widthShMax = width * unit.unitClass().maxShields() / denominator;
        int cfr_ignored_0 = width * 250 / denominator;
        Maff$.MODULE$.fromBoolean(unit.matrixPoints() > 0);
        int widthHpNow = width * unit.hitPoints() / denominator;
        int widthShNow = width * unit.shieldPoints() / denominator;
        int widthDmNow = width * unit.matrixPoints() / denominator;
        int widthEnergyNow = unit.energyMax() == 0 ? 0 : Math.min(width, width * unit.energy() / unit.energyMax());
        int widthCooldownButton = 3;
        int widthCooldownNow = (width - 2 * widthCooldownButton - 2) * Math.max(unit.cooldownLeft(), unit.cooldownSpell()) / Math.max(1, unit.cooldownMaxAirGround());
        int yStartHp = unit.pixel().y() + unit.unitClass().height() / 2 - marginTopHp;
        int yEndHp = yStartHp + 4;
        int yStartEnergy = yEndHp + 2;
        int yEndEnergy = yStartEnergy + 4;
        int yStartCooldown = unit.energyMax() > 0 ? yEndEnergy + 3 : yEndHp + 3;
        int yEndCooldown = yStartCooldown + 3;
        int xStart = unit.pixel().x() - width / 2;
        int xStartSh = xStart + widthHpMax;
        int xStartDm = xStartSh + widthShMax;
        Color colorHp = Colors$.MODULE$.NeonGreen();
        Color colorSh = Colors$.MODULE$.NeonBlue();
        Color colorDm = Colors$.MODULE$.NeonViolet();
        if (unit.totalHealth() != unit.unitClass().maxTotalHealth()) {
            DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartHp - 1), new Pixel(xStart + width + 2, yEndHp + 1), Color.Black, true);
            if (unit.matrixPoints() > 0) {
                DrawMap$.MODULE$.box(new Pixel(xStartDm, yStartHp), new Pixel(xStartDm + widthDmNow, yEndHp), colorDm, true);
            }
            if (unit.unitClass().maxShields() > 0) {
                DrawMap$.MODULE$.box(new Pixel(xStartSh, yStartHp), new Pixel(xStartSh + widthShNow, yEndHp), colorSh, true);
            }
            DrawMap$.MODULE$.box(new Pixel(xStart, yStartHp), new Pixel(xStart + widthHpNow, yEndHp), colorHp, true);
            int healthBarEvery = Math.max(3, width * 25 / (unit.unitClass().maxTotalHealth() + unit.matrixPoints()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).by(healthBarEvery).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)healthX -> {
                int x = xStart + healthX - 1;
                DrawMap$.MODULE$.line(new Pixel(x, yStartHp), new Pixel(x, yEndHp), Color.Black);
            });
        }
        if (unit.energyMax() > 0) {
            DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartEnergy - 1), new Pixel(xStart + width + 2, yEndEnergy + 1), Color.Black, true);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(25), unit.energyMax()).by(25).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)energy -> {
                int x = xStart + width * energy / unit.energyMax();
                DrawMap$.MODULE$.line(new Pixel(x, yStartEnergy), new Pixel(x, yEndEnergy), Color.Black);
            });
            DrawMap$.MODULE$.box(new Pixel(xStart, yStartEnergy), new Pixel(xStart + widthEnergyNow, yEndEnergy), Colors$.MODULE$.BrightTeal(), true);
        }
        if (unit.complete() && widthCooldownNow > 0) {
            DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartCooldown - 1), new Pixel(xStart + width + 2, yEndCooldown + 1), Color.Black, true);
            if (unit.cooldownLeft() > 0) {
                DrawMap$.MODULE$.box(new Pixel(xStart, yStartCooldown), new Pixel(xStart + widthCooldownNow, yEndCooldown), unit.teamColor(), true);
                return;
            }
            return;
        }
    }

    private ShowHealthAndCooldown$() {
        MODULE$ = this;
    }
}

