/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Battles;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Rendering.DrawScreen;
import Debugging.Visualizations.Rendering.DrawScreen$;
import Debugging.Visualizations.Views.DebugView;
import Information.Battles.Prediction.Simulation.ReportCard;
import Information.Battles.Prediction.Simulation.Simulacrum;
import Information.Battles.Prediction.Simulation.SimulationEvent;
import Information.Battles.Prediction.SimulationCheckpoint;
import Information.Battles.Types.Battle;
import Information.Battles.Types.BattleJudgment;
import Information.Battles.Types.EnemyTeam;
import Information.Battles.Types.FriendlyTeam;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import ProxyBwapi.UnitClasses.UnitClass;
import ProxyBwapi.UnitInfo.CombatUnit;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;

public final class ShowBattles$
extends DebugView {
    public static ShowBattles$ MODULE$;

    static {
        new ShowBattles$();
    }

    @Override
    public void renderScreen() {
        this.localBattle().foreach((Function1 & Serializable & scala.Serializable)battle -> {
            ShowBattles$.MODULE$.renderBattleScreen(battle);
            return BoxedUnit.UNIT;
        });
        if (With$.MODULE$.yolo().active() && With$.MODULE$.frame() / 24 % 2 == 0) {
            DrawScreen$.MODULE$.column(610, 230, "YOLO");
            return;
        }
    }

    @Override
    public void renderMap() {
        this.localBattle().foreach((Function1 & Serializable & scala.Serializable)battle -> {
            ShowBattles$.MODULE$.renderBattleMap(battle);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Battle> localBattle() {
        Vector<Battle> battlesSelected = (Vector<Battle>)((TraversableLike)With$.MODULE$.units().ours().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.selected()))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(x$2.battle()), Iterable$.MODULE$.canBuildFrom());
        Vector<Battle> battlesToShow = battlesSelected.isEmpty() ? With$.MODULE$.battles().local() : battlesSelected;
        return Maff$.MODULE$.minBy(battlesToShow, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ShowBattles$.$anonfun$localBattle$3(x$3)), Ordering.Int$.MODULE$);
    }

    public String format(double value) {
        return new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value)}));
    }

    public String describeTeam(Iterable<UnitInfo> units) {
        return ((TraversableOnce)((TraversableLike)units.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.unitClass()).toVector().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ShowBattles$.$anonfun$describeTeam$2(x$5)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)p -> {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)((TraversableOnce)p._2()).size());
            Object arg$macro$2 = new StringOps(Predef$.MODULE$.augmentString(((UnitClass)p._1()).toString())).take(4);
            return new StringOps("%s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
        }, Vector$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public void renderSkimulationScreen(Battle battle) {
        int x = 5;
        FriendlyTeam us = battle.us();
        EnemyTeam enemy = battle.enemy();
        BattleJudgment judge = (BattleJudgment)battle.judgement().get();
        DrawScreen$.MODULE$.table(x, 17 * With$.MODULE$.visualization().lineHeightSmall(), (Iterable<Iterable<String>>)((Iterable)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Us", "Enemy", "Score", "Target", "Fight?"})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total", this.format(us.skimStrengthTotal()), this.format(enemy.skimStrengthTotal()), this.format(judge.scoreTotal()), this.format(judge.scoreTarget()), judge.shouldFight() ? "YES" : ""})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ground", this.format(us.skimStrengthGround()), new StringOps(Predef$.MODULE$.augmentString(this.format(enemy.skimStrengthGround()))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)judge.scoreGround())})), this.format(judge.scoreTarget()), judge.shouldFightGround() ? "YES" : ""})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Air", this.format(us.skimStrengthAir()), new StringOps(Predef$.MODULE$.augmentString(this.format(enemy.skimStrengthAir()))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)judge.scoreAir())})), this.format(judge.scoreTarget()), judge.shouldFightAir() ? "YES" : ""})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vs Ground", this.format(us.skimStrengthVsGround()), this.format(enemy.skimStrengthVsGround())})), (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vs Air", this.format(us.skimStrengthVsAir()), this.format(enemy.skimStrengthVsAir())}))}))));
    }

    public void renderSimulationScreen(Battle battle) {
        int x = 5;
        battle.simulationCheckpoints().lastOption().foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            ShowBattles$.$anonfun$renderSimulationScreen$1(x, battle, metrics);
            return BoxedUnit.UNIT;
        });
        int graphWidth = 82;
        Pixel x$1 = new Pixel(1, 226);
        String x$2 = "Score";
        .colon.colon x$3 = new .colon.colon((Object)new DrawScreen.GraphCurve(Color.Black, (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)unused -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderSimulationScreen$10(unused)), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new DrawScreen.GraphCurve(Color.Black, (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)unused -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderSimulationScreen$11(unused)), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new DrawScreen.GraphCurve(Color.Black, (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)unused -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderSimulationScreen$12(unused)), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new DrawScreen.GraphCurve(Colors$.MODULE$.MediumRed(), (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)unused -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderSimulationScreen$13(battle, unused)), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new DrawScreen.GraphCurve(Colors$.MODULE$.BrightOrange(), (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)unused -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderSimulationScreen$14(battle, unused)), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)new .colon.colon((Object)new DrawScreen.GraphCurve(Color.Yellow, (IndexedSeq<Object>)((IndexedSeq)battle.simulationCheckpoints().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14.totalScore()), ArrayBuffer$.MODULE$.canBuildFrom()))), (List)Nil$.MODULE$))))));
        Some x$4 = new Some((Object)BoxesRunTime.boxToDouble((double)-1.0));
        Some x$5 = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
        Option<Object> x$8 = DrawScreen$.MODULE$.graph$default$6();
        Color x$9 = DrawScreen$.MODULE$.graph$default$7();
        Color x$10 = DrawScreen$.MODULE$.graph$default$8();
        int x$11 = DrawScreen$.MODULE$.graph$default$11();
        DrawScreen$.MODULE$.graph(x$1, x$2, (Seq<DrawScreen.GraphCurve>)x$3, (Option<Object>)x$4, (Option<Object>)x$5, x$8, x$9, x$10, graphWidth, graphWidth, x$11);
    }

    public void renderBattleScreen(Battle battle) {
        int skimBarWidth = 80;
        int skimBarX0 = (640 - skimBarWidth) / 2;
        int skimBarX2 = (640 + skimBarWidth) / 2;
        int skimBarX1 = skimBarX0 + Maff$.MODULE$.clamp((int)((double)skimBarWidth * battle.skimWeight()), 1, skimBarWidth - 1);
        int skimBarY0 = 340;
        int skimBarY1 = skimBarY0 + 12;
        With$.MODULE$.game().drawBoxScreen(skimBarX0, skimBarY0, skimBarX1, skimBarY1, Color.Black, true);
        With$.MODULE$.game().drawBoxScreen(skimBarX1, skimBarY0, skimBarX2, skimBarY1, Color.White, true);
        DrawScreen$.MODULE$.text(skimBarX0 - 19, skimBarY0 + 1, "Skim");
        DrawScreen$.MODULE$.text(skimBarX2 + 1, skimBarY0 + 1, "Sim");
        if (battle.skimulated()) {
            this.renderSkimulationScreen(battle);
        }
        if (battle.simulated()) {
            this.renderSimulationScreen(battle);
            return;
        }
    }

    public void renderSkimulationMap(Battle battle) {
        battle.units().foreach((Function1 & Serializable & scala.Serializable)u -> {
            DrawMap$.MODULE$.labelDot((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ShowBattles$.MODULE$.format(u.skimStrengthDisplay()), u.pixel(), Colors$.MODULE$.hsv(u.player().hue(), 255, Maff$.MODULE$.clamp(64 + (int)((double)128 * u.skimPresence()), 64, 192)));
            return BoxedUnit.UNIT;
        });
    }

    public void renderBattleMap(Battle battle) {
        if (battle.skimulated()) {
            this.renderSkimulationMap(battle);
        }
        if (!battle.simulated()) {
            return;
        }
        boolean shouldFight = ((BattleJudgment)battle.judgement().get()).shouldFight();
        ((IterableLike)battle.units().view().filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderBattleMap$1(x$15)))).foreach((Function1 & Serializable & scala.Serializable)unit -> {
            ShowBattles$.$anonfun$renderBattleMap$2(shouldFight, unit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$localBattle$3(Battle x$3) {
        return x$3.focus().pixelDistanceSquared(With$.MODULE$.viewport().center());
    }

    public static final /* synthetic */ int $anonfun$describeTeam$2(Tuple2 x$5) {
        return -((TraversableOnce)x$5._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$2(Tuple2 x$6) {
        return ((CombatUnit)x$6._1()).isFriendly();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$3(Tuple2 x$7) {
        return ((ReportCard)x$7._2()).alive();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$4(Tuple2 x$8) {
        return ((CombatUnit)x$8._1()).isEnemy();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$5(Tuple2 x$9) {
        return ((ReportCard)x$9._2()).alive();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$6(Tuple2 x$10) {
        return ((CombatUnit)x$10._1()).isFriendly();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$7(Tuple2 x$11) {
        return ((ReportCard)x$11._2()).alive();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$8(Tuple2 x$12) {
        return ((CombatUnit)x$12._1()).isEnemy();
    }

    public static final /* synthetic */ boolean $anonfun$renderSimulationScreen$9(Tuple2 x$13) {
        return ((ReportCard)x$13._2()).alive();
    }

    public static final /* synthetic */ void $anonfun$renderSimulationScreen$1(int x$17, Battle battle$1, SimulationCheckpoint metrics) {
        Vector[] vectorArray = new Vector[9];
        vectorArray[0] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Score", MODULE$.format(((BattleJudgment)battle$1.judgement().get()).scoreTotal()), "Our survivors:", MODULE$.describeTeam((Iterable<UnitInfo>)((MapLike)((TraversableLike)battle$1.simulationReport().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$2(x$6)))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$3(x$7)))).keys())}));
        vectorArray[1] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target", MODULE$.format(((BattleJudgment)battle$1.judgement().get()).scoreTarget()), "Foe survivors:", MODULE$.describeTeam((Iterable<UnitInfo>)((MapLike)((TraversableLike)battle$1.simulationReport().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$4(x$8)))).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$5(x$9)))).keys())}));
        vectorArray[2] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LVLR", MODULE$.format(metrics.valueLostRatio())}));
        vectorArray[3] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LHLR", MODULE$.format(metrics.healthLostRatio()), "Our deaths:", MODULE$.describeTeam((Iterable<UnitInfo>)((MapLike)battle$1.simulationReport().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$6(x$10)))).filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$7(x$11))).keys())}));
        vectorArray[4] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LHVLR", MODULE$.format(metrics.healthValueLostRatio()), "Foe deaths:", MODULE$.describeTeam((Iterable<UnitInfo>)((MapLike)battle$1.simulationReport().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$8(x$12)))).filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ShowBattles$.$anonfun$renderSimulationScreen$9(x$13))).keys())}));
        vectorArray[5] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RLVLN", MODULE$.format(metrics.ratioValueLostNet())}));
        String[] stringArray = new String[3];
        stringArray[0] = "RLHLN";
        stringArray[1] = MODULE$.format(metrics.ratioHealthLostNet());
        Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)(metrics.framesIn() / 24));
        stringArray[2] = new StringOps("%s second duration").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
        vectorArray[6] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
        String[] stringArray2 = new String[3];
        stringArray2[0] = "RLHVLN";
        stringArray2[1] = MODULE$.format(metrics.ratioHealthValueLostNet());
        Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)battle$1.simulationCheckpoints().size());
        stringArray2[2] = new StringOps("%s metrics checkpoints").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2}));
        vectorArray[7] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray2));
        vectorArray[8] = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Confidence", MODULE$.format(((BattleJudgment)battle$1.judgement().get()).confidence11Total())}));
        DrawScreen$.MODULE$.table(x$17, 4 * With$.MODULE$.visualization().lineHeightSmall(), (Iterable<Iterable<String>>)((Iterable)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])vectorArray))));
    }

    public static final /* synthetic */ double $anonfun$renderSimulationScreen$10(SimulationCheckpoint unused) {
        return 1.0;
    }

    public static final /* synthetic */ double $anonfun$renderSimulationScreen$11(SimulationCheckpoint unused) {
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$renderSimulationScreen$12(SimulationCheckpoint unused) {
        return -1.0;
    }

    public static final /* synthetic */ double $anonfun$renderSimulationScreen$13(Battle battle$1, SimulationCheckpoint unused) {
        return ((BattleJudgment)battle$1.judgement().get()).scoreTarget();
    }

    public static final /* synthetic */ double $anonfun$renderSimulationScreen$14(Battle battle$1, SimulationCheckpoint unused) {
        return ((BattleJudgment)battle$1.judgement().get()).scoreTotal();
    }

    public static final /* synthetic */ boolean $anonfun$renderBattleMap$1(UnitInfo x$15) {
        return x$15.simulacrum().initialized();
    }

    public static final /* synthetic */ double $anonfun$renderBattleMap$3(SimulationEvent e) {
        return e.from().pixelDistance(e.to());
    }

    public static final /* synthetic */ void $anonfun$renderBattleMap$4(double distanceToTraverse$1, DoubleRef distanceTraveled$1, ObjectRef pixelAnimation$1, SimulationEvent event) {
        double distanceRemaining = distanceToTraverse$1 - distanceTraveled$1.elem;
        if (distanceRemaining > 0.0) {
            double distanceToTravel = Math.min(distanceRemaining, event.from().pixelDistance(event.to()));
            pixelAnimation$1.elem = event.from().project(event.to(), distanceToTravel);
            distanceTraveled$1.elem += distanceToTravel;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$renderBattleMap$2(boolean shouldFight$1, UnitInfo unit) {
        Simulacrum sim = unit.simulacrum();
        Color color = sim.player().isUs() == shouldFight$1 ? sim.player().colorNeon() : sim.player().colorDark();
        double distanceToTraverse = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)sim.events().view().map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)ShowBattles$.$anonfun$renderBattleMap$3(e)), IndexedSeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)(With$.MODULE$.frame() % 8);
        ObjectRef pixelAnimation = ObjectRef.create((Object)sim.realUnit().pixel());
        DoubleRef distanceTraveled = DoubleRef.create((double)0.0);
        sim.events().foreach((Function1 & Serializable & scala.Serializable)event -> {
            ShowBattles$.$anonfun$renderBattleMap$4(distanceToTraverse, distanceTraveled, pixelAnimation, event);
            return BoxedUnit.UNIT;
        });
        sim.events().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.draw();
            return BoxedUnit.UNIT;
        });
        Pixel x$1 = (Pixel)pixelAnimation.elem;
        int x$2 = 3;
        boolean x$3 = true;
        DrawMap$.MODULE$.circle(x$1, x$2, color, x$3);
        if (sim.dead()) {
            Color dark = sim.realUnit().player().colorMidnight();
            Color skullColor = sim.realUnit().player().colorBright();
            DrawMap$.MODULE$.box(sim.pixel().add(-3, 0), sim.pixel().add(4, 8), dark, false);
            DrawMap$.MODULE$.circle(sim.pixel(), 5, skullColor, true);
            DrawMap$.MODULE$.circle(sim.pixel(), 5, dark, false);
            DrawMap$.MODULE$.box(sim.pixel().add(-2, 1), sim.pixel().add(2, 7), skullColor, true);
            DrawMap$.MODULE$.box(sim.pixel().add(-2, -2), sim.pixel().add(0, 0), Color.Black, true);
            DrawMap$.MODULE$.box(sim.pixel().add(1, -2), sim.pixel().add(3, 0), Color.Black, true);
            DrawMap$.MODULE$.line(sim.pixel().add(-1, 3), sim.pixel().add(-2, 9), dark);
            DrawMap$.MODULE$.line(sim.pixel().add(1, 3), sim.pixel().add(2, 9), dark);
            return;
        }
    }

    private ShowBattles$() {
        MODULE$ = this;
    }
}

