/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Rendering;

import Debugging.Asciify$;
import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawScreen;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import bwapi.Color;
import bwapi.Text;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.IterableViewLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DrawScreen$ {
    public static DrawScreen$ MODULE$;

    static {
        new DrawScreen$();
    }

    public void text(int x, int y, String s) {
        With$.MODULE$.game().drawTextScreen(x, y, Asciify$.MODULE$.apply(s), new Text[0]);
    }

    public void text(Pixel pixel, String s) {
        this.text(pixel.x(), pixel.y(), s);
    }

    public void column(int x, int y, Iterable<String> s) {
        this.column(x, y, s.mkString("\n"));
    }

    public void column(int x, int y, String s) {
        this.text(x, y, s);
    }

    public void table(int x, int y, Iterable<Iterable<String>> cells) {
        ((IterableLike)cells.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)pair -> {
            DrawScreen$.MODULE$.tableRow(x, y, pair._2$mcI$sp(), (Iterable<String>)((Iterable)pair._1()));
            return BoxedUnit.UNIT;
        });
    }

    public void tableRow(int x, int y, int rowIndex, Iterable<String> row) {
        ((IterableLike)row.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)pair -> {
            DrawScreen$.MODULE$.text(x + pair._2$mcI$sp() * 60, y + rowIndex * 13, (String)pair._1());
            return BoxedUnit.UNIT;
        });
    }

    public Iterable<Iterable<String>> padTable(Iterable<Iterable<String>> rows) {
        int columns = BoxesRunTime.unboxToInt((Object)Maff$.MODULE$.max((TraversableOnce)rows.view().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), IterableView$.MODULE$.canBuildFrom()), Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        IndexedSeq columnWidths = (IndexedSeq)((TraversableOnce)rows.view().map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)x$2.view().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.length()), IterableView$.MODULE$.canBuildFrom())).toIndexedSeq(), IterableView$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columns).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> Math.max(BoxesRunTime.unboxToInt((Object)((IterableViewLike)r1.view().padTo(columns, (Object)BoxesRunTime.boxToInteger((int)0), SeqView$.MODULE$.canBuildFrom())).drop(i).head()), BoxesRunTime.unboxToInt((Object)((IterableViewLike)r2.view().padTo(columns, (Object)BoxesRunTime.boxToInteger((int)0), SeqView$.MODULE$.canBuildFrom())).drop(i).head())), IndexedSeq$.MODULE$.canBuildFrom()));
        Maff$.MODULE$.max((TraversableOnce)rows.view().flatten((Function1)Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.length()), TraversableView$.MODULE$.canBuildFrom()), Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        return (Iterable)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> (Iterable)((TraversableLike)x$5.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> (String)new StringOps(Predef$.MODULE$.augmentString((String)p._1())).padTo(BoxesRunTime.unboxToInt((Object)columnWidths.apply(p._2$mcI$sp())), (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public String tableToString(Iterable<Iterable<String>> cells) {
        return ((TraversableOnce)cells.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.mkString(" "), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public void graph(Pixel start, String label, Seq<DrawScreen.GraphCurve> curves, Option<Object> fixedYMin, Option<Object> fixedYMax, Option<Object> fixedXMax, Color color0, Color color1, int width, int height, int margin) {
        Pixel end = start.add(width, height);
        Pixel innerBorderStart = start.add(margin, margin + With$.MODULE$.visualization().lineHeightSmall());
        Pixel innerBorderEnd = end.subtract(margin, margin);
        Pixel pointStart = innerBorderStart.add(margin, margin);
        Pixel pointEnd = innerBorderEnd.subtract(margin, margin);
        if (((SeqLike)curves.flatten((Function1 & Serializable & scala.Serializable)x$7 -> x$7.points())).isEmpty()) {
            return;
        }
        double dataMin = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)curves.flatten((Function1 & Serializable & scala.Serializable)x$8 -> x$8.points())).min((Ordering)Ordering.Double$.MODULE$));
        double dataMax = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)curves.flatten((Function1 & Serializable & scala.Serializable)x$9 -> x$9.points())).max((Ordering)Ordering.Double$.MODULE$));
        double yMin = Math.min(dataMin, BoxesRunTime.unboxToDouble((Object)fixedYMin.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dataMin)));
        double yMax = Math.max(dataMax, BoxesRunTime.unboxToDouble((Object)fixedYMax.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dataMax)));
        int xMax = BoxesRunTime.unboxToInt((Object)fixedXMax.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((TraversableOnce)curves.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)DrawScreen$.$anonfun$graph$7(x$10)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$))));
        double scaleX = (double)(pointEnd.x() - pointStart.x()) / (double)xMax;
        double scaleY = (double)(pointEnd.y() - pointStart.y()) / Math.max(1.0, yMax - yMin);
        With$.MODULE$.game().drawBoxScreen(start.bwapi(), end.bwapi(), color0, true);
        With$.MODULE$.game().drawBoxScreen(innerBorderStart.bwapi(), innerBorderEnd.bwapi(), color1, true);
        this.text(start.add(margin, 0), label);
        curves.foreach((Function1 & Serializable & scala.Serializable)curve -> {
            DrawScreen$.$anonfun$graph$8(xMax, pointStart, scaleX, scaleY, yMax, curve);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> graph$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> graph$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> graph$default$6() {
        return None$.MODULE$;
    }

    public Color graph$default$7() {
        return Colors$.MODULE$.DeepViolet();
    }

    public Color graph$default$8() {
        return Colors$.MODULE$.MidnightViolet();
    }

    public int graph$default$9() {
        return 90;
    }

    public int graph$default$10() {
        return 90 + With$.MODULE$.visualization().lineHeightSmall();
    }

    public int graph$default$11() {
        return 2;
    }

    public void barChart(Seq<Seq<Tuple3<Object, Color, String>>> columns, int argX, int argY, int width, int argHeight) {
        IntRef x = IntRef.create((int)argX);
        double total = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)DrawScreen$.$anonfun$barChart$1(x$11)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
            DrawScreen$.$anonfun$barChart$3(argY, argHeight, total, x, width, column);
            return BoxedUnit.UNIT;
        });
    }

    public int barChart$default$2() {
        return 5;
    }

    public int barChart$default$3() {
        return 39;
    }

    public int barChart$default$4() {
        return 24;
    }

    public int barChart$default$5() {
        return 255;
    }

    public static final /* synthetic */ int $anonfun$graph$7(DrawScreen.GraphCurve x$10) {
        return x$10.points().size();
    }

    public static final /* synthetic */ void $anonfun$graph$8(int xMax$1, Pixel pointStart$1, double scaleX$1, double scaleY$1, double yMax$1, DrawScreen.GraphCurve curve) {
        for (int i = 0; i < Math.min(xMax$1, curve.points().size()) - 1; ++i) {
            With$.MODULE$.game().drawLineScreen((int)((double)pointStart$1.x() + scaleX$1 * (double)i), (int)((double)pointStart$1.y() + scaleY$1 * (yMax$1 - BoxesRunTime.unboxToDouble((Object)curve.points().apply(i)))), (int)((double)pointStart$1.x() + scaleX$1 * (double)(i + 1)), (int)((double)pointStart$1.y() + scaleY$1 * (yMax$1 - BoxesRunTime.unboxToDouble((Object)curve.points().apply(i + 1)))), curve.color());
        }
    }

    public static final /* synthetic */ double $anonfun$barChart$2(Tuple3 x$12) {
        return BoxesRunTime.unboxToDouble((Object)x$12._1());
    }

    public static final /* synthetic */ double $anonfun$barChart$1(Seq x$11) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)x$11.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)DrawScreen$.$anonfun$barChart$2(x$12)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$barChart$4(Tuple3 x$13) {
        return BoxesRunTime.unboxToDouble((Object)x$13._1()) > 0.0;
    }

    public static final /* synthetic */ void $anonfun$barChart$5(int argHeight$1, double total$1, IntRef labelY$1, IntRef y$3, IntRef x$17, int width$1, Tuple3 item) {
        int height = (int)(BoxesRunTime.unboxToDouble((Object)item._1()) * (double)argHeight$1 / total$1);
        labelY$1.elem = Math.min(labelY$1.elem - With$.MODULE$.visualization().lineHeightSmall(), y$3.elem - height / 2 - With$.MODULE$.visualization().lineHeightSmall() / 2);
        With$.MODULE$.game().drawBoxScreen(x$17.elem, y$3.elem - height, x$17.elem + width$1, y$3.elem, (Color)item._2(), true);
        MODULE$.text(x$17.elem + width$1 + 1, labelY$1.elem, (String)item._3());
        y$3.elem -= height;
    }

    public static final /* synthetic */ int $anonfun$barChart$6(Tuple3 x$14) {
        return ((String)x$14._3()).length() * 5 + 1;
    }

    public static final /* synthetic */ void $anonfun$barChart$3(int argY$1, int argHeight$1, double total$1, IntRef x$17, int width$1, Seq column) {
        IntRef y = IntRef.create((int)(argY$1 + argHeight$1));
        IntRef labelY = IntRef.create((int)10000);
        ((IterableLike)((TraversableLike)column.reverse()).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DrawScreen$.$anonfun$barChart$4(x$13)))).foreach((Function1 & Serializable & scala.Serializable)item -> {
            DrawScreen$.$anonfun$barChart$5(argHeight$1, total$1, labelY, y, x$17, width$1, item);
            return BoxedUnit.UNIT;
        });
        x$17.elem += width$1 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)column.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)DrawScreen$.$anonfun$barChart$6(x$14)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    private DrawScreen$() {
        MODULE$ = this;
    }
}

