/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Pair;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Area;
import bwem.ChokePoint;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jbweb.JBWEB;
import jbweb.Wall;

public class Walls {
    private static HashMap<ChokePoint, Wall> walls = new HashMap();
    public static boolean logInfo = false;
    static int failedPlacement = 0;
    static int failedAngle = 0;
    static int failedPath = 0;
    static int failedTight = 0;
    static int failedSpawn = 0;
    static int failedPower = 0;
    static int failedNotable = 0;
    static int failedValid = 0;
    static int failedSeal = 0;
    static int permutations = 0;
    static int minXEvaluated = Integer.MAX_VALUE;
    static int minYEvaluated = Integer.MAX_VALUE;
    static int maxXEvaluated = Integer.MIN_VALUE;
    static int maxYEvaluated = Integer.MIN_VALUE;
    static int totalEvaluated = 0;

    public static Wall createWall(List<UnitType> buildings, Area area, ChokePoint choke, UnitType tightType, List<UnitType> defenses, boolean openWall, boolean requireTight) {
        boolean wallFound;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
        String timeNow = formatter.format(date);
        double clock = Math.round((JBWEB.getAngle(new Pair<Position, Position>(JBWEB.mapBWEM.getMap().getCenter(), new Position(area.getTop()))) + 90.0) / 30.0);
        if (new Position((WalkPosition)area.getTop()).x < JBWEB.mapBWEM.getMap().getCenter().x) {
            clock += 6.0;
        }
        if (logInfo) {
            System.out.println(timeNow + " " + JBWEB.game.mapFileName() + " At: " + clock + " o'clock.\n");
            System.out.println("Buildings:");
            for (UnitType building : buildings) {
                System.out.println(building.toString());
            }
        }
        if (choke == null) {
            System.out.println("JBWEB: Can't create a wall without a valid Chokepoint");
            return null;
        }
        if (buildings.isEmpty()) {
            System.out.println("JBWEB: Can't create a wall with an empty vector of UnitTypes.");
            return null;
        }
        for (ChokePoint chokePoint : walls.keySet()) {
            Wall wall = walls.get(chokePoint);
            if (wall.getArea() != area || wall.getChokePoint() != choke) continue;
            System.out.println("JBWEB: Can't create a Wall where one already exists.");
            return wall;
        }
        Wall wall = new Wall(area, choke, buildings, defenses, tightType, requireTight, openWall);
        boolean bl = wallFound = wall.getSmallTiles().size() + wall.getMediumTiles().size() + wall.getLargeTiles().size() == wall.getRawBuildings().size();
        if (logInfo) {
            System.out.println("Failure Reasons:");
            System.out.println("Power: " + failedPower);
            System.out.println("Angle: " + failedAngle);
            System.out.println("Placement: " + failedPlacement);
            System.out.println("Tight: " + failedTight);
            System.out.println("Path: " + failedPath);
            System.out.println("Spawn: " + failedSpawn);
            System.out.println("Seal: " + failedSeal);
            System.out.println("Notable: " + failedNotable);
            System.out.println("Invalid: " + failedValid);
            System.out.println("Permutations: " + permutations);
            System.out.println("Min X Evaluated: " + minXEvaluated);
            System.out.println("Min Y Evaluated: " + minYEvaluated);
            System.out.println("Max X Evaluated: " + maxXEvaluated);
            System.out.println("Max Y Evaluated: " + maxYEvaluated);
            System.out.println("Total Evaluated: " + totalEvaluated);
            System.out.println("\n");
            date = new Date(System.currentTimeMillis() - date.getTime());
            System.out.println("Generation Time: " + date.getTime() + "ms and " + (wallFound ? "successful." : "failed."));
            System.out.println("--------------------");
        }
        if (wallFound) {
            walls.replace(choke, wall);
            return walls.get(choke);
        }
        return null;
    }

    public static Wall createFFE() {
        return Walls.createFFE(6);
    }

    public static Wall createFFE(int cannons) {
        ArrayList<UnitType> buildings = new ArrayList<UnitType>();
        buildings.add(UnitType.Protoss_Forge);
        buildings.add(UnitType.Protoss_Gateway);
        buildings.add(UnitType.Protoss_Pylon);
        ArrayList<UnitType> defenses = new ArrayList<UnitType>();
        for (int i = 0; i < cannons; ++i) {
            defenses.add(UnitType.Protoss_Photon_Cannon);
        }
        return Walls.createWall(buildings, JBWEB.getNaturalArea(), JBWEB.getNaturalChoke(), UnitType.None, defenses, true, false);
    }

    public static Wall createZSimCity() {
        ArrayList<UnitType> buildings = new ArrayList<UnitType>();
        buildings.add(UnitType.Zerg_Hatchery);
        buildings.add(UnitType.Zerg_Evolution_Chamber);
        ArrayList<UnitType> defenses = new ArrayList<UnitType>();
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        defenses.add(UnitType.Zerg_Sunken_Colony);
        return Walls.createWall(buildings, JBWEB.getNaturalArea(), JBWEB.getNaturalChoke(), UnitType.None, defenses, true, false);
    }

    public static Wall createTWall() {
        ArrayList<UnitType> buildings = new ArrayList<UnitType>();
        buildings.add(UnitType.Terran_Supply_Depot);
        buildings.add(UnitType.Terran_Supply_Depot);
        buildings.add(UnitType.Terran_Barracks);
        ArrayList<UnitType> defenses = new ArrayList<UnitType>();
        UnitType type = JBWEB.game.enemy() != null && JBWEB.game.enemy().getRace() == Race.Protoss ? UnitType.Protoss_Zealot : UnitType.Zerg_Zergling;
        return Walls.createWall(buildings, JBWEB.getMainArea(), JBWEB.getMainChoke(), type, defenses, false, true);
    }

    public static Wall getClosestWall(TilePosition here) {
        double distBest = Double.MAX_VALUE;
        Wall bestWall = null;
        for (ChokePoint chokePoint : walls.keySet()) {
            Wall wall = walls.get(chokePoint);
            double dist = here.getDistance(new TilePosition(wall.getChokePoint().getCenter()));
            if (!(dist < distBest)) continue;
            distBest = dist;
            bestWall = wall;
        }
        return bestWall;
    }

    public static Wall getWall(ChokePoint choke) {
        if (choke == null) {
            return null;
        }
        for (ChokePoint chokePoint : walls.keySet()) {
            Wall wall = walls.get(chokePoint);
            if (wall.getChokePoint() != choke) continue;
            return wall;
        }
        return null;
    }

    public static HashMap<ChokePoint, Wall> getWalls() {
        return walls;
    }

    public static void draw() {
        for (ChokePoint chokePoint : walls.keySet()) {
            Wall wall = walls.get(chokePoint);
            wall.draw();
        }
    }
}

