/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Area;
import bwem.ChokePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jbweb.Block;
import jbweb.JBWEB;
import jbweb.Piece;

public class Blocks {
    private static List<Block> allBlocks = new ArrayList<Block>();
    private static HashMap<Area, Integer> typePerArea = new HashMap();
    private static HashMap<Piece, Integer> mainPieces = new HashMap();

    private static int countPieces(List<Piece> pieces, Piece type) {
        int count = 0;
        for (Piece piece : pieces) {
            if (piece != type) continue;
            ++count;
        }
        return count;
    }

    private static List<Piece> whichPieces(int width, int height, boolean faceUp, boolean faceLeft) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        if (JBWEB.game.self().getRace() == Race.Zerg) {
            if (height == 2) {
                if (width == 2) {
                    pieces.add(Piece.Small);
                }
                if (width == 3) {
                    pieces.add(Piece.Medium);
                }
                if (width == 5) {
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 3) {
                if (width == 4) {
                    pieces.add(Piece.Large);
                }
            } else if (height == 4) {
                if (width == 3) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                }
                if (width == 5) {
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 6 && width == 5) {
                pieces.add(Piece.Small);
                pieces.add(Piece.Medium);
                pieces.add(Piece.Row);
                pieces.add(Piece.Medium);
                pieces.add(Piece.Small);
                pieces.add(Piece.Row);
                pieces.add(Piece.Small);
                pieces.add(Piece.Medium);
            }
        }
        if (JBWEB.game.self().getRace() == Race.Protoss) {
            if (height == 2) {
                if (width == 5) {
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 4) {
                if (width == 5) {
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 5) {
                if (width == 4) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Small);
                }
                if (width == 8) {
                    if (faceLeft) {
                        if (faceUp) {
                            pieces.add(Piece.Large);
                            pieces.add(Piece.Large);
                            pieces.add(Piece.Row);
                            pieces.add(Piece.Medium);
                            pieces.add(Piece.Medium);
                            pieces.add(Piece.Small);
                        } else {
                            pieces.add(Piece.Medium);
                            pieces.add(Piece.Medium);
                            pieces.add(Piece.Small);
                            pieces.add(Piece.Row);
                            pieces.add(Piece.Large);
                            pieces.add(Piece.Large);
                        }
                    } else if (faceUp) {
                        pieces.add(Piece.Large);
                        pieces.add(Piece.Large);
                        pieces.add(Piece.Row);
                        pieces.add(Piece.Small);
                        pieces.add(Piece.Medium);
                        pieces.add(Piece.Medium);
                    } else {
                        pieces.add(Piece.Small);
                        pieces.add(Piece.Medium);
                        pieces.add(Piece.Medium);
                        pieces.add(Piece.Row);
                        pieces.add(Piece.Large);
                        pieces.add(Piece.Large);
                    }
                }
            } else if (height == 6) {
                if (width == 10) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Addon);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Large);
                }
                if (width == 18) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Addon);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                }
            } else if (height == 8) {
                if (width == 8) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Large);
                }
                if (width == 5) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Small);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Large);
                }
            }
        }
        if (JBWEB.game.self().getRace() == Race.Terran) {
            if (height == 2) {
                if (width == 3) {
                    pieces.add(Piece.Medium);
                }
                if (width == 6) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 4) {
                if (width == 3) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 6) {
                if (width == 3) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 3) {
                if (width == 6) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Addon);
                }
            } else if (height == 4) {
                if (width == 6) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                }
                if (width == 9) {
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 5) {
                if (width == 6) {
                    pieces.add(Piece.Large);
                    pieces.add(Piece.Addon);
                    pieces.add(Piece.Row);
                    pieces.add(Piece.Medium);
                    pieces.add(Piece.Medium);
                }
            } else if (height == 6 && width == 6) {
                pieces.add(Piece.Large);
                pieces.add(Piece.Addon);
                pieces.add(Piece.Row);
                pieces.add(Piece.Large);
                pieces.add(Piece.Addon);
            }
        }
        return pieces;
    }

    private static boolean canAddBlock(TilePosition here, int width, int height) {
        for (int x = here.x - 1; x < here.x + width + 1; ++x) {
            for (int y = here.y - 1; y < here.y + height + 1; ++y) {
                TilePosition t = new TilePosition(x, y);
                if (t.isValid(JBWEB.game) && JBWEB.mapBWEM.getMap().getTile(t).isBuildable() && !JBWEB.isReserved(t, 1, 1)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canAddProxyBlock(TilePosition here, int width, int height) {
        for (int x = here.x - 1; x < here.x + width + 1; ++x) {
            for (int y = here.y - 1; y < here.y + height + 1; ++y) {
                TilePosition t = new TilePosition(x, y);
                if (t.isValid(JBWEB.game) && JBWEB.mapBWEM.getMap().getTile(t).isBuildable() && JBWEB.game.isWalkable(new WalkPosition(t))) continue;
                return false;
            }
        }
        return true;
    }

    private static void insertBlock(TilePosition here, List<Piece> pieces) {
        Block newBlock = new Block(here, pieces, false, false);
        allBlocks.add(newBlock);
        JBWEB.addReserve(here, newBlock.width(), newBlock.height());
    }

    private static void insertProxyBlock(TilePosition here, List<Piece> pieces) {
        Block newBlock = new Block(here, pieces, true, false);
        allBlocks.add(newBlock);
        JBWEB.addReserve(here, newBlock.width(), newBlock.height());
    }

    private static void insertDefensiveBlock(TilePosition here, List<Piece> pieces) {
        Block newBlock = new Block(here, pieces, false, true);
        allBlocks.add(newBlock);
        JBWEB.addReserve(here, newBlock.width(), newBlock.height());
    }

    private static boolean creepOnCorners(TilePosition here, int width, int height) {
        boolean b1 = JBWEB.game.hasCreep(here);
        boolean b2 = JBWEB.game.hasCreep(new TilePosition(here.x + width - 1, here.y));
        boolean b3 = JBWEB.game.hasCreep(new TilePosition(here.x, here.y + height - 1));
        boolean b4 = JBWEB.game.hasCreep(new TilePosition(here.x + width - 1, here.y + height - 1));
        return b1 && b2 && b3 && b4;
    }

    private static void searchStart(Position start) {
        TilePosition tileStart = new TilePosition(start);
        TilePosition tileBest = TilePosition.Invalid;
        double distBest = Double.MAX_VALUE;
        List<Piece> piecesBest = new ArrayList<Piece>();
        for (int i = 10; i > 0; --i) {
            for (int j = 10; j > 0; --j) {
                for (int x = tileStart.x - 15; x <= tileStart.x + 15; ++x) {
                    for (int y = tileStart.y - 15; y <= tileStart.y + 15; ++y) {
                        Race race;
                        boolean blockFacesLeft;
                        TilePosition tile = new TilePosition(x, y);
                        Position blockCenter = new Position(tile.x + i * 16, tile.y + j * 16);
                        double dist = blockCenter.getDistance(start);
                        boolean blockFacesUp = blockCenter.y < JBWEB.getMainPosition().y;
                        List<Piece> pieces = Blocks.whichPieces(i, j, blockFacesUp, blockFacesLeft = blockCenter.x < JBWEB.getMainPosition().x);
                        if (pieces.isEmpty() || (race = JBWEB.game.self().getRace()) == Race.Zerg && !Blocks.creepOnCorners(tile, i, j)) continue;
                        int smallCount = Blocks.countPieces(pieces, Piece.Small);
                        int mediumCount = Blocks.countPieces(pieces, Piece.Medium);
                        int largeCount = Blocks.countPieces(pieces, Piece.Large);
                        if (!tile.isValid(JBWEB.game) || mediumCount < 1 || race == Race.Zerg && smallCount == 0 && mediumCount == 0 || race == Race.Protoss && largeCount < 2 || race == Race.Terran && largeCount < 1 || !(dist < distBest) || !Blocks.canAddBlock(tile, i, j)) continue;
                        piecesBest = pieces;
                        distBest = dist;
                        tileBest = tile;
                    }
                }
                if (!tileBest.isValid(JBWEB.game) || !Blocks.canAddBlock(tileBest, i, j)) continue;
                if (JBWEB.mapBWEM.getMap().getArea(tileBest) == JBWEB.getMainArea()) {
                    for (Piece piece : piecesBest) {
                        if (mainPieces.get((Object)piece) == null) {
                            mainPieces.put(piece, 1);
                            continue;
                        }
                        int tmp = mainPieces.get((Object)piece) + 1;
                        mainPieces.put(piece, tmp);
                    }
                }
                Blocks.insertBlock(tileBest, piecesBest);
            }
        }
    }

    private static void findMainStartBlocks() {
        Race race = JBWEB.game.self().getRace();
        Position firstStart = JBWEB.getMainPosition();
        Position secondStart = race != Race.Zerg ? new Position(JBWEB.getMainChoke().getCenter().x + JBWEB.getMainPosition().x / 2, JBWEB.getMainChoke().getCenter().y + JBWEB.getMainPosition().y / 2) : JBWEB.getMainPosition();
        Blocks.searchStart(firstStart);
        Blocks.searchStart(secondStart);
    }

    private static void findMainDefenseBlock() {
        if (JBWEB.game.self().getRace() == Race.Zerg) {
            return;
        }
        TilePosition tileBest = TilePosition.Invalid;
        TilePosition start = new TilePosition(JBWEB.getMainChoke().getCenter());
        double distBest = Double.MAX_VALUE;
        for (int x = start.x - 12; x <= start.x + 16; ++x) {
            for (int y = start.y - 12; y <= start.y + 16; ++y) {
                TilePosition tile = new TilePosition(x, y);
                Position blockCenter = new Position(tile.toPosition().x + 80, tile.toPosition().y + 32);
                double dist = blockCenter.getDistance(JBWEB.getMainChoke().getCenter().toPosition());
                if (!tile.isValid(JBWEB.game) || JBWEB.mapBWEM.getMap().getArea(tile) != JBWEB.getMainArea() || dist < 96.0 || !(dist < distBest) || !Blocks.canAddBlock(tile, 5, 2)) continue;
                tileBest = tile;
                distBest = dist;
            }
        }
        if (tileBest.isValid(JBWEB.game)) {
            ArrayList<Piece> p = new ArrayList<Piece>();
            p.add(Piece.Small);
            p.add(Piece.Medium);
            Blocks.insertDefensiveBlock(tileBest, p);
        }
    }

    private static void findProductionBlocks() {
        HashMap<Double, TilePosition> tilesByPathDist = new HashMap<Double, TilePosition>();
        for (int y = 0; y < JBWEB.game.mapHeight(); ++y) {
            for (int x = 0; x < JBWEB.game.mapWidth(); ++x) {
                TilePosition t = new TilePosition(x, y);
                if (!t.isValid(JBWEB.game) || !JBWEB.game.isBuildable(t)) continue;
                Position p = new Position(x * 32, y * 32);
                double dist = JBWEB.getNaturalChoke() != null && JBWEB.game.self().getRace() != Race.Zerg ? p.getDistance(new Position(JBWEB.getNaturalChoke().getCenter())) : p.getDistance(JBWEB.getMainPosition());
                tilesByPathDist.put(dist, t);
            }
        }
        for (int i = 20; i > 0; --i) {
            for (int j = 20; j > 0; --j) {
                List<Piece> pieces = Blocks.whichPieces(i, j, false, false);
                if (pieces.isEmpty()) continue;
                int smallCount = Blocks.countPieces(pieces, Piece.Small);
                int mediumCount = Blocks.countPieces(pieces, Piece.Medium);
                int largeCount = Blocks.countPieces(pieces, Piece.Large);
                for (Double key : tilesByPathDist.keySet()) {
                    TilePosition tile = (TilePosition)tilesByPathDist.get(key);
                    if (JBWEB.game.self().getRace() == Race.Protoss && mainPieces.get((Object)Piece.Large) != null && mainPieces.get((Object)Piece.Medium) != null && largeCount > 0 && JBWEB.mapBWEM.getMap().getArea(tile) == JBWEB.getMainArea() && mainPieces.get((Object)Piece.Large) >= 12 && mainPieces.get((Object)Piece.Medium) < 10 || JBWEB.game.self().getRace() == Race.Zerg && mainPieces.get((Object)Piece.Medium) != null && mainPieces.get((Object)Piece.Small) != null && (mediumCount > 0 && mainPieces.get((Object)Piece.Medium) >= 4 || smallCount > 0 && mainPieces.get((Object)Piece.Small) >= 2) || JBWEB.game.self().getRace() == Race.Terran && mainPieces.get((Object)Piece.Medium) != null && mediumCount > 0 && mainPieces.get((Object)Piece.Medium) >= 20 || !Blocks.canAddBlock(tile, i, j)) continue;
                    Blocks.insertBlock(tile, pieces);
                    if (JBWEB.mapBWEM.getMap().getArea(tile) != JBWEB.getMainArea()) continue;
                    for (Piece piece : pieces) {
                        if (mainPieces.get((Object)piece) == null) {
                            mainPieces.put(piece, 1);
                            continue;
                        }
                        int tmp = mainPieces.get((Object)piece) + 1;
                        mainPieces.put(piece, tmp);
                    }
                }
            }
        }
    }

    private static boolean goodArea(TilePosition t, List<TilePosition> enemyStartLocations, HashSet<Area> areasToAvoid) {
        for (TilePosition start : enemyStartLocations) {
            if (JBWEB.mapBWEM.getMap().getArea(t) != JBWEB.mapBWEM.getMap().getArea(start)) continue;
            return false;
        }
        for (Area area : areasToAvoid) {
            if (JBWEB.mapBWEM.getMap().getArea(t) != area) continue;
            return false;
        }
        return true;
    }

    private static boolean blockedPath(Position source, Position target) {
        for (ChokePoint choke : JBWEB.mapBWEM.getMap().getPath(source, target)) {
            if (JBWEB.isUsed(new TilePosition(choke.getCenter()), 1, 1) == UnitType.None) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void findProxyBlock() {
        void var2_5;
        HashSet<Area> areasToAvoid = new HashSet<Area>();
        for (TilePosition tilePosition : JBWEB.mapBWEM.getMap().getStartingLocations()) {
            for (TilePosition second : JBWEB.mapBWEM.getMap().getStartingLocations()) {
                if (tilePosition == second) continue;
                for (ChokePoint choke : JBWEB.mapBWEM.getMap().getPath(new Position(tilePosition), new Position(second))) {
                    areasToAvoid.add(choke.getAreas().getFirst());
                    areasToAvoid.add(choke.getAreas().getSecond());
                }
            }
            Area baseArea = JBWEB.mapBWEM.getMap().getNearestArea(tilePosition);
            areasToAvoid.addAll(baseArea.getAccessibleNeighbors());
        }
        ArrayList<TilePosition> enemyStartLocations = new ArrayList<TilePosition>();
        for (TilePosition start : JBWEB.mapBWEM.getMap().getStartingLocations()) {
            if (JBWEB.mapBWEM.getMap().getArea(start) == JBWEB.getMainArea()) continue;
            enemyStartLocations.add(start);
        }
        TilePosition tilePosition = TilePosition.Invalid;
        double distBest = Double.MAX_VALUE;
        for (int x = 0; x < JBWEB.game.mapWidth(); ++x) {
            for (int y = 0; y < JBWEB.game.mapHeight(); ++y) {
                TilePosition topLeft = new TilePosition(x, y);
                TilePosition botRight = new TilePosition(x + 8, y + 5);
                if (!topLeft.isValid(JBWEB.game) || !botRight.isValid(JBWEB.game) || !Blocks.canAddProxyBlock(topLeft, 8, 5)) continue;
                Position blockCenter = new Position(topLeft.toPosition().x + 160, topLeft.toPosition().y + 96);
                double dist = 0.0;
                for (TilePosition base : enemyStartLocations) {
                    Position baseCenter = new Position(base.toPosition().x + 64, base.toPosition().y + 48);
                    dist += JBWEB.getGroundDistance(blockCenter, baseCenter);
                    if (!Blocks.blockedPath(blockCenter, baseCenter)) continue;
                    dist = Double.MAX_VALUE;
                    break;
                }
                if (Blocks.goodArea(topLeft, enemyStartLocations, areasToAvoid) && Blocks.goodArea(botRight, enemyStartLocations, areasToAvoid)) {
                    dist = Math.log(dist);
                }
                if (!(dist < distBest)) continue;
                distBest = dist;
                TilePosition tilePosition2 = topLeft;
            }
        }
        if (Blocks.canAddProxyBlock((TilePosition)var2_5, 8, 5)) {
            ArrayList<Piece> p = new ArrayList<Piece>();
            p.add(Piece.Large);
            p.add(Piece.Large);
            p.add(Piece.Row);
            p.add(Piece.Small);
            p.add(Piece.Small);
            p.add(Piece.Small);
            p.add(Piece.Small);
            Blocks.insertProxyBlock((TilePosition)var2_5, p);
        }
    }

    public void eraseBlock(TilePosition here) {
        ArrayList<Block> blocksToRemove = new ArrayList<Block>();
        for (Block block : allBlocks) {
            if (here.x < block.getTilePosition().x || here.x >= block.getTilePosition().x + block.width() || here.y < block.getTilePosition().y || here.y >= block.getTilePosition().y + block.height()) continue;
            blocksToRemove.add(block);
        }
        for (Block block : blocksToRemove) {
            allBlocks.remove(block);
        }
    }

    public static void findBlocks() {
        Blocks.findMainDefenseBlock();
        Blocks.findMainStartBlocks();
        Blocks.findProxyBlock();
        Blocks.findProductionBlocks();
    }

    public static void draw() {
        for (Block block : allBlocks) {
            block.draw();
        }
    }

    public static List<Block> getBlocks() {
        return allBlocks;
    }

    public Block getClosestBlock(TilePosition here) {
        double distBest = Double.MAX_VALUE;
        Block bestBlock = null;
        for (Block block : allBlocks) {
            TilePosition tile = new TilePosition(block.getTilePosition().x + block.width() / 2, block.getTilePosition().y + block.height() / 2);
            double dist = here.getDistance(tile);
            if (!(dist < distBest)) continue;
            distBest = dist;
            bestBlock = block;
        }
        return bestBlock;
    }
}

