/*
 * Decompiled with CFR 0.152.
 */
package bwta;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import bwta.BaseLocation;
import bwta.Chokepoint;
import bwta.Region;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BWTA {
    private static BWEM bwem;
    static Map<Area, Region> regionMap;
    static Map<ChokePoint, Chokepoint> chokeMap;
    static Map<Base, BaseLocation> baseMap;
    private static List<Region> regions;
    private static List<Chokepoint> chokepoints;
    private static List<BaseLocation> baseLocations;

    public static BWEM getBWEM() {
        return bwem;
    }

    public static void setFailOnError(boolean value) {
        bwem.setFailOnError(value);
    }

    public static void setFailOnErrorStream(OutputStream stream) {
        bwem.setFailOutputStream(stream);
    }

    @Deprecated
    public static void readMap(Game game) {
        bwem = new BWEM(game);
    }

    public static void analyze() {
        bwem.initialize();
        regionMap = new HashMap<Area, Region>();
        for (Area a : bwem.getMap().getAreas()) {
            regionMap.put(a, new Region(a));
        }
        regions = Collections.unmodifiableList(new ArrayList<Region>(regionMap.values()));
        chokeMap = new HashMap<ChokePoint, Chokepoint>();
        for (ChokePoint c : bwem.getMap().getChokePoints()) {
            chokeMap.put(c, new Chokepoint(c));
        }
        chokepoints = Collections.unmodifiableList(new ArrayList<Chokepoint>(chokeMap.values()));
        baseMap = new HashMap<Base, BaseLocation>();
        for (Base b : bwem.getMap().getBases()) {
            baseMap.put(b, new BaseLocation(b));
        }
        baseLocations = Collections.unmodifiableList(new ArrayList<BaseLocation>(baseMap.values()));
    }

    public static List<Region> getRegions() {
        return regions;
    }

    public static List<Chokepoint> getChokepoints() {
        return chokepoints;
    }

    public static List<BaseLocation> getBaseLocations() {
        return baseLocations;
    }

    public static List<BaseLocation> getStartLocations() {
        return BWTA.getBaseLocations().stream().filter(BaseLocation::isStartLocation).collect(Collectors.toList());
    }

    public static BaseLocation getStartLocation(Player player) {
        return BWTA.getNearestBaseLocation(player.getStartLocation());
    }

    public static Region getRegion(TilePosition tileposition) {
        return regionMap.get(bwem.getMap().getNearestArea(tileposition));
    }

    public static Region getRegion(Position position) {
        return regionMap.get(bwem.getMap().getNearestArea(position.toWalkPosition()));
    }

    public static Chokepoint getNearestChokepoint(TilePosition tileposition) {
        return BWTA.getNearestChokepoint(tileposition.toPosition());
    }

    public static Chokepoint getNearestChokepoint(Position position) {
        return (Chokepoint)chokepoints.stream().min((a, b) -> (int)(a.getCenter().getDistance(position) - b.getCenter().getDistance(position))).get();
    }

    public static BaseLocation getNearestBaseLocation(TilePosition tileposition) {
        return (BaseLocation)baseLocations.stream().min((a, b) -> (int)(a.getTilePosition().getDistance(tileposition) - b.getTilePosition().getDistance(tileposition))).get();
    }

    public static BaseLocation getNearestBaseLocation(Position position) {
        return (BaseLocation)baseLocations.stream().min((a, b) -> (int)(a.getPosition().getDistance(position) - b.getPosition().getDistance(position))).get();
    }

    public static boolean isConnected(TilePosition a, TilePosition b) {
        return bwem.getMap().getNearestArea(a).isAccessibleFrom(bwem.getMap().getNearestArea(b));
    }

    public static double getGroundDistance(TilePosition start, TilePosition end) {
        return bwem.getMap().getPathLength(start.toPosition(), end.toPosition());
    }

    public static List<TilePosition> getShortestPath(TilePosition start, TilePosition end) {
        ArrayList<TilePosition> path = new ArrayList<TilePosition>();
        Iterator<ChokePoint> it = bwem.getMap().getPath(start.toPosition(), end.toPosition()).iterator();
        ChokePoint curr = null;
        while (it.hasNext()) {
            ChokePoint next = it.next();
            if (curr != null) {
                TilePosition t0 = curr.getCenter().toTilePosition();
                TilePosition t1 = next.getCenter().toTilePosition();
                int dx = Math.abs(t1.x - t0.x);
                int dy = Math.abs(t1.y - t0.y);
                int x = t0.x;
                int y = t0.y;
                int n = 1 + dx + dy;
                int x_inc = t1.x > t0.x ? 1 : -1;
                int y_inc = t1.x > t0.x ? 1 : -1;
                int error = dx - dy;
                dx *= 2;
                dy *= 2;
                while (n > 0) {
                    path.add(new TilePosition(x, y));
                    if (error > 0) {
                        x += x_inc;
                        error -= dy;
                    } else {
                        y += y_inc;
                        error += dx;
                    }
                    --n;
                }
            }
            curr = next;
        }
        return path;
    }
}

