/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

public class BWClientConfiguration {
    private boolean debugConnection;
    private boolean autoContinue = false;
    private boolean unlimitedFrameZero = true;
    private int maxFrameDurationMs = 40;
    private boolean async = false;
    private int asyncFrameBufferCapacity = 10;
    private boolean asyncUnsafe = false;
    private boolean logVerbosely = false;
    private boolean locked = false;

    public BWClientConfiguration withDebugConnection(boolean value) {
        this.throwIfLocked();
        this.debugConnection = value;
        return this;
    }

    public boolean getDebugConnection() {
        return this.debugConnection;
    }

    public BWClientConfiguration withAutoContinue(boolean value) {
        this.throwIfLocked();
        this.autoContinue = value;
        return this;
    }

    public boolean getAutoContinue() {
        return this.autoContinue;
    }

    public BWClientConfiguration withUnlimitedFrameZero(boolean value) {
        this.throwIfLocked();
        this.unlimitedFrameZero = value;
        return this;
    }

    public boolean getUnlimitedFrameZero() {
        return this.unlimitedFrameZero;
    }

    public BWClientConfiguration withMaxFrameDurationMs(int value) {
        this.throwIfLocked();
        this.maxFrameDurationMs = value;
        return this;
    }

    public int getMaxFrameDurationMs() {
        return this.maxFrameDurationMs;
    }

    public BWClientConfiguration withAsync(boolean value) {
        this.throwIfLocked();
        this.async = value;
        return this;
    }

    public boolean getAsync() {
        return this.async;
    }

    public BWClientConfiguration withAsyncFrameBufferCapacity(int size) {
        this.throwIfLocked();
        this.asyncFrameBufferCapacity = size;
        return this;
    }

    public int getAsyncFrameBufferCapacity() {
        return this.asyncFrameBufferCapacity;
    }

    public BWClientConfiguration withAsyncUnsafe(boolean value) {
        this.throwIfLocked();
        this.asyncUnsafe = value;
        return this;
    }

    public boolean getAsyncUnsafe() {
        return this.asyncUnsafe;
    }

    public BWClientConfiguration withLogVerbosely(boolean value) {
        this.throwIfLocked();
        this.logVerbosely = value;
        return this;
    }

    public boolean getLogVerbosely() {
        return this.logVerbosely;
    }

    void validateAndLock() {
        if (this.asyncUnsafe && !this.async) {
            throw new IllegalArgumentException("asyncUnsafe mode needs async mode.");
        }
        if (this.async && this.maxFrameDurationMs < 0) {
            throw new IllegalArgumentException("maxFrameDurationMs needs to be a non-negative number (it's how long JBWAPI waits for a bot response before returning control to BWAPI).");
        }
        if (this.async && this.asyncFrameBufferCapacity < 1) {
            throw new IllegalArgumentException("asyncFrameBufferCapacity needs to be a positive number (There needs to be at least one frame buffer).");
        }
        this.locked = true;
    }

    void throwIfLocked() {
        if (this.locked) {
            throw new RuntimeException("Configuration can not be modified after the game has started");
        }
    }

    void log(String value) {
        if (this.logVerbosely) {
            System.out.println(value);
        }
    }
}

