/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Micro;

import Debugging.EnumerateUnits$;
import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Hues$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Rendering.DrawScreen$;
import Debugging.Visualizations.Views.DebugView;
import Information.Geography.Types.Base;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import ProxyBwapi.UnitInfo.CombatUnit;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitTracking.IndexedSet;
import Tactic.Squads.Squad;
import bwapi.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ShowSquads$
extends DebugView {
    public static ShowSquads$ MODULE$;
    private Vector<Color> squadColors;
    private volatile boolean bitmap$0;

    static {
        new ShowSquads$();
    }

    @Override
    public void renderMap() {
        ((IterableLike)With$.MODULE$.squads().all().filter((Function1<Squad, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ShowSquads$.$anonfun$renderMap$1(x$1)))).foreach((Function1<Squad, Object> & Serializable & scala.Serializable)squad -> {
            ShowSquads$.MODULE$.renderSquadMap(squad);
            return BoxedUnit.UNIT;
        });
    }

    public void renderSquadMap(Squad squad) {
        Color color = this.squadColors().apply(squad.hashCode() % this.squadColors().length());
        squad.units().foreach((Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            DrawMap$.MODULE$.label((Function0<String> & Serializable & scala.Serializable)() -> squad$1.toString(), unit.pixel().add(0, unit.unitClass().height()), true, color, unit.isEnemy(), With$.MODULE$.enemy().colorMedium());
            return BoxedUnit.UNIT;
        });
        Maff$.MODULE$.centroid(squad.units().view().map((Function1<FriendlyUnitInfo, Pixel> & Serializable & scala.Serializable)x$2 -> x$2.pixel(), SeqView$.MODULE$.canBuildFrom()));
        Seq<Pixel> hull = Maff$.MODULE$.convexHull(squad.units().flatMap((Function1<FriendlyUnitInfo, Vector> & Serializable & scala.Serializable)x$3 -> x$3.corners(), Seq$.MODULE$.canBuildFrom()));
        DrawMap$.MODULE$.polygon(hull, color);
        squad.targets().foreach((Function1<IndexedSet, Object> & Serializable & scala.Serializable)q -> {
            ShowSquads$.$anonfun$renderSquadMap$5(q);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void renderScreen() {
        Vector<Iterable<String>> table = ((Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Goal", "", "Vicinity", "", "", "Recruits", "", "Targets", "", "Enemies"}))}))).$plus$plus((GenTraversableOnce)With$.MODULE$.squads().all().map((Function1<Squad, Vector> & Serializable & scala.Serializable)squad -> (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{squad.toString(), (String)squad.vicinity().base().map((Function1<Base, String> & Serializable & scala.Serializable)x$4 -> x$4.toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> squad.vicinity().tile().toString()), "", "", "", EnumerateUnits$.MODULE$.apply(squad.units()), "", EnumerateUnits$.MODULE$.apply((Iterable)squad.targets().getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> Nil$.MODULE$)), "", EnumerateUnits$.MODULE$.apply(squad.enemies())})), Seq$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
        DrawScreen$.MODULE$.table(5, 7 * With$.MODULE$.visualization().lineHeightSmall(), table);
    }

    private Vector<Color> squadColors$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.squadColors = (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Color[]{Colors$.MODULE$.MidnightRed(), Colors$.MODULE$.MidnightOrange(), Colors$.MODULE$.MidnightYellow(), Colors$.MODULE$.MidnightGreen(), Colors$.MODULE$.MidnightBlue(), Colors$.MODULE$.MidnightIndigo(), Colors$.MODULE$.MidnightViolet(), Colors$.MODULE$.DarkRed(), Colors$.MODULE$.DarkOrange(), Colors$.MODULE$.DarkYellow(), Colors$.MODULE$.DarkGreen(), Colors$.MODULE$.DarkBlue(), Colors$.MODULE$.DarkIndigo(), Colors$.MODULE$.DarkViolet(), Colors$.MODULE$.MediumRed(), Colors$.MODULE$.MediumOrange(), Colors$.MODULE$.MediumYellow(), Colors$.MODULE$.MediumGreen(), Colors$.MODULE$.MediumBlue(), Colors$.MODULE$.MediumIndigo(), Colors$.MODULE$.MediumViolet(), Colors$.MODULE$.BrightRed(), Colors$.MODULE$.BrightOrange(), Colors$.MODULE$.BrightYellow(), Colors$.MODULE$.BrightGreen(), Colors$.MODULE$.BrightBlue(), Colors$.MODULE$.BrightIndigo(), Colors$.MODULE$.BrightViolet()}));
                this.bitmap$0 = true;
            }
        }
        return this.squadColors;
    }

    public Vector<Color> squadColors() {
        if (!this.bitmap$0) {
            return this.squadColors$lzycompute();
        }
        return this.squadColors;
    }

    public static final /* synthetic */ boolean $anonfun$renderMap$1(Squad x$1) {
        return x$1.units().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$renderSquadMap$5(IndexedSet q) {
        if (q.nonEmpty()) {
            Color targetColor = Colors$.MODULE$.BrightYellow();
            DrawMap$.MODULE$.crosshair(((CombatUnit)q.head()).pixel(), ((CombatUnit)q.head()).unitClass().dimensionMax() / 2, targetColor);
            for (int i = 0; i < q.size() - 1; ++i) {
                DrawMap$.MODULE$.arrow(((CombatUnit)q.apply(i)).pixel(), ((CombatUnit)q.apply(i + 1)).pixel(), Colors$.MODULE$.hsv(Hues$.MODULE$.Red(), 255, 255 - 255 * i / q.size()));
            }
            return;
        }
    }

    private ShowSquads$() {
        MODULE$ = this;
    }
}

