/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Color;
import bwapi.Pair;
import bwapi.Position;
import bwapi.Race;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Area;
import bwem.Base;
import bwem.ChokePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import jbweb.JBWEB;
import jbweb.Path;
import jbweb.Station;
import jbweb.Stations;
import jbweb.Walls;

public class Wall {
    private UnitType tightType;
    private Position centroid;
    private TilePosition opening;
    private TilePosition initialPathStart;
    private TilePosition initialPathEnd;
    private TilePosition pathStart;
    private TilePosition pathEnd;
    private TilePosition creationStart;
    private List<TilePosition> defenses = new ArrayList<TilePosition>();
    private List<TilePosition> smallTiles = new ArrayList<TilePosition>();
    private List<TilePosition> mediumTiles = new ArrayList<TilePosition>();
    private List<TilePosition> largeTiles = new ArrayList<TilePosition>();
    private List<Position> notableLocations = new ArrayList<Position>();
    private ListIterator<UnitType> typeIterator;
    private List<UnitType> rawBuildings;
    private List<UnitType> rawDefenses;
    private List<Area> accessibleNeighbors;
    private HashMap<TilePosition, UnitType> currentLayout = new HashMap();
    private HashMap<TilePosition, UnitType> bestLayout = new HashMap();
    private Area area;
    private ChokePoint choke;
    private Base base;
    private double chokeAngle;
    private double bestWallScore;
    private double pathDist;
    private boolean pylonWall;
    private boolean openWall;
    private boolean requireTight;
    private boolean movedStart;
    private boolean pylonWallPiece;
    private boolean allowLifted;
    private boolean flatRamp;
    private Station closestStation;

    public Wall(Area _area, ChokePoint _choke, List<UnitType> _buildings, List<UnitType> _defenses, UnitType _tightType, boolean _requireTight, boolean _openWall) {
        this.area = _area;
        this.choke = _choke;
        this.rawBuildings = _buildings;
        this.rawDefenses = _defenses;
        this.tightType = _tightType;
        this.requireTight = _requireTight;
        this.openWall = _openWall;
        this.initialize();
        this.addPieces();
        this.currentLayout = this.bestLayout;
        this.centroid = this.findCentroid();
        this.opening = this.findOpening();
        this.addDefenses();
        this.opening = this.findOpening();
        this.cleanup();
    }

    public ChokePoint getChokePoint() {
        return this.choke;
    }

    public Area getArea() {
        return this.area;
    }

    public List<TilePosition> getDefenses() {
        return this.defenses;
    }

    public TilePosition getOpening() {
        return this.opening;
    }

    public Position getCentroid() {
        return this.centroid;
    }

    public List<TilePosition> getLargeTiles() {
        return this.largeTiles;
    }

    public List<TilePosition> getMediumTiles() {
        return this.mediumTiles;
    }

    public List<TilePosition> getSmallTiles() {
        return this.smallTiles;
    }

    public List<UnitType> getRawBuildings() {
        return this.rawBuildings;
    }

    public List<UnitType> getRawDefenses() {
        return this.rawDefenses;
    }

    public boolean isPylonWall() {
        return this.pylonWall;
    }

    public void addToWallPieces(TilePosition here, UnitType building) {
        if (building.tileWidth() >= 4) {
            this.largeTiles.add(here);
        } else if (building.tileWidth() >= 3) {
            this.mediumTiles.add(here);
        } else if (this.rawDefenses.contains((Object)building)) {
            this.defenses.add(here);
        } else if (building.tileWidth() >= 2) {
            this.smallTiles.add(here);
        }
    }

    private Position findCentroid() {
        UnitType type;
        Position currentCentroid = new Position(0, 0);
        int sizeWall = this.rawBuildings.size();
        for (TilePosition tile : this.bestLayout.keySet()) {
            type = this.bestLayout.get(tile);
            if (type != UnitType.Protoss_Pylon) {
                currentCentroid = new Position(currentCentroid.x + tile.toPosition().x + type.tileSize().toPosition().x / 2, currentCentroid.y + tile.toPosition().y + type.tileSize().toPosition().y / 2);
                continue;
            }
            --sizeWall;
        }
        if (sizeWall == 0) {
            sizeWall = this.bestLayout.size();
            for (TilePosition tile : this.bestLayout.keySet()) {
                type = this.bestLayout.get(tile);
                currentCentroid = new Position(currentCentroid.x + tile.toPosition().x + type.tileSize().toPosition().x / 2, currentCentroid.y + tile.toPosition().y + type.tileSize().toPosition().y / 2);
            }
        }
        return new Position(currentCentroid.x / sizeWall, currentCentroid.y / sizeWall);
    }

    private TilePosition findOpening() {
        double dist;
        if (!this.openWall) {
            return TilePosition.Invalid;
        }
        Path currentPath = this.findPathOut();
        TilePosition currentOpening = TilePosition.Invalid;
        double distBest = Double.MAX_VALUE;
        for (TilePosition pathTile : currentPath.getTiles()) {
            Position closestChokeGeo = JBWEB.getClosestChokeTile(this.choke, new Position(pathTile));
            dist = closestChokeGeo.getDistance(new Position(pathTile));
            Position centerPath = new Position(pathTile.x + 16, pathTile.y + 16);
            boolean angleOkay = true;
            boolean distOkay = false;
            for (TilePosition tileLayout : this.currentLayout.keySet()) {
                UnitType typeLayout = this.currentLayout.get(tileLayout);
                if (typeLayout == UnitType.Protoss_Pylon) continue;
                Position centerPiece = new Position(tileLayout.toPosition().x + typeLayout.tileWidth() * 16, tileLayout.toPosition().y + typeLayout.tileHeight() * 16);
                double openingAngle = JBWEB.getAngle(new Pair<Position, Position>(centerPiece, centerPath));
                double openingDist = centerPiece.getDistance(centerPath);
                if (Math.abs(this.chokeAngle - openingAngle) > 35.0) {
                    angleOkay = false;
                }
                if (!(openingDist < 320.0)) continue;
                distOkay = true;
            }
            if (!distOkay || !angleOkay || !(dist < distBest)) continue;
            distBest = dist;
            currentOpening = pathTile;
        }
        if (!currentOpening.isValid(JBWEB.game)) {
            for (TilePosition pathTile : currentPath.getTiles()) {
                Position p = new Position(pathTile);
                dist = this.centroid.getDistance(p);
                if (!(dist < distBest)) continue;
                distBest = dist;
                currentOpening = pathTile;
            }
        }
        return currentOpening;
    }

    private Path findPathOut() {
        this.checkPathPoints();
        Position startCenter = new Position(this.pathStart.toPosition().x + 16, this.pathStart.toPosition().y + 16);
        Position endCenter = new Position(this.pathEnd.toPosition().x + 16, this.pathEnd.toPosition().y + 16);
        Path newPath = new Path();
        this.allowLifted = false;
        newPath.bfsPath(endCenter, startCenter, this);
        return newPath;
    }

    private boolean powerCheck(UnitType type, TilePosition here) {
        if (type != UnitType.Protoss_Pylon || this.pylonWall) {
            return true;
        }
        for (TilePosition tileLayout : this.currentLayout.keySet()) {
            boolean powersThis;
            UnitType typeLayout = this.currentLayout.get(tileLayout);
            if (typeLayout == UnitType.Protoss_Pylon) continue;
            if (typeLayout.tileWidth() == 4) {
                powersThis = false;
                if ((tileLayout.y - here.y == -5 || tileLayout.y - here.y == 4) && tileLayout.x - here.x >= -4 && tileLayout.x - here.x <= 1) {
                    powersThis = true;
                }
                if ((tileLayout.y - here.y == -4 || tileLayout.y - here.y == 3) && tileLayout.x - here.x >= -7 && tileLayout.x - here.x <= 4) {
                    powersThis = true;
                }
                if ((tileLayout.y - here.y == -3 || tileLayout.y - here.y == 2) && tileLayout.x - here.x >= -8 && tileLayout.x - here.x <= 5) {
                    powersThis = true;
                }
                if (tileLayout.y - here.y >= -2 && tileLayout.y - here.y <= 1 && tileLayout.x - here.x >= -8 && tileLayout.x - here.x <= 6) {
                    powersThis = true;
                }
                if (powersThis) continue;
                return false;
            }
            powersThis = false;
            if (tileLayout.y - here.y == 4 && tileLayout.x - here.x >= -3 && tileLayout.x - here.x <= 2) {
                powersThis = true;
            }
            if ((tileLayout.y - here.y == -4 || tileLayout.y - here.y == 3) && tileLayout.x - here.x >= -6 && tileLayout.x - here.x <= 5) {
                powersThis = true;
            }
            if (tileLayout.y - here.y >= -3 && tileLayout.y - here.y <= 2 && tileLayout.x - here.x >= -7 && tileLayout.x - here.x <= 6) {
                powersThis = true;
            }
            if (powersThis) continue;
            return false;
        }
        return true;
    }

    private boolean angleCheck(UnitType type, TilePosition here) {
        Position centerHere = new Position(here.toPosition().x + type.tileWidth() * 16, here.toPosition().y + type.tileHeight() * 16);
        if (!this.openWall || type == UnitType.Protoss_Pylon && !this.pylonWall && !this.pylonWallPiece) {
            return true;
        }
        for (TilePosition tileLayout : this.currentLayout.keySet()) {
            Position centerPiece;
            double wallAngle;
            UnitType typeLayout = this.currentLayout.get(tileLayout);
            if (typeLayout == UnitType.Protoss_Pylon || !(Math.abs(this.chokeAngle - (wallAngle = JBWEB.getAngle(new Pair<Position, Position>(centerPiece = new Position(tileLayout.toPosition().x + typeLayout.tileWidth() * 16, tileLayout.toPosition().y + typeLayout.tileHeight() * 16), centerHere)))) > 20.0)) continue;
            return false;
        }
        return true;
    }

    private boolean placeCheck(UnitType type, TilePosition here) {
        if (type == UnitType.Protoss_Pylon && this.closestStation != null && this.closestStation.getDefenseLocations().contains(here)) {
            return true;
        }
        return !JBWEB.isReserved(here, type.tileWidth(), type.tileHeight()) && JBWEB.isPlaceable(type, here) && (this.openWall || JBWEB.tilesWithinArea(this.area, here, type.tileWidth(), type.tileHeight()) != 0) && (!this.openWall || JBWEB.tilesWithinArea(this.area, here, type.tileWidth(), type.tileHeight()) != 0 || type != UnitType.Protoss_Pylon && (JBWEB.mapBWEM.getMap().getArea(here) == null || this.choke.getAreas().getFirst() == JBWEB.mapBWEM.getMap().getArea(here) || this.choke.getAreas().getSecond() == JBWEB.mapBWEM.getMap().getArea(here)));
    }

    private int gapRight(UnitType parent, int dimR) {
        return parent.tileWidth() * 16 - parent.dimensionLeft() + dimR;
    }

    private int gapLeft(UnitType parent, int dimL) {
        return parent.tileWidth() * 16 - parent.dimensionRight() - 1 + dimL;
    }

    private int gapUp(UnitType parent, int dimU) {
        return parent.tileHeight() * 16 - parent.dimensionDown() - 1 + dimU;
    }

    private int gapDown(UnitType parent, int dimD) {
        return parent.tileHeight() * 16 - parent.dimensionUp() + dimD;
    }

    private boolean terrainTightCheck(WalkPosition w, boolean check) {
        TilePosition t = new TilePosition(w);
        if (!(this.tightType == UnitType.None || !check || w.isValid(JBWEB.game) && JBWEB.game.isWalkable(w))) {
            return true;
        }
        if (!this.requireTight && !JBWEB.isWalkable(t)) {
            return true;
        }
        return JBWEB.isUsed(t, 1, 1).isResourceContainer();
    }

    private List<Pair<Boolean, Integer>> checkVerticalSide(WalkPosition start, boolean check, String gap, int dim, int walkWidth, boolean terrainTight, boolean parentTight, int p1Tight, int p2Tight, boolean checkL, boolean checkR, int vertTight, int horizTight) {
        for (int x = start.x - 1; x < start.x + walkWidth + 1; ++x) {
            WalkPosition w = new WalkPosition(x, start.y);
            TilePosition t = new TilePosition(w);
            UnitType parent = JBWEB.isUsed(t, 1, 1);
            boolean leftCorner = x < start.x;
            boolean rightCorner = x >= start.x + walkWidth;
            int gapValue = 0;
            if (gap.equals("Right")) {
                gapValue = this.gapRight(parent, dim);
            } else if (gap.equals("Left")) {
                gapValue = this.gapLeft(parent, dim);
            } else if (gap.equals("Up")) {
                gapValue = this.gapUp(parent, dim);
            } else if (gap.equals("Down")) {
                gapValue = this.gapDown(parent, dim);
            }
            if (leftCorner || rightCorner) {
                if (!terrainTight && this.terrainTightCheck(w, check) && leftCorner ? this.terrainTightCheck(w, checkL) : this.terrainTightCheck(w, checkR)) {
                    terrainTight = true;
                }
                if (!parentTight && this.rawBuildings.contains((Object)parent) && (!this.requireTight || gapValue < vertTight && (leftCorner ? gapValue < horizTight : gapValue < horizTight))) {
                    parentTight = true;
                }
            } else {
                if (!terrainTight && this.terrainTightCheck(w, check)) {
                    terrainTight = true;
                }
                if (!(parentTight || !this.rawBuildings.contains((Object)parent) || this.requireTight && gapValue >= vertTight)) {
                    parentTight = true;
                }
            }
            if (this.openWall || JBWEB.isWalkable(t) || !(w.getDistance(this.choke.getCenter()) < 4.0)) continue;
            if (w.getDistance(this.choke.getNodePosition(ChokePoint.Node.END1)) < w.getDistance(this.choke.getNodePosition(ChokePoint.Node.END2))) {
                if (p1Tight == 0) {
                    p1Tight = 1;
                }
                if (!terrainTight) continue;
                p1Tight = 2;
                continue;
            }
            if (p2Tight != 0) continue;
            if (p2Tight == 0) {
                p2Tight = 1;
            }
            if (!terrainTight) continue;
            p2Tight = 2;
        }
        ArrayList<Pair<Boolean, Integer>> checkValue = new ArrayList<Pair<Boolean, Integer>>();
        checkValue.add(new Pair<Boolean, Integer>(terrainTight, p1Tight));
        checkValue.add(new Pair<Boolean, Integer>(parentTight, p2Tight));
        return checkValue;
    }

    private List<Pair<Boolean, Integer>> checkHorizontalSide(WalkPosition start, boolean check, String gap, int dim, int walkHeight, boolean terrainTight, boolean parentTight, int p1Tight, int p2Tight, boolean checkU, boolean checkD, int vertTight, int horizTight) {
        for (int y = start.y - 1; y < start.y + walkHeight + 1; ++y) {
            WalkPosition w = new WalkPosition(start.x, y);
            TilePosition t = new TilePosition(w);
            UnitType parent = JBWEB.isUsed(t, 1, 1);
            boolean topCorner = y < start.y;
            boolean downCorner = y >= start.y + walkHeight;
            int gapValue = 0;
            if (gap.equals("Right")) {
                gapValue = this.gapRight(parent, dim);
            } else if (gap.equals("Left")) {
                gapValue = this.gapLeft(parent, dim);
            } else if (gap.equals("Up")) {
                gapValue = this.gapUp(parent, dim);
            } else if (gap.equals("Down")) {
                gapValue = this.gapDown(parent, dim);
            }
            if (topCorner || downCorner) {
                if (!terrainTight && this.terrainTightCheck(w, check) && topCorner ? this.terrainTightCheck(w, checkU) : this.terrainTightCheck(w, checkD)) {
                    terrainTight = true;
                }
                if (!parentTight && this.rawBuildings.contains((Object)parent) && (!this.requireTight || gapValue < horizTight && (topCorner ? gapValue < vertTight : gapValue < vertTight))) {
                    parentTight = true;
                }
            } else {
                if (!terrainTight && this.terrainTightCheck(w, check)) {
                    terrainTight = true;
                }
                if (!(parentTight || !this.rawBuildings.contains((Object)parent) || this.requireTight && gapValue >= horizTight)) {
                    parentTight = true;
                }
            }
            if (this.openWall || JBWEB.isWalkable(t) || !(w.getDistance(this.choke.getCenter()) < 4.0)) continue;
            if (w.getDistance(this.choke.getNodePosition(ChokePoint.Node.END1)) < w.getDistance(this.choke.getNodePosition(ChokePoint.Node.END2))) {
                if (p1Tight == 0) {
                    p1Tight = 1;
                }
                if (!terrainTight) continue;
                p1Tight = 2;
                continue;
            }
            if (p2Tight != 0) continue;
            if (p2Tight == 0) {
                p2Tight = 1;
            }
            if (!terrainTight) continue;
            p2Tight = 2;
        }
        ArrayList<Pair<Boolean, Integer>> checkValue = new ArrayList<Pair<Boolean, Integer>>();
        checkValue.add(new Pair<Boolean, Integer>(terrainTight, p1Tight));
        checkValue.add(new Pair<Boolean, Integer>(parentTight, p2Tight));
        return checkValue;
    }

    private boolean tightCheck(UnitType type, TilePosition here) {
        if (type == UnitType.Protoss_Pylon && !this.pylonWall && !this.pylonWallPiece) {
            return true;
        }
        int dimL = type.tileWidth() * 16 - type.dimensionLeft();
        int dimR = type.tileWidth() * 16 - type.dimensionRight() - 1;
        int dimU = type.tileHeight() * 16 - type.dimensionUp();
        int dimD = type.tileHeight() * 16 - type.dimensionDown() - 1;
        int walkHeight = type.tileHeight() * 4;
        int walkWidth = type.tileWidth() * 4;
        int vertTight = this.tightType == UnitType.None ? 32 : this.tightType.height();
        int horizTight = this.tightType == UnitType.None ? 32 : this.tightType.width();
        boolean checkL = dimL < horizTight;
        boolean checkR = dimR < horizTight;
        boolean checkU = dimU < vertTight;
        boolean checkD = dimD < vertTight;
        int extraL = this.pylonWall || !this.requireTight ? 0 : Math.max(0, (horizTight - dimL) / 8);
        int extraR = this.pylonWall || !this.requireTight ? 0 : Math.max(0, (horizTight - dimR) / 8);
        int extraU = this.pylonWall || !this.requireTight ? 0 : Math.max(0, (vertTight - dimU) / 8);
        int extraD = this.pylonWall || !this.requireTight ? 0 : Math.max(0, (vertTight - dimD) / 8);
        WalkPosition left = new WalkPosition(here.x - (1 + extraL), here.y);
        WalkPosition right = new WalkPosition(here.x + walkWidth + extraR, here.y);
        WalkPosition up = new WalkPosition(here.x, here.y - (1 + extraU));
        WalkPosition down = new WalkPosition(here.x, here.y + walkHeight + extraD);
        boolean firstBuilding = this.currentLayout.size() == 0;
        boolean lastBuilding = this.currentLayout.size() == this.rawBuildings.size() - 1;
        boolean terrainTight = false;
        boolean parentTight = false;
        int p1Tight = 0;
        int p2Tight = 0;
        List<Pair<Boolean, Integer>> v = this.checkVerticalSide(up, checkU, "Up", dimR, walkWidth, terrainTight, parentTight, p1Tight, p2Tight, checkL, checkR, vertTight, horizTight);
        v = this.checkVerticalSide(down, checkD, "Down", dimL, walkWidth, v.get(0).getFirst(), v.get(1).getFirst(), v.get(0).getSecond(), v.get(1).getSecond(), checkL, checkR, vertTight, horizTight);
        v = this.checkHorizontalSide(left, checkL, "Left", dimU, walkHeight, v.get(0).getFirst(), v.get(1).getFirst(), v.get(0).getSecond(), v.get(1).getSecond(), checkU, checkD, vertTight, horizTight);
        v = this.checkHorizontalSide(right, checkR, "Right", dimD, walkHeight, v.get(0).getFirst(), v.get(1).getFirst(), v.get(0).getSecond(), v.get(1).getSecond(), checkU, checkD, vertTight, horizTight);
        terrainTight = v.get(0).getFirst();
        parentTight = v.get(1).getFirst();
        p1Tight = v.get(0).getSecond();
        p2Tight = v.get(1).getSecond();
        if (!this.openWall) {
            if (!lastBuilding && !firstBuilding) {
                return parentTight;
            }
            if (firstBuilding) {
                return terrainTight && p1Tight != 1 && p2Tight != 1;
            }
            if (lastBuilding) {
                return terrainTight && parentTight && p1Tight != 1 && p2Tight != 1;
            }
        } else if (this.openWall) {
            return terrainTight || parentTight;
        }
        return false;
    }

    private boolean spawnCheck(UnitType type, TilePosition here) {
        this.checkPathPoints();
        Position startCenter = new Position(this.pathStart.toPosition().x + 16, this.pathStart.toPosition().y + 16);
        Position endCenter = new Position(this.pathEnd.toPosition().x + 16, this.pathEnd.toPosition().y + 16);
        return true;
    }

    boolean wallWalkable(TilePosition tile) {
        return !(!tile.isValid(JBWEB.game) || JBWEB.mapBWEM.getMap().getArea(tile) != null && JBWEB.mapBWEM.getMap().getArea(tile) != this.area && this.accessibleNeighbors.contains(JBWEB.mapBWEM.getMap().getArea(tile)) || JBWEB.isReserved(tile, 1, 1) || !JBWEB.isWalkable(tile) || this.allowLifted && JBWEB.isUsed(tile, 1, 1) != UnitType.Terran_Barracks && JBWEB.isUsed(tile, 1, 1) != UnitType.None || !this.allowLifted && JBWEB.isUsed(tile, 1, 1) != UnitType.None && JBWEB.isUsed(tile, 1, 1) != UnitType.Zerg_Larva) && (!this.openWall || !(tile.getDistance(this.pathEnd) - 64.0 > this.pathDist / 32.0));
    }

    private void initialize() {
        ArrayList<Integer> indexes;
        ArrayList<UnitType> tmpList;
        Walls.failedPlacement = 0;
        Walls.failedAngle = 0;
        Walls.failedPath = 0;
        Walls.failedTight = 0;
        Walls.failedSpawn = 0;
        Walls.failedPower = 0;
        Walls.failedNotable = 0;
        Walls.failedValid = 0;
        this.centroid = Position.Invalid;
        this.opening = TilePosition.Invalid;
        this.pathStart = TilePosition.Invalid;
        this.pathEnd = TilePosition.Invalid;
        this.initialPathStart = TilePosition.Invalid;
        this.initialPathEnd = TilePosition.Invalid;
        this.bestWallScore = 0.0;
        this.accessibleNeighbors = this.area.getAccessibleNeighbors();
        this.chokeAngle = JBWEB.getAngle(new Pair<Position, Position>(new Position(this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END1).toPosition().x + 4, this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END1).toPosition().y + 4), new Position(this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END2).toPosition().x + 4, this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END2).toPosition().y + 4)));
        int count = 0;
        for (UnitType rawBuilding : this.rawBuildings) {
            if (rawBuilding != UnitType.Protoss_Pylon) continue;
            ++count;
        }
        this.pylonWall = count > 1;
        this.creationStart = new TilePosition(this.choke.getCenter());
        this.base = !this.area.getBases().isEmpty() ? this.area.getBases().get(0) : null;
        this.flatRamp = JBWEB.game.isBuildable(new TilePosition(this.choke.getCenter()));
        this.closestStation = Stations.getClosestStation(new TilePosition(this.choke.getCenter()));
        Position p1 = this.choke.getNodePosition(ChokePoint.Node.END1).toPosition();
        Position p2 = this.choke.getNodePosition(ChokePoint.Node.END2).toPosition();
        this.pylonWallPiece = Math.abs(p1.x - p2.x) * 8 >= 320 || Math.abs(p1.y - p2.y) * 8 >= 256 || p1.getDistance(p2) * 8.0 >= 288.0;
        Path path = new Path();
        this.initializePathPoints();
        this.checkPathPoints();
        path.createUnitPath(new Position(this.pathStart), new Position(this.pathEnd), this);
        this.pathDist = path.getDistance();
        if (!path.isReachable()) {
            return;
        }
        if (this.base != null) {
            this.notableLocations.add(this.base.getCenter());
            this.notableLocations.add(this.initialPathStart.toPosition().add(new Position(16, 16)));
            this.notableLocations.add(new Position((this.base.getCenter().x + this.initialPathStart.toPosition().x) / 2, (this.base.getCenter().y + this.initialPathStart.toPosition().y) / 2));
        } else {
            this.notableLocations.add(new Position(this.initialPathStart.toPosition().x + 16, this.initialPathStart.toPosition().y + 16));
            this.notableLocations.add(new Position(this.initialPathEnd.toPosition().x + 16, this.initialPathEnd.toPosition().y + 16));
        }
        if (this.rawBuildings.contains((Object)UnitType.Protoss_Pylon)) {
            tmpList = new ArrayList<UnitType>();
            indexes = new ArrayList<Integer>();
            for (UnitType rawBuilding : this.rawBuildings) {
                if (rawBuilding != UnitType.Protoss_Pylon) continue;
                tmpList.add(rawBuilding);
                indexes.add(this.rawBuildings.indexOf((Object)rawBuilding));
            }
            for (Integer i : indexes) {
                this.rawBuildings.remove(i);
            }
            Collections.sort(this.rawBuildings);
            this.rawBuildings.addAll(tmpList);
        } else if (this.rawBuildings.contains((Object)UnitType.Zerg_Hatchery)) {
            tmpList = new ArrayList();
            indexes = new ArrayList();
            for (UnitType rawBuilding : this.rawBuildings) {
                if (rawBuilding != UnitType.Zerg_Hatchery) continue;
                tmpList.add(rawBuilding);
                indexes.add(this.rawBuildings.indexOf((Object)rawBuilding));
            }
            for (Integer i : indexes) {
                this.rawBuildings.remove(i);
            }
            Collections.sort(this.rawBuildings);
            tmpList.addAll(this.rawBuildings);
            this.rawBuildings = tmpList;
        } else {
            Collections.sort(this.rawBuildings);
        }
        if (this.openWall && this.base != null) {
            Position startCenter = new Position(this.creationStart.toPosition().x + 16, this.creationStart.toPosition().y + 16);
            double distBest = Double.MAX_VALUE;
            Position moveTowards = new Position((this.initialPathStart.toPosition().x + this.base.getCenter().x) / 2, (this.initialPathStart.toPosition().y + this.base.getCenter().x) / 2);
            while (startCenter.getDistance(moveTowards) > 320.0) {
                TilePosition initialStart = this.creationStart;
                block6: for (int x = initialStart.x - 1; x <= initialStart.x + 1; ++x) {
                    for (int y = initialStart.y - 1; y <= initialStart.y + 1; ++y) {
                        Position p;
                        double dist;
                        TilePosition t = new TilePosition(x, y);
                        if (!t.isValid(JBWEB.game) || !((dist = (p = new Position(t.toPosition().x + 16, t.toPosition().y + 16)).getDistance(moveTowards)) < distBest)) continue;
                        distBest = dist;
                        this.creationStart = t;
                        startCenter = p;
                        this.movedStart = true;
                        continue block6;
                    }
                }
            }
        }
        while (this.openWall && !JBWEB.game.isBuildable(this.creationStart)) {
            double distBest = Double.MAX_VALUE;
            TilePosition initialStart = this.creationStart;
            for (int x = initialStart.x - 1; x <= initialStart.x + 1; ++x) {
                for (int y = initialStart.y - 1; y <= initialStart.y + 1; ++y) {
                    Position p;
                    double dist;
                    TilePosition t = new TilePosition(x, y);
                    if (!t.isValid(JBWEB.game) || !((dist = (p = new Position(t)).getDistance(new Position(this.area.getTop()))) < distBest)) continue;
                    distBest = dist;
                    this.creationStart = t;
                    this.movedStart = true;
                }
            }
        }
    }

    private void initializePathPoints() {
        boolean isNatural;
        Pair<Position, Position> line = new Pair<Position, Position>(new Position(this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END1).toPosition().x + 4, this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END1).toPosition().y + 4), new Position(this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END2).toPosition().y + 4, this.choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END2).toPosition().y + 4));
        Pair<Position, Position> perpLine = this.openWall ? JBWEB.perpendicularLine(line, 160.0) : JBWEB.perpendicularLine(line, 96.0);
        Position lineStart = perpLine.getFirst().getDistance(new Position(this.area.getTop())) > perpLine.getSecond().getDistance(new Position(this.area.getTop())) ? perpLine.getSecond() : perpLine.getFirst();
        Position lineEnd = perpLine.getFirst().getDistance(new Position(this.area.getTop())) > perpLine.getSecond().getDistance(new Position(this.area.getTop())) ? perpLine.getFirst() : perpLine.getSecond();
        boolean isMain = this.closestStation != null && this.closestStation.isMain();
        boolean bl = isNatural = this.closestStation != null && this.closestStation.isNatural();
        if (isNatural) {
            Station closestMain = Stations.getClosestMainStation(new TilePosition(this.choke.getCenter()));
            this.initialPathStart = closestMain != null ? new TilePosition(JBWEB.mapBWEM.getMap().getPath(this.closestStation.getBWEMBase().getCenter(), closestMain.getBWEMBase().getCenter()).get(0).getCenter()) : new TilePosition(lineStart);
            this.initialPathEnd = new TilePosition(lineEnd);
        } else if (isMain) {
            this.initialPathEnd = new TilePosition((this.choke.getCenter().toPosition().x + lineEnd.x) / 2, (this.choke.getCenter().toPosition().y + lineEnd.y) / 2);
            this.initialPathStart = new TilePosition((this.area.getTop().toPosition().x + lineStart.x) / 2, (this.area.getTop().toPosition().y + lineStart.y) / 2);
        } else {
            this.initialPathStart = new TilePosition(lineStart);
            this.initialPathEnd = new TilePosition(lineEnd);
        }
        this.pathStart = this.initialPathStart;
        this.pathEnd = this.initialPathEnd;
    }

    private boolean notValidPathPoint(TilePosition testTile) {
        return !testTile.isValid(JBWEB.game) || !JBWEB.isWalkable(testTile) || JBWEB.isReserved(testTile, 1, 1) || JBWEB.isUsed(testTile, 1, 1) != UnitType.None;
    }

    private void checkPathPoints() {
        double dist;
        TilePosition t;
        int y;
        int x;
        double distBest = 0.0;
        if (this.notValidPathPoint(this.pathStart)) {
            for (x = this.initialPathStart.x - 4; x < this.initialPathStart.x + 4; ++x) {
                for (y = this.initialPathStart.y - 4; y < this.initialPathStart.y + 4; ++y) {
                    t = new TilePosition(x, y);
                    dist = t.getDistance(this.initialPathEnd);
                    if (this.notValidPathPoint(t) || !(dist > distBest)) continue;
                    this.pathStart = t;
                    distBest = dist;
                }
            }
        }
        distBest = 0.0;
        if (this.notValidPathPoint(this.pathEnd)) {
            for (x = this.initialPathEnd.x - 4; x < this.initialPathEnd.x + 4; ++x) {
                for (y = this.initialPathEnd.y - 4; y < this.initialPathEnd.y + 4; ++y) {
                    t = new TilePosition(x, y);
                    dist = t.getDistance(this.initialPathStart);
                    if (this.notValidPathPoint(t) || !(dist > distBest)) continue;
                    this.pathEnd = t;
                    distBest = dist;
                }
            }
        }
    }

    private boolean nextPermutationRawBuildings(int start, int end) {
        int last;
        int length = end - start + 1;
        if (length <= 1) {
            return false;
        }
        for (last = length - 2; last >= 0 && this.rawBuildings.get((int)last).id <= this.rawBuildings.get((int)(last + 1)).id; --last) {
        }
        if (last < 0) {
            return false;
        }
        int nextGreater = length - 1;
        for (int i = length - 1; i > last; --i) {
            if (this.rawBuildings.get((int)i).id <= this.rawBuildings.get((int)last).id) continue;
            nextGreater = i;
            break;
        }
        int left = nextGreater;
        int right = last;
        UnitType newLeft = this.rawBuildings.get(right);
        UnitType newRight = this.rawBuildings.get(left);
        this.rawBuildings.set(left, newLeft);
        this.rawBuildings.set(right, newRight);
        left = last + 1;
        right = length - 1;
        while (left < right) {
            newLeft = this.rawBuildings.get(right);
            newRight = this.rawBuildings.get(left);
            this.rawBuildings.set(left++, newLeft);
            this.rawBuildings.set(right--, newRight);
        }
        ++Walls.permutations;
        return true;
    }

    private void addPieces() {
        do {
            this.currentLayout.clear();
            this.typeIterator = this.rawBuildings.listIterator();
            this.addNextPiece(this.creationStart);
        } while (JBWEB.game.self().getRace() != Race.Zerg ? this.nextPermutationRawBuildings(0, this.rawBuildings.indexOf((Object)UnitType.Protoss_Pylon)) : this.nextPermutationRawBuildings(this.rawBuildings.indexOf((Object)UnitType.Zerg_Hatchery), this.rawBuildings.size() - 1));
        for (TilePosition tile : this.bestLayout.keySet()) {
            UnitType type = this.bestLayout.get(tile);
            this.addToWallPieces(tile, type);
            JBWEB.addReserve(tile, type.tileWidth(), type.tileHeight());
            JBWEB.addUsed(tile, type);
        }
    }

    private void addNextPiece(TilePosition start) {
        boolean isFirstPiece = this.typeIterator.nextIndex() == 0;
        UnitType type = this.typeIterator.next();
        this.typeIterator.previous();
        int radius = this.openWall || isFirstPiece ? 8 : 4;
        for (int x = start.x - radius; x < start.x + radius; ++x) {
            for (int y = start.y - radius; y < start.y + radius; ++y) {
                double m2;
                double m1;
                double dist;
                TilePosition tile = new TilePosition(x, y);
                ++Walls.totalEvaluated;
                Walls.minXEvaluated = Math.min(Walls.minXEvaluated, x);
                Walls.minYEvaluated = Math.min(Walls.minYEvaluated, y);
                Walls.maxXEvaluated = Math.max(Walls.maxXEvaluated, x);
                Walls.maxYEvaluated = Math.max(Walls.maxYEvaluated, y);
                if (!tile.isValid(JBWEB.game)) {
                    ++Walls.failedValid;
                    continue;
                }
                Position center = tile.toPosition().add(new Position(type.tileWidth() * 16, type.tileHeight() * 16));
                Position closestGeo = JBWEB.getClosestChokeTile(this.choke, center);
                if (this.openWall) {
                    Position closestNotable = Position.Invalid;
                    double closestNotableDist = Double.MAX_VALUE;
                    for (Position pos : this.notableLocations) {
                        double dist2 = pos.getDistance(center);
                        if (!(dist2 < closestNotableDist)) continue;
                        closestNotable = pos;
                        closestNotableDist = dist2;
                    }
                    if (center.getDistance(closestNotable) >= 256.0 || center.getDistance(closestNotable) >= closestGeo.getDistance(closestNotable) + 48.0) {
                        ++Walls.failedNotable;
                    }
                }
                if (!this.openWall && this.flatRamp && (dist = Math.min(m1 = Math.min(new Position(tile).getDistance(new Position(this.choke.getCenter())), new Position(new TilePosition(tile.toPosition().x + type.tileWidth(), tile.toPosition().y)).getDistance(new Position(this.choke.getCenter()))), m2 = Math.min(new Position(new TilePosition(tile.toPosition().x, tile.toPosition().y + type.tileHeight())).getDistance(new Position(this.choke.getCenter())), new Position(new TilePosition(tile.toPosition().x + type.tileWidth(), tile.toPosition().y + type.tileHeight())).getDistance(new Position(this.choke.getCenter()))))) < 64.0) {
                    ++Walls.failedSeal;
                    continue;
                }
                if (!this.powerCheck(type, tile)) {
                    ++Walls.failedPower;
                    continue;
                }
                if (!this.angleCheck(type, tile)) {
                    ++Walls.failedAngle;
                    continue;
                }
                if (!this.placeCheck(type, tile)) {
                    ++Walls.failedPlacement;
                    continue;
                }
                if (!this.tightCheck(type, tile)) {
                    ++Walls.failedTight;
                    continue;
                }
                if (!this.spawnCheck(type, tile)) {
                    ++Walls.failedSpawn;
                    continue;
                }
                this.currentLayout.put(tile, type);
                JBWEB.addUsed(tile, type);
                this.typeIterator.next();
                if (!this.typeIterator.hasNext()) {
                    this.scoreWall();
                } else if (this.openWall) {
                    this.addNextPiece(start);
                } else {
                    this.addNextPiece(tile);
                }
                if (this.typeIterator.nextIndex() > 0) {
                    this.typeIterator.previous();
                }
                this.currentLayout.remove(tile);
                JBWEB.removeUsed(tile, type.tileWidth(), type.tileHeight());
            }
        }
    }

    private void addDefenses() {
        double dist;
        Position closestGeo;
        Position center;
        if (this.bestLayout.isEmpty()) {
            return;
        }
        double furthest = 0.0;
        for (TilePosition tile : this.largeTiles) {
            center = new Position(tile.toPosition().x + 64, tile.toPosition().y + 48);
            closestGeo = JBWEB.getClosestChokeTile(this.choke, center);
            dist = center.getDistance(closestGeo);
            if (!(dist > furthest)) continue;
            furthest = dist;
        }
        for (TilePosition tile : this.mediumTiles) {
            center = new Position(tile.toPosition().x + 48, tile.toPosition().y + 32);
            closestGeo = JBWEB.getClosestChokeTile(this.choke, center);
            dist = center.getDistance(closestGeo);
            if (!(dist > furthest)) continue;
            furthest = dist;
        }
        if (this.pylonWall) {
            for (TilePosition tile : this.smallTiles) {
                center = new Position(tile.toPosition().x + 32, tile.toPosition().y + 32);
                closestGeo = JBWEB.getClosestChokeTile(this.choke, center);
                dist = center.getDistance(closestGeo);
                if (!(dist > furthest)) continue;
                furthest = dist;
            }
        }
        Station closestStation = Stations.getClosestStation(new TilePosition(this.choke.getCenter()));
        for (UnitType building : this.rawDefenses) {
            TilePosition start = new TilePosition(this.centroid);
            int width = building.tileWidth() * 32;
            int height = building.tileHeight() * 32;
            Position openingCenter = new Position(this.opening.toPosition().x + 16, this.opening.toPosition().y + 16);
            double arbitraryCloseMetric = JBWEB.game.self().getRace() == Race.Zerg ? 32.0 : 160.0;
            double scoreBest = Double.MAX_VALUE;
            TilePosition tileBest = TilePosition.Invalid;
            for (int x = start.x - 12; x <= start.x + 12; ++x) {
                for (int y = start.y - 12; y <= start.y + 12; ++y) {
                    double score;
                    boolean tooFar;
                    TilePosition t = new TilePosition(x, y);
                    Position center2 = new Position(t.toPosition().x + width / 2, t.toPosition().y + height / 2);
                    Position closestGeo2 = JBWEB.getClosestChokeTile(this.choke, center2);
                    boolean overlapsDefense = closestStation != null && closestStation.getDefenseLocations().contains(t) && this.defenses.contains(t);
                    double dist2 = center2.getDistance(closestGeo2);
                    boolean tooClose = dist2 < furthest || center2.getDistance(openingCenter) < arbitraryCloseMetric;
                    boolean bl = tooFar = center2.getDistance(this.centroid) > 200.0;
                    if (!overlapsDefense && (!t.isValid(JBWEB.game) || JBWEB.isReserved(t, building.tileWidth(), building.tileHeight()) || !JBWEB.isPlaceable(building, t) || JBWEB.tilesWithinArea(this.area, t, building.tileWidth(), building.tileHeight()) == 0 || tooClose || tooFar) || !((score = dist2 + center2.getDistance(openingCenter)) < scoreBest)) continue;
                    JBWEB.addUsed(t, building);
                    Path pathOut = this.findPathOut();
                    if (!this.openWall || pathOut.isReachable()) {
                        tileBest = t;
                        scoreBest = score;
                    }
                    JBWEB.removeUsed(t, building.tileWidth(), building.tileHeight());
                }
            }
            if (!tileBest.isValid(JBWEB.game)) break;
            this.defenses.add(tileBest);
            JBWEB.addReserve(tileBest, building.tileWidth(), building.tileHeight());
        }
    }

    private void scoreWall() {
        double score;
        Path pathOut = this.findPathOut();
        if (this.openWall && !pathOut.isReachable() || !this.openWall && pathOut.isReachable()) {
            ++Walls.failedPath;
            return;
        }
        double dist = 1.0;
        Position optimalChokeTile = this.pathStart.getDistance(new TilePosition(this.choke.getNodePosition(ChokePoint.Node.END1))) < this.pathStart.getDistance(new TilePosition(this.choke.getNodePosition(ChokePoint.Node.END2))) ? new Position(this.choke.getNodePosition(ChokePoint.Node.END1)) : new Position(this.choke.getNodePosition(ChokePoint.Node.END2));
        for (TilePosition tile : this.currentLayout.keySet()) {
            UnitType type = this.currentLayout.get(tile);
            Position center = new Position(tile.toPosition().x + type.tileWidth() * 16, tile.toPosition().y + type.tileHeight() * 16);
            double chokeDist = optimalChokeTile.getDistance(center);
            if (type == UnitType.Protoss_Pylon && !this.pylonWall && !this.pylonWallPiece) {
                dist += -chokeDist;
                continue;
            }
            dist += chokeDist;
        }
        Position currentCentroid = this.findCentroid();
        Position currentOpening = new Position(this.findOpening().toPosition().x + 16, this.findOpening().toPosition().y + 16);
        double d = score = !this.openWall ? dist : 1.0 / dist;
        if (score > this.bestWallScore) {
            this.bestLayout = this.currentLayout;
            this.bestWallScore = score;
        }
    }

    private void cleanup() {
        if (this.openWall && !this.bestLayout.isEmpty()) {
            Path currentPath = this.findPathOut();
            for (TilePosition tile : currentPath.getTiles()) {
                JBWEB.addReserve(tile, 1, 1);
            }
        }
        for (TilePosition tile : this.smallTiles) {
            JBWEB.removeUsed(tile, 2, 2);
        }
        for (TilePosition tile : this.mediumTiles) {
            JBWEB.removeUsed(tile, 3, 2);
        }
        for (TilePosition tile : this.largeTiles) {
            JBWEB.removeUsed(tile, 4, 3);
        }
        for (TilePosition tile : this.defenses) {
            JBWEB.removeUsed(tile, 2, 2);
        }
    }

    public int getGroundDefenseCount() {
        int count = 0;
        for (TilePosition defense : this.defenses) {
            UnitType type = JBWEB.isUsed(defense, 1, 1);
            if (type != UnitType.Protoss_Photon_Cannon && type != UnitType.Zerg_Sunken_Colony && type != UnitType.Terran_Bunker) continue;
            ++count;
        }
        return count;
    }

    public int getAirDefenseCount() {
        int count = 0;
        for (TilePosition defense : this.defenses) {
            UnitType type = JBWEB.isUsed(defense, 1, 1);
            if (type != UnitType.Protoss_Photon_Cannon && type != UnitType.Zerg_Spore_Colony && type != UnitType.Terran_Missile_Turret) continue;
            ++count;
        }
        return count;
    }

    public void draw() {
        boolean drawAngles;
        ArrayList<Position> anglePositions = new ArrayList<Position>();
        Color color = JBWEB.game.self().getColor();
        Text textColor = color.id == 185 ? Text.DarkGreen : JBWEB.game.self().getTextColor();
        boolean drawBoxes = true;
        if (drawBoxes) {
            for (TilePosition tilePosition : this.smallTiles) {
                JBWEB.game.drawBoxMap(new Position(tilePosition), new Position(tilePosition.toPosition().x + 65, tilePosition.toPosition().y + 65), color);
                JBWEB.game.drawTextMap(new Position(tilePosition.toPosition().x + 4, tilePosition.toPosition().y + 4), "%cW", JBWEB.game.self().getTextColor());
                anglePositions.add(new Position(tilePosition.toPosition().x + 32, tilePosition.toPosition().y + 32));
            }
            for (TilePosition tilePosition : this.mediumTiles) {
                JBWEB.game.drawBoxMap(new Position(tilePosition), new Position(tilePosition.toPosition().x + 97, tilePosition.toPosition().y + 65), color);
                JBWEB.game.drawTextMap(new Position(tilePosition.toPosition().x + 4, tilePosition.toPosition().y + 4), "%cW", JBWEB.game.self().getTextColor());
                anglePositions.add(new Position(tilePosition.toPosition().x + 48, tilePosition.toPosition().y + 32));
            }
            for (TilePosition tilePosition : this.largeTiles) {
                JBWEB.game.drawBoxMap(new Position(tilePosition), new Position(tilePosition.toPosition().x + 129, tilePosition.toPosition().y + 97), color);
                JBWEB.game.drawTextMap(new Position(tilePosition.toPosition().x + 4, tilePosition.toPosition().y + 4), "%cW", JBWEB.game.self().getTextColor());
                anglePositions.add(new Position(tilePosition.toPosition().x + 64, tilePosition.toPosition().y + 48));
            }
            for (TilePosition tilePosition : this.defenses) {
                JBWEB.game.drawBoxMap(new Position(tilePosition), new Position(tilePosition.toPosition().x + 65, tilePosition.toPosition().y + 65), color);
                JBWEB.game.drawTextMap(new Position(tilePosition.toPosition().x + 4, tilePosition.toPosition().y + 4), "%cW", JBWEB.game.self().getTextColor());
            }
        }
        if (drawAngles = false) {
            for (Position pos1 : anglePositions) {
                for (Position pos2 : anglePositions) {
                    if (pos1.equals(pos2)) continue;
                    JBWEB.game.drawLineMap(pos1, pos2, color);
                    JBWEB.game.drawTextMap(new Position((pos1.x + pos2.x) / 2, (pos1.y + pos2.y) / 2), "%c%.2f", textColor);
                }
            }
        }
        JBWEB.game.drawBoxMap(new Position(this.opening), new Position(this.opening.toPosition().x + 33, this.opening.toPosition().y + 33), color, true);
        Position position = this.choke.getNodePosition(ChokePoint.Node.END1).toPosition();
        Position p2 = this.choke.getNodePosition(ChokePoint.Node.END2).toPosition();
        JBWEB.game.drawTextMap(new Position(this.choke.getCenter()), "%c%.2f", Text.Grey);
        JBWEB.game.drawLineMap(new Position(position), new Position(p2), Color.Grey);
        JBWEB.game.drawCircleMap(new Position(this.pathStart), 6, Color.Black, true);
        JBWEB.game.drawCircleMap(new Position(this.pathEnd), 6, Color.White, true);
    }
}

