/*
 * Decompiled with CFR 0.152.
 */
package Micro.Coordination.Pushing;

import Debugging.Visualizations.Rendering.DrawMap$;
import Mathematics.Maff$;
import Mathematics.Physics.Force;
import Mathematics.Physics.ForceMath$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Point;
import Mathematics.Points.Tile;
import Mathematics.Shapes.Circle$;
import Micro.Coordination.Pushing.Push;
import Micro.Coordination.Pushing.TrafficPriority;
import Micro.Heuristics.Potential$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import bwapi.Color;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0003\u0007\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003!\u0011!!\u0003A!A!\u0002\u0013)\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011E\u0002!\u0011!Q\u0001\nIBQ!\u0010\u0001\u0005\u0002yBq\u0001\u0012\u0001C\u0002\u0013\u0005S\t\u0003\u0004V\u0001\u0001\u0006IA\u0012\u0005\u0006-\u0002!\te\u0016\u0005\u0006G\u0002!\t\u0005\u001a\u0002\r\u0007&\u00148-\u001e7beB+8\u000f\u001b\u0006\u0003\u001b9\tq\u0001U;tQ&twM\u0003\u0002\u0010!\u0005a1i\\8sI&t\u0017\r^5p]*\t\u0011#A\u0003NS\u000e\u0014xn\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011\u0001D\u0005\u0003;1\u0011A\u0001U;tQ\u0006A\u0001O]5pe&$\u00180F\u0001!!\tY\u0012%\u0003\u0002#\u0019\tyAK]1gM&\u001c\u0007K]5pe&$\u00180A\u0005qe&|'/\u001b;zA\u000511-\u001a8uKJ\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\rA{\u0017N\u001c;t\u0015\u0005Q\u0013aC'bi\",W.\u0019;jGNL!\u0001L\u0014\u0003\u000bAK\u00070\u001a7\u0002\rI\fG-[;t!\t)r&\u0003\u00021-\t1Ai\\;cY\u0016\f1b\u001c:jO&t\u0017\r^8sgB\u0019QcM\u001b\n\u0005Q2\"A\u0003\u001fsKB,\u0017\r^3e}A\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\t+:LG/\u00138g_*\t!(\u0001\u0006Qe>D\u0018PQ<ba&L!\u0001P\u001c\u0003!\u0019\u0013\u0018.\u001a8eYf,f.\u001b;J]\u001a|\u0017A\u0002\u001fj]&$h\bF\u0003@\u0001\u0006\u00135\t\u0005\u0002\u001c\u0001!)aD\u0002a\u0001A!)AE\u0002a\u0001K!)QF\u0002a\u0001]!)\u0011G\u0002a\u0001e\u0005)A/\u001b7fgV\ta\tE\u0002H\u001fJs!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-\u0013\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\tqe#A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011aJ\u0006\t\u0003MMK!\u0001V\u0014\u0003\tQKG.Z\u0001\u0007i&dWm\u001d\u0011\u0002\u000b\u0019|'oY3\u0015\u0005a\u000b\u0007cA\u000bZ7&\u0011!L\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q{V\"A/\u000b\u0005yK\u0013a\u0002)isNL7m]\u0005\u0003Av\u0013QAR8sG\u0016DQAY\u0005A\u0002U\n\u0011B]3dSBLWM\u001c;\u0002\t\u0011\u0014\u0018m\u001e\u000b\u0002KB\u0011QCZ\u0005\u0003OZ\u0011A!\u00168ji\u0002")
public class CircularPush
implements Push {
    private final TrafficPriority priority;
    private final Pixel center;
    private final double radius;
    private final Seq<FriendlyUnitInfo> originators;
    private final Seq<Tile> tiles;
    private final String toString;

    @Override
    public void drawTiles() {
        Push.drawTiles$(this);
    }

    @Override
    public void drawLabel(Pixel center) {
        Push.drawLabel$(this, center);
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public void Micro$Coordination$Pushing$Push$_setter_$toString_$eq(String x$1) {
        this.toString = x$1;
    }

    @Override
    public TrafficPriority priority() {
        return this.priority;
    }

    @Override
    public Seq<Tile> tiles() {
        return this.tiles;
    }

    @Override
    public Option<Force> force(FriendlyUnitInfo recipient) {
        if (this.originators.contains(recipient)) {
            return None$.MODULE$;
        }
        Pixel target = recipient.pixel();
        double distance = target.pixelDistance(this.center);
        Pixel pixel = this.center;
        if (pixel != null && ((Object)pixel).equals(target)) {
            return new Some<Force>(Potential$.MODULE$.towards(recipient, recipient.agent().safety()));
        }
        double magnitude = Maff$.MODULE$.nanToZero((this.radius - distance) / this.radius);
        double magnitudeClamped = Maff$.MODULE$.clamp(magnitude, 0.0, 1.0);
        if (magnitudeClamped <= 0.0) {
            return None$.MODULE$;
        }
        return new Some<Force>(ForceMath$.MODULE$.fromPixels(this.center, target, magnitudeClamped));
    }

    @Override
    public void draw() {
        Color color = this.priority().color();
        this.drawLabel(this.center);
        DrawMap$.MODULE$.circle(this.center, (int)this.radius, color, DrawMap$.MODULE$.circle$default$4());
    }

    public static final /* synthetic */ Tile $anonfun$tiles$1(Tile eta$0$1$1, Point point) {
        return eta$0$1$1.add(point);
    }

    public CircularPush(TrafficPriority priority, Pixel center, double radius, Seq<FriendlyUnitInfo> originators) {
        this.priority = priority;
        this.center = center;
        this.radius = radius;
        this.originators = originators;
        Push.$init$(this);
        this.tiles = Circle$.MODULE$.apply(Maff$.MODULE$.div32((int)radius + 31)).view().map(arg_0 -> CircularPush.$anonfun$tiles$1(center.tile(), arg_0), SeqView$.MODULE$.canBuildFrom());
    }
}

