/*
 * Decompiled with CFR 0.152.
 */
package Micro.Agency;

import Information.Geography.Types.Base;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Points$;
import Mathematics.Points.Tile;
import Micro.Agency.AttackDelay$;
import Micro.Coordination.Pathing.MicroPathing$;
import Micro.Coordination.Pushing.CircularPush;
import Micro.Coordination.Pushing.Push;
import Micro.Coordination.Pushing.TrafficPriorities$;
import Micro.Coordination.Pushing.TrafficPriority;
import Micro.Coordination.Pushing.UnitLinearGroundPush;
import ProxyBwapi.Orders$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.Techs.Tech;
import ProxyBwapi.UnitClasses.UnitClass;
import ProxyBwapi.UnitInfo.CombatUnit;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import ProxyBwapi.Upgrades.Upgrade;
import Utilities.$qmark$;
import Utilities.UnitFilters.UnitFilter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyDouble;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcZD$sp;

public final class Commander$ {
    public static Commander$ MODULE$;
    private final int tryingToMoveThreshold;

    static {
        new Commander$();
    }

    private int tryingToMoveThreshold() {
        return this.tryingToMoveThreshold;
    }

    public void doNothing(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        this.sleep(unit, this.sleep$default$2());
    }

    public void stop(FriendlyUnitInfo unit2) {
        unit2.agent().setRideGoal(unit2.pixel());
        this.leadFollower(unit2, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            Commander$.MODULE$.stop(unit);
            return BoxedUnit.UNIT;
        });
        if (unit2.unready()) {
            return;
        }
        unit2.bwapiUnit().stop();
        this.sleep(unit2, this.sleep$default$2());
        unit2.resetSticking();
    }

    public void hold(FriendlyUnitInfo unit2) {
        unit2.agent().setRideGoal(unit2.pixel());
        this.leadFollower(unit2, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            Commander$.MODULE$.hold(unit);
            return BoxedUnit.UNIT;
        });
        if (unit2.unready()) {
            return;
        }
        if (!Zerg$.MODULE$.Lurker().apply(unit2) && this.autoUnburrow(unit2)) {
            return;
        }
        if (unit2.velocity().lengthSquared() > 0.0) {
            String string = unit2.order();
            String string2 = Orders$.MODULE$.HoldPosition();
            if (string == null ? string2 != null : !string.equals(string2)) {
                unit2.bwapiUnit().holdPosition();
            }
        }
        if (unit2.matchups().targetsInRange().nonEmpty()) {
            this.sleepAttack(unit2);
            return;
        }
        this.sleep(unit2, this.sleep$default$2());
    }

    private boolean acceptableAttackFrom(FriendlyUnitInfo unit, UnitInfo target, Pixel attackFrom) {
        if (!target.visible() && target.pixelDistanceCenter(attackFrom) > (double)16) {
            return false;
        }
        if (unit.inRangeToAttackFrom(target, attackFrom)) {
            return true;
        }
        return !(unit.pixelsToGetInRange(target) <= unit.pixelsToGetInRangeFrom(target, attackFrom));
    }

    public void attack(FriendlyUnitInfo unit) {
        unit.agent().toAttack().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$1 -> {
            Commander$.MODULE$.attack(unit, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void attack(FriendlyUnitInfo unit, UnitInfo target) {
        LazyRef attackFrom$lzy = new LazyRef();
        unit.agent().toAttack_$eq(new Some<UnitInfo>(target));
        if (Protoss$.MODULE$.Reaver().apply(unit)) {
            if (unit.loaded()) {
                this.pushAway(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target), TrafficPriorities$.MODULE$.Bump(), this.pushAway$default$4());
            } else {
                this.pushThrough(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target), TrafficPriorities$.MODULE$.Bump(), this.pushThrough$default$4());
            }
        } else if (!target.visible() || !unit.inRangeToAttack(target)) {
            this.pushThrough(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target), TrafficPriorities$.MODULE$.Nudge(), this.pushThrough$default$4());
        }
        unit.agent().setRideGoal(Commander$.attackFrom$1(attackFrom$lzy, unit, target));
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$3 -> {
            Commander$.MODULE$.attack(x$3, target);
            return BoxedUnit.UNIT;
        });
        unit.agent().tryingToMove_$eq(unit.pixelsToGetInRange(target) > (double)this.tryingToMoveThreshold());
        if (unit.unready()) {
            return;
        }
        if (unit.airlifted() && (unit.pixelDistanceCenter(Commander$.attackFrom$1(attackFrom$lzy, unit, target)) < (double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(unit.agent().isPrimaryPassenger(), (JFunction0$mcI$sp & scala.Serializable)() -> 32, (JFunction0$mcI$sp & scala.Serializable)() -> 64)) || unit.pixelsToGetInRange(target) <= (double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(unit.agent().isPrimaryPassenger(), (JFunction0$mcI$sp & scala.Serializable)() -> 16, (JFunction0$mcI$sp & scala.Serializable)() -> 48)))) {
            this.requestUnload(unit);
            this.sleep(unit, this.sleep$default$2());
            return;
        }
        if (!Zerg$.MODULE$.Lurker().apply(unit) && this.autoUnburrow(unit)) {
            return;
        }
        if (Protoss$.MODULE$.Interceptor().apply(target)) {
            this.attackMove(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target));
            return;
        }
        if (Protoss$.MODULE$.Carrier().apply(target) && unit.readyForAttackOrder() && !unit.inRangeToAttack(target) && !unit.flying()) {
            this.attackMove(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target));
            return;
        }
        if (Zerg$.MODULE$.Lurker().apply(unit) && !unit.burrowed()) {
            this.move(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target));
            return;
        }
        if ((unit.readyForAttackOrder() || unit.inRangeToAttack(target) || unit.unitClass().melee() || !unit.canMove() || unit.flying() && unit.readyForAttackOrder() || unit.framesToGetInRange(target) <= With$.MODULE$.latency().latencyFrames() + Math.max(unit.cooldownLeft(), With$.MODULE$.reaction().agencyAverage())) && target.visible()) {
            LazyBoolean moving$lzy = new LazyBoolean();
            LazyBoolean alreadyInRange$lzy = new LazyBoolean();
            LazyBoolean overdueToAttack$lzy = new LazyBoolean();
            if (Commander$.thisIsANewTarget$1(new LazyBoolean(), unit, target) || Commander$.overdueToAttack$1(overdueToAttack$lzy, unit) && (Commander$.moving$1(moving$lzy, unit) || Commander$.alreadyInRange$1(alreadyInRange$lzy, unit, target)) || target.isFriendly() && Protoss$.MODULE$.Carrier().apply(unit)) {
                unit.bwapiUnit().attack(target.bwapiUnit());
                target.addFutureAttack(unit);
                this.sleepAttack(unit);
                return;
            }
            this.sleep(unit, this.sleep$default$2());
            return;
        }
        this.move(unit, Commander$.attackFrom$1(attackFrom$lzy, unit, target));
    }

    public Pixel adjustDestination(FriendlyUnitInfo unit, Pixel argTo) {
        Pixel to = argTo;
        if (With$.MODULE$.reaction().sluggishness() == 0 && (unit.isAny(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Terran$.MODULE$.ScienceVessel(), Protoss$.MODULE$.Observer(), Zerg$.MODULE$.Mutalisk(), Zerg$.MODULE$.Overlord(), Zerg$.MODULE$.Queen()})) || unit.loadedUnits().nonEmpty())) {
            double overshootDistance = BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(unit.airborne(), (JFunction0$mcD$sp & scala.Serializable)() -> 288.0, (JFunction0$mcD$sp & scala.Serializable)() -> 8.0));
            Pixel pixel = argTo;
            Pixel pixel2 = unit.pixel();
            if (!(pixel != null ? !((Object)pixel).equals(pixel2) : pixel2 != null)) {
                int signX = Maff$.MODULE$.signum11(Points$.MODULE$.middle().x() - argTo.x());
                int signY = Maff$.MODULE$.signum11(Points$.MODULE$.middle().y() - argTo.y());
                to = argTo.add((int)((double)signX * overshootDistance), (int)((double)signY * overshootDistance));
            } else if (unit.pixelDistanceSquared(argTo) < overshootDistance * overshootDistance) {
                to = unit.pixel().project(argTo, overshootDistance);
            }
        }
        to = new Pixel(Maff$.MODULE$.clamp(to.x(), unit.unitClass().dimensionLeft(), With$.MODULE$.mapPixelWidth() - unit.unitClass().dimensionRight()), Maff$.MODULE$.clamp(to.y(), unit.unitClass().dimensionUp(), With$.MODULE$.mapPixelHeight() - unit.unitClass().dimensionDown()));
        if (unit.airborne()) {
            return to;
        }
        if (unit.pixelDistanceTravelling(to) >= (double)(2 * MicroPathing$.MODULE$.waypointDistancePixels()) && With$.MODULE$.reaction().sluggishness() < 2) {
            Zone zone = unit.zone();
            Zone zone2 = to.zone();
            if (zone == null ? zone2 != null : !zone.equals(zone2)) {
                to = MicroPathing$.MODULE$.getWaypointToPixel(unit, to);
            }
        }
        if (!(to.walkable() && to.add(-unit.unitClass().dimensionLeft(), -unit.unitClass().dimensionUp()).walkable() && to.add(unit.unitClass().dimensionRight(), unit.unitClass().dimensionDown()).walkable() && to.add(unit.unitClass().dimensionRight(), -unit.unitClass().dimensionUp()).walkable() && to.add(-unit.unitClass().dimensionLeft(), unit.unitClass().dimensionDown()).walkable()) && unit.pixelDistanceCenter(to) > (double)32) {
            to = to.walkableTile().center();
        }
        if (unit.pixelDistanceCenter(to) > (double)160) {
            to = to.add((unit.id() + With$.MODULE$.frame() / 96) % 3 - 1, 0);
        }
        return to;
    }

    public void attackMove(FriendlyUnitInfo unit) {
        this.attackMove(unit, unit.agent().destinationNext().apply());
    }

    private void attackMove(FriendlyUnitInfo unit, Pixel destination) {
        unit.agent().setRideGoal(destination);
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$4 -> {
            Commander$.MODULE$.attackMove(x$4, destination);
            return BoxedUnit.UNIT;
        });
        unit.agent().tryingToMove_$eq(unit.pixelDistanceCenter(destination) > (double)this.tryingToMoveThreshold());
        if (unit.unready()) {
            return;
        }
        Pixel to = this.adjustDestination(unit, destination);
        this.autoUnburrowUnlessLurkerInRangeOf(unit, to);
        String string = unit.order();
        String string2 = Orders$.MODULE$.AttackMove();
        if (!(!(string != null ? !string.equals(string2) : string2 != null) && unit.orderTargetPixel().exists((Function1<Pixel, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(Commander$.$anonfun$attackMove$2(to, x$5)))) || unit.seeminglyStuck()) {
            unit.bwapiUnit().attack(to.bwapi());
        }
        this.sleepAttack(unit);
    }

    public void patrol(FriendlyUnitInfo unit) {
        this.patrol(unit, unit.agent().destinationNext().apply());
    }

    private void patrol(FriendlyUnitInfo unit, Pixel destination) {
        unit.agent().setRideGoal(destination);
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$6 -> {
            Commander$.MODULE$.patrol(x$6, destination);
            return BoxedUnit.UNIT;
        });
        unit.agent().tryingToMove_$eq(unit.pixelDistanceCenter(destination) > (double)this.tryingToMoveThreshold());
        if (unit.unready()) {
            return;
        }
        Pixel to = this.adjustDestination(unit, destination);
        this.autoUnburrowUnlessLurkerInRangeOf(unit, to);
        unit.bwapiUnit().patrol(to.bwapi());
        this.sleepAttack(unit);
    }

    public void move(FriendlyUnitInfo unit) {
        this.move(unit, unit.agent().destinationNext().apply());
    }

    private void move(FriendlyUnitInfo unit, Pixel destination) {
        Pixel to = this.adjustDestination(unit, destination);
        unit.agent().setRideGoal(to);
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$7 -> {
            Commander$.MODULE$.move(x$7, to);
            return BoxedUnit.UNIT;
        });
        unit.agent().tryingToMove_$eq(unit.pixelDistanceCenter(to) > (double)this.tryingToMoveThreshold());
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (unit.pixelDistanceCenter(to) <= (double)8) {
            this.requestUnload(unit);
        }
        if (Terran$.MODULE$.Medic().apply(unit) && unit.agent().shouldFight()) {
            this.attackMove(unit, to);
        } else if (unit.pixelDistanceCenter(to) > (double)3) {
            if (!unit.unitClass().isWorker() && unit.agent().shouldFight() && With$.MODULE$.reaction().sluggishness() >= 3 && unit.canAttack()) {
                this.attackMove(unit, to);
            } else {
                unit.bwapiUnit().move(to.bwapi());
            }
            if (!unit.flying()) {
                this.pushThrough(unit, to, TrafficPriorities$.MODULE$.None(), this.pushThrough$default$4());
            }
        }
        this.sleep(unit, this.sleep$default$2());
    }

    public void rightClick(FriendlyUnitInfo unit, UnitInfo target) {
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$8 -> {
            Commander$.MODULE$.rightClick(x$8, target);
            return BoxedUnit.UNIT;
        });
        unit.agent().tryingToMove_$eq(unit.pixelDistanceEdge(target) > (double)this.tryingToMoveThreshold());
        if (unit.agent().ride().contains(target)) {
            unit.agent().wantsPickup_$eq(true);
        } else {
            unit.agent().setRideGoal(target.pixel());
        }
        if (unit.unready()) {
            return;
        }
        if (!Zerg$.MODULE$.Lurker().apply(unit) && this.autoUnburrow(unit)) {
            return;
        }
        unit.bwapiUnit().rightClick(target.bwapiUnit());
        this.sleepAttack(unit);
    }

    public void useTech(FriendlyUnitInfo unit, Tech tech) {
        Tech tech2 = tech;
        Tech tech3 = Terran$.MODULE$.Stim();
        if (!(tech2 != null ? !((Object)tech2).equals(tech3) : tech3 != null)) {
            if (With$.MODULE$.framesSince(unit.agent().lastStim()) < 24) {
                return;
            }
            unit.agent().lastStim_$eq(With$.MODULE$.frame());
        }
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        unit.bwapiUnit().useTech(tech.bwapiTech());
        this.sleep(unit, this.sleep$default$2());
    }

    public void useTechOnUnit(FriendlyUnitInfo unit, Tech tech, UnitInfo target) {
        block7: {
            block6: {
                unit.agent().setRideGoal(target.pixel());
                if (unit.unready()) {
                    return;
                }
                if (this.autoUnburrow(unit)) {
                    return;
                }
                if (this.autoUnload(unit)) {
                    return;
                }
                unit.bwapiUnit().useTech(tech.bwapiTech(), target.bwapiUnit());
                if (((Object)tech).equals(Protoss$.MODULE$.ArchonMeld())) break block6;
                Tech tech2 = tech;
                Tech tech3 = Protoss$.MODULE$.DarkArchonMeld();
                if (tech2 != null ? !((Object)tech2).equals(tech3) : tech3 != null) break block7;
            }
            this.sleep(unit, 48);
            return;
        }
        this.sleep(unit, this.sleep$default$2());
    }

    public void useTechOnPixel(FriendlyUnitInfo unit, Tech tech, Pixel target) {
        unit.agent().setRideGoal(target);
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        unit.bwapiUnit().useTech(tech.bwapiTech(), target.bwapi());
        if (((Object)tech).equals(Terran$.MODULE$.SpiderMinePlant())) {
            this.sleep(unit, 12);
            return;
        }
        this.sleepAttack(unit);
    }

    public void repair(FriendlyUnitInfo unit, UnitInfo target) {
        unit.agent().setRideGoal(target.pixel());
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        this.sleep(unit, 24);
    }

    public void returnCargo(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        if (unit.carrying()) {
            unit.bwapiUnit().returnCargo();
            this.sleepReturnCargo(unit);
            return;
        }
    }

    public void gather(FriendlyUnitInfo unit) {
        unit.agent().toGather().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$9 -> {
            Commander$.MODULE$.gather(unit, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private void gather(FriendlyUnitInfo unit, UnitInfo resource) {
        unit.agent().setRideGoal(resource.pixel());
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        if (unit.carrying()) {
            if (!((SeqLike)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{Orders$.MODULE$.ResetCollision(), Orders$.MODULE$.ReturnMinerals(), Orders$.MODULE$.ReturnGas()}))).contains(unit.order())) {
                LazyRef nextClosestFrames$lzy = new LazyRef();
                Option incompleteHall = unit.base().flatMap((Function1<Base, Option> & Serializable & scala.Serializable)x$10 -> x$10.townHall().filterNot((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(x$11.complete())));
                if (incompleteHall.exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)hall -> BoxesRunTime.boxToBoolean(Commander$.$anonfun$gather$7(nextClosestFrames$lzy, unit, hall)))) {
                    this.move(unit, ((CombatUnit)incompleteHall.get()).pixel());
                } else {
                    unit.bwapiUnit().returnCargo();
                }
            }
        } else if (resource.visible()) {
            if (resource.unitClass().isGas()) {
                if (!unit.orderTarget().contains(resource)) {
                    Commander$.doGather$1(unit, resource);
                }
            } else {
                LazyRef coworkers$lzy = new LazyRef();
                LazyInt accelerantFrame$lzy = new LazyInt();
                LazyRef accelerantMineral$lzy = new LazyRef();
                new LazyRef();
                LazyDouble distance$lzy = new LazyDouble();
                LazyDouble projectedFrames$lzy = new LazyDouble();
                LazyBoolean onAccelerantPixel$lzy = new LazyBoolean();
                LazyBoolean onTargetMineral$lzy = new LazyBoolean();
                new LazyBoolean();
                String string = unit.order();
                String string2 = Orders$.MODULE$.MiningMinerals();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    if (Commander$.onAccelerantPixel$1(onAccelerantPixel$lzy, unit, resource)) {
                        Commander$.doGather$1(unit, resource);
                    } else if (Commander$.coworkers$1(coworkers$lzy, resource).exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)w -> BoxesRunTime.boxToBoolean(Commander$.$anonfun$gather$10(unit, resource, w)))) {
                        Commander$.doGather$1(unit, resource);
                    } else if (Commander$.projectedFrames$1(projectedFrames$lzy, unit, distance$lzy, resource) == (double)Commander$.accelerantFrame$1(accelerantFrame$lzy)) {
                        Commander$.doGather$1(unit, resource);
                    } else {
                        Commander$.accelerantMineral$1(accelerantMineral$lzy, resource).isDefined();
                        if (!Commander$.onTargetMineral$1(onTargetMineral$lzy, unit, resource)) {
                            Commander$.doGather$1(unit, resource);
                        }
                    }
                }
            }
        } else {
            this.move(unit, resource.pixel());
        }
        this.sleep(unit, 1);
    }

    public void build(FriendlyUnitInfo unit, UnitClass unitClass) {
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        unit.bwapiUnit().build(unitClass.bwapiType());
        this.sleepBuild(unit);
    }

    public void build(FriendlyUnitInfo unit, UnitClass unitClass, Tile tile) {
        unit.agent().setRideGoal(tile.center());
        if (unit.unready()) {
            return;
        }
        if (this.autoUnburrow(unit)) {
            return;
        }
        if (this.autoUnload(unit)) {
            return;
        }
        if (unit.pixelDistanceSquared(tile.center()) > Math.pow(160.0, 2.0)) {
            this.move(unit, tile.center());
            return;
        }
        unit.bwapiUnit().build(unitClass.bwapiType(), tile.bwapi());
        this.sleepBuild(unit);
    }

    public void tech(FriendlyUnitInfo unit, Tech tech) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().research(tech.bwapiTech());
        this.sleep(unit, this.sleep$default$2());
    }

    public void upgrade(FriendlyUnitInfo unit, Upgrade upgrade) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().upgrade(upgrade.bwapiType());
        this.sleep(unit, this.sleep$default$2());
    }

    public void cancel(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        if (unit.teching()) {
            unit.bwapiUnit().cancelResearch();
        } else if (unit.upgrading()) {
            unit.bwapiUnit().cancelUpgrade();
        } else if (unit.training()) {
            unit.bwapiUnit().cancelTrain();
        } else {
            unit.bwapiUnit().cancelConstruction();
        }
        this.sleep(unit, this.sleep$default$2());
    }

    public void rally(FriendlyUnitInfo unit, Pixel pixel) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().setRallyPoint(pixel.bwapi());
        unit.lastSetRally_$eq(With$.MODULE$.frame());
        this.sleep(unit, this.sleep$default$2());
    }

    public void requestUnload(FriendlyUnitInfo passenger) {
        passenger.agent().wantsUnload_$eq(true);
    }

    public void unload(FriendlyUnitInfo transport, UnitInfo passenger) {
        transport.bwapiUnit().unload(passenger.bwapiUnit());
    }

    public void addon(FriendlyUnitInfo unit, UnitClass unitClass) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().buildAddon(unitClass.bwapiType());
        this.sleep(unit, this.sleep$default$2());
    }

    public void buildScarab(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().build(Protoss$.MODULE$.Scarab().bwapiType());
        this.sleep(unit, this.sleep$default$2());
    }

    public void buildInterceptor(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().build(Protoss$.MODULE$.Interceptor().bwapiType());
        this.sleep(unit, this.sleep$default$2());
    }

    public void cloak(FriendlyUnitInfo unit, Tech tech) {
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$15 -> {
            Commander$.MODULE$.cloak(x$15, tech);
            return BoxedUnit.UNIT;
        });
        if (unit.unready()) {
            return;
        }
        unit.agent().lastCloak_$eq(With$.MODULE$.frame());
        unit.bwapiUnit().cloak();
        this.sleep(unit, this.sleep$default$2());
    }

    public void decloak(FriendlyUnitInfo unit, Tech tech) {
        this.leadFollower(unit, (Function1<FriendlyUnitInfo, BoxedUnit>)(Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$16 -> {
            Commander$.MODULE$.decloak(x$16, tech);
            return BoxedUnit.UNIT;
        });
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().decloak();
        this.sleep(unit, this.sleep$default$2());
    }

    public void burrow(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().burrow();
        this.sleep(unit, this.sleep$default$2());
    }

    public void unburrow(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().unburrow();
        this.sleep(unit, this.sleep$default$2());
    }

    public void lift(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return;
        }
        unit.bwapiUnit().lift();
        this.sleep(unit, this.sleep$default$2());
    }

    public void defaultEscalation(FriendlyUnitInfo unit) {
        LazyDouble buildDistance$lzy = new LazyDouble();
        if (unit.flying()) {
            return;
        }
        if (unit.intent().toScoutTiles().nonEmpty()) {
            unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Pardon());
        }
        if (unit.intent().toFinish().isDefined()) {
            unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Bump());
        }
        if (unit.intent().toRepair().isDefined()) {
            unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Bump());
        }
        if (unit.intent().toBuildTile().isDefined()) {
            unit.agent().escalatePriority((TrafficPriority)$qmark$.MODULE$.apply(Commander$.buildDistance$1(buildDistance$lzy, unit) < (double)128, (Function0<TrafficPriority> & Serializable & scala.Serializable)() -> TrafficPriorities$.MODULE$.Shove(), (Function0<TrafficPriority> & Serializable & scala.Serializable)() -> TrafficPriorities$.MODULE$.Bump()));
        }
        if (unit.agent().toAttack().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean(Commander$.$anonfun$defaultEscalation$5(unit, x$18)))) {
            unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Nudge());
        }
        if (unit.battle().isDefined() && !unit.agent().shouldFight()) {
            unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Pardon());
            if (unit.matchups().pixelsEntangled() > (double)-80) {
                unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Nudge());
            }
            if (unit.matchups().pixelsEntangled() > (double)-48) {
                unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Bump());
            }
            if (unit.matchups().pixelsEntangled() > (double)-16) {
                unit.agent().escalatePriority(TrafficPriorities$.MODULE$.Shove());
                return;
            }
            return;
        }
    }

    private void push(FriendlyUnitInfo unit, TrafficPriority minimumPriority, Function0<Push> makePush) {
        if (unit.flying()) {
            return;
        }
        unit.agent().escalatePriority(minimumPriority);
        this.defaultEscalation(unit);
        if (unit.agent().priority().$greater(TrafficPriorities$.MODULE$.None())) {
            With$.MODULE$.coordinator().pushes().put(makePush.apply());
            return;
        }
    }

    public void pushAway(FriendlyUnitInfo unit, Pixel to, TrafficPriority minimumPriority, double radius) {
        this.push(unit, minimumPriority, (Function0<Push>)(Function0<CircularPush> & Serializable & scala.Serializable)() -> new CircularPush(unit.agent().priority(), to, radius, Predef$.MODULE$.wrapRefArray((Object[])new FriendlyUnitInfo[]{unit})));
    }

    public double pushAway$default$4() {
        return 48.0;
    }

    public void pushThrough(FriendlyUnitInfo unit, Pixel to, TrafficPriority minimumPriority, double maxDistance) {
        this.push(unit, minimumPriority, (Function0<Push>)(Function0<UnitLinearGroundPush> & Serializable & scala.Serializable)() -> new UnitLinearGroundPush(unit.agent().priority(), unit, (Pixel)$qmark$.MODULE$.apply(unit.pixelDistanceCenter(to) > maxDistance, (Function0<Pixel> & Serializable & scala.Serializable)() -> unit.pixel().project(to, maxDistance), (Function0<Pixel> & Serializable & scala.Serializable)() -> to)));
    }

    public double pushThrough$default$4() {
        return 96.0;
    }

    private boolean autoUnburrow(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return false;
        }
        if (!unit.burrowed()) {
            return false;
        }
        this.unburrow(unit);
        return true;
    }

    private boolean autoUnload(FriendlyUnitInfo unit) {
        if (unit.unready()) {
            return false;
        }
        if (unit.transport().isEmpty()) {
            return false;
        }
        this.requestUnload(unit);
        return true;
    }

    private void autoUnburrowUnlessLurkerInRangeOf(FriendlyUnitInfo unit, Pixel to) {
        if (!Zerg$.MODULE$.Lurker().apply(unit) || unit.pixelDistanceCenter(to) > unit.pixelRangeGround()) {
            this.autoUnburrow(unit);
            return;
        }
    }

    private void sleepAttack(FriendlyUnitInfo unit) {
        this.sleep(unit, AttackDelay$.MODULE$.framesToWaitAfterIssuingAttackOrder(unit));
    }

    private void sleepBuild(FriendlyUnitInfo unit) {
        this.sleep(unit, 3 + 2 * With$.MODULE$.latency().latencyFrames());
    }

    private void sleepReturnCargo(FriendlyUnitInfo unit) {
        this.sleep(unit, 8);
    }

    public void sleep(FriendlyUnitInfo unit, int requiredDelay) {
        unit.sleepUntil_$eq(BoxesRunTime.unboxToInt(Maff$.MODULE$.vmax(Predef$.MODULE$.wrapIntArray(new int[]{With$.MODULE$.frame() + requiredDelay, With$.MODULE$.frame() + With$.MODULE$.latency().turnSize(), unit.sleepUntil()}), Ordering$Int$.MODULE$)));
        if (With$.MODULE$.configuration().trackUnit() && (unit.selected() || unit.transport().exists((Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean(x$19.selected())))) {
            With$.MODULE$.configuration().trackUnit_$eq(false);
            return;
        }
    }

    public int sleep$default$2() {
        return 2;
    }

    private void retrack() {
        With$.MODULE$.configuration().trackUnit_$eq(true);
    }

    private void leadFollower(FriendlyUnitInfo unit, Function1<FriendlyUnitInfo, BoxedUnit> todo) {
        if (unit.ready()) {
            unit.agent().leadFollower_$eq(todo);
            return;
        }
    }

    private static final /* synthetic */ Pixel attackFrom$lzycompute$1(LazyRef attackFrom$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        synchronized (attackFrom$lzy$1) {
            Pixel pixel = attackFrom$lzy$1.initialized() ? (Pixel)attackFrom$lzy$1.value() : (Pixel)attackFrom$lzy$1.initialize(unit$2.agent().perch().pixel().filter((Function1<Pixel, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Commander$.MODULE$.acceptableAttackFrom(unit$2, target$1, x$2))).getOrElse((Function0<Pixel> & Serializable & scala.Serializable)() -> unit$2.agent().choosePerch().apply()));
            return pixel;
        }
    }

    private static final Pixel attackFrom$1(LazyRef attackFrom$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        if (attackFrom$lzy$1.initialized()) {
            return (Pixel)attackFrom$lzy$1.value();
        }
        return Commander$.attackFrom$lzycompute$1(attackFrom$lzy$1, unit$2, target$1);
    }

    private static final /* synthetic */ boolean moving$lzycompute$1(LazyBoolean moving$lzy$1, FriendlyUnitInfo unit$2) {
        synchronized (moving$lzy$1) {
            boolean bl = moving$lzy$1.initialized() ? moving$lzy$1.value() : moving$lzy$1.initialize(unit$2.moving());
            return bl;
        }
    }

    private static final boolean moving$1(LazyBoolean moving$lzy$1, FriendlyUnitInfo unit$2) {
        if (moving$lzy$1.initialized()) {
            return moving$lzy$1.value();
        }
        return Commander$.moving$lzycompute$1(moving$lzy$1, unit$2);
    }

    private static final /* synthetic */ boolean alreadyInRange$lzycompute$1(LazyBoolean alreadyInRange$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        synchronized (alreadyInRange$lzy$1) {
            boolean bl = alreadyInRange$lzy$1.initialized() ? alreadyInRange$lzy$1.value() : alreadyInRange$lzy$1.initialize(unit$2.inRangeToAttack(target$1));
            return bl;
        }
    }

    private static final boolean alreadyInRange$1(LazyBoolean alreadyInRange$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        if (alreadyInRange$lzy$1.initialized()) {
            return alreadyInRange$lzy$1.value();
        }
        return Commander$.alreadyInRange$lzycompute$1(alreadyInRange$lzy$1, unit$2, target$1);
    }

    private static final /* synthetic */ boolean overdueToAttack$lzycompute$1(LazyBoolean overdueToAttack$lzy$1, FriendlyUnitInfo unit$2) {
        synchronized (overdueToAttack$lzy$1) {
            boolean bl = overdueToAttack$lzy$1.initialized() ? overdueToAttack$lzy$1.value() : overdueToAttack$lzy$1.initialize(unit$2.cooldownLeft() == 0 && (double)With$.MODULE$.framesSince(unit$2.lastFrameStartingAttack()) > 2.0 * (double)unit$2.cooldownMaxAirGround());
            return bl;
        }
    }

    private static final boolean overdueToAttack$1(LazyBoolean overdueToAttack$lzy$1, FriendlyUnitInfo unit$2) {
        if (overdueToAttack$lzy$1.initialized()) {
            return overdueToAttack$lzy$1.value();
        }
        return Commander$.overdueToAttack$lzycompute$1(overdueToAttack$lzy$1, unit$2);
    }

    private static final /* synthetic */ boolean thisIsANewTarget$lzycompute$1(LazyBoolean thisIsANewTarget$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        synchronized (thisIsANewTarget$lzy$1) {
            boolean bl = thisIsANewTarget$lzy$1.initialized() ? thisIsANewTarget$lzy$1.value() : thisIsANewTarget$lzy$1.initialize(!unit$2.orderTarget().contains(target$1));
            return bl;
        }
    }

    private static final boolean thisIsANewTarget$1(LazyBoolean thisIsANewTarget$lzy$1, FriendlyUnitInfo unit$2, UnitInfo target$1) {
        if (thisIsANewTarget$lzy$1.initialized()) {
            return thisIsANewTarget$lzy$1.value();
        }
        return Commander$.thisIsANewTarget$lzycompute$1(thisIsANewTarget$lzy$1, unit$2, target$1);
    }

    public static final /* synthetic */ boolean $anonfun$attackMove$2(Pixel to$1, Pixel x$5) {
        return x$5.pixelDistance(to$1) < (double)128;
    }

    public static final /* synthetic */ double $anonfun$gather$6(FriendlyUnitInfo unit$4, UnitInfo h) {
        return unit$4.pixelDistanceTravelling(h.exitTile()) / unit$4.topSpeed();
    }

    private static final /* synthetic */ Option nextClosestFrames$lzycompute$1(LazyRef nextClosestFrames$lzy$1, FriendlyUnitInfo unit$4) {
        synchronized (nextClosestFrames$lzy$1) {
            Option<Object> option = nextClosestFrames$lzy$1.initialized() ? (Option<Object>)nextClosestFrames$lzy$1.value() : nextClosestFrames$lzy$1.initialize(Maff$.MODULE$.min(((TraversableViewLike)With$.MODULE$.geography().ourBases().view().flatMap((Function1<Base, Iterable> & Serializable & scala.Serializable)x$12 -> Option$.MODULE$.option2Iterable(x$12.townHall()), SeqView$.MODULE$.canBuildFrom())).filter((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.complete())).map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)h -> BoxesRunTime.boxToDouble(Commander$.$anonfun$gather$6(unit$4, h)), SeqView$.MODULE$.canBuildFrom()), Ordering$Double$.MODULE$));
            return option;
        }
    }

    private static final Option nextClosestFrames$1(LazyRef nextClosestFrames$lzy$1, FriendlyUnitInfo unit$4) {
        if (nextClosestFrames$lzy$1.initialized()) {
            return (Option)nextClosestFrames$lzy$1.value();
        }
        return Commander$.nextClosestFrames$lzycompute$1(nextClosestFrames$lzy$1, unit$4);
    }

    public static final /* synthetic */ boolean $anonfun$gather$7(LazyRef nextClosestFrames$lzy$1, FriendlyUnitInfo unit$4, UnitInfo hall) {
        return Commander$.nextClosestFrames$1(nextClosestFrames$lzy$1, unit$4).forall((JFunction1$mcZD$sp & scala.Serializable)x$14 -> x$14 * (double)2 > (double)hall.remainingCompletionFrames());
    }

    private static final void doGather$1(FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        unit$4.bwapiUnit().rightClick(resource$1.bwapiUnit());
    }

    private static final /* synthetic */ Iterable coworkers$lzycompute$1(LazyRef coworkers$lzy$1, UnitInfo resource$1) {
        synchronized (coworkers$lzy$1) {
            Iterable<UnitInfo> iterable = coworkers$lzy$1.initialized() ? (Iterable<UnitInfo>)coworkers$lzy$1.value() : coworkers$lzy$1.initialize(With$.MODULE$.gathering().getWorkersByResource(resource$1));
            return iterable;
        }
    }

    private static final Iterable coworkers$1(LazyRef coworkers$lzy$1, UnitInfo resource$1) {
        if (coworkers$lzy$1.initialized()) {
            return (Iterable)coworkers$lzy$1.value();
        }
        return Commander$.coworkers$lzycompute$1(coworkers$lzy$1, resource$1);
    }

    private static final /* synthetic */ int accelerantFrame$lzycompute$1(LazyInt accelerantFrame$lzy$1) {
        synchronized (accelerantFrame$lzy$1) {
            int n = accelerantFrame$lzy$1.initialized() ? accelerantFrame$lzy$1.value() : accelerantFrame$lzy$1.initialize(11 + With$.MODULE$.latency().remainingFrames());
            return n;
        }
    }

    private static final int accelerantFrame$1(LazyInt accelerantFrame$lzy$1) {
        if (accelerantFrame$lzy$1.initialized()) {
            return accelerantFrame$lzy$1.value();
        }
        return Commander$.accelerantFrame$lzycompute$1(accelerantFrame$lzy$1);
    }

    private static final /* synthetic */ Option accelerantMineral$lzycompute$1(LazyRef accelerantMineral$lzy$1, UnitInfo resource$1) {
        synchronized (accelerantMineral$lzy$1) {
            Option<UnitInfo> option = accelerantMineral$lzy$1.initialized() ? (Option<UnitInfo>)accelerantMineral$lzy$1.value() : accelerantMineral$lzy$1.initialize(With$.MODULE$.gathering().getAccelerantMineral(resource$1));
            return option;
        }
    }

    private static final Option accelerantMineral$1(LazyRef accelerantMineral$lzy$1, UnitInfo resource$1) {
        if (accelerantMineral$lzy$1.initialized()) {
            return (Option)accelerantMineral$lzy$1.value();
        }
        return Commander$.accelerantMineral$lzycompute$1(accelerantMineral$lzy$1, resource$1);
    }

    private static final /* synthetic */ Option accelerantPixel$lzycompute$1(LazyRef accelerantPixel$lzy$1, UnitInfo resource$1) {
        synchronized (accelerantPixel$lzy$1) {
            Option<Pixel> option = accelerantPixel$lzy$1.initialized() ? (Option<Pixel>)accelerantPixel$lzy$1.value() : accelerantPixel$lzy$1.initialize(With$.MODULE$.gathering().getAccelerantPixelSteady(resource$1));
            return option;
        }
    }

    private static final Option accelerantPixel$1(LazyRef accelerantPixel$lzy$1, UnitInfo resource$1) {
        if (accelerantPixel$lzy$1.initialized()) {
            return (Option)accelerantPixel$lzy$1.value();
        }
        return Commander$.accelerantPixel$lzycompute$1(accelerantPixel$lzy$1, resource$1);
    }

    private static final /* synthetic */ double distance$lzycompute$1(LazyDouble distance$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        synchronized (distance$lzy$1) {
            double d = distance$lzy$1.initialized() ? distance$lzy$1.value() : distance$lzy$1.initialize(unit$4.pixelDistanceEdge(resource$1));
            return d;
        }
    }

    private static final double distance$1(LazyDouble distance$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        if (distance$lzy$1.initialized()) {
            return distance$lzy$1.value();
        }
        return Commander$.distance$lzycompute$1(distance$lzy$1, unit$4, resource$1);
    }

    private static final /* synthetic */ double projectedFrames$lzycompute$1(LazyDouble projectedFrames$lzy$1, FriendlyUnitInfo unit$4, LazyDouble distance$lzy$1, UnitInfo resource$1) {
        synchronized (projectedFrames$lzy$1) {
            double d = projectedFrames$lzy$1.initialized() ? projectedFrames$lzy$1.value() : projectedFrames$lzy$1.initialize(Maff$.MODULE$.nanToZero(Math.max(0.0, Commander$.distance$1(distance$lzy$1, unit$4, resource$1) - (double)unit$4.unitClass().haltPixels()) / unit$4.topSpeed() + (double)2 * Math.min(Commander$.distance$1(distance$lzy$1, unit$4, resource$1), (double)unit$4.unitClass().haltPixels()) / unit$4.topSpeed()));
            return d;
        }
    }

    private static final double projectedFrames$1(LazyDouble projectedFrames$lzy$1, FriendlyUnitInfo unit$4, LazyDouble distance$lzy$1, UnitInfo resource$1) {
        if (projectedFrames$lzy$1.initialized()) {
            return projectedFrames$lzy$1.value();
        }
        return Commander$.projectedFrames$lzycompute$1(projectedFrames$lzy$1, unit$4, distance$lzy$1, resource$1);
    }

    private static final /* synthetic */ boolean onAccelerantPixel$lzycompute$1(LazyBoolean onAccelerantPixel$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        synchronized (onAccelerantPixel$lzy$1) {
            boolean bl = onAccelerantPixel$lzy$1.initialized() ? onAccelerantPixel$lzy$1.value() : onAccelerantPixel$lzy$1.initialize(With$.MODULE$.gathering().onAccelerant(unit$4, resource$1));
            return bl;
        }
    }

    private static final boolean onAccelerantPixel$1(LazyBoolean onAccelerantPixel$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        if (onAccelerantPixel$lzy$1.initialized()) {
            return onAccelerantPixel$lzy$1.value();
        }
        return Commander$.onAccelerantPixel$lzycompute$1(onAccelerantPixel$lzy$1, unit$4, resource$1);
    }

    private static final /* synthetic */ boolean onTargetMineral$lzycompute$1(LazyBoolean onTargetMineral$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        synchronized (onTargetMineral$lzy$1) {
            boolean bl = onTargetMineral$lzy$1.initialized() ? onTargetMineral$lzy$1.value() : onTargetMineral$lzy$1.initialize(unit$4.orderTarget().contains(resource$1));
            return bl;
        }
    }

    private static final boolean onTargetMineral$1(LazyBoolean onTargetMineral$lzy$1, FriendlyUnitInfo unit$4, UnitInfo resource$1) {
        if (onTargetMineral$lzy$1.initialized()) {
            return onTargetMineral$lzy$1.value();
        }
        return Commander$.onTargetMineral$lzycompute$1(onTargetMineral$lzy$1, unit$4, resource$1);
    }

    private static final /* synthetic */ boolean onAccelerantMineral$lzycompute$1(LazyBoolean onAccelerantMineral$lzy$1, FriendlyUnitInfo unit$4, LazyRef accelerantMineral$lzy$1, UnitInfo resource$1) {
        synchronized (onAccelerantMineral$lzy$1) {
            boolean bl = onAccelerantMineral$lzy$1.initialized() ? onAccelerantMineral$lzy$1.value() : onAccelerantMineral$lzy$1.initialize(Commander$.accelerantMineral$1(accelerantMineral$lzy$1, resource$1).exists(arg_0 -> Commander$.$anonfun$gather$9$adapted(unit$4.orderTarget(), arg_0)));
            return bl;
        }
    }

    private static final boolean onAccelerantMineral$1(LazyBoolean onAccelerantMineral$lzy$1, FriendlyUnitInfo unit$4, LazyRef accelerantMineral$lzy$1, UnitInfo resource$1) {
        if (onAccelerantMineral$lzy$1.initialized()) {
            return onAccelerantMineral$lzy$1.value();
        }
        return Commander$.onAccelerantMineral$lzycompute$1(onAccelerantMineral$lzy$1, unit$4, accelerantMineral$lzy$1, resource$1);
    }

    private static final void doGatherFromAccelerant$1(FriendlyUnitInfo unit$4, LazyRef accelerantMineral$lzy$1, UnitInfo resource$1) {
        unit$4.bwapiUnit().gather(((UnitInfo)Commander$.accelerantMineral$1(accelerantMineral$lzy$1, resource$1).get()).bwapiUnit());
    }

    public static final /* synthetic */ boolean $anonfun$gather$10(FriendlyUnitInfo unit$4, UnitInfo resource$1, UnitInfo w) {
        UnitInfo unitInfo = w;
        if (unitInfo == null ? unit$4 != null : !unitInfo.equals(unit$4)) {
            String string = w.order();
            String string2 = Orders$.MODULE$.MiningMinerals();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (w.orderTarget().contains(resource$1) && w.bwapiUnit().getOrderTimer() + 7 == 11 + With$.MODULE$.latency().remainingFrames()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static final /* synthetic */ double buildDistance$lzycompute$1(LazyDouble buildDistance$lzy$1, FriendlyUnitInfo unit$5) {
        synchronized (buildDistance$lzy$1) {
            double d = buildDistance$lzy$1.initialized() ? buildDistance$lzy$1.value() : buildDistance$lzy$1.initialize(unit$5.pixelDistanceCenter((Pixel)unit$5.intent().toBuild().map((Function1<UnitClass, Pixel> & Serializable & scala.Serializable)x$17 -> x$17.tileArea().add(unit$5.intent().toBuildTile().get()).center()).getOrElse((Function0<Pixel> & Serializable & scala.Serializable)() -> unit$5.intent().toBuildTile().get().center())));
            return d;
        }
    }

    private static final double buildDistance$1(LazyDouble buildDistance$lzy$1, FriendlyUnitInfo unit$5) {
        if (buildDistance$lzy$1.initialized()) {
            return buildDistance$lzy$1.value();
        }
        return Commander$.buildDistance$lzycompute$1(buildDistance$lzy$1, unit$5);
    }

    public static final /* synthetic */ boolean $anonfun$defaultEscalation$5(FriendlyUnitInfo unit$5, UnitInfo x$18) {
        return !unit$5.inRangeToAttack(x$18);
    }

    private Commander$() {
        MODULE$ = this;
        this.tryingToMoveThreshold = 32;
    }

    public static final /* synthetic */ Object $anonfun$gather$9$adapted(Option eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.contains(elem));
    }
}

