/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Micro;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Views.DebugView;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.UnitInfo.ForeignUnitInfo;
import Utilities.Time.Frames;
import bwapi.Color;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ShowUnitsEnemy$
extends DebugView {
    public static ShowUnitsEnemy$ MODULE$;
    private boolean showSiegeRadius;
    private boolean showFogged;
    private boolean showCountdown;

    static {
        new ShowUnitsEnemy$();
    }

    public boolean showSiegeRadius() {
        return this.showSiegeRadius;
    }

    public void showSiegeRadius_$eq(boolean x$1) {
        this.showSiegeRadius = x$1;
    }

    public boolean showFogged() {
        return this.showFogged;
    }

    public void showFogged_$eq(boolean x$1) {
        this.showFogged = x$1;
    }

    public boolean showCountdown() {
        return this.showCountdown;
    }

    public void showCountdown_$eq(boolean x$1) {
        this.showCountdown = x$1;
    }

    @Override
    public void renderMap() {
        With$.MODULE$.units().enemy().foreach((Function1<ForeignUnitInfo, Object> & java.io.Serializable & Serializable)unit -> {
            ShowUnitsEnemy$.MODULE$.renderUnit(unit);
            return BoxedUnit.UNIT;
        });
    }

    private void renderUnit(ForeignUnitInfo unit) {
        Color color = unit.teamColor();
        if (this.showFogged() && (!unit.visible() || unit.effectivelyCloaked())) {
            int radius = unit.unitClass().dimensionMin() / 2;
            DrawMap$.MODULE$.circle(unit.pixel(), radius, color, true);
            Pixel pixel = unit.pixel();
            Pixel pixel2 = unit.pixelObserved();
            if (pixel == null ? pixel2 != null : !((Object)pixel).equals(pixel2)) {
                DrawMap$.MODULE$.circle(unit.pixelObserved(), radius, color, DrawMap$.MODULE$.circle$default$4());
                DrawMap$.MODULE$.line(unit.pixel().project(unit.pixelObserved(), radius), unit.pixelObserved().project(unit.pixel(), radius), color);
            }
            DrawMap$.MODULE$.label((Function0<String> & java.io.Serializable & Serializable)() -> unit.unitClass().toString(), unit.pixel(), true, color, DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
        }
        if (this.showSiegeRadius() && Terran$.MODULE$.SiegeTankSieged().apply(unit)) {
            With$.MODULE$.game().drawCircleMap(unit.pixel().bwapi(), (int)(unit.pixelRangeGround() + unit.unitClass().radialHypotenuse()), Colors$.MODULE$.DarkOrange());
        }
        if (this.showCountdown()) {
            if (!unit.complete() && unit.remainingCompletionFrames() > 0) {
                Frames timeLeft = new Frames(unit.remainingCompletionFrames());
                Frames timeEnd = new Frames(unit.completionFrame());
                double pctHp = (double)unit.hitPoints() / (double)unit.unitClass().maxHitPoints();
                DrawMap$.MODULE$.labelBox((Function0<TraversableOnce<String>>)(Function0<Object> & java.io.Serializable & Serializable)() -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new String[]{new StringOps("%s (%s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{timeLeft, timeEnd})), new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString("%02f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(pctHp)}))).append("%").toString()})), new Pixel(unit.x(), unit.bottom()), true, unit.teamColor(), DrawMap$.MODULE$.labelBox$default$5(), DrawMap$.MODULE$.labelBox$default$6());
                return;
            }
            return;
        }
    }

    private ShowUnitsEnemy$() {
        MODULE$ = this;
        this.showSiegeRadius = true;
        this.showFogged = true;
        this.showCountdown = true;
    }
}

