package util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * All hail StackOverflow: https://stackoverflow.com/questions/18805178/how-to-detect-outliers-in-an-arraylist
 */
public class Stats {

    public static List<Double> getOutliers(List<Double> input) {
        input = input.stream().sorted().collect(Collectors.toList());
        List<Double> output = new ArrayList<Double>();
        List<Double> data1;
        List<Double> data2;
        if (input.size() % 2 == 0) {
            data1 = input.subList(0, input.size() / 2);
            data2 = input.subList(input.size() / 2, input.size());
        } else {
            data1 = input.subList(0, input.size() / 2);
            data2 = input.subList(input.size() / 2 + 1, input.size());
        }
        double q1 = getMedian(data1);
        double q3 = getMedian(data2);
        double iqr = q3 - q1;
        double lowerFence = q1 - 1.5 * iqr;
        double upperFence = q3 + 1.5 * iqr;
        for (int i = 0; i < input.size(); i++) {
            if (input.get(i) < lowerFence || input.get(i) > upperFence)
                output.add(input.get(i));
        }
        return output;
    }

    private static double getMedian(List<Double> data) {
        if (data.size() % 2 == 0)
            return (data.get(data.size() / 2) + data.get(data.size() / 2 - 1)) / 2;
        else
            return data.get(data.size() / 2);
    }
}
