/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import info.GameState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import unit.squad.CombatSimulator;
import unit.squad.ScourgeCombatSimulator;
import unit.squad.Squad;
import unit.squad.SquadStatus;
import util.Filter;

public class ScourgeSquad
extends Squad {
    private final CombatSimulator combatSimulator = new ScourgeCombatSimulator();

    public ScourgeSquad() {
        this.setType(UnitType.Zerg_Scourge);
    }

    @Override
    public void onFrame() {
        this.checkRallyTransition();
        super.onFrame();
    }

    public void executeTactics(GameState gameState) {
        if (this.getMembers().size() < 2) {
            this.setStatus(SquadStatus.RALLY);
            this.rallyToSafePosition(gameState);
            return;
        }
        Set<Unit> enemyUnits = gameState.getDetectedEnemyUnits();
        Set<Unit> enemyBuildings = gameState.getEnemyBuildings();
        ArrayList<Unit> airTargets = new ArrayList<Unit>();
        for (Unit enemy : enemyUnits) {
            if (!enemy.isFlying() || !enemy.isDetected() || enemy.isInvincible() || Filter.isLowPriorityCombatTarget(enemy.getType())) continue;
            airTargets.add(enemy);
        }
        for (Unit building : enemyBuildings) {
            if (!building.isFlying() || !building.isDetected() || building.isInvincible()) continue;
            airTargets.add(building);
        }
        if (airTargets.isEmpty()) {
            this.setStatus(SquadStatus.RALLY);
            this.rallyToHuntPosition(gameState);
            return;
        }
        CombatSimulator.CombatResult combatResult = this.combatSimulator.evaluate(this, gameState);
        if (combatResult == CombatSimulator.CombatResult.ENGAGE) {
            this.setStatus(SquadStatus.FIGHT);
            this.executeKamikazeAttack(airTargets);
        } else {
            this.setStatus(SquadStatus.RALLY);
            this.rallyToSafePosition(gameState);
        }
    }

    private void executeKamikazeAttack(List<Unit> airTargets) {
        List<Unit> prioritizedTargets = this.prioritizeTargets(airTargets);
        for (ManagedUnit scourge : this.getMembers()) {
            scourge.setRole(UnitRole.FIGHT);
            scourge.setReady(true);
            Unit target = this.findBestTargetForScourge(scourge, prioritizedTargets);
            if (target == null) continue;
            scourge.setFightTarget(target);
        }
    }

    private Unit findBestTargetForScourge(ManagedUnit scourge, List<Unit> prioritizedTargets) {
        Position scourgePos = scourge.getUnit().getPosition();
        Unit bestTarget = null;
        double bestScore = Double.MIN_VALUE;
        for (Unit target : prioritizedTargets) {
            if (!target.isFlying()) continue;
            double distance = scourgePos.getDistance(target.getPosition());
            double priority = this.getTargetPriority(target.getType());
            double score = priority * 1000.0 - distance;
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestTarget = target;
        }
        return bestTarget;
    }

    private List<Unit> prioritizeTargets(List<Unit> airTargets) {
        ArrayList<Unit> highPriority = new ArrayList<Unit>();
        ArrayList<Unit> mediumPriority = new ArrayList<Unit>();
        ArrayList<Unit> lowPriority = new ArrayList<Unit>();
        for (Unit target : airTargets) {
            UnitType type = target.getType();
            if (this.isLowPriorityTarget(type)) {
                lowPriority.add(target);
                continue;
            }
            if (this.isFloatingBuilding(type)) {
                mediumPriority.add(target);
                continue;
            }
            highPriority.add(target);
        }
        ArrayList<Unit> prioritized = new ArrayList<Unit>();
        prioritized.addAll(highPriority);
        prioritized.addAll(mediumPriority);
        prioritized.addAll(lowPriority);
        return prioritized;
    }

    private double getTargetPriority(UnitType type) {
        if (this.isLowPriorityTarget(type)) {
            return 2.0;
        }
        if (this.isFloatingBuilding(type)) {
            return 1.0;
        }
        return 3.0;
    }

    private void rallyToSafePosition(GameState gameState) {
        Position homeBase = gameState.getSquadRallyPoint();
        this.rallyToPosition(homeBase);
    }

    private void rallyToHuntPosition(GameState gameState) {
        Position huntPosition = gameState.getSquadRallyPoint();
        Set<Unit> enemyBuildings = gameState.getEnemyBuildings();
        if (!enemyBuildings.isEmpty()) {
            Unit enemyBuilding = enemyBuildings.iterator().next();
            huntPosition = enemyBuilding.getPosition();
        }
        this.rallyToPosition(huntPosition);
    }

    private void rallyToPosition(Position position) {
        for (ManagedUnit scourge : this.getMembers()) {
            scourge.setRole(UnitRole.RALLY);
            scourge.setReady(true);
            scourge.setRallyPoint(position);
        }
    }

    private void checkRallyTransition() {
        if (this.getStatus() != SquadStatus.RALLY) {
            return;
        }
        int scourgeCount = this.getMembers().size();
        int scourgeAtRally = 0;
        for (ManagedUnit scourge : this.getMembers()) {
            double distanceToRally;
            if (scourge.getRallyPoint() == null || !((distanceToRally = scourge.getUnit().getPosition().getDistance(scourge.getRallyPoint())) < 64.0)) continue;
            ++scourgeAtRally;
        }
        if (scourgeCount > 0 && (double)scourgeAtRally / (double)scourgeCount >= 0.75) {
            this.setStatus(SquadStatus.FIGHT);
            for (ManagedUnit scourge : this.getMembers()) {
                scourge.setRole(UnitRole.FIGHT);
                scourge.setReady(true);
            }
        }
    }

    private boolean isFloatingBuilding(UnitType type) {
        return type.isFlyingBuilding();
    }

    private boolean isLowPriorityTarget(UnitType type) {
        return type == UnitType.Zerg_Overlord || type == UnitType.Protoss_Interceptor;
    }
}

