/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import info.GameState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import unit.squad.CombatSimulator;
import unit.squad.MutaliskCombatSimulator;
import unit.squad.Squad;
import unit.squad.SquadStatus;
import util.Filter;
import util.Time;

public class MutaliskSquad
extends Squad {
    private final CombatSimulator combatSimulator = new MutaliskCombatSimulator();
    private boolean shouldDisband = false;
    private Time attackUntilFrame = null;
    private Time retreatUntilFrame = null;
    private static final Time ATTACK_WINDOW = new Time(12);
    private static final Time RETREAT_WINDOW = new Time(36);

    public MutaliskSquad() {
        this.setType(UnitType.Zerg_Mutalisk);
    }

    @Override
    public void onFrame() {
        this.checkRallyTransition();
        super.onFrame();
    }

    @Override
    public boolean shouldDisband() {
        return this.shouldDisband;
    }

    public void executeTactics(GameState gameState) {
        Position safeAttackPos;
        boolean isRetreatWindowActive;
        if (this.getMembers().size() < 3) {
            this.setStatus(SquadStatus.RALLY);
            this.rallyToSafePosition(gameState);
            return;
        }
        Set<Unit> enemyUnits = gameState.getDetectedEnemyUnits();
        ArrayList<Unit> allEnemies = new ArrayList<Unit>();
        allEnemies.addAll(enemyUnits);
        allEnemies.removeIf(enemy -> Filter.isLowPriorityCombatTarget(enemy.getType()));
        if (allEnemies.isEmpty()) {
            Set<Position> enemyWorkerLocations = gameState.getLastKnownLocationOfEnemyWorkers();
            if (enemyWorkerLocations.isEmpty()) {
                this.shouldDisband = true;
                return;
            }
            this.setStatus(SquadStatus.RALLY);
            this.rallyToHarassmentPosition(gameState);
            return;
        }
        Set<Position> staticDefenseCoverage = gameState.getAerielStaticDefenseCoverage();
        Time currentTime = gameState.getGameTime();
        boolean isAttackWindowActive = this.attackUntilFrame != null && currentTime.lessThanOrEqual(this.attackUntilFrame);
        boolean bl = isRetreatWindowActive = this.retreatUntilFrame != null && currentTime.lessThanOrEqual(this.retreatUntilFrame);
        if (!isAttackWindowActive && !isRetreatWindowActive) {
            CombatSimulator.CombatResult combatResult = this.combatSimulator.evaluate(this, gameState);
            if (combatResult == CombatSimulator.CombatResult.RETREAT) {
                this.retreatUntilFrame = currentTime.add(RETREAT_WINDOW);
            } else {
                this.attackUntilFrame = currentTime.add(ATTACK_WINDOW);
            }
        }
        if (isRetreatWindowActive) {
            this.setStatus(SquadStatus.RETREAT);
            this.executeRetreat(gameState, allEnemies, staticDefenseCoverage);
            return;
        }
        if (isAttackWindowActive) {
            this.setStatus(SquadStatus.FIGHT);
        } else {
            this.attackUntilFrame = null;
            this.retreatUntilFrame = null;
        }
        Unit priorityTarget = this.findPriorityTarget(allEnemies, staticDefenseCoverage);
        if (priorityTarget != null && this.canAttackTargetFromSafePosition(priorityTarget, staticDefenseCoverage) && (safeAttackPos = this.findSafeAttackPosition(priorityTarget, staticDefenseCoverage)) != null) {
            this.setStatus(SquadStatus.RALLY);
            this.setTarget(priorityTarget);
            this.rallyToPosition(safeAttackPos, priorityTarget);
            return;
        }
        if (priorityTarget != null) {
            this.setTarget(priorityTarget);
        }
        for (ManagedUnit mutalisk : this.getMembers()) {
            mutalisk.setRole(UnitRole.FIGHT);
            mutalisk.setReady(true);
            if (priorityTarget != null) {
                mutalisk.setFightTarget(priorityTarget);
            }
            Position individualRetreat = this.calculateIndividualRetreat(mutalisk.getUnit(), allEnemies, staticDefenseCoverage);
            mutalisk.setRetreatTarget(individualRetreat);
        }
    }

    private void executeRetreat(GameState gameState, List<Unit> allEnemies, Set<Position> staticDefenseCoverage) {
        Position retreatVector = this.calculateRetreatVector(this.getCenter(), allEnemies, staticDefenseCoverage, gameState);
        for (ManagedUnit mutalisk : this.getMembers()) {
            mutalisk.setRole(UnitRole.RETREAT);
            mutalisk.setReady(true);
            mutalisk.setRetreatTarget(retreatVector);
        }
    }

    private void rallyToHarassmentPosition(GameState gameState) {
        Set<Position> enemyWorkerLocations = gameState.getLastKnownLocationOfEnemyWorkers();
        Position rallyPoint = enemyWorkerLocations.isEmpty() ? gameState.getSquadRallyPoint() : this.findClosestWorkerLocation(enemyWorkerLocations);
        this.rallyToPosition(rallyPoint, null);
    }

    private void rallyToSafePosition(GameState gameState) {
        Position homeBase = gameState.getSquadRallyPoint();
        this.rallyToPosition(homeBase, null);
    }

    private void rallyToPosition(Position position, Unit target) {
        for (ManagedUnit mutalisk : this.getMembers()) {
            mutalisk.setRole(UnitRole.RALLY);
            mutalisk.setReady(true);
            mutalisk.setRallyPoint(position);
            if (target == null) continue;
            mutalisk.setFightTarget(target);
        }
    }

    private Position findClosestWorkerLocation(Set<Position> workerLocations) {
        Position squadCenter = this.getCenter();
        Position closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Position workerLocation : workerLocations) {
            double distance = squadCenter.getDistance(workerLocation);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = workerLocation;
        }
        return closest != null ? closest : squadCenter;
    }

    private Position calculateRetreatVector(Position squadCenter, List<Unit> enemies, Set<Position> staticDefenseCoverage, GameState gameState) {
        Position alternativeRetreat;
        if (enemies.isEmpty()) {
            return squadCenter;
        }
        double totalDx = 0.0;
        double totalDy = 0.0;
        double totalWeight = 0.0;
        for (Unit enemy : enemies) {
            Position enemyPos = enemy.getPosition();
            double distance = squadCenter.getDistance(enemyPos);
            double weight = 1.0;
            if (this.isAntiAir(enemy)) {
                weight = 3.0;
            } else if (enemy.getType().isBuilding()) {
                weight = 0.5;
            }
            if (!(distance > 0.0)) continue;
            double dx = squadCenter.getX() - enemyPos.getX();
            double dy = squadCenter.getY() - enemyPos.getY();
            totalDx += dx * (weight /= distance * distance / 10000.0);
            totalDy += dy * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0) {
            return squadCenter;
        }
        double normalizedDx = totalDx / totalWeight;
        double normalizedDy = totalDy / totalWeight;
        double length = Math.sqrt(normalizedDx * normalizedDx + normalizedDy * normalizedDy);
        if (length > 0.0) {
            normalizedDx = normalizedDx / length * 256.0;
            normalizedDy = normalizedDy / length * 256.0;
        }
        int retreatX = squadCenter.getX() + (int)normalizedDx;
        int retreatY = squadCenter.getY() + (int)normalizedDy;
        Position retreatPos = new Position(retreatX = Math.max(0, Math.min(retreatX, gameState.getGame().mapWidth() * 32 - 1)), retreatY = Math.max(0, Math.min(retreatY, gameState.getGame().mapHeight() * 32 - 1)));
        if (this.isPositionInStaticDefenseCoverage(retreatPos, staticDefenseCoverage) && (alternativeRetreat = this.findSafeRetreatPosition(squadCenter, staticDefenseCoverage, gameState)) != null) {
            retreatPos = alternativeRetreat;
        }
        return retreatPos;
    }

    private Position calculateIndividualRetreat(Unit mutalisk, List<Unit> enemies, Set<Position> staticDefenseCoverage) {
        double dy;
        Position mutaliskPos = mutalisk.getPosition();
        Unit nearestThreat = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Unit enemy : enemies) {
            double distance;
            if (!this.isAntiAir(enemy) || !((distance = mutaliskPos.getDistance(enemy.getPosition())) < nearestDistance)) continue;
            nearestThreat = enemy;
            nearestDistance = distance;
        }
        if (nearestThreat == null) {
            return mutaliskPos;
        }
        Position threatPos = nearestThreat.getPosition();
        double dx = mutaliskPos.getX() - threatPos.getX();
        double length = Math.sqrt(dx * dx + (dy = (double)(mutaliskPos.getY() - threatPos.getY())) * dy);
        if (length > 0.0) {
            dx = dx / length * 192.0;
            dy = dy / length * 192.0;
        }
        int retreatX = mutaliskPos.getX() + (int)dx;
        int retreatY = mutaliskPos.getY() + (int)dy;
        Position retreatPos = new Position(retreatX, retreatY);
        return retreatPos;
    }

    private Unit findPriorityTarget(List<Unit> enemies, Set<Position> staticDefenseCoverage) {
        boolean dangerousHasNonBuildings;
        Position squadCenter = this.getCenter();
        ArrayList<Unit> safeTargets = new ArrayList<Unit>();
        ArrayList<Unit> dangerousTargets = new ArrayList<Unit>();
        for (Unit enemy : enemies) {
            if (this.isPositionInStaticDefenseCoverage(enemy.getPosition(), staticDefenseCoverage)) {
                dangerousTargets.add(enemy);
                continue;
            }
            safeTargets.add(enemy);
        }
        boolean safeTargetsOnlyBuildings = safeTargets.stream().allMatch(unit -> unit.getType().isBuilding());
        ArrayList<Unit> preferredTargets = safeTargets.isEmpty() ? dangerousTargets : (safeTargetsOnlyBuildings && !dangerousTargets.isEmpty() ? ((dangerousHasNonBuildings = dangerousTargets.stream().anyMatch(unit -> !unit.getType().isBuilding())) ? dangerousTargets : safeTargets) : safeTargets);
        List<Unit> antiAirThreats = this.findAntiAirThreats(preferredTargets);
        if (!antiAirThreats.isEmpty()) {
            return this.getClosestUnit(squadCenter, antiAirThreats);
        }
        List<Unit> workers = this.findWorkers(preferredTargets);
        if (!workers.isEmpty()) {
            return this.getClosestUnit(squadCenter, workers);
        }
        List<Unit> staticDefense = this.findStaticDefense(preferredTargets);
        if (!staticDefense.isEmpty()) {
            return this.getClosestUnit(squadCenter, staticDefense);
        }
        return preferredTargets.isEmpty() ? null : this.getClosestUnit(squadCenter, preferredTargets);
    }

    private boolean canAttackTargetFromSafePosition(Unit target, Set<Position> staticDefenseCoverage) {
        return this.isPositionInStaticDefenseCoverage(target.getPosition(), staticDefenseCoverage) && this.findSafeAttackPosition(target, staticDefenseCoverage) != null;
    }

    private Position findSafeAttackPosition(Unit target, Set<Position> staticDefenseCoverage) {
        Position targetPos = target.getPosition();
        int mutaRange = UnitType.Zerg_Mutalisk.airWeapon().maxRange();
        ArrayList<Position> candidatePositions = new ArrayList<Position>();
        int angle = 0;
        while (angle < 360) {
            int y;
            double radians = Math.toRadians(angle);
            int x = targetPos.getX() + (int)((double)mutaRange * Math.cos(radians));
            Position candidatePos = new Position(x, y = targetPos.getY() + (int)((double)mutaRange * Math.sin(radians)));
            if (!this.isPositionInStaticDefenseCoverage(candidatePos, staticDefenseCoverage)) {
                candidatePositions.add(candidatePos);
            }
            angle += 15;
        }
        if (candidatePositions.isEmpty()) {
            return null;
        }
        candidatePositions.sort((pos1, pos2) -> {
            double score1 = this.calculatePositionScore((Position)pos1, staticDefenseCoverage, null);
            double score2 = this.calculatePositionScore((Position)pos2, staticDefenseCoverage, null);
            return Double.compare(score2, score1);
        });
        return (Position)candidatePositions.get(0);
    }

    private Position findSafeRetreatPosition(Position currentPos, Set<Position> staticDefenseCoverage, GameState gameState) {
        int step;
        int maxRadius = 320;
        int radius = step = 32;
        while (radius <= maxRadius) {
            int angle = 0;
            while (angle < 360) {
                int y;
                double radians = Math.toRadians(angle);
                int x = currentPos.getX() + (int)((double)radius * Math.cos(radians));
                Position candidatePos = new Position(x, y = currentPos.getY() + (int)((double)radius * Math.sin(radians)));
                if (!this.isPositionInStaticDefenseCoverage(candidatePos, staticDefenseCoverage)) {
                    return candidatePos;
                }
                angle += 30;
            }
            radius += step;
        }
        return null;
    }

    private boolean isPositionInStaticDefenseCoverage(Position pos, Set<Position> staticDefenseCoverage) {
        for (Position coveredPos : staticDefenseCoverage) {
            if (!(pos.getDistance(coveredPos) < 16.0)) continue;
            return true;
        }
        return false;
    }

    private boolean isAntiAir(Unit unit) {
        UnitType type = unit.getType();
        if (type.airWeapon() != null && type.airWeapon().maxRange() > 0) {
            return true;
        }
        return type == UnitType.Terran_Bunker && !unit.getLoadedUnits().isEmpty();
    }

    private List<Unit> findWorkers(List<Unit> enemies) {
        ArrayList<Unit> workers = new ArrayList<Unit>();
        for (Unit unit : enemies) {
            UnitType type = unit.getType();
            if (type != UnitType.Protoss_Probe && type != UnitType.Terran_SCV && type != UnitType.Zerg_Drone) continue;
            workers.add(unit);
        }
        return workers;
    }

    private List<Unit> findAntiAirThreats(List<Unit> enemies) {
        ArrayList<Unit> threats = new ArrayList<Unit>();
        for (Unit enemy : enemies) {
            if (!this.isAntiAir(enemy)) continue;
            threats.add(enemy);
        }
        return threats;
    }

    private List<Unit> findStaticDefense(List<Unit> enemies) {
        ArrayList<Unit> staticDefense = new ArrayList<Unit>();
        for (Unit unit : enemies) {
            UnitType type = unit.getType();
            if (type != UnitType.Terran_Missile_Turret && type != UnitType.Terran_Bunker && type != UnitType.Protoss_Photon_Cannon && type != UnitType.Zerg_Spore_Colony) continue;
            staticDefense.add(unit);
        }
        return staticDefense;
    }

    private Unit getClosestUnit(Position from, List<Unit> units) {
        Unit closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Unit unit : units) {
            double distance = from.getDistance(unit.getPosition());
            if (!(distance < closestDistance)) continue;
            closest = unit;
            closestDistance = distance;
        }
        return closest;
    }

    private void checkRallyTransition() {
        boolean isRallyOrRetreat;
        boolean bl = isRallyOrRetreat = this.getStatus() == SquadStatus.RALLY || this.getStatus() == SquadStatus.RETREAT;
        if (!isRallyOrRetreat) {
            return;
        }
        int mutaliskCount = this.getMembers().size();
        int mutaliskAtRally = 0;
        for (ManagedUnit mutalisk : this.getMembers()) {
            double distanceToRally;
            if (mutalisk.getRallyPoint() == null || !((distanceToRally = mutalisk.getUnit().getPosition().getDistance(mutalisk.getRallyPoint())) < 64.0)) continue;
            ++mutaliskAtRally;
        }
        if (mutaliskCount > 0 && (double)mutaliskAtRally / (double)mutaliskCount >= 0.75) {
            this.setStatus(SquadStatus.FIGHT);
            for (ManagedUnit mutalisk : this.getMembers()) {
                mutalisk.setRole(UnitRole.FIGHT);
                mutalisk.setReady(true);
            }
        }
    }

    private double calculatePositionScore(Position pos, Set<Position> staticDefenseCoverage, GameState gameState) {
        double score = 0.0;
        double minDistanceToStaticDefense = Double.MAX_VALUE;
        for (Position defensePos : staticDefenseCoverage) {
            double distance = pos.getDistance(defensePos);
            if (!(distance < minDistanceToStaticDefense)) continue;
            minDistanceToStaticDefense = distance;
        }
        score = minDistanceToStaticDefense != Double.MAX_VALUE ? (score += Math.min(100.0, minDistanceToStaticDefense / 3.2)) : (score += 100.0);
        if (gameState != null && !gameState.getGame().isBuildable(pos.toTilePosition())) {
            score += 50.0;
        }
        return score;
    }
}

