/*
 * Decompiled with CFR 0.152.
 */
package unit.scout;

import bwapi.Game;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import info.BaseData;
import info.GameState;
import info.InformationManager;
import info.ScoutData;
import info.map.GameMap;
import info.map.ScoutPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class ScoutManager {
    final int FRAME_DRONE_SCOUT = 1440;
    private InformationManager informationManager;
    private Game game;
    private GameState gameState;
    private HashSet<ManagedUnit> scouts = new HashSet();
    private HashSet<ManagedUnit> droneScouts = new HashSet();
    private ScoutPath enemyMainScoutPath;

    public ScoutManager(Game game, GameState gameState, InformationManager informationManager) {
        this.game = game;
        this.gameState = gameState;
        this.informationManager = informationManager;
    }

    public void onFrame() {
        for (ManagedUnit managedUnit : this.scouts) {
            if (managedUnit.getMovementTargetPosition() != null) continue;
            this.assignScoutMovementTarget(managedUnit);
        }
    }

    public boolean isDroneScout(Unit unit) {
        return this.droneScouts.contains(unit);
    }

    public void addScout(ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.SCOUT);
        this.assignScoutMovementTarget(managedUnit);
        this.scouts.add(managedUnit);
        if (managedUnit.getUnitType() == UnitType.Zerg_Drone) {
            this.droneScouts.add(managedUnit);
        }
    }

    public void removeScout(ManagedUnit managedUnit) {
        if (managedUnit == null) {
            return;
        }
        ScoutData scoutData = this.gameState.getScoutData();
        TilePosition movementTarget = managedUnit.getMovementTargetPosition();
        HashSet<TilePosition> activeScoutTargets = scoutData.getActiveScoutTargets();
        if (movementTarget != null && activeScoutTargets.contains(managedUnit.getMovementTargetPosition())) {
            activeScoutTargets.remove(movementTarget);
        }
        this.scouts.remove(managedUnit);
        this.droneScouts.remove(managedUnit);
    }

    public boolean needDroneScout() {
        if (Objects.equals(this.gameState.getActiveBuildOrder().getName(), "4Pool")) {
            return false;
        }
        if (this.gameState.getBaseData().getMainEnemyBase() != null) {
            return false;
        }
        if (this.game.enemy().getRace() == Race.Zerg) {
            return false;
        }
        if (this.game.getFrameCount() < 1440) {
            return false;
        }
        return this.droneScouts.size() <= 0;
    }

    public boolean endDroneScout() {
        if (this.gameState.getBaseData().getMainEnemyBase() != null) {
            return true;
        }
        for (ManagedUnit managedUnit : this.droneScouts) {
            Unit unit = managedUnit.getUnit();
            if (!unit.isUnderAttack()) continue;
            return true;
        }
        return false;
    }

    private TilePosition pollDroneScoutTarget() {
        BaseData baseData = this.gameState.getBaseData();
        if (!baseData.knowEnemyMainBase()) {
            return this.findEnemyMain();
        }
        return this.scoutEnemyMain();
    }

    private TilePosition scoutEnemyMain() {
        BaseData baseData = this.gameState.getBaseData();
        Base enemyMain = baseData.getMainEnemyBase();
        TilePosition enemyMainTp = enemyMain.getLocation();
        if (this.enemyMainScoutPath == null) {
            this.ensureEnemyMainMovePoints(enemyMainTp);
        }
        return this.enemyMainScoutPath.next();
    }

    private void ensureEnemyMainMovePoints(TilePosition enemyMainTp) {
        GameMap gameMap = this.gameState.getGameMap();
        this.enemyMainScoutPath = gameMap.findScoutPath(enemyMainTp);
    }

    private TilePosition findEnemyMain() {
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        Set<Base> baseSet = scoutData.getScoutingBaseSet();
        int unscountedMainBases = baseSet.size();
        if (unscountedMainBases == 3) {
            Base farthestBase = baseData.findFarthestStartingBaseByGround();
            this.updateBaseScoutAssignments(farthestBase);
            return farthestBase.getLocation();
        }
        if (unscountedMainBases == 2) {
            Base farthestBase = this.fetchBaseFarthestFromScouts(baseSet);
            this.updateBaseScoutAssignments(farthestBase);
            return farthestBase.getLocation();
        }
        Base fathestBase = new ArrayList<Base>(baseSet).get(0);
        Base farthestBase = this.fetchBaseFarthestFromScouts(baseSet);
        this.updateBaseScoutAssignments(farthestBase);
        return fathestBase.getLocation();
    }

    private void updateBaseScoutAssignments(Base base) {
        ScoutData scoutData = this.gameState.getScoutData();
        int assignments = scoutData.getScoutsAssignedToBase(base);
        scoutData.updateBaseScoutAssignment(base, assignments);
    }

    private Base fetchBaseFarthestFromScouts(Set<Base> mainBases) {
        HashMap<Base, Double> baseDistance = new HashMap<Base, Double>();
        mainBases.stream().forEach(b -> {
            Double d = baseDistance.put((Base)b, (Double)Double.MAX_VALUE);
        });
        for (Base b2 : mainBases) {
            for (ManagedUnit scout : this.scouts) {
                double distance = b2.getLocation().getDistance(scout.getUnit().getTilePosition());
                if (!(distance < (Double)baseDistance.get(b2))) continue;
                baseDistance.put(b2, distance);
            }
        }
        Base farthest = null;
        for (Map.Entry entry : baseDistance.entrySet()) {
            if (farthest == null) {
                farthest = (Base)entry.getKey();
                continue;
            }
            if (!((Double)entry.getValue() > (Double)baseDistance.get(farthest))) continue;
            farthest = (Base)entry.getKey();
        }
        return farthest;
    }

    private void assignScoutMovementTarget(ManagedUnit managedUnit) {
        if (managedUnit.getMovementTargetPosition() != null) {
            if (!this.game.isVisible(managedUnit.getMovementTargetPosition())) {
                return;
            }
            managedUnit.setMovementTargetPosition(null);
        }
        ScoutData scoutData = this.gameState.getScoutData();
        TilePosition target = null;
        target = managedUnit.getUnitType() == UnitType.Zerg_Drone ? this.pollDroneScoutTarget() : this.informationManager.pollScoutTarget(false);
        if (target != null) {
            scoutData.setActiveScoutTarget(target);
            managedUnit.setMovementTargetPosition(target);
        }
    }
}

