/*
 * Decompiled with CFR 0.152.
 */
package unit.managed;

import bwapi.Game;
import bwapi.Unit;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import util.Time;

public class Mutalisk
extends ManagedUnit {
    private Time retreatUntilFrame = null;
    private static final int RETREAT_DURATION_FRAMES = 24;

    public Mutalisk(Game game, Unit unit, UnitRole role) {
        super(game, unit, role);
    }

    @Override
    protected void fight() {
        if (this.unit.isAttackFrame()) {
            this.retreatUntilFrame = new Time(this.game.getFrameCount() + 24);
            return;
        }
        this.setUnready(4);
        if (this.retreatUntilFrame != null && this.game.getFrameCount() < this.retreatUntilFrame.getFrames()) {
            if (this.retreatTarget == null) {
                this.retreatTarget = this.getRetreatPosition();
            } else {
                this.retreatUntilFrame = null;
            }
            this.unit.move(this.retreatTarget);
            return;
        }
        if (this.fightTarget != null) {
            this.unit.attack(this.fightTarget);
            return;
        }
        if (this.movementTargetPosition != null) {
            this.unit.move(this.movementTargetPosition.toPosition());
            return;
        }
        this.role = UnitRole.IDLE;
    }

    @Override
    protected void rally() {
        if (this.rallyPoint == null) {
            return;
        }
        if (this.role == UnitRole.RALLY && this.unit.getDistance(this.rallyPoint) < 16) {
            return;
        }
        if (this.unit.getDistance(this.rallyPoint) < 4) {
            return;
        }
        this.setUnready();
        this.unit.move(this.rallyPoint);
    }
}

