/*
 * Decompiled with CFR 0.152.
 */
package unit.managed;

import bwapi.Game;
import bwapi.Unit;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class Lurker
extends ManagedUnit {
    private int targetOutOfRangeFrames = 0;
    private int noAttackFrames = 0;
    private static final int MAX_TARGET_OUT_OF_RANGE_FRAMES = 20;
    private static final int MAX_NO_ATTACK_FRAMES = 50;

    public Lurker(Game game, Unit unit, UnitRole role) {
        super(game, unit, role);
    }

    @Override
    protected void fight() {
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.setUnready(11);
        if (this.hasNoValidFightTarget()) {
            this.handleNoTarget();
            this.unburrowAndReset();
            return;
        }
        int range = this.weaponRange(this.fightTarget);
        double distance = this.unit.getDistance(this.fightTarget.getPosition());
        if (this.unit.isBurrowed()) {
            int cooldown;
            Unit closestEnemy;
            if (distance > (double)range) {
                ++this.targetOutOfRangeFrames;
                if (this.targetOutOfRangeFrames >= 20) {
                    this.unburrowAndReset();
                    return;
                }
            } else {
                this.targetOutOfRangeFrames = 0;
            }
            if ((closestEnemy = this.findClosestEnemyInRange()) != null && closestEnemy != this.fightTarget) {
                this.fightTarget = closestEnemy;
                this.noAttackFrames = 0;
            }
            if ((cooldown = this.unit.getGroundWeaponCooldown()) == 0) {
                ++this.noAttackFrames;
                if (this.noAttackFrames >= 50) {
                    this.unburrowAndReset();
                    return;
                }
            }
            this.noAttackFrames = 0;
            this.unit.attack(this.fightTarget);
            return;
        }
        if (distance <= (double)range && this.unit.canBurrow()) {
            this.unit.burrow();
            this.resetCounters();
            return;
        }
        this.unit.move(this.fightTarget.getPosition());
    }

    @Override
    protected void retreat() {
        this.setUnready();
        this.setRole(UnitRole.FIGHT);
        if (this.unit.isBurrowed() && !this.unit.isUnderAttack()) {
            return;
        }
        this.unit.burrow();
    }

    @Override
    protected void rally() {
        if (this.unit.isBurrowed()) {
            this.setUnready();
            this.unburrowAndReset();
            return;
        }
        super.rally();
    }

    private void unburrowAndReset() {
        if (this.unit.canUnburrow()) {
            this.unit.unburrow();
        }
        this.resetCounters();
    }

    private void resetCounters() {
        this.targetOutOfRangeFrames = 0;
        this.noAttackFrames = 0;
    }

    private boolean hasNoValidFightTarget() {
        return this.fightTarget == null || !this.fightTarget.exists() || !this.fightTarget.isDetected();
    }
}

