/*
 * Decompiled with CFR 0.152.
 */
package unit;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import bwem.Mineral;
import info.GameState;
import info.ResourceCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import macro.plan.Plan;
import macro.plan.PlanState;
import macro.plan.PlanType;
import unit.managed.ManagedUnit;
import unit.managed.ManagedUnitToPositionComparator;
import unit.managed.UnitRole;
import util.BaseUnitDistanceComparator;
import util.UnitDistanceComparator;

public class WorkerManager {
    private Game game;
    private GameState gameState;
    private HashSet<ManagedUnit> assignedManagedWorkers;
    private HashSet<ManagedUnit> gatherers;
    private HashSet<ManagedUnit> mineralGatherers;
    private HashSet<ManagedUnit> gasGatherers;
    private HashSet<ManagedUnit> larva;
    private HashSet<ManagedUnit> eggs = new HashSet();
    final int OVERLORD_HATCH_ANIMATION_FRAMES = 26;

    public WorkerManager(Game game, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
        this.gatherers = gameState.getGatherers();
        this.larva = gameState.getLarva();
        this.mineralGatherers = gameState.getMineralGatherers();
        this.gasGatherers = gameState.getGasGatherers();
        this.assignedManagedWorkers = gameState.getAssignedManagedWorkers();
    }

    public void onFrame() {
        this.checksLarvaDeadlock();
        this.handleLarvaDeadlock();
        this.rebalanceCheck();
    }

    public void onUnitComplete(ManagedUnit managedUnit) {
        UnitType unitType = managedUnit.getUnitType();
        if (unitType == UnitType.Zerg_Drone) {
            this.assignWorker(managedUnit);
            return;
        }
        if (unitType == UnitType.Zerg_Larva) {
            this.larva.add(managedUnit);
        }
    }

    public void addManagedWorker(ManagedUnit managedUnit) {
        this.assignWorker(managedUnit);
    }

    public void removeManagedWorker(ManagedUnit managedUnit) {
        this.gameState.clearAssignments(managedUnit);
    }

    public void removeMineral(Unit unit) {
        HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments = this.gameState.getMineralAssignments();
        HashSet mineralWorkers = (HashSet)mineralAssignments.get(unit);
        mineralAssignments.remove(unit);
        if (mineralWorkers == null) {
            return;
        }
        for (ManagedUnit managedUnit : mineralWorkers) {
            this.gameState.clearAssignments(managedUnit);
            this.assignWorker(managedUnit);
        }
    }

    public void removeGeyser(Unit unit) {
        HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments = this.gameState.getGeyserAssignments();
        HashSet geyserWorkers = (HashSet)geyserAssignments.get(unit);
        geyserAssignments.remove(unit);
        if (geyserWorkers == null) {
            return;
        }
        for (ManagedUnit managedUnit : geyserWorkers) {
            this.gameState.clearAssignments(managedUnit);
            this.assignWorker(managedUnit);
        }
    }

    public void onExtractorComplete(Unit unit) {
        ArrayList<ManagedUnit> newGeyserWorkers = new ArrayList<ManagedUnit>();
        if (this.mineralGatherers.size() < 4) {
            return;
        }
        List sortedGatherers = this.mineralGatherers.stream().sorted(new ManagedUnitToPositionComparator(unit.getPosition())).collect(Collectors.toList());
        for (ManagedUnit managedUnit : sortedGatherers) {
            if (newGeyserWorkers.size() >= 3) break;
            newGeyserWorkers.add(managedUnit);
        }
        for (ManagedUnit managedUnit : newGeyserWorkers) {
            this.gameState.clearAssignments(managedUnit);
            this.assignToGeyser(managedUnit);
        }
    }

    private void assignWorker(ManagedUnit managedUnit) {
        if (this.gameState.needGeyserWorkers() && this.gameState.needGeyserWorkersAmount() > 0) {
            this.assignToGeyser(managedUnit);
            return;
        }
        this.assignToMineral(managedUnit);
    }

    private void assignToClosestBase(Unit gatherTarget, ManagedUnit gatherer) {
        HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase();
        ArrayList<Base> bases = new ArrayList<Base>(gatherersAssignedToBase.keySet());
        if (bases.isEmpty()) {
            return;
        }
        bases.sort(new BaseUnitDistanceComparator(gatherTarget));
        HashSet<ManagedUnit> assignedManagedUnits = gatherersAssignedToBase.get(bases.get(0));
        assignedManagedUnits.add(gatherer);
    }

    private void assignToMineral(ManagedUnit managedUnit) {
        Unit unit = managedUnit.getUnit();
        Base targetBase = this.findBestBaseForMineralAssignment(unit);
        if (targetBase == null) {
            return;
        }
        this.assignToMineralAtBase(managedUnit, targetBase);
    }

    private boolean assignToMineralAtBase(ManagedUnit managedUnit, Base base) {
        Unit unit = managedUnit.getUnit();
        ArrayList<Unit> baseMinerals = new ArrayList<Unit>();
        for (Mineral mineral : base.getMinerals()) {
            Unit unit2 = mineral.getUnit();
            if (!this.gameState.getMineralAssignments().containsKey(unit2)) continue;
            baseMinerals.add(unit2);
        }
        if (baseMinerals.isEmpty()) {
            return false;
        }
        int dronesAtBase = 0;
        for (Unit unit3 : baseMinerals) {
            HashSet<ManagedUnit> mineralUnits = this.gameState.getMineralAssignments().get(unit3);
            dronesAtBase += mineralUnits.size();
        }
        int n = dronesAtBase < baseMinerals.size() ? 0 : 1;
        baseMinerals.sort(new UnitDistanceComparator(unit));
        for (Unit unit4 : baseMinerals) {
            HashSet<ManagedUnit> mineralUnits = this.gameState.getMineralAssignments().get(unit4);
            if (mineralUnits.size() > n) continue;
            managedUnit.setRole(UnitRole.GATHER);
            managedUnit.setGatherTarget(unit4);
            managedUnit.setNewGatherTarget(true);
            this.assignedManagedWorkers.add(managedUnit);
            this.gameState.setMineralWorkers(this.gameState.getMineralWorkers() + 1);
            mineralUnits.add(managedUnit);
            this.gatherers.add(managedUnit);
            this.mineralGatherers.add(managedUnit);
            this.assignToClosestBase(unit4, managedUnit);
            return true;
        }
        return false;
    }

    private Base findBestBaseForMineralAssignment(Unit drone) {
        HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase();
        ArrayList<Base> bases = new ArrayList<Base>(gatherersAssignedToBase.keySet());
        if (bases.isEmpty()) {
            return null;
        }
        bases.sort(new BaseUnitDistanceComparator(drone));
        for (Base base : bases) {
            if (!this.hasUnlockedMineralPatches(base)) continue;
            return base;
        }
        return (Base)bases.get(0);
    }

    private boolean hasUnlockedMineralPatches(Base base) {
        for (Mineral mineral : base.getMinerals()) {
            HashSet<ManagedUnit> mineralUnits;
            Unit mineralUnit = mineral.getUnit();
            if (!this.gameState.getMineralAssignments().containsKey(mineralUnit) || (mineralUnits = this.gameState.getMineralAssignments().get(mineralUnit)).size() != 0) continue;
            return true;
        }
        return false;
    }

    private void assignToGeyser(ManagedUnit managedUnit) {
        Unit unit = managedUnit.getUnit();
        ArrayList<Unit> availableGeysers = new ArrayList<Unit>();
        for (Unit geyser : this.gameState.getGeyserAssignments().keySet()) {
            HashSet<ManagedUnit> geyserUnits = this.gameState.getGeyserAssignments().get(geyser);
            if (geyserUnits.size() >= 3) continue;
            availableGeysers.add(geyser);
        }
        if (availableGeysers.isEmpty()) {
            return;
        }
        availableGeysers.sort(new UnitDistanceComparator(unit));
        Unit targetGeyser = (Unit)availableGeysers.get(0);
        HashSet<ManagedUnit> geyserUnits = this.gameState.getGeyserAssignments().get(targetGeyser);
        managedUnit.setRole(UnitRole.GATHER);
        managedUnit.setGatherTarget(targetGeyser);
        managedUnit.setNewGatherTarget(true);
        this.assignedManagedWorkers.add(managedUnit);
        this.gameState.setGeyserWorkers(this.gameState.getGeyserWorkers() + 1);
        geyserUnits.add(managedUnit);
        this.gatherers.add(managedUnit);
        this.gasGatherers.add(managedUnit);
        this.assignToClosestBase(targetGeyser, managedUnit);
    }

    private void checksLarvaDeadlock() {
        Plan plan;
        Player self = this.game.self();
        int supplyTotal = self.supplyTotal();
        int supplyUsed = self.supplyUsed();
        int curFrame = this.game.getFrameCount();
        if (supplyTotal - supplyUsed + this.gameState.getResourceCount().getPlannedSupply() > 0) {
            this.gameState.setLarvaDeadlocked(false);
            return;
        }
        if (this.gameState.isLarvaDeadlocked() && curFrame < this.gameState.getLarvaDeadlockDetectedFrame() + 26) {
            return;
        }
        if (this.gameState.getPlansScheduled().isEmpty()) {
            return;
        }
        for (ManagedUnit managedUnit : this.larva) {
            if (managedUnit.getRole() == UnitRole.LARVA) {
                return;
            }
            if (managedUnit.getRole() != UnitRole.MORPH || !((plan = managedUnit.getPlan()) != null & plan.getPlannedUnit() == UnitType.Zerg_Overlord)) continue;
            return;
        }
        for (ManagedUnit managedUnit : this.eggs) {
            if (managedUnit.getRole() != UnitRole.MORPH || !((plan = managedUnit.getPlan()) != null & plan.getPlannedUnit() == UnitType.Zerg_Overlord)) continue;
            return;
        }
        boolean isOverlordAssignedOrMorphing = false;
        for (Plan plan2 : this.gameState.getAssignedPlannedItems().values()) {
            if (plan2.getType() != PlanType.UNIT || plan2.getPlannedUnit() != UnitType.Zerg_Overlord) continue;
            isOverlordAssignedOrMorphing = true;
            break;
        }
        for (Plan plan2 : this.gameState.getPlansMorphing()) {
            if (plan2.getType() != PlanType.UNIT || plan2.getPlannedUnit() != UnitType.Zerg_Overlord) continue;
            isOverlordAssignedOrMorphing = true;
            break;
        }
        if (isOverlordAssignedOrMorphing) {
            return;
        }
        this.gameState.setLarvaDeadlocked(true);
        this.gameState.setLarvaDeadlockDetectedFrame(curFrame);
    }

    private void handleLarvaDeadlock() {
        int frameDeadlockDetected;
        if (!this.gameState.isLarvaDeadlocked()) {
            return;
        }
        int frameCount = this.game.getFrameCount();
        if (frameCount < (frameDeadlockDetected = this.gameState.getLarvaDeadlockDetectedFrame()) + 26) {
            return;
        }
        List larvaCopy = this.larva.stream().collect(Collectors.toList());
        for (ManagedUnit managedUnit : larvaCopy) {
            Unit unit = managedUnit.getUnit();
            this.gameState.clearAssignments(managedUnit);
            managedUnit.setRole(UnitRole.LARVA);
            this.larva.add(managedUnit);
            Plan plan = managedUnit.getPlan();
            if (plan != null) {
                plan.setState(PlanState.CANCELLED);
                managedUnit.setPlan(null);
            }
            this.gameState.getAssignedPlannedItems().remove(unit);
        }
        this.gameState.setLarvaDeadlocked(false);
    }

    private void rebalanceCheck() {
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.isFloatingGas()) {
            this.cutGasHarvesting();
        } else if (resourceCount.isFloatingMinerals()) {
            this.saturateGeysers();
        }
    }

    private void saturateGeysers() {
        if (!this.gameState.needGeyserWorkers()) {
            return;
        }
        ArrayList<ManagedUnit> reassignedWorkers = new ArrayList<ManagedUnit>();
        for (ManagedUnit managedUnit : this.mineralGatherers) {
            if (reassignedWorkers.size() >= this.gameState.needGeyserWorkersAmount()) break;
            reassignedWorkers.add(managedUnit);
        }
        for (ManagedUnit worker : reassignedWorkers) {
            this.gameState.clearAssignments(worker);
            this.assignToGeyser(worker);
        }
    }

    private void cutGasHarvesting() {
        int minGasWorkers;
        int gasWorkers = this.gameState.getGeyserWorkers();
        int excessGasWorkers = Math.max(0, gasWorkers - (minGasWorkers = this.gameState.getGeyserAssignments().size()));
        if (excessGasWorkers > 0) {
            ArrayList<ManagedUnit> geyserWorkers = new ArrayList<ManagedUnit>(this.gasGatherers);
            int reassigned = 0;
            for (ManagedUnit worker : geyserWorkers) {
                if (reassigned >= excessGasWorkers) break;
                this.gameState.clearAssignments(worker);
                this.assignToMineral(worker);
                ++reassigned;
            }
        }
    }
}

