/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.AgentUtil;
import org.bk.ass.sim.Simulator;

public class RepairerBehavior
implements Simulator.Behavior {
    public static final int SCV_REPAIR_RANGE_SQUARED = 25;

    @Override
    public boolean simUnit(int frameSkip, Agent agent, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
        int dstSq;
        Agent selectedAlly = null;
        int selectedDistanceSquared = Integer.MAX_VALUE;
        if (agent.restoreTarget != null && agent.healthShifted < agent.maxHealthShifted && (dstSq = AgentUtil.distanceSquared(agent, agent.restoreTarget)) <= 25) {
            selectedAlly = agent.restoreTarget;
            selectedDistanceSquared = dstSq;
        }
        if (selectedAlly == null) {
            for (int i = allies.size() - 1; i >= 0; --i) {
                int distanceSq;
                Agent ally = allies.get(i);
                if (!ally.isMechanic || ally.isStasised || ally.healthShifted >= ally.maxHealthShifted || ally == agent || (distanceSq = AgentUtil.distanceSquared(agent, ally)) >= selectedDistanceSquared) continue;
                selectedDistanceSquared = distanceSq;
                selectedAlly = ally;
                if (selectedDistanceSquared <= 25) break;
            }
        }
        agent.restoreTarget = selectedAlly;
        if (selectedAlly == null) {
            return false;
        }
        AgentUtil.moveToward(frameSkip, agent, selectedAlly, (float)Math.sqrt(selectedDistanceSquared));
        if (selectedDistanceSquared > 25) {
            return true;
        }
        selectedAlly.heal(selectedAlly.hpConstructionRate * frameSkip);
        return true;
    }
}

