/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.bk.ass.sim.UnitSize;
import org.bk.ass.sim.Weapon;

public class Agent {
    static final BiConsumer<Agent, Collection<Agent>> CARRIER_DEATH_HANDLER = (carrier, agents) -> agents.removeAll(carrier.interceptors);
    private static final int STIM_TIMER = 37;
    private static final int STIM_ENERGY_COST_SHIFTED = 2560;
    private final String name;
    TargetingPriority attackTargetPriority = TargetingPriority.HIGHEST;
    int armorShifted;
    int shieldUpgrades;
    Object userObject;
    int elevationLevel = -2;
    int x;
    int y;
    int speedSquared;
    float speed;
    int vx;
    int vy;
    int healthShifted;
    int maxHealthShifted;
    boolean healedThisFrame;
    int hpConstructionRate;
    int shieldsShifted;
    int maxShieldsShifted;
    int energyShifted;
    int maxEnergyShifted;
    int cooldown;
    int maxCooldown;
    int stopFrames;
    int remainingStimFrames;
    boolean canStim;
    int plagueDamagePerFrameShifted;
    boolean regeneratesHealth;
    boolean isSuicider;
    boolean isHealer;
    boolean isFlyer;
    boolean isOrganic;
    boolean isMechanic;
    boolean isKiter;
    boolean isRepairer;
    boolean protectedByDarkSwarm;
    boolean burrowed;
    boolean burrowedAttacker;
    boolean detected;
    boolean isStasised;
    boolean isLockeddown;
    UnitSize size;
    boolean isMelee;
    Weapon airWeapon;
    Weapon groundWeapon;
    Agent attackTarget;
    Agent restoreTarget;
    List<Agent> interceptors = Collections.emptyList();
    BiConsumer<Agent, Collection<Agent>> onDeathHandler;

    public Agent(String name) {
        this.onDeathHandler = (ignored1, ignored2) -> {};
        this.name = name;
    }

    public Agent(Agent other) {
        this.onDeathHandler = (ignored1, ignored2) -> {};
        this.name = other.name;
        this.attackTargetPriority = other.attackTargetPriority;
        this.armorShifted = other.armorShifted;
        this.shieldUpgrades = other.shieldUpgrades;
        this.userObject = other.userObject;
        this.elevationLevel = other.elevationLevel;
        this.x = other.x;
        this.y = other.y;
        this.speedSquared = other.speedSquared;
        this.speed = other.speed;
        this.vx = other.vx;
        this.vy = other.vy;
        this.healthShifted = other.healthShifted;
        this.maxHealthShifted = other.maxHealthShifted;
        this.healedThisFrame = other.healedThisFrame;
        this.hpConstructionRate = other.hpConstructionRate;
        this.shieldsShifted = other.shieldsShifted;
        this.maxShieldsShifted = other.maxShieldsShifted;
        this.energyShifted = other.energyShifted;
        this.maxEnergyShifted = other.maxEnergyShifted;
        this.cooldown = other.cooldown;
        this.maxCooldown = other.maxCooldown;
        this.stopFrames = other.stopFrames;
        this.remainingStimFrames = other.remainingStimFrames;
        this.canStim = other.canStim;
        this.plagueDamagePerFrameShifted = other.plagueDamagePerFrameShifted;
        this.regeneratesHealth = other.regeneratesHealth;
        this.isSuicider = other.isSuicider;
        this.isHealer = other.isHealer;
        this.isFlyer = other.isFlyer;
        this.isOrganic = other.isOrganic;
        this.isMechanic = other.isMechanic;
        this.isKiter = other.isKiter;
        this.isRepairer = other.isRepairer;
        this.protectedByDarkSwarm = other.protectedByDarkSwarm;
        this.burrowed = other.burrowed;
        this.burrowedAttacker = other.burrowedAttacker;
        this.detected = other.detected;
        this.isStasised = other.isStasised;
        this.isLockeddown = other.isLockeddown;
        this.size = other.size;
        this.isMelee = other.isMelee;
        this.airWeapon = other.airWeapon;
        this.groundWeapon = other.groundWeapon;
        this.onDeathHandler = other.onDeathHandler;
        this.attackTarget = null;
        this.restoreTarget = null;
        this.interceptors = Collections.emptyList();
    }

    public Agent setUserObject(Object userObject) {
        this.userObject = userObject;
        return this;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Agent setMelee(boolean melee) {
        this.isMelee = melee;
        return this;
    }

    public Agent setBurrowedAttacker(boolean burrowedAttacker) {
        this.burrowedAttacker = burrowedAttacker;
        return this;
    }

    public Agent setBurrowed(boolean burrowed) {
        this.burrowed = burrowed;
        return this;
    }

    public Agent setCanStim(boolean canStim) {
        this.canStim = canStim;
        return this;
    }

    public Agent setRemainingStimFrames(int remainingStimFrames) {
        this.remainingStimFrames = remainingStimFrames;
        return this;
    }

    public Agent setStasised(boolean stasised) {
        this.isStasised = stasised;
        return this;
    }

    public Agent setLockeddown(boolean lockeddown) {
        this.isLockeddown = lockeddown;
        return this;
    }

    public String toString() {
        return this.name + " (" + this.x + ", " + this.y + "), hp: " + this.getHealth() + ", sh: " + this.getShields();
    }

    public Agent setDetected(boolean detected) {
        this.detected = detected;
        return this;
    }

    public Agent setArmor(int armor) {
        this.armorShifted = armor << 8;
        return this;
    }

    public Agent setMaxEnergy(int maxEnergyShifted) {
        this.maxEnergyShifted = maxEnergyShifted << 8;
        return this;
    }

    public Agent setEnergy(int energyShifted) {
        this.energyShifted = energyShifted << 8;
        return this;
    }

    public Agent setShieldUpgrades(int shieldUpgrades) {
        this.shieldUpgrades = shieldUpgrades;
        return this;
    }

    public Agent setElevationLevel(int elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    public Agent setX(int x) {
        this.x = x;
        return this;
    }

    public Agent setY(int y) {
        this.y = y;
        return this;
    }

    public Agent setSpeed(float speed) {
        this.speedSquared = Math.round(speed * speed);
        this.speed = speed;
        return this;
    }

    public Agent setHealth(int health) {
        this.healthShifted = health << 8;
        return this;
    }

    public int getHealth() {
        return Math.min(this.healthShifted, this.maxHealthShifted) >> 8;
    }

    public Agent setMaxHealth(int maxHealth) {
        this.maxHealthShifted = maxHealth << 8;
        return this;
    }

    public Agent setShields(int shields) {
        this.shieldsShifted = shields << 8;
        return this;
    }

    public int getShields() {
        return Math.min(this.shieldsShifted, this.maxShieldsShifted) >> 8;
    }

    public Agent setMaxShields(int maxShields) {
        this.maxShieldsShifted = maxShields << 8;
        return this;
    }

    public Agent setCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public Agent setMaxCooldown(int maxCooldown) {
        this.maxCooldown = maxCooldown;
        return this;
    }

    public Agent setStopFrames(int stopFrames) {
        this.stopFrames = stopFrames;
        return this;
    }

    public Agent setRegeneratesHealth(boolean regeneratesHealth) {
        this.regeneratesHealth = regeneratesHealth;
        return this;
    }

    public Agent setSuicider(boolean suicider) {
        this.isSuicider = suicider;
        return this;
    }

    public Agent setRepairer(boolean repairer) {
        this.isRepairer = repairer;
        return this;
    }

    public Agent setMechanic(boolean mechanic) {
        this.isMechanic = mechanic;
        return this;
    }

    public Agent setHealer(boolean healer) {
        this.isHealer = healer;
        return this;
    }

    public Agent setFlyer(boolean flyer) {
        this.isFlyer = flyer;
        return this;
    }

    public Agent setOrganic(boolean organic) {
        this.isOrganic = organic;
        return this;
    }

    public Agent setSize(UnitSize size) {
        this.size = size;
        return this;
    }

    public Agent setOnDeathHandler(BiConsumer<Agent, Collection<Agent>> onDeathHandler) {
        this.onDeathHandler = onDeathHandler;
        return this;
    }

    public Agent setKiter(boolean kiter) {
        this.isKiter = kiter;
        return this;
    }

    public Agent setAirWeapon(Weapon airWeapon) {
        this.airWeapon = airWeapon;
        return this;
    }

    public Agent setGroundWeapon(Weapon groundWeapon) {
        this.groundWeapon = groundWeapon;
        return this;
    }

    public void setAttackTarget(Agent attackTarget) {
        this.attackTarget = attackTarget;
    }

    public void setInterceptors(Collection<Agent> childAgents) {
        this.interceptors = new ArrayList<Agent>(childAgents);
    }

    public Agent setAttackTargetPriority(TargetingPriority attackTargetPriority) {
        this.attackTargetPriority = attackTargetPriority;
        return this;
    }

    public Agent setProtectedByDarkSwarm(boolean protectedByDarkSwarm) {
        this.protectedByDarkSwarm = protectedByDarkSwarm;
        return this;
    }

    final Weapon weaponVs(Agent other) {
        if (other.isFlyer) {
            return this.airWeapon;
        }
        return this.groundWeapon;
    }

    public Agent setHpConstructionRate(int buildTime) {
        this.hpConstructionRate = Math.max(1, (this.maxHealthShifted - this.maxHealthShifted / 10 + buildTime - 1) / buildTime);
        return this;
    }

    public Agent setPlagueDamage(int plagueDamage) {
        this.plagueDamagePerFrameShifted = (plagueDamage << 8) / 76;
        return this;
    }

    public final void consumeEnergy(int amountShifted) {
        this.energyShifted = Math.min(this.energyShifted, this.maxEnergyShifted) - amountShifted;
    }

    public final void consumeHealth(int amountShifted) {
        this.healthShifted = Math.min(this.healthShifted, this.maxHealthShifted) - amountShifted;
    }

    public final void heal(int amountShifted) {
        this.healthShifted += amountShifted;
    }

    public final void stim() {
        this.remainingStimFrames = 37;
        this.consumeHealth(2560);
    }

    public static enum TargetingPriority {
        LOW,
        MEDIUM,
        HIGHEST;

    }
}

